/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticWarningCode;
import io.ballerina.compiler.internal.parser.AbstractLexer;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentationLexer
extends AbstractLexer {
    private static final char[] deprecatedChars = new char[]{'D', 'e', 'p', 'r', 'e', 'c', 'a', 't', 'e', 'd'};
    private ParserMode previousBacktickMode = null;

    public DocumentationLexer(CharReader charReader, List<STNode> leadingTriviaList, Collection<STNodeDiagnostic> diagnostics) {
        super(charReader, ParserMode.DOC_LINE_START_HASH, leadingTriviaList, diagnostics);
    }

    @Override
    public STToken nextToken() {
        STToken token = switch (this.mode) {
            case ParserMode.DOC_LINE_START_HASH -> {
                this.processLeadingTrivia();
                yield this.readDocLineStartHashToken();
            }
            case ParserMode.DOC_LINE_DIFFERENTIATOR -> {
                this.processLeadingTrivia();
                yield this.readDocLineDifferentiatorToken();
            }
            case ParserMode.DOC_INTERNAL -> this.readDocInternalToken();
            case ParserMode.DOC_PARAMETER -> {
                this.processLeadingTrivia();
                yield this.readDocParameterToken();
            }
            case ParserMode.DOC_REFERENCE_TYPE -> {
                this.processLeadingTrivia();
                yield this.readDocReferenceTypeToken();
            }
            case ParserMode.DOC_SINGLE_BACKTICK_CONTENT -> this.readSingleBacktickContentToken();
            case ParserMode.DOC_DOUBLE_BACKTICK_CONTENT -> this.readCodeContent(2);
            case ParserMode.DOC_TRIPLE_BACKTICK_CONTENT -> this.readCodeContent(3);
            case ParserMode.DOC_CODE_REF_END -> this.readCodeReferenceEndToken();
            case ParserMode.DOC_CODE_LINE_START_HASH -> {
                this.processLeadingTrivia();
                yield this.readCodeLineStartHashToken();
            }
            default -> null;
        };
        return this.cloneWithDiagnostics(token);
    }

    private int peek() {
        return this.reader.peek();
    }

    private String getLexeme() {
        return this.reader.getMarkedChars();
    }

    private boolean isPossibleIdentifierStart(int startChar) {
        return switch (startChar) {
            case 39, 92 -> true;
            default -> DocumentationLexer.isIdentifierInitialChar(startChar);
        };
    }

    private void processIdentifierEnd() {
        block4: while (!this.reader.isEOF()) {
            char nextChar = this.reader.peek();
            if (DocumentationLexer.isIdentifierFollowingChar(nextChar)) {
                this.reader.advance();
                continue;
            }
            if (nextChar != '\\') break;
            nextChar = this.reader.peek(1);
            switch (nextChar) {
                case '\t': 
                case '\n': 
                case '\r': {
                    this.reader.advance();
                    this.reportLexerError(DiagnosticWarningCode.WARNING_INVALID_ESCAPE_SEQUENCE, "");
                    break block4;
                }
                case 'u': {
                    if (this.reader.peek(2) == '{') {
                        this.processNumericEscape();
                        continue block4;
                    }
                    this.reader.advance(2);
                    continue block4;
                }
                default: {
                    this.reader.advance(2);
                    continue block4;
                }
            }
        }
    }

    @Override
    protected void processNumericEscape() {
        this.reader.advance(3);
        if (!DocumentationLexer.isHexDigit(this.peek())) {
            return;
        }
        this.reader.advance();
        while (DocumentationLexer.isHexDigit(this.peek())) {
            this.reader.advance();
        }
        if (this.peek() != 125) {
            return;
        }
        this.reader.advance();
    }

    private void processLeadingTrivia() {
        this.processSyntaxTrivia(this.leadingTriviaList, true);
    }

    private STNode processTrailingTrivia() {
        ArrayList<STNode> triviaList = new ArrayList<STNode>(10);
        this.processSyntaxTrivia(triviaList, false);
        return STNodeFactory.createNodeList(triviaList);
    }

    private void processSyntaxTrivia(List<STNode> triviaList, boolean isLeading) {
        while (!this.reader.isEOF()) {
            this.reader.mark();
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    triviaList.add(this.processWhitespaces());
                    break;
                }
                case '\n': 
                case '\r': {
                    triviaList.add(this.processEndOfLine());
                    if (isLeading) break;
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    private STNode processWhitespaces() {
        block3: while (!this.reader.isEOF()) {
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    this.reader.advance();
                    continue block3;
                }
            }
            break;
        }
        return STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, this.getLexeme());
    }

    private STNode processEndOfLine() {
        char c = this.reader.peek();
        switch (c) {
            case '\n': {
                this.reader.advance();
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
            case '\r': {
                this.reader.advance();
                if (this.reader.peek() == '\n') {
                    this.reader.advance();
                }
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
        }
        throw new IllegalStateException();
    }

    private STToken getLiteral(SyntaxKind tokenKind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createLiteralValueToken(tokenKind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getDocSyntaxToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = this.processTrailingTrivia();
        this.checkAndTerminateCurrentMode(trailingTrivia);
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getDocLiteralToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        this.checkAndTerminateCurrentMode(trailingTrivia);
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getDocIdentifierToken() {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        this.checkAndTerminateCurrentMode(trailingTrivia);
        return STNodeFactory.createIdentifierToken(lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getDocSyntaxTokenWithoutTrivia(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        ArrayList<STNode> triviaList = new ArrayList<STNode>(1);
        int nextChar = this.peek();
        if (nextChar == 10 || nextChar == 13) {
            this.reader.mark();
            triviaList.add(this.processEndOfLine());
            this.endMode();
        }
        STNode trailingTrivia = STNodeFactory.createNodeList(triviaList);
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getDocLiteralWithoutTrivia(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        ArrayList<STNode> triviaList = new ArrayList<STNode>(1);
        int nextChar = this.peek();
        if (nextChar == 10 || nextChar == 13) {
            this.reader.mark();
            triviaList.add(this.processEndOfLine());
            this.endMode();
        }
        STNode trailingTrivia = STNodeFactory.createNodeList(triviaList);
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getCodeStartBacktickToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        ArrayList<STNode> triviaList = new ArrayList<STNode>(1);
        int nextChar = this.peek();
        if (nextChar == 10 || nextChar == 13) {
            this.reader.mark();
            triviaList.add(this.processEndOfLine());
            this.previousBacktickMode = this.mode;
            this.switchMode(ParserMode.DOC_CODE_LINE_START_HASH);
        }
        STNode trailingTrivia = STNodeFactory.createNodeList(triviaList);
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getCodeLineStartHashToken() {
        STNode leadingTrivia = this.getLeadingTrivia();
        ArrayList<STNode> triviaList = new ArrayList<STNode>(2);
        int nextChar = this.peek();
        switch (nextChar) {
            case 9: 
            case 12: 
            case 32: {
                this.reader.mark();
                this.reader.advance();
                STNode singleWhitespace = STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, this.getLexeme());
                triviaList.add(singleWhitespace);
                nextChar = this.peek();
                if (nextChar == 10 || nextChar == 13) {
                    this.reader.mark();
                    triviaList.add(this.processEndOfLine());
                    break;
                }
                this.switchMode(this.previousBacktickMode);
                break;
            }
            case 10: 
            case 13: {
                this.reader.mark();
                triviaList.add(this.processEndOfLine());
                break;
            }
            default: {
                this.switchMode(this.previousBacktickMode);
            }
        }
        STNode trailingTrivia = STNodeFactory.createNodeList(triviaList);
        return STNodeFactory.createToken(SyntaxKind.HASH_TOKEN, leadingTrivia, trailingTrivia);
    }

    private void checkAndTerminateCurrentMode(STNode trailingTrivia) {
        int bucketCount = trailingTrivia.bucketCount();
        if (bucketCount > 0 && trailingTrivia.childInBucket((int)(bucketCount - 1)).kind == SyntaxKind.END_OF_LINE_MINUTIAE) {
            this.endMode();
        }
    }

    private STToken readDocLineStartHashToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getDocSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        if (nextChar == 35) {
            this.reader.advance();
            this.startMode(ParserMode.DOC_LINE_DIFFERENTIATOR);
            return this.getDocSyntaxToken(SyntaxKind.HASH_TOKEN);
        }
        assert (false) : "Documentation line should always start with a hash";
        return this.getDocSyntaxToken(SyntaxKind.EOF_TOKEN);
    }

    private STToken readDocLineDifferentiatorToken() {
        int c = this.peek();
        switch (c) {
            case 43: {
                return this.processPlusToken();
            }
            case 35: {
                this.switchMode(ParserMode.DOC_INTERNAL);
                return this.processDeprecationLiteralToken();
            }
            case 96: {
                if (this.reader.peek(1) != '`') break;
                return this.processDoubleOrTripleBacktickToken();
            }
        }
        this.switchMode(ParserMode.DOC_INTERNAL);
        return this.readDocInternalToken();
    }

    private STToken processPlusToken() {
        this.reader.advance();
        this.switchMode(ParserMode.DOC_PARAMETER);
        return this.getDocSyntaxToken(SyntaxKind.PLUS_TOKEN);
    }

    private STToken processDoubleOrTripleBacktickToken() {
        this.reader.advance(2);
        if (this.peek() == 96) {
            this.reader.advance();
            this.switchMode(ParserMode.DOC_TRIPLE_BACKTICK_CONTENT);
            return this.getCodeStartBacktickToken(SyntaxKind.TRIPLE_BACKTICK_TOKEN);
        }
        this.switchMode(ParserMode.DOC_DOUBLE_BACKTICK_CONTENT);
        return this.getCodeStartBacktickToken(SyntaxKind.DOUBLE_BACKTICK_TOKEN);
    }

    private STToken processDeprecationLiteralToken() {
        int lookAheadCount = 1;
        char lookAheadChar = this.reader.peek(lookAheadCount);
        int whitespaceCount = 0;
        while (lookAheadChar == ' ' || lookAheadChar == '\t') {
            ++whitespaceCount;
            lookAheadChar = this.reader.peek(++lookAheadCount);
        }
        for (int i = 0; i < 10; ++i) {
            if ((char)lookAheadChar != deprecatedChars[i]) {
                return this.readDocInternalToken();
            }
            lookAheadChar = this.reader.peek(++lookAheadCount);
        }
        this.processLeadingTrivia();
        this.reader.mark();
        this.reader.advance();
        this.reader.advance(whitespaceCount);
        this.reader.advance(10);
        return this.getDocLiteralWithoutTrivia(SyntaxKind.DEPRECATION_LITERAL);
    }

    private STToken readDocInternalToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getDocSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        if (nextChar == 96) {
            this.reader.advance();
            nextChar = this.peek();
            if (nextChar != 96) {
                this.switchMode(ParserMode.DOC_SINGLE_BACKTICK_CONTENT);
                return this.getDocSyntaxTokenWithoutTrivia(SyntaxKind.BACKTICK_TOKEN);
            }
            this.reader.advance();
            nextChar = this.peek();
            if (nextChar != 96) {
                this.switchMode(ParserMode.DOC_DOUBLE_BACKTICK_CONTENT);
                return this.getCodeStartBacktickToken(SyntaxKind.DOUBLE_BACKTICK_TOKEN);
            }
            this.reader.advance();
            this.switchMode(ParserMode.DOC_TRIPLE_BACKTICK_CONTENT);
            return this.getCodeStartBacktickToken(SyntaxKind.TRIPLE_BACKTICK_TOKEN);
        }
        block4: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 10: 
                case 13: {
                    this.endMode();
                    break block4;
                }
                case 96: {
                    break block4;
                }
                default: {
                    if (DocumentationLexer.isIdentifierInitialChar(nextChar)) {
                        boolean hasDocumentationReference = this.processDocumentationReference(nextChar);
                        if (hasDocumentationReference) {
                            this.switchMode(ParserMode.DOC_REFERENCE_TYPE);
                            break block4;
                        }
                    } else {
                        this.reader.advance();
                    }
                    nextChar = this.peek();
                    continue block4;
                }
            }
        }
        if (this.getLexeme().isEmpty()) {
            return this.readDocReferenceTypeToken();
        }
        return this.getLiteral(SyntaxKind.DOCUMENTATION_DESCRIPTION);
    }

    private boolean processDocumentationReference(int nextChar) {
        int lookAheadChar = nextChar;
        int lookAheadCount = 0;
        String identifier = "";
        while (DocumentationLexer.isIdentifierInitialChar(lookAheadChar)) {
            identifier = identifier.concat(String.valueOf((char)lookAheadChar));
            lookAheadChar = this.reader.peek(++lookAheadCount);
        }
        switch (identifier) {
            case "type": 
            case "service": 
            case "variable": 
            case "var": 
            case "annotation": 
            case "module": 
            case "function": 
            case "parameter": 
            case "const": {
                block19: while (true) {
                    switch (lookAheadChar) {
                        case 9: 
                        case 32: {
                            lookAheadChar = this.reader.peek(++lookAheadCount);
                            continue block19;
                        }
                        case 96: {
                            if (this.reader.peek(lookAheadCount + 1) == '`') break block19;
                            return true;
                        }
                    }
                    break;
                }
                break;
            }
        }
        this.reader.advance(lookAheadCount);
        return false;
    }

    private STToken readDocParameterToken() {
        this.reader.mark();
        int nextChar = this.peek();
        if (this.isPossibleIdentifierStart(nextChar)) {
            if (nextChar != 92) {
                this.reader.advance();
            }
            this.processIdentifierEnd();
            STToken token = "return".equals(this.getLexeme()) ? this.getDocSyntaxToken(SyntaxKind.RETURN_KEYWORD) : this.getDocLiteralToken(SyntaxKind.PARAMETER_NAME);
            if (this.peek() != 45 && this.mode != ParserMode.DOC_LINE_START_HASH) {
                this.switchMode(ParserMode.DOC_INTERNAL);
            }
            return token;
        }
        if (nextChar == 45) {
            this.reader.advance();
            this.switchMode(ParserMode.DOC_INTERNAL);
            return this.getDocSyntaxToken(SyntaxKind.MINUS_TOKEN);
        }
        this.switchMode(ParserMode.DOC_INTERNAL);
        return this.readDocInternalToken();
    }

    private STToken readDocReferenceTypeToken() {
        int nextChar = this.peek();
        if (nextChar == 96) {
            this.reader.advance();
            this.switchMode(ParserMode.DOC_SINGLE_BACKTICK_CONTENT);
            return this.getDocSyntaxTokenWithoutTrivia(SyntaxKind.BACKTICK_TOKEN);
        }
        while (DocumentationLexer.isIdentifierInitialChar(this.peek())) {
            this.reader.advance();
        }
        return this.processReferenceType();
    }

    private STToken processReferenceType() {
        String tokenText;
        return switch (tokenText = this.getLexeme()) {
            case "type" -> this.getDocSyntaxToken(SyntaxKind.TYPE_DOC_REFERENCE_TOKEN);
            case "service" -> this.getDocSyntaxToken(SyntaxKind.SERVICE_DOC_REFERENCE_TOKEN);
            case "variable" -> this.getDocSyntaxToken(SyntaxKind.VARIABLE_DOC_REFERENCE_TOKEN);
            case "var" -> this.getDocSyntaxToken(SyntaxKind.VAR_DOC_REFERENCE_TOKEN);
            case "annotation" -> this.getDocSyntaxToken(SyntaxKind.ANNOTATION_DOC_REFERENCE_TOKEN);
            case "module" -> this.getDocSyntaxToken(SyntaxKind.MODULE_DOC_REFERENCE_TOKEN);
            case "function" -> this.getDocSyntaxToken(SyntaxKind.FUNCTION_DOC_REFERENCE_TOKEN);
            case "parameter" -> this.getDocSyntaxToken(SyntaxKind.PARAMETER_DOC_REFERENCE_TOKEN);
            case "const" -> this.getDocSyntaxToken(SyntaxKind.CONST_DOC_REFERENCE_TOKEN);
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Invalid reference type");
                }
                yield this.getDocSyntaxToken(SyntaxKind.EOF_TOKEN);
            }
        };
    }

    private STToken readSingleBacktickContentToken() {
        this.reader.mark();
        int nextChar = this.peek();
        if (nextChar == 92) {
            this.processIdentifierEnd();
            return this.getDocIdentifierToken();
        }
        this.reader.advance();
        switch (nextChar) {
            case 96: {
                this.switchMode(ParserMode.DOC_INTERNAL);
                return this.getDocSyntaxTokenWithoutTrivia(SyntaxKind.BACKTICK_TOKEN);
            }
            case 46: {
                return this.getDocSyntaxToken(SyntaxKind.DOT_TOKEN);
            }
            case 58: {
                return this.getDocSyntaxToken(SyntaxKind.COLON_TOKEN);
            }
            case 40: {
                return this.getDocSyntaxToken(SyntaxKind.OPEN_PAREN_TOKEN);
            }
            case 41: {
                return this.getDocSyntaxToken(SyntaxKind.CLOSE_PAREN_TOKEN);
            }
        }
        if (this.isPossibleIdentifierStart(nextChar)) {
            this.processIdentifierEnd();
            return this.getDocIdentifierToken();
        }
        this.processInvalidChars();
        return this.getDocLiteralToken(SyntaxKind.CODE_CONTENT);
    }

    private void processInvalidChars() {
        int nextChar = this.peek();
        block3: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 10: 
                case 13: 
                case 96: {
                    break block3;
                }
                default: {
                    this.reader.advance();
                    nextChar = this.peek();
                    continue block3;
                }
            }
        }
    }

    private STToken readCodeContent(int backtickCount) {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getDocSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        block4: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 96: {
                    int count = this.getBackticksCount();
                    if (count == backtickCount) {
                        this.switchMode(ParserMode.DOC_CODE_REF_END);
                        break block4;
                    }
                    this.reader.advance(count);
                    nextChar = this.peek();
                    continue block4;
                }
                case 10: 
                case 13: {
                    this.previousBacktickMode = this.mode;
                    this.switchMode(ParserMode.DOC_CODE_LINE_START_HASH);
                    break block4;
                }
                default: {
                    this.reader.advance();
                    nextChar = this.peek();
                    continue block4;
                }
            }
        }
        if (this.getLexeme().isEmpty()) {
            return this.readCodeReferenceEndToken();
        }
        return this.getLiteral(SyntaxKind.CODE_CONTENT);
    }

    private int getBackticksCount() {
        int count = 1;
        while (this.reader.peek(count) == '`') {
            ++count;
        }
        return count;
    }

    private STToken readCodeReferenceEndToken() {
        this.switchMode(ParserMode.DOC_INTERNAL);
        if (this.peek() == 96) {
            this.reader.advance();
            if (this.peek() == 96) {
                this.reader.advance();
                if (this.peek() == 96) {
                    this.reader.advance();
                    return this.getDocSyntaxTokenWithoutTrivia(SyntaxKind.TRIPLE_BACKTICK_TOKEN);
                }
                return this.getDocSyntaxTokenWithoutTrivia(SyntaxKind.DOUBLE_BACKTICK_TOKEN);
            }
        }
        assert (false) : "Invalid character: Expected a backtick";
        return this.getDocSyntaxToken(SyntaxKind.EOF_TOKEN);
    }

    private STToken readCodeLineStartHashToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getDocSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        if (nextChar == 35) {
            this.reader.advance();
            return this.getCodeLineStartHashToken();
        }
        assert (false) : "Invalid character: Expected a hash";
        return this.getDocSyntaxToken(SyntaxKind.EOF_TOKEN);
    }
}

