/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.AbstractParser;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.tree.STAbstractNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import java.util.ArrayList;
import java.util.Queue;

public class RegExpParser
extends AbstractParser {
    private final Queue<STNode> interpolationExprs;

    protected RegExpParser(AbstractTokenReader tokenReader, Queue<STNode> interpolationExprs) {
        super(tokenReader);
        this.interpolationExprs = interpolationExprs;
    }

    @Override
    public STNode parse() {
        return this.parseReDisjunction(false);
    }

    private STNode parseReDisjunction(boolean inCapturingGroup) {
        ArrayList<STNode> reSequenceList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfReDisjunction(nextToken.kind, inCapturingGroup)) {
            STNode reSequence = this.parseReSequence(inCapturingGroup);
            reSequenceList.add(reSequence);
            nextToken = this.peek();
            if (nextToken.kind != SyntaxKind.PIPE_TOKEN) continue;
            STToken pipe = this.consume();
            reSequenceList.add(pipe);
            nextToken = this.peek();
        }
        return STAbstractNodeFactory.createNodeList(reSequenceList);
    }

    private STNode parseReSequence(boolean inCapturingGroup) {
        ArrayList<STNode> reTerms = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfReSequence(nextToken.kind, inCapturingGroup)) {
            STNode reTerm = this.parseReTerm();
            reTerms.add(reTerm);
            nextToken = this.peek();
        }
        return STNodeFactory.createReSequenceNode(STAbstractNodeFactory.createNodeList(reTerms));
    }

    private STNode parseReTerm() {
        STToken nextToken = this.peek();
        SyntaxKind tokenKind = nextToken.kind;
        if (tokenKind == SyntaxKind.BITWISE_XOR_TOKEN || tokenKind == SyntaxKind.DOLLAR_TOKEN) {
            return this.parseReAssertion();
        }
        STNode reAtom = switch (nextToken.kind) {
            case SyntaxKind.RE_LITERAL_CHAR, SyntaxKind.RE_NUMERIC_ESCAPE, SyntaxKind.RE_CONTROL_ESCAPE, SyntaxKind.COMMA_TOKEN, SyntaxKind.DOT_TOKEN, SyntaxKind.DIGIT -> this.parseChars();
            case SyntaxKind.BACK_SLASH_TOKEN -> this.parseReEscape();
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseCharacterClass();
            case SyntaxKind.OPEN_PAREN_TOKEN -> this.parseCapturingGroup();
            case SyntaxKind.INTERPOLATION_START_TOKEN -> this.parseInterpolation();
            default -> {
                STToken missingBackSlash = SyntaxErrors.createMissingRegExpTokenWithDiagnostics(SyntaxKind.BACK_SLASH_TOKEN);
                yield SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(missingBackSlash, this.consume());
            }
        };
        nextToken = this.peek();
        STNode quantifier = this.parseOptionalQuantifier(nextToken.kind);
        if (quantifier != null) {
            return STNodeFactory.createReAtomQuantifierNode(reAtom, quantifier);
        }
        return STNodeFactory.createReAtomQuantifierNode(reAtom, null);
    }

    private STNode parseOptionalQuantifier(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.PLUS_TOKEN, SyntaxKind.ASTERISK_TOKEN, SyntaxKind.QUESTION_MARK_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN -> this.parseReQuantifier();
            default -> null;
        };
    }

    private STNode parseReAssertion() {
        STToken assertion = this.consume();
        return STNodeFactory.createReAssertionNode(assertion);
    }

    private STNode parseReEscape() {
        STToken backSlash = this.consume();
        return this.parseEscapeChar(backSlash);
    }

    private STNode parseEscapeChar(STNode backSlash) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case RE_PROPERTY: {
                return this.parseReUnicodePropertyEscape(backSlash);
            }
            case DOT_TOKEN: 
            case BACK_SLASH_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case OPEN_PAREN_TOKEN: 
            case PLUS_TOKEN: 
            case ASTERISK_TOKEN: 
            case QUESTION_MARK_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case BITWISE_XOR_TOKEN: 
            case DOLLAR_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case CLOSE_BRACKET_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case PIPE_TOKEN: {
                return this.parseReQuoteEscape(backSlash);
            }
        }
        if (RegExpParser.isReSimpleCharClassCode(nextToken)) {
            return this.parseReSimpleCharClassEscape(backSlash);
        }
        STNode syntaxChar = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.BITWISE_XOR_TOKEN, DiagnosticErrorCode.ERROR_INVALID_RE_SYNTAX_CHAR);
        syntaxChar = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(syntaxChar, this.consume());
        return STNodeFactory.createReQuoteEscapeNode(backSlash, syntaxChar);
    }

    private STNode parseChars() {
        STToken chars = this.consume();
        return STNodeFactory.createReAtomCharOrEscapeNode(chars);
    }

    private STNode parseReUnicodePropertyEscape(STNode backSlash) {
        STToken property = this.consume();
        STNode openBrace = this.parseOpenBrace();
        STNode unicodeProperty = this.parseUnicodeProperty();
        STNode closeBrace = this.parseCloseBrace();
        return STNodeFactory.createReUnicodePropertyEscapeNode(backSlash, property, openBrace, unicodeProperty, closeBrace);
    }

    private STNode parseOpenBrace() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACE_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.OPEN_BRACE_TOKEN);
    }

    private STNode parseUnicodeProperty() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RE_UNICODE_SCRIPT_START) {
            return this.parseReUnicodeScript();
        }
        return this.parseReUnicodeGeneralCategory();
    }

    private STNode parseReUnicodeScript() {
        STToken scriptStart = this.consume();
        STToken nextToken = this.peek();
        STNode unicodePropertyValue = nextToken.kind == SyntaxKind.RE_UNICODE_PROPERTY_VALUE ? this.consume() : this.createMissingTokenWithDiagnostics(SyntaxKind.RE_UNICODE_PROPERTY_VALUE);
        return STNodeFactory.createReUnicodeScriptNode(scriptStart, unicodePropertyValue);
    }

    private STNode parseReUnicodeGeneralCategory() {
        STToken nextToken = this.peek();
        STToken scriptStart = null;
        if (nextToken.kind == SyntaxKind.RE_UNICODE_GENERAL_CATEGORY_START) {
            scriptStart = this.consume();
        }
        nextToken = this.peek();
        STNode generalCategory = nextToken.kind == SyntaxKind.RE_UNICODE_GENERAL_CATEGORY_NAME ? this.consume() : this.createMissingTokenWithDiagnostics(SyntaxKind.RE_UNICODE_PROPERTY_VALUE);
        return STNodeFactory.createReUnicodeGeneralCategoryNode(scriptStart, generalCategory);
    }

    private STNode parseReQuoteEscape(STNode backSlash) {
        STToken syntaxChar = this.consume();
        return STNodeFactory.createReQuoteEscapeNode(backSlash, syntaxChar);
    }

    static boolean isReSimpleCharClassCode(STToken token) {
        if (token.kind != SyntaxKind.RE_LITERAL_CHAR) {
            return false;
        }
        return switch (token.text()) {
            case "d", "D", "s", "S", "w", "W" -> true;
            default -> false;
        };
    }

    private STNode parseReSimpleCharClassEscape(STNode backSlash) {
        STNode simpleCharClassCode = this.getLiteralValueToken(this.consume(), SyntaxKind.RE_SIMPLE_CHAR_CLASS_CODE);
        return STNodeFactory.createReSimpleCharClassEscapeNode(backSlash, simpleCharClassCode);
    }

    private STNode parseCharacterClass() {
        STToken characterClassStart = this.consume();
        STNode negation = this.parseNegation();
        STNode characterSet = this.parseReCharSet(negation);
        STNode characterClassEnd = this.parseCharacterClassEnd();
        return STNodeFactory.createReCharacterClassNode(characterClassStart, negation, characterSet, characterClassEnd);
    }

    private STNode parseNegation() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.BITWISE_XOR_TOKEN) {
            return this.consume();
        }
        return null;
    }

    private STNode parseReCharSet(STNode prevNode) {
        STToken nextToken = this.peek();
        if (this.isCharacterClassEnd(nextToken.kind)) {
            return null;
        }
        STNode startReCharSetAtom = this.parseCharSetAtom(nextToken, prevNode);
        nextToken = this.peek();
        if (this.isCharacterClassEnd(nextToken.kind)) {
            return startReCharSetAtom;
        }
        if ("-".equals(nextToken.text())) {
            STToken minus = this.consume();
            nextToken = this.peek();
            if (this.isCharacterClassEnd(nextToken.kind)) {
                return STNodeFactory.createReCharSetAtomWithReCharSetNoDashNode(startReCharSetAtom, minus);
            }
            STNode rhsReCharSetAtom = this.parseCharSetAtom(nextToken, minus);
            STNode reCharSetRange = STNodeFactory.createReCharSetRangeNode(startReCharSetAtom, minus, rhsReCharSetAtom);
            STNode reCharSet = this.parseReCharSet(reCharSetRange);
            return STNodeFactory.createReCharSetRangeWithReCharSetNode(reCharSetRange, reCharSet);
        }
        STNode reCharSetNoDash = this.parseCharSetNoDash(nextToken, startReCharSetAtom);
        return STNodeFactory.createReCharSetAtomWithReCharSetNoDashNode(startReCharSetAtom, reCharSetNoDash);
    }

    private STNode parseCharSetNoDash(STToken nextToken, STNode prevNode) {
        STNode startReCharSetAtomNoDash = this.parseCharSetAtom(nextToken, prevNode);
        nextToken = this.peek();
        if (this.isCharacterClassEnd(nextToken.kind)) {
            return startReCharSetAtomNoDash;
        }
        if ("-".equals(nextToken.text())) {
            STToken minus = this.consume();
            nextToken = this.peek();
            if (this.isCharacterClassEnd(nextToken.kind)) {
                return STNodeFactory.createReCharSetAtomNoDashWithReCharSetNoDashNode(startReCharSetAtomNoDash, minus);
            }
            STNode rhsReCharSetAtom = this.parseCharSetAtom(nextToken, minus);
            STNode reCharSetRange = STNodeFactory.createReCharSetRangeNoDashNode(startReCharSetAtomNoDash, minus, rhsReCharSetAtom);
            STNode reCharSet = this.parseReCharSet(reCharSetRange);
            return STNodeFactory.createReCharSetRangeNoDashWithReCharSetNode(reCharSetRange, reCharSet);
        }
        STNode reCharSetNoDash = this.parseCharSetNoDash(nextToken, startReCharSetAtomNoDash);
        return STNodeFactory.createReCharSetAtomNoDashWithReCharSetNoDashNode(startReCharSetAtomNoDash, reCharSetNoDash);
    }

    private STNode parseCharSetAtom(STToken nextToken, STNode prevNode) {
        switch (nextToken.kind) {
            case RE_NUMERIC_ESCAPE: 
            case RE_CONTROL_ESCAPE: {
                return this.parseChars();
            }
            case BACK_SLASH_TOKEN: {
                STToken token = this.peek(2);
                if (token.kind == SyntaxKind.RE_LITERAL_CHAR && token.text().equals(Character.toString('-'))) {
                    this.consume();
                    STToken minusToken = this.consume();
                    return STNodeFactory.createToken(SyntaxKind.ESCAPED_MINUS_TOKEN, ((STNode)minusToken).leadingMinutiae(), ((STNode)minusToken).trailingMinutiae());
                }
                if (token.kind == SyntaxKind.CLOSE_BRACKET_TOKEN) {
                    this.tokenReader.startMode(ParserMode.RE_CHAR_CLASS);
                }
                return this.parseReEscape();
            }
        }
        STToken consumedToken = this.consume();
        if ("-".equals(nextToken.text())) {
            return consumedToken;
        }
        if (this.isReCharSetLiteralChar(nextToken.text())) {
            return consumedToken;
        }
        return SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(prevNode, (STNode)consumedToken, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_TOKEN_IN_REG_EXP, new Object[0]);
    }

    private boolean isReCharSetLiteralChar(String tokenText) {
        return switch (tokenText) {
            case "\\", "-", "]" -> false;
            default -> true;
        };
    }

    private boolean isCharacterClassEnd(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.CLOSE_BRACKET_TOKEN, SyntaxKind.EOF_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseCharacterClassEnd() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACKET_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.CLOSE_BRACKET_TOKEN);
    }

    private STNode parseReQuantifier() {
        STNode quantifier = this.parseBaseQuantifier();
        STNode nonGreedyChar = this.parseNonGreedyChar();
        return STNodeFactory.createReQuantifierNode(quantifier, nonGreedyChar);
    }

    private STNode parseBaseQuantifier() {
        STToken nextToken = this.peek();
        if (nextToken.kind != SyntaxKind.OPEN_BRACE_TOKEN) {
            return this.consume();
        }
        STNode openBrace = this.consume();
        nextToken = this.peek();
        if (this.isInvalidDigit(nextToken, true)) {
            openBrace = this.invalidateNonDigitNodesAndAddToTrailingMinutiae(openBrace, true);
        }
        STNode leastDigits = this.parseDigits(true);
        STNode comma = STNodeFactory.createEmptyNode();
        STNode mostDigits = STNodeFactory.createEmptyNodeList();
        nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.COMMA_TOKEN) {
            comma = this.consume();
            if (this.isInvalidDigit(nextToken, false)) {
                comma = this.invalidateNonDigitNodesAndAddToTrailingMinutiae(comma, false);
            }
            mostDigits = this.parseDigits(false);
        }
        STNode closeBrace = this.parseCloseBrace();
        return STNodeFactory.createReBracedQuantifierNode(openBrace, leastDigits, comma, mostDigits, closeBrace);
    }

    private STNode parseDigits(boolean isLeastDigits) {
        ArrayList<STNode> digits = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfDigits(nextToken.kind, isLeastDigits)) {
            STToken digit = this.consume();
            if (nextToken.kind != SyntaxKind.DIGIT) {
                this.updateLastNodeInListWithInvalidNode(digits, digit, DiagnosticErrorCode.ERROR_INVALID_TOKEN_IN_REG_EXP, new Object[0]);
            } else {
                digits.add(digit);
            }
            nextToken = this.peek();
        }
        if (isLeastDigits && digits.isEmpty()) {
            digits.add(this.createMissingTokenWithDiagnostics(SyntaxKind.DIGIT));
        }
        return STAbstractNodeFactory.createNodeList(digits);
    }

    private boolean isInvalidDigit(STToken nextToken, boolean isLeastDigits) {
        return !this.isEndOfDigits(nextToken.kind, isLeastDigits) && nextToken.kind != SyntaxKind.DIGIT;
    }

    private boolean isEndOfDigits(SyntaxKind kind, boolean isLeastDigits) {
        return switch (kind) {
            case SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.EOF_TOKEN -> true;
            case SyntaxKind.COMMA_TOKEN -> isLeastDigits;
            default -> false;
        };
    }

    private STNode parseCloseBrace() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.CLOSE_BRACE_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.CLOSE_BRACE_TOKEN);
    }

    private STNode parseNonGreedyChar() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.QUESTION_MARK_TOKEN) {
            return this.consume();
        }
        return null;
    }

    private STNode parseCapturingGroup() {
        STToken openParenthesis = this.consume();
        STToken nextToken = this.peek();
        STNode flagExpression = null;
        if (nextToken.kind == SyntaxKind.QUESTION_MARK_TOKEN) {
            flagExpression = this.parseFlagExpression();
        }
        STNode reDisjunction = this.parseReDisjunction(true);
        STNode closeParenthesis = this.parseCloseParenthesis();
        return STNodeFactory.createReCapturingGroupsNode(openParenthesis, flagExpression, reDisjunction, closeParenthesis);
    }

    private STNode parseFlagExpression() {
        STNode questionMark = this.consume();
        STToken nextToken = this.peek();
        STNode reFlagsOnOff = null;
        if (!this.isEndOfFlagExpression(nextToken.kind)) {
            if (this.isInvalidFlag(nextToken, true)) {
                questionMark = this.invalidateNonFlagNodesAndAddToTrailingMinutiae(questionMark, true);
            }
            reFlagsOnOff = this.parseReFlagsOnOff();
        }
        STNode colon = this.parseColon();
        return STNodeFactory.createReFlagExpressionNode(questionMark, reFlagsOnOff, colon);
    }

    private boolean isEndOfFlagExpression(SyntaxKind kind) {
        return kind == SyntaxKind.COLON_TOKEN || kind == SyntaxKind.EOF_TOKEN;
    }

    private boolean isInvalidFlag(STToken nextToken, boolean isLhsFlag) {
        return !this.isEndOfReFlags(nextToken, isLhsFlag) && !RegExpParser.isReFlag(nextToken);
    }

    static boolean isReFlag(STToken nextToken) {
        if (nextToken.kind != SyntaxKind.RE_LITERAL_CHAR) {
            return false;
        }
        return switch (nextToken.text()) {
            case "m", "s", "i", "x" -> true;
            default -> false;
        };
    }

    private STNode parseReFlagsOnOff() {
        STNode lhsReFlags = this.parseReFlags(true);
        STToken nextToken = this.peek();
        STNode dash = null;
        STNode rhsReFlags = null;
        if (nextToken.kind == SyntaxKind.RE_LITERAL_CHAR && nextToken.text().equals(Character.toString('-'))) {
            dash = this.getToken(this.consume(), SyntaxKind.MINUS_TOKEN);
            if (this.isInvalidFlag(nextToken, false)) {
                dash = this.invalidateNonFlagNodesAndAddToTrailingMinutiae(dash, false);
            }
            rhsReFlags = this.parseReFlags(false);
        }
        return STNodeFactory.createReFlagsOnOffNode(lhsReFlags, dash, rhsReFlags);
    }

    private STNode parseReFlags(boolean isLhsFlag) {
        ArrayList<STNode> reFlags = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfReFlags(nextToken, isLhsFlag)) {
            STNode reFlag = this.getLiteralValueToken(this.consume(), SyntaxKind.RE_FLAGS_VALUE);
            if (!RegExpParser.isReFlag(nextToken)) {
                this.updateLastNodeInListWithInvalidNode(reFlags, reFlag, DiagnosticErrorCode.ERROR_INVALID_FLAG_IN_REG_EXP, new Object[0]);
            } else {
                reFlags.add(reFlag);
            }
            nextToken = this.peek();
        }
        return STNodeFactory.createReFlagsNode(STAbstractNodeFactory.createNodeList(reFlags));
    }

    private boolean isEndOfReFlags(STToken nextToken, boolean isLhsFlag) {
        SyntaxKind kind = nextToken.kind;
        if (kind == SyntaxKind.EOF_TOKEN) {
            return true;
        }
        if (kind != SyntaxKind.RE_LITERAL_CHAR) {
            return false;
        }
        String tokenText = nextToken.text();
        return isLhsFlag && tokenText.equals(Character.toString('-')) || tokenText.equals(Character.toString(':'));
    }

    private STNode parseColon() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.RE_LITERAL_CHAR && nextToken.text().equals(Character.toString(':'))) {
            return this.getToken(this.consume(), SyntaxKind.COLON_TOKEN);
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.COLON_TOKEN);
    }

    private STNode parseCloseParenthesis() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.CLOSE_PAREN_TOKEN);
    }

    private STNode parseInterpolation() {
        this.consume();
        this.consume();
        return this.interpolationExprs.remove();
    }

    private boolean isEndOfReDisjunction(SyntaxKind kind, boolean inCapturingGroup) {
        return switch (kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN -> true;
            default -> kind == SyntaxKind.CLOSE_PAREN_TOKEN && inCapturingGroup;
        };
    }

    private boolean isEndOfReSequence(SyntaxKind kind, boolean inCapturingGroup) {
        return switch (kind) {
            case SyntaxKind.PIPE_TOKEN, SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN -> true;
            default -> kind == SyntaxKind.CLOSE_PAREN_TOKEN && inCapturingGroup;
        };
    }

    private STNode getToken(STToken token, SyntaxKind syntaxKind) {
        return STAbstractNodeFactory.createToken(syntaxKind, token.leadingMinutiae(), token.trailingMinutiae(), token.diagnostics());
    }

    private STNode getLiteralValueToken(STToken token, SyntaxKind syntaxKind) {
        return STAbstractNodeFactory.createLiteralValueToken(syntaxKind, token.text(), token.leadingMinutiae(), token.trailingMinutiae(), token.diagnostics());
    }

    private STNode invalidateNonDigitNodesAndAddToTrailingMinutiae(STNode node, boolean isLeastDigits) {
        node = this.addInvalidNodeStackToTrailingMinutiae(node);
        while (this.isInvalidDigit(this.peek(), isLeastDigits)) {
            node = this.addTrailingInvalidNode(node, DiagnosticErrorCode.ERROR_INVALID_QUANTIFIER_IN_REG_EXP);
        }
        return node;
    }

    private STNode addTrailingInvalidNode(STNode node, DiagnosticErrorCode errorCode) {
        STToken invalidToken = this.consume();
        return SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(node, (STNode)invalidToken, (DiagnosticCode)errorCode, new Object[0]);
    }

    private STNode invalidateNonFlagNodesAndAddToTrailingMinutiae(STNode node, boolean isLhsFlag) {
        node = this.addInvalidNodeStackToTrailingMinutiae(node);
        while (this.isInvalidFlag(this.peek(), isLhsFlag)) {
            node = this.addTrailingInvalidNode(node, DiagnosticErrorCode.ERROR_INVALID_FLAG_IN_REG_EXP);
        }
        return node;
    }

    private STNode createMissingTokenWithDiagnostics(SyntaxKind expectedKind) {
        return SyntaxErrors.createMissingRegExpTokenWithDiagnostics(expectedKind);
    }
}

