/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STModuleMemberDeclarationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STClassDefinitionNode
extends STModuleMemberDeclarationNode {
    public final STNode metadata;
    public final STNode visibilityQualifier;
    public final STNode classTypeQualifiers;
    public final STNode classKeyword;
    public final STNode className;
    public final STNode openBrace;
    public final STNode members;
    public final STNode closeBrace;
    public final STNode semicolonToken;

    STClassDefinitionNode(STNode metadata, STNode visibilityQualifier, STNode classTypeQualifiers, STNode classKeyword, STNode className, STNode openBrace, STNode members, STNode closeBrace, STNode semicolonToken) {
        this(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace, semicolonToken, Collections.emptyList());
    }

    STClassDefinitionNode(STNode metadata, STNode visibilityQualifier, STNode classTypeQualifiers, STNode classKeyword, STNode className, STNode openBrace, STNode members, STNode closeBrace, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.CLASS_DEFINITION, diagnostics);
        this.metadata = metadata;
        this.visibilityQualifier = visibilityQualifier;
        this.classTypeQualifiers = classTypeQualifiers;
        this.classKeyword = classKeyword;
        this.className = className;
        this.openBrace = openBrace;
        this.members = members;
        this.closeBrace = closeBrace;
        this.semicolonToken = semicolonToken;
        this.addChildren(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STClassDefinitionNode(this.metadata, this.visibilityQualifier, this.classTypeQualifiers, this.classKeyword, this.className, this.openBrace, this.members, this.closeBrace, this.semicolonToken, diagnostics);
    }

    public STClassDefinitionNode modify(STNode metadata, STNode visibilityQualifier, STNode classTypeQualifiers, STNode classKeyword, STNode className, STNode openBrace, STNode members, STNode closeBrace, STNode semicolonToken) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace, semicolonToken)) {
            return this;
        }
        return new STClassDefinitionNode(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ClassDefinitionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

