/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STErrorConstructorExpressionNode
extends STExpressionNode {
    public final STNode errorKeyword;
    public final STNode typeReference;
    public final STNode openParenToken;
    public final STNode arguments;
    public final STNode closeParenToken;

    STErrorConstructorExpressionNode(STNode errorKeyword, STNode typeReference, STNode openParenToken, STNode arguments, STNode closeParenToken) {
        this(errorKeyword, typeReference, openParenToken, arguments, closeParenToken, Collections.emptyList());
    }

    STErrorConstructorExpressionNode(STNode errorKeyword, STNode typeReference, STNode openParenToken, STNode arguments, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ERROR_CONSTRUCTOR, diagnostics);
        this.errorKeyword = errorKeyword;
        this.typeReference = typeReference;
        this.openParenToken = openParenToken;
        this.arguments = arguments;
        this.closeParenToken = closeParenToken;
        this.addChildren(errorKeyword, typeReference, openParenToken, arguments, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STErrorConstructorExpressionNode(this.errorKeyword, this.typeReference, this.openParenToken, this.arguments, this.closeParenToken, diagnostics);
    }

    public STErrorConstructorExpressionNode modify(STNode errorKeyword, STNode typeReference, STNode openParenToken, STNode arguments, STNode closeParenToken) {
        if (this.checkForReferenceEquality(errorKeyword, typeReference, openParenToken, arguments, closeParenToken)) {
            return this;
        }
        return new STErrorConstructorExpressionNode(errorKeyword, typeReference, openParenToken, arguments, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ErrorConstructorExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

