/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MemberTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMemberTypeDescriptorNode
extends STNode {
    public final STNode annotations;
    public final STNode typeDescriptor;

    STMemberTypeDescriptorNode(STNode annotations, STNode typeDescriptor) {
        this(annotations, typeDescriptor, Collections.emptyList());
    }

    STMemberTypeDescriptorNode(STNode annotations, STNode typeDescriptor, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MEMBER_TYPE_DESC, diagnostics);
        this.annotations = annotations;
        this.typeDescriptor = typeDescriptor;
        this.addChildren(annotations, typeDescriptor);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMemberTypeDescriptorNode(this.annotations, this.typeDescriptor, diagnostics);
    }

    public STMemberTypeDescriptorNode modify(STNode annotations, STNode typeDescriptor) {
        if (this.checkForReferenceEquality(annotations, typeDescriptor)) {
            return this;
        }
        return new STMemberTypeDescriptorNode(annotations, typeDescriptor, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MemberTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

