/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.NaturalExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STNaturalExpressionNode
extends STExpressionNode {
    public final STNode constKeyword;
    public final STNode naturalKeyword;
    public final STNode parenthesizedArgList;
    public final STNode openBraceToken;
    public final STNode prompt;
    public final STNode closeBraceToken;

    STNaturalExpressionNode(STNode constKeyword, STNode naturalKeyword, STNode parenthesizedArgList, STNode openBraceToken, STNode prompt, STNode closeBraceToken) {
        this(constKeyword, naturalKeyword, parenthesizedArgList, openBraceToken, prompt, closeBraceToken, Collections.emptyList());
    }

    STNaturalExpressionNode(STNode constKeyword, STNode naturalKeyword, STNode parenthesizedArgList, STNode openBraceToken, STNode prompt, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.NATURAL_EXPRESSION, diagnostics);
        this.constKeyword = constKeyword;
        this.naturalKeyword = naturalKeyword;
        this.parenthesizedArgList = parenthesizedArgList;
        this.openBraceToken = openBraceToken;
        this.prompt = prompt;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(constKeyword, naturalKeyword, parenthesizedArgList, openBraceToken, prompt, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STNaturalExpressionNode(this.constKeyword, this.naturalKeyword, this.parenthesizedArgList, this.openBraceToken, this.prompt, this.closeBraceToken, diagnostics);
    }

    public STNaturalExpressionNode modify(STNode constKeyword, STNode naturalKeyword, STNode parenthesizedArgList, STNode openBraceToken, STNode prompt, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(constKeyword, naturalKeyword, parenthesizedArgList, openBraceToken, prompt, closeBraceToken)) {
            return this;
        }
        return new STNaturalExpressionNode(constKeyword, naturalKeyword, parenthesizedArgList, openBraceToken, prompt, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new NaturalExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

