/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QueryPipelineNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STQueryPipelineNode
extends STNode {
    public final STNode fromClause;
    public final STNode intermediateClauses;

    STQueryPipelineNode(STNode fromClause, STNode intermediateClauses) {
        this(fromClause, intermediateClauses, Collections.emptyList());
    }

    STQueryPipelineNode(STNode fromClause, STNode intermediateClauses, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.QUERY_PIPELINE, diagnostics);
        this.fromClause = fromClause;
        this.intermediateClauses = intermediateClauses;
        this.addChildren(fromClause, intermediateClauses);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STQueryPipelineNode(this.fromClause, this.intermediateClauses, diagnostics);
    }

    public STQueryPipelineNode modify(STNode fromClause, STNode intermediateClauses) {
        if (this.checkForReferenceEquality(fromClause, intermediateClauses)) {
            return this;
        }
        return new STQueryPipelineNode(fromClause, intermediateClauses, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new QueryPipelineNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

