/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.Collection;
import java.util.Collections;

public class STTypeParameterNode
extends STNode {
    public final STNode ltToken;
    public final STNode typeNode;
    public final STNode gtToken;

    STTypeParameterNode(STNode ltToken, STNode typeNode, STNode gtToken) {
        this(ltToken, typeNode, gtToken, Collections.emptyList());
    }

    STTypeParameterNode(STNode ltToken, STNode typeNode, STNode gtToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TYPE_PARAMETER, diagnostics);
        this.ltToken = ltToken;
        this.typeNode = typeNode;
        this.gtToken = gtToken;
        this.addChildren(ltToken, typeNode, gtToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTypeParameterNode(this.ltToken, this.typeNode, this.gtToken, diagnostics);
    }

    public STTypeParameterNode modify(STNode ltToken, STNode typeNode, STNode gtToken) {
        if (this.checkForReferenceEquality(ltToken, typeNode, gtToken)) {
            return this;
        }
        return new STTypeParameterNode(ltToken, typeNode, gtToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TypeParameterNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

