/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLItemNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLComment;
import java.util.Collection;
import java.util.Collections;

public class STXMLComment
extends STXMLItemNode {
    public final STNode commentStart;
    public final STNode content;
    public final STNode commentEnd;

    STXMLComment(STNode commentStart, STNode content, STNode commentEnd) {
        this(commentStart, content, commentEnd, Collections.emptyList());
    }

    STXMLComment(STNode commentStart, STNode content, STNode commentEnd, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_COMMENT, diagnostics);
        this.commentStart = commentStart;
        this.content = content;
        this.commentEnd = commentEnd;
        this.addChildren(commentStart, content, commentEnd);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLComment(this.commentStart, this.content, this.commentEnd, diagnostics);
    }

    public STXMLComment modify(STNode commentStart, STNode content, STNode commentEnd) {
        if (this.checkForReferenceEquality(commentStart, content, commentEnd)) {
            return this;
        }
        return new STXMLComment(commentStart, content, commentEnd, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLComment(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

