/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.syntax;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TreeModifier;
import io.ballerina.tools.text.TextRange;

class NodeReplacer
extends TreeModifier {
    private final TextRange oldNodeTextRange;
    private final Node target;
    private final Node replacement;

    NodeReplacer(Node target, Node replacement) {
        this.oldNodeTextRange = target.textRangeWithMinutiae();
        this.target = target;
        this.replacement = replacement;
    }

    <T extends NonTerminalNode> T replace(T root) {
        return this.modifyNode(root);
    }

    private boolean shouldDescend(Node node) {
        return this.oldNodeTextRange.intersectionExists(node.textRangeWithMinutiae());
    }

    @Override
    protected <T extends Node> T modifyNode(T node) {
        if (node == null) {
            return null;
        }
        Node replaced = node;
        if (node == this.target) {
            replaced = this.replacement;
        } else if (this.shouldDescend(node)) {
            replaced = node.apply(this);
        }
        return (T)replaced;
    }

    @Override
    protected <T extends Token> T modifyToken(T token) {
        if (token == null) {
            return null;
        }
        Object replaced = token;
        if (token == this.target) {
            replaced = (Token)this.replacement;
        }
        return replaced;
    }
}

