/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ArrayDimensionNode
extends NonTerminalNode {
    public ArrayDimensionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public Optional<Node> arrayLength() {
        return this.optionalChildInBucket(1);
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "arrayLength", "closeBracket"};
    }

    public ArrayDimensionNode modify(Token openBracket, Node arrayLength, Token closeBracket) {
        if (this.checkForReferenceEquality(openBracket, arrayLength, closeBracket)) {
            return this;
        }
        return NodeFactory.createArrayDimensionNode(openBracket, arrayLength, closeBracket);
    }

    public ArrayDimensionNodeModifier modify() {
        return new ArrayDimensionNodeModifier(this);
    }

    public static class ArrayDimensionNodeModifier {
        private final ArrayDimensionNode oldNode;
        private Token openBracket;
        private Node arrayLength;
        private Token closeBracket;

        public ArrayDimensionNodeModifier(ArrayDimensionNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.arrayLength = oldNode.arrayLength().orElse(null);
            this.closeBracket = oldNode.closeBracket();
        }

        public ArrayDimensionNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public ArrayDimensionNodeModifier withArrayLength(Node arrayLength) {
            this.arrayLength = arrayLength;
            return this;
        }

        public ArrayDimensionNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public ArrayDimensionNode apply() {
            return this.oldNode.modify(this.openBracket, this.arrayLength, this.closeBracket);
        }
    }
}

