/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ComputedResourceAccessSegmentNode
extends NonTerminalNode {
    public ComputedResourceAccessSegmentNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracketToken() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token closeBracketToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracketToken", "expression", "closeBracketToken"};
    }

    public ComputedResourceAccessSegmentNode modify(Token openBracketToken, ExpressionNode expression, Token closeBracketToken) {
        if (this.checkForReferenceEquality(openBracketToken, expression, closeBracketToken)) {
            return this;
        }
        return NodeFactory.createComputedResourceAccessSegmentNode(openBracketToken, expression, closeBracketToken);
    }

    public ComputedResourceAccessSegmentNodeModifier modify() {
        return new ComputedResourceAccessSegmentNodeModifier(this);
    }

    public static class ComputedResourceAccessSegmentNodeModifier {
        private final ComputedResourceAccessSegmentNode oldNode;
        private Token openBracketToken;
        private ExpressionNode expression;
        private Token closeBracketToken;

        public ComputedResourceAccessSegmentNodeModifier(ComputedResourceAccessSegmentNode oldNode) {
            this.oldNode = oldNode;
            this.openBracketToken = oldNode.openBracketToken();
            this.expression = oldNode.expression();
            this.closeBracketToken = oldNode.closeBracketToken();
        }

        public ComputedResourceAccessSegmentNodeModifier withOpenBracketToken(Token openBracketToken) {
            Objects.requireNonNull(openBracketToken, "openBracketToken must not be null");
            this.openBracketToken = openBracketToken;
            return this;
        }

        public ComputedResourceAccessSegmentNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public ComputedResourceAccessSegmentNodeModifier withCloseBracketToken(Token closeBracketToken) {
            Objects.requireNonNull(closeBracketToken, "closeBracketToken must not be null");
            this.closeBracketToken = closeBracketToken;
            return this;
        }

        public ComputedResourceAccessSegmentNode apply() {
            return this.oldNode.modify(this.openBracketToken, this.expression, this.closeBracketToken);
        }
    }
}

