/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class LetClauseNode
extends IntermediateClauseNode {
    public LetClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token letKeyword() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<LetVariableDeclarationNode> letVarDeclarations() {
        return new SeparatedNodeList<LetVariableDeclarationNode>((NonTerminalNode)this.childInBucket(1));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"letKeyword", "letVarDeclarations"};
    }

    public LetClauseNode modify(Token letKeyword, SeparatedNodeList<LetVariableDeclarationNode> letVarDeclarations) {
        if (this.checkForReferenceEquality(letKeyword, letVarDeclarations.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createLetClauseNode(letKeyword, letVarDeclarations);
    }

    public LetClauseNodeModifier modify() {
        return new LetClauseNodeModifier(this);
    }

    public static class LetClauseNodeModifier {
        private final LetClauseNode oldNode;
        private Token letKeyword;
        private SeparatedNodeList<LetVariableDeclarationNode> letVarDeclarations;

        public LetClauseNodeModifier(LetClauseNode oldNode) {
            this.oldNode = oldNode;
            this.letKeyword = oldNode.letKeyword();
            this.letVarDeclarations = oldNode.letVarDeclarations();
        }

        public LetClauseNodeModifier withLetKeyword(Token letKeyword) {
            Objects.requireNonNull(letKeyword, "letKeyword must not be null");
            this.letKeyword = letKeyword;
            return this;
        }

        public LetClauseNodeModifier withLetVarDeclarations(SeparatedNodeList<LetVariableDeclarationNode> letVarDeclarations) {
            Objects.requireNonNull(letVarDeclarations, "letVarDeclarations must not be null");
            this.letVarDeclarations = letVarDeclarations;
            return this;
        }

        public LetClauseNode apply() {
            return this.oldNode.modify(this.letKeyword, this.letVarDeclarations);
        }
    }
}

