/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.DocumentationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class MarkdownDocumentationLineNode
extends DocumentationNode {
    public MarkdownDocumentationLineNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token hashToken() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<Node> documentElements() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"hashToken", "documentElements"};
    }

    public MarkdownDocumentationLineNode modify(SyntaxKind kind, Token hashToken, NodeList<Node> documentElements) {
        if (this.checkForReferenceEquality(hashToken, documentElements.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createMarkdownDocumentationLineNode(kind, hashToken, documentElements);
    }

    public MarkdownDocumentationLineNodeModifier modify() {
        return new MarkdownDocumentationLineNodeModifier(this);
    }

    public static class MarkdownDocumentationLineNodeModifier {
        private final MarkdownDocumentationLineNode oldNode;
        private Token hashToken;
        private NodeList<Node> documentElements;

        public MarkdownDocumentationLineNodeModifier(MarkdownDocumentationLineNode oldNode) {
            this.oldNode = oldNode;
            this.hashToken = oldNode.hashToken();
            this.documentElements = oldNode.documentElements();
        }

        public MarkdownDocumentationLineNodeModifier withHashToken(Token hashToken) {
            Objects.requireNonNull(hashToken, "hashToken must not be null");
            this.hashToken = hashToken;
            return this;
        }

        public MarkdownDocumentationLineNodeModifier withDocumentElements(NodeList<Node> documentElements) {
            Objects.requireNonNull(documentElements, "documentElements must not be null");
            this.documentElements = documentElements;
            return this;
        }

        public MarkdownDocumentationLineNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.hashToken, this.documentElements);
        }
    }
}

