/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class NaturalExpressionNode
extends ExpressionNode {
    public NaturalExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> constKeyword() {
        return this.optionalChildInBucket(0);
    }

    public Token naturalKeyword() {
        return (Token)this.childInBucket(1);
    }

    public Optional<ParenthesizedArgList> parenthesizedArgList() {
        return this.optionalChildInBucket(2);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(3);
    }

    public NodeList<Node> prompt() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(4));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"constKeyword", "naturalKeyword", "parenthesizedArgList", "openBraceToken", "prompt", "closeBraceToken"};
    }

    public NaturalExpressionNode modify(Token constKeyword, Token naturalKeyword, ParenthesizedArgList parenthesizedArgList, Token openBraceToken, NodeList<Node> prompt, Token closeBraceToken) {
        if (this.checkForReferenceEquality(constKeyword, naturalKeyword, parenthesizedArgList, openBraceToken, prompt.underlyingListNode(), closeBraceToken)) {
            return this;
        }
        return NodeFactory.createNaturalExpressionNode(constKeyword, naturalKeyword, parenthesizedArgList, openBraceToken, prompt, closeBraceToken);
    }

    public NaturalExpressionNodeModifier modify() {
        return new NaturalExpressionNodeModifier(this);
    }

    public static class NaturalExpressionNodeModifier {
        private final NaturalExpressionNode oldNode;
        private Token constKeyword;
        private Token naturalKeyword;
        private ParenthesizedArgList parenthesizedArgList;
        private Token openBraceToken;
        private NodeList<Node> prompt;
        private Token closeBraceToken;

        public NaturalExpressionNodeModifier(NaturalExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.constKeyword = oldNode.constKeyword().orElse(null);
            this.naturalKeyword = oldNode.naturalKeyword();
            this.parenthesizedArgList = oldNode.parenthesizedArgList().orElse(null);
            this.openBraceToken = oldNode.openBraceToken();
            this.prompt = oldNode.prompt();
            this.closeBraceToken = oldNode.closeBraceToken();
        }

        public NaturalExpressionNodeModifier withConstKeyword(Token constKeyword) {
            this.constKeyword = constKeyword;
            return this;
        }

        public NaturalExpressionNodeModifier withNaturalKeyword(Token naturalKeyword) {
            Objects.requireNonNull(naturalKeyword, "naturalKeyword must not be null");
            this.naturalKeyword = naturalKeyword;
            return this;
        }

        public NaturalExpressionNodeModifier withParenthesizedArgList(ParenthesizedArgList parenthesizedArgList) {
            this.parenthesizedArgList = parenthesizedArgList;
            return this;
        }

        public NaturalExpressionNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public NaturalExpressionNodeModifier withPrompt(NodeList<Node> prompt) {
            Objects.requireNonNull(prompt, "prompt must not be null");
            this.prompt = prompt;
            return this;
        }

        public NaturalExpressionNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public NaturalExpressionNode apply() {
            return this.oldNode.modify(this.constKeyword, this.naturalKeyword, this.parenthesizedArgList, this.openBraceToken, this.prompt, this.closeBraceToken);
        }
    }
}

