/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ReBracedQuantifierNode
extends NonTerminalNode {
    public ReBracedQuantifierNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<Node> leastTimesMatchedDigit() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Optional<Token> commaToken() {
        return this.optionalChildInBucket(2);
    }

    public NodeList<Node> mostTimesMatchedDigit() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(3));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBraceToken", "leastTimesMatchedDigit", "commaToken", "mostTimesMatchedDigit", "closeBraceToken"};
    }

    public ReBracedQuantifierNode modify(Token openBraceToken, NodeList<Node> leastTimesMatchedDigit, Token commaToken, NodeList<Node> mostTimesMatchedDigit, Token closeBraceToken) {
        if (this.checkForReferenceEquality(openBraceToken, leastTimesMatchedDigit.underlyingListNode(), commaToken, mostTimesMatchedDigit.underlyingListNode(), closeBraceToken)) {
            return this;
        }
        return NodeFactory.createReBracedQuantifierNode(openBraceToken, leastTimesMatchedDigit, commaToken, mostTimesMatchedDigit, closeBraceToken);
    }

    public ReBracedQuantifierNodeModifier modify() {
        return new ReBracedQuantifierNodeModifier(this);
    }

    public static class ReBracedQuantifierNodeModifier {
        private final ReBracedQuantifierNode oldNode;
        private Token openBraceToken;
        private NodeList<Node> leastTimesMatchedDigit;
        private Token commaToken;
        private NodeList<Node> mostTimesMatchedDigit;
        private Token closeBraceToken;

        public ReBracedQuantifierNodeModifier(ReBracedQuantifierNode oldNode) {
            this.oldNode = oldNode;
            this.openBraceToken = oldNode.openBraceToken();
            this.leastTimesMatchedDigit = oldNode.leastTimesMatchedDigit();
            this.commaToken = oldNode.commaToken().orElse(null);
            this.mostTimesMatchedDigit = oldNode.mostTimesMatchedDigit();
            this.closeBraceToken = oldNode.closeBraceToken();
        }

        public ReBracedQuantifierNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public ReBracedQuantifierNodeModifier withLeastTimesMatchedDigit(NodeList<Node> leastTimesMatchedDigit) {
            Objects.requireNonNull(leastTimesMatchedDigit, "leastTimesMatchedDigit must not be null");
            this.leastTimesMatchedDigit = leastTimesMatchedDigit;
            return this;
        }

        public ReBracedQuantifierNodeModifier withCommaToken(Token commaToken) {
            this.commaToken = commaToken;
            return this;
        }

        public ReBracedQuantifierNodeModifier withMostTimesMatchedDigit(NodeList<Node> mostTimesMatchedDigit) {
            Objects.requireNonNull(mostTimesMatchedDigit, "mostTimesMatchedDigit must not be null");
            this.mostTimesMatchedDigit = mostTimesMatchedDigit;
            return this;
        }

        public ReBracedQuantifierNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public ReBracedQuantifierNode apply() {
            return this.oldNode.modify(this.openBraceToken, this.leastTimesMatchedDigit, this.commaToken, this.mostTimesMatchedDigit, this.closeBraceToken);
        }
    }
}

