/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReFlagsNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ReFlagsOnOffNode
extends NonTerminalNode {
    public ReFlagsOnOffNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ReFlagsNode lhsReFlags() {
        return (ReFlagsNode)this.childInBucket(0);
    }

    public Optional<Token> minusToken() {
        return this.optionalChildInBucket(1);
    }

    public Optional<ReFlagsNode> rhsReFlags() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"lhsReFlags", "minusToken", "rhsReFlags"};
    }

    public ReFlagsOnOffNode modify(ReFlagsNode lhsReFlags, Token minusToken, ReFlagsNode rhsReFlags) {
        if (this.checkForReferenceEquality(lhsReFlags, minusToken, rhsReFlags)) {
            return this;
        }
        return NodeFactory.createReFlagsOnOffNode(lhsReFlags, minusToken, rhsReFlags);
    }

    public ReFlagsOnOffNodeModifier modify() {
        return new ReFlagsOnOffNodeModifier(this);
    }

    public static class ReFlagsOnOffNodeModifier {
        private final ReFlagsOnOffNode oldNode;
        private ReFlagsNode lhsReFlags;
        private Token minusToken;
        private ReFlagsNode rhsReFlags;

        public ReFlagsOnOffNodeModifier(ReFlagsOnOffNode oldNode) {
            this.oldNode = oldNode;
            this.lhsReFlags = oldNode.lhsReFlags();
            this.minusToken = oldNode.minusToken().orElse(null);
            this.rhsReFlags = oldNode.rhsReFlags().orElse(null);
        }

        public ReFlagsOnOffNodeModifier withLhsReFlags(ReFlagsNode lhsReFlags) {
            Objects.requireNonNull(lhsReFlags, "lhsReFlags must not be null");
            this.lhsReFlags = lhsReFlags;
            return this;
        }

        public ReFlagsOnOffNodeModifier withMinusToken(Token minusToken) {
            this.minusToken = minusToken;
            return this;
        }

        public ReFlagsOnOffNodeModifier withRhsReFlags(ReFlagsNode rhsReFlags) {
            this.rhsReFlags = rhsReFlags;
            return this;
        }

        public ReFlagsOnOffNode apply() {
            return this.oldNode.modify(this.lhsReFlags, this.minusToken, this.rhsReFlags);
        }
    }
}

