/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ReturnStatementNode
extends StatementNode {
    public ReturnStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token returnKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<ExpressionNode> expression() {
        return this.optionalChildInBucket(1);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"returnKeyword", "expression", "semicolonToken"};
    }

    public ReturnStatementNode modify(Token returnKeyword, ExpressionNode expression, Token semicolonToken) {
        if (this.checkForReferenceEquality(returnKeyword, expression, semicolonToken)) {
            return this;
        }
        return NodeFactory.createReturnStatementNode(returnKeyword, expression, semicolonToken);
    }

    public ReturnStatementNodeModifier modify() {
        return new ReturnStatementNodeModifier(this);
    }

    public static class ReturnStatementNodeModifier {
        private final ReturnStatementNode oldNode;
        private Token returnKeyword;
        private ExpressionNode expression;
        private Token semicolonToken;

        public ReturnStatementNodeModifier(ReturnStatementNode oldNode) {
            this.oldNode = oldNode;
            this.returnKeyword = oldNode.returnKeyword();
            this.expression = oldNode.expression().orElse(null);
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ReturnStatementNodeModifier withReturnKeyword(Token returnKeyword) {
            Objects.requireNonNull(returnKeyword, "returnKeyword must not be null");
            this.returnKeyword = returnKeyword;
            return this;
        }

        public ReturnStatementNodeModifier withExpression(ExpressionNode expression) {
            this.expression = expression;
            return this;
        }

        public ReturnStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ReturnStatementNode apply() {
            return this.oldNode.modify(this.returnKeyword, this.expression, this.semicolonToken);
        }
    }
}

