/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class TrippleGTTokenNode
extends NonTerminalNode {
    public TrippleGTTokenNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openGTToken() {
        return (Token)this.childInBucket(0);
    }

    public Token middleGTToken() {
        return (Token)this.childInBucket(1);
    }

    public Token endGTToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openGTToken", "middleGTToken", "endGTToken"};
    }

    public TrippleGTTokenNode modify(Token openGTToken, Token middleGTToken, Token endGTToken) {
        if (this.checkForReferenceEquality(openGTToken, middleGTToken, endGTToken)) {
            return this;
        }
        return NodeFactory.createTrippleGTTokenNode(openGTToken, middleGTToken, endGTToken);
    }

    public TrippleGTTokenNodeModifier modify() {
        return new TrippleGTTokenNodeModifier(this);
    }

    public static class TrippleGTTokenNodeModifier {
        private final TrippleGTTokenNode oldNode;
        private Token openGTToken;
        private Token middleGTToken;
        private Token endGTToken;

        public TrippleGTTokenNodeModifier(TrippleGTTokenNode oldNode) {
            this.oldNode = oldNode;
            this.openGTToken = oldNode.openGTToken();
            this.middleGTToken = oldNode.middleGTToken();
            this.endGTToken = oldNode.endGTToken();
        }

        public TrippleGTTokenNodeModifier withOpenGTToken(Token openGTToken) {
            Objects.requireNonNull(openGTToken, "openGTToken must not be null");
            this.openGTToken = openGTToken;
            return this;
        }

        public TrippleGTTokenNodeModifier withMiddleGTToken(Token middleGTToken) {
            Objects.requireNonNull(middleGTToken, "middleGTToken must not be null");
            this.middleGTToken = middleGTToken;
            return this;
        }

        public TrippleGTTokenNodeModifier withEndGTToken(Token endGTToken) {
            Objects.requireNonNull(endGTToken, "endGTToken must not be null");
            this.endGTToken = endGTToken;
            return this;
        }

        public TrippleGTTokenNode apply() {
            return this.oldNode.modify(this.openGTToken, this.middleGTToken, this.endGTToken);
        }
    }
}

