/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class TypedBindingPatternNode
extends NonTerminalNode {
    public TypedBindingPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public TypeDescriptorNode typeDescriptor() {
        return (TypeDescriptorNode)this.childInBucket(0);
    }

    public BindingPatternNode bindingPattern() {
        return (BindingPatternNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"typeDescriptor", "bindingPattern"};
    }

    public TypedBindingPatternNode modify(TypeDescriptorNode typeDescriptor, BindingPatternNode bindingPattern) {
        if (this.checkForReferenceEquality(typeDescriptor, bindingPattern)) {
            return this;
        }
        return NodeFactory.createTypedBindingPatternNode(typeDescriptor, bindingPattern);
    }

    public TypedBindingPatternNodeModifier modify() {
        return new TypedBindingPatternNodeModifier(this);
    }

    public static class TypedBindingPatternNodeModifier {
        private final TypedBindingPatternNode oldNode;
        private TypeDescriptorNode typeDescriptor;
        private BindingPatternNode bindingPattern;

        public TypedBindingPatternNodeModifier(TypedBindingPatternNode oldNode) {
            this.oldNode = oldNode;
            this.typeDescriptor = oldNode.typeDescriptor();
            this.bindingPattern = oldNode.bindingPattern();
        }

        public TypedBindingPatternNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public TypedBindingPatternNodeModifier withBindingPattern(BindingPatternNode bindingPattern) {
            Objects.requireNonNull(bindingPattern, "bindingPattern must not be null");
            this.bindingPattern = bindingPattern;
            return this;
        }

        public TypedBindingPatternNode apply() {
            return this.oldNode.modify(this.typeDescriptor, this.bindingPattern);
        }
    }
}

