/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.typedesc;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeId;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BTypeIdSet;
import io.ballerina.runtime.internal.types.BTypeReferenceType;
import java.util.ArrayList;
import java.util.HashMap;

public final class TypeIds {
    private static final String PACKAGE_NAME = "lang.typedesc";
    private static final String BALLERINA_BUILTIN_PKG_PREFIX = "ballerina";
    private static final String PACKAGE_VERSION = "0";
    private static final Module BALLERINA_TYPEDESC_PKG_ID = new Module("ballerina", "lang.typedesc", "0");
    private static final String TYPE_ID_TYPE_SIG = "record {| ballerina/lang.typedesc:0.0.0:ModuleId moduleId; (string|int) localId; |}";
    private static final String MODULE_ID_TYPE_SIG = "record {| string organization; string name; string[] platformParts; |}";
    private static final ArrayType typeIdArrayType = new BArrayType(TypeIds.createTypeId(TypeIds.createModuleId(BALLERINA_TYPEDESC_PKG_ID), "empty").getType());

    private TypeIds() {
    }

    public static Object typeIds(BTypedesc t, boolean primaryOnly) {
        Type describingType = t.getDescribingType();
        BTypeIdSet typeIdSet = TypeIds.getTypeIdSetForType(describingType);
        if (typeIdSet == null) {
            return null;
        }
        ArrayList<BMap<BString, Object>> objects = new ArrayList<BMap<BString, Object>>();
        for (TypeId id : typeIdSet.getIds()) {
            if (primaryOnly && !id.isPrimary()) continue;
            BMap<BString, Object> moduleId = TypeIds.createModuleId(id.getPkg());
            objects.add(TypeIds.createTypeId(moduleId, id.getName()));
        }
        BArray arrayValue = ValueCreator.createArrayValue((Object[])objects.toArray(new Object[0]), (ArrayType)typeIdArrayType);
        arrayValue.freezeDirect();
        return arrayValue;
    }

    private static BTypeIdSet getTypeIdSetForType(Type describingType) {
        BTypeIdSet typeIdSet;
        switch (describingType.getTag()) {
            case 42: {
                BErrorType errorType = (BErrorType)describingType;
                typeIdSet = errorType.typeIdSet;
                break;
            }
            case 31: 
            case 47: {
                BObjectType objectType = (BObjectType)describingType;
                typeIdSet = objectType.typeIdSet;
                break;
            }
            case 34: {
                BIntersectionType intersectionType = (BIntersectionType)describingType;
                typeIdSet = TypeIds.getTypeIdSetForType(intersectionType.getEffectiveType());
                break;
            }
            case 53: {
                BTypeReferenceType referenceType = (BTypeReferenceType)describingType;
                typeIdSet = TypeIds.getTypeIdSetForType(referenceType.getReferredType());
                break;
            }
            default: {
                return null;
            }
        }
        return typeIdSet != null ? typeIdSet : new BTypeIdSet();
    }

    private static BMap<BString, Object> createModuleId(Module mod) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("organization", StringUtils.fromString((String)mod.getOrg()));
        map.put("name", StringUtils.fromString((String)mod.getName()));
        map.put("platformParts", ValueCreator.createArrayValue((BString[])new BString[]{StringUtils.fromString((String)mod.getMajorVersion())}));
        return ValueCreator.createReadonlyRecordValue((Module)BALLERINA_TYPEDESC_PKG_ID, (String)MODULE_ID_TYPE_SIG, map);
    }

    private static BMap<BString, Object> createTypeId(Object moduleId, String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("moduleId", moduleId);
        map.put("localId", TypeIds.processLocalId(name));
        return ValueCreator.createReadonlyRecordValue((Module)BALLERINA_TYPEDESC_PKG_ID, (String)TYPE_ID_TYPE_SIG, map);
    }

    private static Object processLocalId(String localId) {
        for (char c : localId.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return StringUtils.fromString((String)localId);
        }
        try {
            return Long.parseLong(localId);
        }
        catch (NumberFormatException e) {
            return StringUtils.fromString((String)localId);
        }
    }
}

