/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TypeUtils {
    private static final String UNICODE_REGEX = "\\\\(\\\\*)u\\{([a-fA-F0-9]+)\\}";
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\(\\\\*)u\\{([a-fA-F0-9]+)\\}");
    private static final String SINGLE_QUOTE_CHARACTER = "'";

    private TypeUtils() {
    }

    public static String removeEscapeCharacter(String identifier) {
        if (identifier == null) {
            return null;
        }
        Matcher matcher = UNICODE_PATTERN.matcher(identifier);
        StringBuffer buffer = new StringBuffer(identifier.length());
        while (matcher.find()) {
            String leadingSlashes = matcher.group(1);
            if (TypeUtils.isEscapedNumericEscape(leadingSlashes)) continue;
            int codePoint = Integer.parseInt(matcher.group(2), 16);
            char[] chars = Character.toChars(codePoint);
            String ch = String.valueOf(chars);
            if (ch.equals("\\")) {
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(leadingSlashes + "\\u005C"));
                continue;
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(leadingSlashes + ch));
        }
        matcher.appendTail(buffer);
        String value = String.valueOf(buffer);
        if (value.startsWith(SINGLE_QUOTE_CHARACTER)) {
            return value.substring(1);
        }
        return value;
    }

    private static boolean isEscapedNumericEscape(String leadingSlashes) {
        return !TypeUtils.isEven(leadingSlashes.length());
    }

    private static boolean isEven(int n) {
        return (n & 1) == 0;
    }
}

