/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core;

import io.ballerina.compiler.syntax.tree.AlternateReceiveNode;
import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.AnnotationAttachPointNode;
import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.AsyncSendActionNode;
import io.ballerina.compiler.syntax.tree.BallerinaNameReferenceNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.BreakStatementNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ByteArrayLiteralNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.CollectClauseNode;
import io.ballerina.compiler.syntax.tree.CommitActionNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ComputedNameFieldNode;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.ContinueStatementNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.DistinctTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.DoubleGTTokenNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.ErrorBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ErrorMatchPatternNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.ExternalFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FailStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternFullNode;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternVarnameNode;
import io.ballerina.compiler.syntax.tree.FieldMatchPatternNode;
import io.ballerina.compiler.syntax.tree.FlushActionNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.ForkStatementNode;
import io.ballerina.compiler.syntax.tree.FromClauseNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.FunctionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.GroupByClauseNode;
import io.ballerina.compiler.syntax.tree.GroupingKeyVarDeclarationNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionParameters;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.InlineCodeReferenceNode;
import io.ballerina.compiler.syntax.tree.InterpolationNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.JoinClauseNode;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.KeyTypeConstraintNode;
import io.ballerina.compiler.syntax.tree.LetClauseNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.LimitClauseNode;
import io.ballerina.compiler.syntax.tree.ListBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ListMatchPatternNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.LiteralValueToken;
import io.ballerina.compiler.syntax.tree.LocalTypeDefinitionStatementNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MappingBindingPatternNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingMatchPatternNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeBlockNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.MatchGuardNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MemberTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleXMLNamespaceDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgBindingPatternNode;
import io.ballerina.compiler.syntax.tree.NamedArgMatchPatternNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarator;
import io.ballerina.compiler.syntax.tree.NaturalExpressionNode;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.NilTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.OnClauseNode;
import io.ballerina.compiler.syntax.tree.OnConflictClauseNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.OrderByClauseNode;
import io.ballerina.compiler.syntax.tree.OrderKeyNode;
import io.ballerina.compiler.syntax.tree.PanicStatementNode;
import io.ballerina.compiler.syntax.tree.ParameterizedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryActionNode;
import io.ballerina.compiler.syntax.tree.QueryConstructTypeNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.QueryPipelineNode;
import io.ballerina.compiler.syntax.tree.ReceiveActionNode;
import io.ballerina.compiler.syntax.tree.ReceiveFieldNode;
import io.ballerina.compiler.syntax.tree.ReceiveFieldsNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.RequiredExpressionNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourceAccessRestSegmentNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.RestArgumentNode;
import io.ballerina.compiler.syntax.tree.RestBindingPatternNode;
import io.ballerina.compiler.syntax.tree.RestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RestMatchPatternNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.RetryStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RollbackStatementNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SingletonTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SpreadFieldNode;
import io.ballerina.compiler.syntax.tree.SpreadMemberNode;
import io.ballerina.compiler.syntax.tree.StartActionNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeParamsNode;
import io.ballerina.compiler.syntax.tree.SyncSendActionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import io.ballerina.compiler.syntax.tree.TransactionalExpressionNode;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import io.ballerina.compiler.syntax.tree.TreeModifier;
import io.ballerina.compiler.syntax.tree.TrippleGTTokenNode;
import io.ballerina.compiler.syntax.tree.TupleTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastParamNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceTypeDescNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WaitActionNode;
import io.ballerina.compiler.syntax.tree.WaitFieldNode;
import io.ballerina.compiler.syntax.tree.WaitFieldsListNode;
import io.ballerina.compiler.syntax.tree.WhereClauseNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.compiler.syntax.tree.WildcardBindingPatternNode;
import io.ballerina.compiler.syntax.tree.XMLAtomicNamePatternNode;
import io.ballerina.compiler.syntax.tree.XMLAttributeNode;
import io.ballerina.compiler.syntax.tree.XMLAttributeValue;
import io.ballerina.compiler.syntax.tree.XMLCDATANode;
import io.ballerina.compiler.syntax.tree.XMLComment;
import io.ballerina.compiler.syntax.tree.XMLElementNode;
import io.ballerina.compiler.syntax.tree.XMLEmptyElementNode;
import io.ballerina.compiler.syntax.tree.XMLEndTagNode;
import io.ballerina.compiler.syntax.tree.XMLFilterExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLNameNode;
import io.ballerina.compiler.syntax.tree.XMLNamePatternChainingNode;
import io.ballerina.compiler.syntax.tree.XMLNamespaceDeclarationNode;
import io.ballerina.compiler.syntax.tree.XMLProcessingInstruction;
import io.ballerina.compiler.syntax.tree.XMLQualifiedNameNode;
import io.ballerina.compiler.syntax.tree.XMLSimpleNameNode;
import io.ballerina.compiler.syntax.tree.XMLStartTagNode;
import io.ballerina.compiler.syntax.tree.XMLStepExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLStepIndexedExtendNode;
import io.ballerina.compiler.syntax.tree.XMLStepMethodCallExtendNode;
import io.ballerina.compiler.syntax.tree.XMLTextNode;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.FormattingEnv;
import org.ballerinalang.formatter.core.options.BraceStyle;
import org.ballerinalang.formatter.core.options.FormattingOptions;
import org.ballerinalang.formatter.core.options.FunctionCallFormattingOptions;
import org.ballerinalang.formatter.core.options.FunctionDefFormattingOptions;
import org.ballerinalang.formatter.core.options.WrappingMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattingTreeModifier
extends TreeModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormattingTreeModifier.class);
    private final FormattingOptions options;
    private final FormattingEnv env;
    private final LineRange lineRange;

    public FormattingTreeModifier(FormattingOptions options, LineRange lineRange) {
        this.options = options;
        this.lineRange = lineRange;
        this.env = new FormattingEnv();
    }

    public ModulePartNode transform(ModulePartNode modulePartNode) {
        NodeList<ImportDeclarationNode> imports = this.arrangeAndFormatImportDeclarations((NodeList<ImportDeclarationNode>)modulePartNode.imports());
        NodeList members = this.formatMemberDeclarations(modulePartNode.members(), n -> this.isMultilineModuleMember(n));
        Token eofToken = this.formatToken(modulePartNode.eofToken(), 0, 0);
        return modulePartNode.modify(imports, members, eofToken);
    }

    public FunctionDefinitionNode transform(FunctionDefinitionNode functionDefinitionNode) {
        boolean prevPreservedNewLine = this.env.hasPreservedNewline;
        MetadataNode metadata = this.formatNode(functionDefinitionNode.metadata().orElse(null), 0, 1);
        this.setPreserveNewline(metadata == null ? prevPreservedNewLine : metadata.documentationString().isEmpty() && prevPreservedNewLine);
        NodeList qualifierList = this.formatNodeList(functionDefinitionNode.qualifierList(), 1, 0, 1, 0);
        Token functionKeyword = this.formatToken(functionDefinitionNode.functionKeyword(), 1, 0);
        this.setPreserveNewline(prevPreservedNewLine);
        IdentifierToken functionName = functionDefinitionNode.relativeResourcePath().isEmpty() ? this.formatToken(functionDefinitionNode.functionName(), 0, 0) : this.formatToken(functionDefinitionNode.functionName(), 1, 0);
        NodeList relativeResourcePath = this.formatNodeList(functionDefinitionNode.relativeResourcePath(), 0, 0, 0, 0);
        int trailingNL = this.options.braceFormattingOptions().functionBraceStyle() == BraceStyle.NewLine ? 1 : 0;
        FunctionSignatureNode functionSignatureNode = this.formatNode(functionDefinitionNode.functionSignature(), this.invert(trailingNL), trailingNL);
        FunctionBodyNode functionBodyNode = this.formatNode(functionDefinitionNode.functionBody(), this.env.trailingWS, this.env.trailingNL);
        return functionDefinitionNode.modify().withMetadata(metadata).withFunctionKeyword(functionKeyword).withFunctionName(functionName).withRelativeResourcePath(relativeResourcePath).withFunctionSignature(functionSignatureNode).withQualifierList(qualifierList).withFunctionBody(functionBodyNode).apply();
    }

    public ResourcePathParameterNode transform(ResourcePathParameterNode resourcePathParameterNode) {
        Token openBracketToken = this.formatToken(resourcePathParameterNode.openBracketToken(), 0, 0);
        NodeList annotations = this.formatNodeList(resourcePathParameterNode.annotations(), 1, 0, 1, 0);
        TypeDescriptorNode typeDescriptor = resourcePathParameterNode.ellipsisToken().isEmpty() && resourcePathParameterNode.paramName().isPresent() ? this.formatNode(resourcePathParameterNode.typeDescriptor(), 1, 0) : this.formatNode(resourcePathParameterNode.typeDescriptor(), 0, 0);
        Token ellipsisToken = resourcePathParameterNode.paramName().isPresent() ? this.formatToken(resourcePathParameterNode.ellipsisToken().orElse(null), 1, 0) : this.formatToken(resourcePathParameterNode.ellipsisToken().orElse(null), 0, 0);
        Token paramName = this.formatToken(resourcePathParameterNode.paramName().orElse(null), 0, 0);
        Token closeBracketToken = this.formatToken(resourcePathParameterNode.closeBracketToken(), this.env.trailingWS, this.env.trailingNL);
        return resourcePathParameterNode.modify().withOpenBracketToken(openBracketToken).withAnnotations(annotations).withTypeDescriptor(typeDescriptor).withEllipsisToken(ellipsisToken).withParamName(paramName).withCloseBracketToken(closeBracketToken).apply();
    }

    public FunctionSignatureNode transform(FunctionSignatureNode functionSignatureNode) {
        Token closePara;
        int parenTrailingNL = 0;
        FunctionDefFormattingOptions funcOptions = this.options.functionDefFormattingOptions();
        if (this.hasNonWSMinutiae(functionSignatureNode.openParenToken().trailingMinutiae()) || funcOptions.newLineAfterLeftParen()) {
            ++parenTrailingNL;
        }
        boolean paranAlign = funcOptions.alignMultilineParameters();
        if (!functionSignatureNode.openParenToken().isMissing()) {
            this.alignOrIndent(paranAlign, this.options.indentFormattingOptions().continuationIndentSize());
        }
        Token openPara = this.formatToken(functionSignatureNode.openParenToken(), 0, parenTrailingNL);
        int closeParenLeadingNL = funcOptions.rightParenOnNewLine() ? 1 : 0;
        int separatorTrailingWS = funcOptions.parametersWrap() == WrappingMethod.ChopDown ? 0 : 1;
        SeparatedNodeList parameters = this.formatSeparatedNodeList(functionSignatureNode.parameters(), 0, 0, separatorTrailingWS, this.invert(separatorTrailingWS), 0, closeParenLeadingNL, true);
        this.unalignOrUnindent(paranAlign, this.options.indentFormattingOptions().continuationIndentSize());
        ReturnTypeDescriptorNode returnTypeDesc = null;
        if (functionSignatureNode.returnTypeDesc().isPresent()) {
            closePara = this.formatToken(functionSignatureNode.closeParenToken(), 1, 0);
            returnTypeDesc = this.formatNode((ReturnTypeDescriptorNode)functionSignatureNode.returnTypeDesc().get(), this.env.trailingWS, this.env.trailingNL);
        } else {
            closePara = this.formatToken(functionSignatureNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        }
        return functionSignatureNode.modify().withOpenParenToken(openPara).withParameters(parameters).withCloseParenToken(closePara).withReturnTypeDesc(returnTypeDesc).apply();
    }

    public RequiredParameterNode transform(RequiredParameterNode requiredParameterNode) {
        NodeList annotations = this.formatNodeList(requiredParameterNode.annotations(), 1, 0, 1, 0);
        if (requiredParameterNode.paramName().isPresent()) {
            Node typeName = this.formatNode(requiredParameterNode.typeName(), 1, 0);
            Token paramName = this.formatToken(requiredParameterNode.paramName().orElse(null), this.env.trailingWS, this.env.trailingNL);
            return requiredParameterNode.modify().withAnnotations(annotations).withTypeName(typeName).withParamName(paramName).apply();
        }
        Node typeName = this.formatNode(requiredParameterNode.typeName(), this.env.trailingWS, this.env.trailingNL);
        return requiredParameterNode.modify().withAnnotations(annotations).withTypeName(typeName).apply();
    }

    public IncludedRecordParameterNode transform(IncludedRecordParameterNode includedRecordParameterNode) {
        NodeList annotations = this.formatNodeList(includedRecordParameterNode.annotations(), 1, 0, 1, 0);
        Token asterisk = this.formatToken(includedRecordParameterNode.asteriskToken(), 0, 0);
        if (includedRecordParameterNode.paramName().isPresent()) {
            Node typeName = this.formatNode(includedRecordParameterNode.typeName(), 1, 0);
            Token paramName = this.formatToken(includedRecordParameterNode.paramName().orElse(null), this.env.trailingWS, this.env.trailingNL);
            return includedRecordParameterNode.modify().withAsteriskToken(asterisk).withAnnotations(annotations).withTypeName(typeName).withParamName(paramName).apply();
        }
        Node typeName = this.formatNode(includedRecordParameterNode.typeName(), this.env.trailingWS, this.env.trailingNL);
        return includedRecordParameterNode.modify().withAsteriskToken(asterisk).withAnnotations(annotations).withTypeName(typeName).apply();
    }

    public FunctionBodyBlockNode transform(FunctionBodyBlockNode functionBodyBlockNode) {
        int trailingNL = FormatterUtils.openBraceTrailingNLs(this.options.wrappingFormattingOptions(), (Node)functionBodyBlockNode);
        Token openBrace = this.formatToken(functionBodyBlockNode.openBraceToken(), this.invert(trailingNL), trailingNL);
        this.indent();
        NodeList statements = this.formatNodeList(functionBodyBlockNode.statements(), 0, 1, this.invert(trailingNL), trailingNL);
        NamedWorkerDeclarator namedWorkerDeclarator = this.formatNode(functionBodyBlockNode.namedWorkerDeclarator().orElse(null), 0, 1);
        this.unindent();
        Optional optSemicolon = functionBodyBlockNode.semicolonToken();
        Token closeBrace = optSemicolon.isPresent() ? this.formatToken(functionBodyBlockNode.closeBraceToken(), 0, 0) : this.formatToken(functionBodyBlockNode.closeBraceToken(), this.env.trailingWS, this.env.trailingNL);
        Token semicolon = this.formatToken(optSemicolon.orElse(null), this.env.trailingWS, this.env.trailingNL);
        return functionBodyBlockNode.modify().withOpenBraceToken(openBrace).withNamedWorkerDeclarator(namedWorkerDeclarator).withStatements(statements).withCloseBraceToken(closeBrace).withSemicolonToken(semicolon).apply();
    }

    public VariableDeclarationNode transform(VariableDeclarationNode variableDeclarationNode) {
        NodeList annotationNodes = this.formatNodeList(variableDeclarationNode.annotations(), 0, 1, 0, 1);
        Token finalToken = this.formatToken(variableDeclarationNode.finalKeyword().orElse(null), 1, 0);
        boolean hasInit = variableDeclarationNode.initializer().isPresent();
        TypedBindingPatternNode typedBindingPatternNode = this.formatNode(variableDeclarationNode.typedBindingPattern(), hasInit ? 1 : 0, 0);
        Token equalToken = this.formatToken(variableDeclarationNode.equalsToken().orElse(null), 1, 0);
        boolean previousInlineAnnotation = this.env.inlineAnnotation;
        this.setInlineAnnotation(true);
        ExpressionNode initializer = this.formatNode(variableDeclarationNode.initializer().orElse(null), 0, 0);
        this.setInlineAnnotation(previousInlineAnnotation);
        Token semicolonToken = this.formatToken(variableDeclarationNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return variableDeclarationNode.modify().withAnnotations(annotationNodes).withFinalKeyword(finalToken).withTypedBindingPattern(typedBindingPatternNode).withEqualsToken(equalToken).withInitializer(initializer).withSemicolonToken(semicolonToken).apply();
    }

    public TypedBindingPatternNode transform(TypedBindingPatternNode typedBindingPatternNode) {
        TypeDescriptorNode typeDescriptorNode = this.formatNode(typedBindingPatternNode.typeDescriptor(), 1, 0);
        BindingPatternNode bindingPatternNode = this.formatNode(typedBindingPatternNode.bindingPattern(), this.env.trailingWS, this.env.trailingNL);
        return typedBindingPatternNode.modify().withTypeDescriptor(typeDescriptorNode).withBindingPattern(bindingPatternNode).apply();
    }

    public BuiltinSimpleNameReferenceNode transform(BuiltinSimpleNameReferenceNode builtinSimpleNameReferenceNode) {
        Token name = this.formatToken(builtinSimpleNameReferenceNode.name(), this.env.trailingWS, this.env.trailingNL);
        return builtinSimpleNameReferenceNode.modify().withName(name).apply();
    }

    public BasicLiteralNode transform(BasicLiteralNode basicLiteralNode) {
        Token literalToken = this.formatToken(basicLiteralNode.literalToken(), this.env.trailingWS, this.env.trailingNL);
        return basicLiteralNode.modify().withLiteralToken(literalToken).apply();
    }

    public CaptureBindingPatternNode transform(CaptureBindingPatternNode captureBindingPatternNode) {
        Token variableName = this.formatToken(captureBindingPatternNode.variableName(), this.env.trailingWS, this.env.trailingNL);
        return captureBindingPatternNode.modify().withVariableName(variableName).apply();
    }

    public IfElseStatementNode transform(IfElseStatementNode ifElseStatementNode) {
        BlockStatementNode ifBody;
        boolean prevPreservedNewLine = this.env.hasPreservedNewline;
        Token ifKeyword = this.formatToken(ifElseStatementNode.ifKeyword(), 1, 0);
        ExpressionNode condition = this.formatNode(ifElseStatementNode.condition(), 1, 0);
        Node elseBody = null;
        if (ifElseStatementNode.elseBody().isPresent()) {
            int trailingWS = this.options.ifStatementFormattingOptions().elseOnNewLine() ? 0 : 1;
            ifBody = this.formatNode(ifElseStatementNode.ifBody(), trailingWS, this.invert(trailingWS));
            this.preserveIndentation(!this.hasTrailingNL(ifElseStatementNode.ifBody().closeBraceToken()));
            elseBody = this.formatNode(ifElseStatementNode.elseBody().orElse(null), this.env.trailingWS, this.env.trailingNL);
            this.preserveIndentation(prevPreservedNewLine);
        } else {
            ifBody = this.formatNode(ifElseStatementNode.ifBody(), this.env.trailingWS, this.env.trailingNL);
        }
        return ifElseStatementNode.modify().withIfKeyword(ifKeyword).withCondition(condition).withIfBody(ifBody).withElseBody(elseBody).apply();
    }

    public ElseBlockNode transform(ElseBlockNode elseBlockNode) {
        Token elseKeyword = this.formatToken(elseBlockNode.elseKeyword(), 1, 0);
        StatementNode elseBody = this.formatNode(elseBlockNode.elseBody(), this.env.trailingWS, this.env.trailingNL);
        return elseBlockNode.modify().withElseKeyword(elseKeyword).withElseBody(elseBody).apply();
    }

    public BlockStatementNode transform(BlockStatementNode blockStatementNode) {
        boolean preserveIndent = this.env.preserveIndentation;
        this.preserveIndentation(blockStatementNode.openBraceToken().isMissing() && preserveIndent);
        int trailingNL = FormatterUtils.openBraceTrailingNLs(this.options.wrappingFormattingOptions(), (Node)blockStatementNode);
        int trailingWS = this.invert(trailingNL);
        Token openBrace = this.formatToken(blockStatementNode.openBraceToken(), trailingWS, trailingNL);
        this.preserveIndentation(preserveIndent);
        this.indent();
        NodeList statements = this.formatNodeList(blockStatementNode.statements(), 0, 1, trailingWS, trailingNL);
        this.unindent();
        int closingNL = this.options.ifStatementFormattingOptions().elseOnNewLine() && blockStatementNode.parent().kind() == SyntaxKind.IF_ELSE_STATEMENT ? 1 : this.env.trailingNL;
        Token closeBrace = this.formatToken(blockStatementNode.closeBraceToken(), this.env.trailingWS, closingNL);
        return blockStatementNode.modify().withOpenBraceToken(openBrace).withStatements(statements).withCloseBraceToken(closeBrace).apply();
    }

    public RecordTypeDescriptorNode transform(RecordTypeDescriptorNode recordTypeDesc) {
        boolean recordKeywordTrailingWS = true;
        Token recordKeyword = this.formatNode(recordTypeDesc.recordKeyword(), 1, 0);
        int fieldTrailingWS = 0;
        int fieldTrailingNL = 0;
        if (this.shouldExpand((Node)recordTypeDesc)) {
            ++fieldTrailingNL;
        } else {
            ++fieldTrailingWS;
        }
        Token bodyStartDelimiter = this.formatToken(recordTypeDesc.bodyStartDelimiter(), 0, fieldTrailingNL);
        this.indent();
        NodeList fields = this.formatNodeList(recordTypeDesc.fields(), fieldTrailingWS, fieldTrailingNL, recordTypeDesc.recordRestDescriptor().isEmpty() ? 0 : fieldTrailingWS, fieldTrailingNL);
        RecordRestDescriptorNode recordRestDescriptor = this.formatNode(recordTypeDesc.recordRestDescriptor().orElse(null), 0, fieldTrailingNL);
        this.unindent();
        Token bodyEndDelimiter = this.formatToken(recordTypeDesc.bodyEndDelimiter(), this.env.trailingWS, this.env.trailingNL);
        return recordTypeDesc.modify().withRecordKeyword(recordKeyword).withBodyStartDelimiter(bodyStartDelimiter).withFields(fields).withRecordRestDescriptor(recordRestDescriptor).withBodyEndDelimiter(bodyEndDelimiter).apply();
    }

    public RecordFieldNode transform(RecordFieldNode recordField) {
        MetadataNode metadata = this.formatNode(recordField.metadata().orElse(null), 0, 1);
        Token readonlyKeyword = this.formatNode(recordField.readonlyKeyword().orElse(null), 1, 0);
        Node typeName = this.formatNode(recordField.typeName(), 1, 0);
        Token fieldName = this.formatToken(recordField.fieldName(), 0, 0);
        Token questionMarkToken = this.formatToken(recordField.questionMarkToken().orElse(null), 0, 0);
        Token semicolonToken = this.formatToken(recordField.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return recordField.modify().withMetadata(metadata).withReadonlyKeyword(readonlyKeyword).withTypeName(typeName).withFieldName(fieldName).withQuestionMarkToken(questionMarkToken).withSemicolonToken(semicolonToken).apply();
    }

    public MemberTypeDescriptorNode transform(MemberTypeDescriptorNode member) {
        NodeList annotations = this.formatNodeList(member.annotations(), 1, 0, 1, 0);
        TypeDescriptorNode type = this.formatNode(member.typeDescriptor(), this.env.trailingWS, this.env.trailingNL);
        return member.modify().withAnnotations(annotations).withTypeDescriptor(type).apply();
    }

    public RecordFieldWithDefaultValueNode transform(RecordFieldWithDefaultValueNode recordField) {
        MetadataNode metadata = this.formatNode(recordField.metadata().orElse(null), 0, 1);
        Token readonlyKeyword = this.formatNode(recordField.readonlyKeyword().orElse(null), 1, 0);
        Node typeName = this.formatNode(recordField.typeName(), 1, 0);
        Token fieldName = this.formatToken(recordField.fieldName(), 1, 0);
        Token equalsToken = this.formatToken(recordField.equalsToken(), 1, 0);
        ExpressionNode expression = this.formatNode(recordField.expression(), 0, 0);
        Token semicolonToken = this.formatToken(recordField.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return recordField.modify().withMetadata(metadata).withReadonlyKeyword(readonlyKeyword).withTypeName(typeName).withFieldName(fieldName).withEqualsToken(equalsToken).withExpression(expression).withSemicolonToken(semicolonToken).apply();
    }

    public ImportDeclarationNode transform(ImportDeclarationNode importDeclarationNode) {
        boolean prevPreservedNewLine = this.env.hasPreservedNewline;
        this.setPreserveNewline(this.hasLeadingComments((Node)importDeclarationNode));
        Token importKeyword = this.formatToken(importDeclarationNode.importKeyword(), 1, 0);
        this.setPreserveNewline(prevPreservedNewLine);
        boolean hasPrefix = importDeclarationNode.prefix().isPresent();
        ImportOrgNameNode orgName = this.formatNode(importDeclarationNode.orgName().orElse(null), 0, 0);
        SeparatedNodeList moduleNames = this.formatSeparatedNodeList(importDeclarationNode.moduleName(), 0, 0, 0, 0, hasPrefix ? 1 : 0, 0);
        ImportPrefixNode prefix = this.formatNode(importDeclarationNode.prefix().orElse(null), 0, 0);
        Token semicolon = this.formatToken(importDeclarationNode.semicolon(), this.env.trailingWS, this.env.trailingNL);
        return importDeclarationNode.modify().withImportKeyword(importKeyword).withOrgName(orgName).withModuleName(moduleNames).withPrefix(prefix).withSemicolon(semicolon).apply();
    }

    public ImportOrgNameNode transform(ImportOrgNameNode importOrgNameNode) {
        Token orgName = this.formatToken(importOrgNameNode.orgName(), 0, 0);
        Token slashToken = this.formatToken(importOrgNameNode.slashToken(), this.env.trailingWS, this.env.trailingNL);
        return importOrgNameNode.modify().withOrgName(orgName).withSlashToken(slashToken).apply();
    }

    public ImportPrefixNode transform(ImportPrefixNode importPrefixNode) {
        Token asKeyword = this.formatToken(importPrefixNode.asKeyword(), 1, 0);
        Token prefix = this.formatToken(importPrefixNode.prefix(), this.env.trailingWS, this.env.trailingNL);
        return importPrefixNode.modify().withAsKeyword(asKeyword).withPrefix(prefix).apply();
    }

    public ServiceDeclarationNode transform(ServiceDeclarationNode serviceDeclarationNode) {
        MetadataNode metadata = this.formatNode(serviceDeclarationNode.metadata().orElse(null), 0, 1);
        NodeList qualifiers = this.formatNodeList(serviceDeclarationNode.qualifiers(), 1, 0, 1, 0);
        Token serviceKeyword = this.formatToken(serviceDeclarationNode.serviceKeyword(), 1, 0);
        TypeDescriptorNode typeDescriptor = this.formatNode(serviceDeclarationNode.typeDescriptor().orElse(null), 1, 0);
        NodeList absoluteResourcePath = this.formatNodeList(serviceDeclarationNode.absoluteResourcePath(), 0, 0, 1, 0);
        Token onKeyword = this.formatToken(serviceDeclarationNode.onKeyword(), 1, 0);
        SeparatedNodeList expressions = this.formatSeparatedNodeList(serviceDeclarationNode.expressions(), 0, 0, 1, 0);
        Token openBrace = this.formatToken(serviceDeclarationNode.openBraceToken(), 0, 1);
        this.indent();
        NodeList members = this.formatMemberDeclarations(serviceDeclarationNode.members(), n -> this.isClassOrServiceMultiLineMember((Node)n));
        this.unindent();
        Optional optSemicolon = serviceDeclarationNode.semicolonToken();
        Token closeBrace = optSemicolon.isPresent() ? this.formatToken(serviceDeclarationNode.closeBraceToken(), 0, 0) : this.formatToken(serviceDeclarationNode.closeBraceToken(), this.env.trailingWS, this.env.trailingNL);
        Token semicolon = this.formatToken(optSemicolon.orElse(null), this.env.trailingWS, this.env.trailingNL);
        return serviceDeclarationNode.modify().withMetadata(metadata).withQualifiers(qualifiers).withServiceKeyword(serviceKeyword).withTypeDescriptor(typeDescriptor).withAbsoluteResourcePath(absoluteResourcePath).withOnKeyword(onKeyword).withExpressions(expressions).withOpenBraceToken(openBrace).withMembers(members).withCloseBraceToken(closeBrace).withSemicolonToken(semicolon).apply();
    }

    public RequiredExpressionNode transform(RequiredExpressionNode requiredExpressionNode) {
        Token questionMarkToken = this.formatToken(requiredExpressionNode.questionMarkToken(), this.env.trailingWS, this.env.trailingNL);
        return requiredExpressionNode.modify().withQuestionMarkToken(questionMarkToken).apply();
    }

    public ExplicitNewExpressionNode transform(ExplicitNewExpressionNode explicitNewExpressionNode) {
        Token newKeywordToken = this.formatToken(explicitNewExpressionNode.newKeyword(), 1, 0);
        TypeDescriptorNode typeDescriptorNode = this.formatNode(explicitNewExpressionNode.typeDescriptor(), 0, 0);
        ParenthesizedArgList parenthesizedArgList = this.formatNode(explicitNewExpressionNode.parenthesizedArgList(), this.env.trailingWS, this.env.trailingNL);
        return explicitNewExpressionNode.modify().withNewKeyword(newKeywordToken).withTypeDescriptor(typeDescriptorNode).withParenthesizedArgList(parenthesizedArgList).apply();
    }

    public ParenthesizedArgList transform(ParenthesizedArgList parenthesizedArgList) {
        boolean shouldIndent;
        int parenTrailingNL = 0;
        if (this.hasNonWSMinutiae(parenthesizedArgList.openParenToken().trailingMinutiae())) {
            ++parenTrailingNL;
        }
        Token openParenToken = this.formatToken(parenthesizedArgList.openParenToken(), 0, parenTrailingNL);
        boolean bl = shouldIndent = parenTrailingNL > 0 || this.shouldIndentParenthesizedArgs(parenthesizedArgList.arguments());
        if (shouldIndent) {
            this.indent();
        }
        SeparatedNodeList arguments = this.formatSeparatedNodeList(parenthesizedArgList.arguments(), 0, 0, 0, shouldIndent ? 1 : 0, true);
        if (shouldIndent) {
            this.unindent();
        }
        Token closeParenToken = this.formatToken(parenthesizedArgList.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return parenthesizedArgList.modify().withOpenParenToken(openParenToken).withArguments(arguments).withCloseParenToken(closeParenToken).apply();
    }

    public QualifiedNameReferenceNode transform(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
        Token modulePrefix = this.formatToken(qualifiedNameReferenceNode.modulePrefix(), 0, 0);
        Token colon = this.formatToken((Token)qualifiedNameReferenceNode.colon(), 0, 0);
        IdentifierToken identifier = this.formatToken(qualifiedNameReferenceNode.identifier(), this.env.trailingWS, this.env.trailingNL);
        return qualifiedNameReferenceNode.modify().withModulePrefix(modulePrefix).withColon((Node)colon).withIdentifier(identifier).apply();
    }

    public ReturnTypeDescriptorNode transform(ReturnTypeDescriptorNode returnTypeDescriptorNode) {
        Token returnsKeyword = this.formatToken(returnTypeDescriptorNode.returnsKeyword(), 1, 0);
        NodeList annotations = this.formatNodeList(returnTypeDescriptorNode.annotations(), 0, 0, 1, 0);
        Node type = this.formatNode(returnTypeDescriptorNode.type(), this.env.trailingWS, this.env.trailingNL);
        return returnTypeDescriptorNode.modify().withReturnsKeyword(returnsKeyword).withAnnotations(annotations).withType(type).apply();
    }

    public OptionalTypeDescriptorNode transform(OptionalTypeDescriptorNode optionalTypeDescriptorNode) {
        Node typeDescriptor = this.formatNode(optionalTypeDescriptorNode.typeDescriptor(), 0, 0);
        Token questionMarkToken = this.formatToken(optionalTypeDescriptorNode.questionMarkToken(), this.env.trailingWS, this.env.trailingNL);
        return optionalTypeDescriptorNode.modify().withTypeDescriptor(typeDescriptor).withQuestionMarkToken(questionMarkToken).apply();
    }

    public ExpressionStatementNode transform(ExpressionStatementNode expressionStatementNode) {
        ExpressionNode expression = this.formatNode(expressionStatementNode.expression(), 0, 0);
        Token semicolonToken = this.formatToken(expressionStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return expressionStatementNode.modify().withExpression(expression).withSemicolonToken(semicolonToken).apply();
    }

    public CheckExpressionNode transform(CheckExpressionNode checkExpressionNode) {
        Token checkKeyword = this.formatToken(checkExpressionNode.checkKeyword(), 1, 0);
        ExpressionNode expressionNode = this.formatNode(checkExpressionNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return checkExpressionNode.modify().withCheckKeyword(checkKeyword).withExpression(expressionNode).apply();
    }

    public RemoteMethodCallActionNode transform(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        ExpressionNode expression = this.formatNode(remoteMethodCallActionNode.expression(), 0, 0);
        Token rightArrowToken = this.formatToken(remoteMethodCallActionNode.rightArrowToken(), 0, 0);
        SimpleNameReferenceNode methodName = this.formatNode(remoteMethodCallActionNode.methodName(), 0, 0);
        Token openParenToken = this.formatToken(remoteMethodCallActionNode.openParenToken(), 0, 0);
        SeparatedNodeList arguments = this.formatSeparatedNodeList(remoteMethodCallActionNode.arguments(), 0, 0, 0, 0);
        Token closeParenToken = this.formatToken(remoteMethodCallActionNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return remoteMethodCallActionNode.modify().withExpression(expression).withRightArrowToken(rightArrowToken).withMethodName(methodName).withOpenParenToken(openParenToken).withArguments(arguments).withCloseParenToken(closeParenToken).apply();
    }

    public SimpleNameReferenceNode transform(SimpleNameReferenceNode simpleNameReferenceNode) {
        Token name = this.formatToken(simpleNameReferenceNode.name(), this.env.trailingWS, this.env.trailingNL);
        return simpleNameReferenceNode.modify().withName(name).apply();
    }

    public TypeDefinitionNode transform(TypeDefinitionNode typeDefinitionNode) {
        MetadataNode metadata = this.formatNode(typeDefinitionNode.metadata().orElse(null), 0, 1);
        Token visibilityQualifier = this.formatToken(typeDefinitionNode.visibilityQualifier().orElse(null), 1, 0);
        Token typeKeyword = this.formatToken(typeDefinitionNode.typeKeyword(), 1, 0);
        Token typeName = this.formatToken(typeDefinitionNode.typeName(), 1, 0);
        Node typeDescriptor = this.formatNode(typeDefinitionNode.typeDescriptor(), 0, 0);
        Token semicolonToken = this.formatToken(typeDefinitionNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return typeDefinitionNode.modify().withMetadata(metadata).withVisibilityQualifier(visibilityQualifier).withTypeKeyword(typeKeyword).withTypeName(typeName).withTypeDescriptor(typeDescriptor).withSemicolonToken(semicolonToken).apply();
    }

    public SingletonTypeDescriptorNode transform(SingletonTypeDescriptorNode singletonTypeDescriptorNode) {
        ExpressionNode simpleContExprNode = this.formatNode(singletonTypeDescriptorNode.simpleContExprNode(), this.env.trailingWS, this.env.trailingNL);
        return singletonTypeDescriptorNode.modify().withSimpleContExprNode(simpleContExprNode).apply();
    }

    public WhileStatementNode transform(WhileStatementNode whileStatementNode) {
        BlockStatementNode whileBody;
        boolean hasOnFailClause = whileStatementNode.onFailClause().isPresent();
        Token whileKeyword = this.formatToken(whileStatementNode.whileKeyword(), 1, 0);
        ExpressionNode condition = this.formatNode(whileStatementNode.condition(), 1, 0);
        OnFailClauseNode onFailClause = null;
        if (hasOnFailClause) {
            whileBody = this.formatNode(whileStatementNode.whileBody(), 1, 0);
            onFailClause = this.formatNode(whileStatementNode.onFailClause().orElse(null), this.env.trailingWS, this.env.trailingNL);
        } else {
            whileBody = this.formatNode(whileStatementNode.whileBody(), this.env.trailingWS, this.env.trailingNL);
        }
        return whileStatementNode.modify().withWhileKeyword(whileKeyword).withCondition(condition).withWhileBody(whileBody).withOnFailClause(onFailClause).apply();
    }

    public BracedExpressionNode transform(BracedExpressionNode bracedExpressionNode) {
        Token openParen = this.formatToken(bracedExpressionNode.openParen(), 0, 0);
        ExpressionNode expression = this.formatNode(bracedExpressionNode.expression(), 0, 0);
        Token closeParen = this.formatToken(bracedExpressionNode.closeParen(), this.env.trailingWS, this.env.trailingNL);
        return bracedExpressionNode.modify().withOpenParen(openParen).withExpression(expression).withCloseParen(closeParen).apply();
    }

    public AssignmentStatementNode transform(AssignmentStatementNode assignmentStatementNode) {
        Node varRef = this.formatNode(assignmentStatementNode.varRef(), 1, 0);
        Token equalsToken = this.formatToken(assignmentStatementNode.equalsToken(), 1, 0);
        boolean previousInlineAnnotation = this.env.inlineAnnotation;
        this.setInlineAnnotation(true);
        ExpressionNode expression = this.formatNode(assignmentStatementNode.expression(), 0, 0);
        Token semicolonToken = this.formatToken(assignmentStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        this.setInlineAnnotation(previousInlineAnnotation);
        return assignmentStatementNode.modify().withVarRef(varRef).withEqualsToken(equalsToken).withExpression(expression).withSemicolonToken(semicolonToken).apply();
    }

    public CompoundAssignmentStatementNode transform(CompoundAssignmentStatementNode compoundAssignmentStatementNode) {
        ExpressionNode lhsExpression = this.formatNode(compoundAssignmentStatementNode.lhsExpression(), 1, 0);
        Token binaryOperator = this.formatToken(compoundAssignmentStatementNode.binaryOperator(), 0, 0);
        Token equalsToken = this.formatToken(compoundAssignmentStatementNode.equalsToken(), 1, 0);
        ExpressionNode rhsExpression = this.formatNode(compoundAssignmentStatementNode.rhsExpression(), 0, 0);
        Token semicolonToken = this.formatToken(compoundAssignmentStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return compoundAssignmentStatementNode.modify().withLhsExpression(lhsExpression).withBinaryOperator(binaryOperator).withEqualsToken(equalsToken).withRhsExpression(rhsExpression).withSemicolonToken(semicolonToken).apply();
    }

    public DoStatementNode transform(DoStatementNode doStatementNode) {
        BlockStatementNode blockStatement;
        boolean hasOnFailClause = doStatementNode.onFailClause().isPresent();
        Token doKeyword = this.formatToken(doStatementNode.doKeyword(), 1, 0);
        OnFailClauseNode onFailClause = null;
        if (hasOnFailClause) {
            blockStatement = this.formatNode(doStatementNode.blockStatement(), 1, 0);
            onFailClause = this.formatNode(doStatementNode.onFailClause().orElse(null), this.env.trailingWS, this.env.trailingNL);
        } else {
            blockStatement = this.formatNode(doStatementNode.blockStatement(), this.env.trailingWS, this.env.trailingNL);
        }
        return doStatementNode.modify().withDoKeyword(doKeyword).withBlockStatement(blockStatement).withOnFailClause(onFailClause).apply();
    }

    public ForEachStatementNode transform(ForEachStatementNode forEachStatementNode) {
        BlockStatementNode blockStatement;
        boolean hasOnFailClause = forEachStatementNode.onFailClause().isPresent();
        Token forEachKeyword = this.formatToken(forEachStatementNode.forEachKeyword(), 1, 0);
        TypedBindingPatternNode typedBindingPattern = this.formatNode(forEachStatementNode.typedBindingPattern(), 1, 0);
        Token inKeyword = this.formatToken(forEachStatementNode.inKeyword(), 1, 0);
        Node actionOrExpressionNode = this.formatNode(forEachStatementNode.actionOrExpressionNode(), 1, 0);
        OnFailClauseNode onFailClause = null;
        if (hasOnFailClause) {
            blockStatement = this.formatNode(forEachStatementNode.blockStatement(), 1, 0);
            onFailClause = this.formatNode(forEachStatementNode.onFailClause().orElse(null), this.env.trailingWS, this.env.trailingNL);
        } else {
            blockStatement = this.formatNode(forEachStatementNode.blockStatement(), this.env.trailingWS, this.env.trailingNL);
        }
        return forEachStatementNode.modify().withForEachKeyword(forEachKeyword).withTypedBindingPattern(typedBindingPattern).withInKeyword(inKeyword).withActionOrExpressionNode(actionOrExpressionNode).withBlockStatement(blockStatement).withOnFailClause(onFailClause).apply();
    }

    public BinaryExpressionNode transform(BinaryExpressionNode binaryExpressionNode) {
        Node lhsExpr = this.formatNode(binaryExpressionNode.lhsExpr(), 1, 0);
        Token operator = this.formatToken(binaryExpressionNode.operator(), 1, 0);
        Node rhsExpr = this.formatNode(binaryExpressionNode.rhsExpr(), this.env.trailingWS, this.env.trailingNL);
        return binaryExpressionNode.modify().withLhsExpr(lhsExpr).withOperator(operator).withRhsExpr(rhsExpr).apply();
    }

    public OnFailClauseNode transform(OnFailClauseNode onFailClauseNode) {
        Token onKeyword = this.formatToken(onFailClauseNode.onKeyword(), 1, 0);
        Token failKeyword = this.formatToken(onFailClauseNode.failKeyword(), 1, 0);
        TypedBindingPatternNode typeBindingPattern = this.formatNode(onFailClauseNode.typedBindingPattern().orElse(null), 1, 0);
        BlockStatementNode blockStatement = this.formatNode(onFailClauseNode.blockStatement(), this.env.trailingWS, this.env.trailingNL);
        return onFailClauseNode.modify().withOnKeyword(onKeyword).withFailKeyword(failKeyword).withTypedBindingPattern(typeBindingPattern).withBlockStatement(blockStatement).apply();
    }

    public ReturnStatementNode transform(ReturnStatementNode returnStatementNode) {
        Token returnKeyword = this.formatToken(returnStatementNode.returnKeyword(), returnStatementNode.expression().isPresent() ? 1 : 0, 0);
        ExpressionNode expressionNode = this.formatNode(returnStatementNode.expression().orElse(null), 0, 0);
        Token semicolonToken = this.formatToken(returnStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return returnStatementNode.modify().withReturnKeyword(returnKeyword).withExpression(expressionNode).withSemicolonToken(semicolonToken).apply();
    }

    public FunctionCallExpressionNode transform(FunctionCallExpressionNode functionCallExpressionNode) {
        NameReferenceNode functionName = this.formatNode(functionCallExpressionNode.functionName(), 0, 0);
        FunctionCallFormattingOptions callOptions = this.options.functionCallFormattingOptions();
        int prevIndentation = this.env.currentIndentation;
        this.alignOrIndent(callOptions.alignMultilineArguments(), this.options.indentFormattingOptions().continuationIndentSize());
        Token functionCallOpenPara = this.formatToken(functionCallExpressionNode.openParenToken(), 0, callOptions.newLineAfterLeftParen() ? 1 : 0);
        int closeParenLeadingNL = callOptions.rightParenOnNewLine() ? 1 : 0;
        int separatorTrailingWS = callOptions.argumentsWrap() == WrappingMethod.ChopDown ? 0 : 1;
        SeparatedNodeList arguments = this.formatSeparatedNodeList(functionCallExpressionNode.arguments(), 0, 0, separatorTrailingWS, this.invert(separatorTrailingWS), 0, closeParenLeadingNL, true);
        this.setIndentation(prevIndentation);
        Token functionCallClosePara = this.formatToken(functionCallExpressionNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return functionCallExpressionNode.modify().withFunctionName(functionName).withOpenParenToken(functionCallOpenPara).withCloseParenToken(functionCallClosePara).withArguments(arguments).apply();
    }

    public ErrorConstructorExpressionNode transform(ErrorConstructorExpressionNode errorConstructorExpressionNode) {
        boolean hasTypeReference = errorConstructorExpressionNode.typeReference().isPresent();
        Token errorKeyword = this.formatToken(errorConstructorExpressionNode.errorKeyword(), hasTypeReference ? 1 : 0, 0);
        TypeDescriptorNode typeReference = this.formatNode(errorConstructorExpressionNode.typeReference().orElse(null), 0, 0);
        Token openParenthesis = this.formatToken(errorConstructorExpressionNode.openParenToken(), 0, 0);
        SeparatedNodeList arguments = this.formatSeparatedNodeList(errorConstructorExpressionNode.arguments(), 0, 0, 0, 0);
        Token closeParenthesis = this.formatToken(errorConstructorExpressionNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return errorConstructorExpressionNode.modify().withErrorKeyword(errorKeyword).withTypeReference(typeReference).withOpenParenToken(openParenthesis).withArguments(arguments).withCloseParenToken(closeParenthesis).apply();
    }

    public UnionTypeDescriptorNode transform(UnionTypeDescriptorNode unionTypeDescriptorNode) {
        TypeDescriptorNode leftTypeDesc = this.formatNode(unionTypeDescriptorNode.leftTypeDesc(), 0, 0);
        Token pipeToken = this.formatToken(unionTypeDescriptorNode.pipeToken(), 0, 0);
        TypeDescriptorNode rightTypeDesc = this.formatNode(unionTypeDescriptorNode.rightTypeDesc(), this.env.trailingWS, this.env.trailingNL);
        return unionTypeDescriptorNode.modify().withLeftTypeDesc(leftTypeDesc).withPipeToken(pipeToken).withRightTypeDesc(rightTypeDesc).apply();
    }

    public NilTypeDescriptorNode transform(NilTypeDescriptorNode nilTypeDescriptorNode) {
        Token openParenToken = this.formatToken(nilTypeDescriptorNode.openParenToken(), 0, 0);
        Token closeParenToken = this.formatToken(nilTypeDescriptorNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return nilTypeDescriptorNode.modify().withOpenParenToken(openParenToken).withCloseParenToken(closeParenToken).apply();
    }

    public ConstantDeclarationNode transform(ConstantDeclarationNode constantDeclarationNode) {
        MetadataNode metadata = this.formatNode(constantDeclarationNode.metadata().orElse(null), 0, 1);
        Token visibilityQualifier = this.formatToken(constantDeclarationNode.visibilityQualifier().orElse(null), 1, 0);
        Token constKeyword = this.formatToken(constantDeclarationNode.constKeyword(), 1, 0);
        TypeDescriptorNode typeDescriptorNode = this.formatNode(constantDeclarationNode.typeDescriptor().orElse(null), 1, 0);
        int wSBeforeEqual = !this.options.spacingFormattingOptions().alignConsecutiveDefinitions() ? 1 : this.env.maxConstDefWidth - FormatterUtils.getConstDefWidth(constantDeclarationNode) + 1;
        Token variableName = this.formatToken(constantDeclarationNode.variableName(), wSBeforeEqual, 0);
        Token equalsToken = this.formatToken(constantDeclarationNode.equalsToken(), 1, 0);
        Node initializer = this.formatNode(constantDeclarationNode.initializer(), 0, 0);
        Token semicolonToken = this.formatToken(constantDeclarationNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return constantDeclarationNode.modify().withMetadata(metadata).withVisibilityQualifier(visibilityQualifier).withConstKeyword(constKeyword).withTypeDescriptor(typeDescriptorNode).withVariableName(variableName).withEqualsToken(equalsToken).withInitializer(initializer).withSemicolonToken(semicolonToken).apply();
    }

    public MapTypeDescriptorNode transform(MapTypeDescriptorNode mapTypeDescriptorNode) {
        Token mapKeywordToken = this.formatToken(mapTypeDescriptorNode.mapKeywordToken(), 0, 0);
        TypeParameterNode mapTypeParamsNode = this.formatNode(mapTypeDescriptorNode.mapTypeParamsNode(), this.env.trailingWS, this.env.trailingNL);
        return mapTypeDescriptorNode.modify().withMapKeywordToken(mapKeywordToken).withMapTypeParamsNode(mapTypeParamsNode).apply();
    }

    public TypeParameterNode transform(TypeParameterNode typeParameterNode) {
        Token ltToken = this.formatToken(typeParameterNode.ltToken(), 0, 0);
        TypeDescriptorNode typeNode = this.formatNode(typeParameterNode.typeNode(), 0, 0);
        Token gtToken = this.formatToken(typeParameterNode.gtToken(), this.env.trailingWS, this.env.trailingNL);
        return typeParameterNode.modify().withTypeNode(typeNode).withLtToken(ltToken).withGtToken(gtToken).apply();
    }

    public FunctionTypeDescriptorNode transform(FunctionTypeDescriptorNode functionTypeDescriptorNode) {
        NodeList qualifierList = this.formatNodeList(functionTypeDescriptorNode.qualifierList(), 1, 0, 1, 0);
        Token functionKeyword = functionTypeDescriptorNode.functionSignature().isPresent() ? this.formatToken(functionTypeDescriptorNode.functionKeyword(), 1, 0) : this.formatToken(functionTypeDescriptorNode.functionKeyword(), this.env.trailingWS, this.env.trailingNL);
        FunctionSignatureNode functionSignature = this.formatNode(functionTypeDescriptorNode.functionSignature().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return functionTypeDescriptorNode.modify().withQualifierList(qualifierList).withFunctionKeyword(functionKeyword).withFunctionSignature(functionSignature).apply();
    }

    public ParenthesisedTypeDescriptorNode transform(ParenthesisedTypeDescriptorNode parenthesisedTypeDescriptorNode) {
        Token openParenToken = this.formatToken(parenthesisedTypeDescriptorNode.openParenToken(), 0, 0);
        TypeDescriptorNode typeDesc = this.formatNode(parenthesisedTypeDescriptorNode.typedesc(), 0, 0);
        Token closeParenToken = this.formatToken(parenthesisedTypeDescriptorNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return parenthesisedTypeDescriptorNode.modify().withOpenParenToken(openParenToken).withTypedesc(typeDesc).withCloseParenToken(closeParenToken).apply();
    }

    public ExternalFunctionBodyNode transform(ExternalFunctionBodyNode externalFunctionBodyNode) {
        Token equalsToken = this.formatToken(externalFunctionBodyNode.equalsToken(), 1, 0);
        NodeList annotations = this.formatNodeList(externalFunctionBodyNode.annotations(), 0, 1, 1, 0);
        Token externalKeyword = this.formatToken(externalFunctionBodyNode.externalKeyword(), 0, 0);
        Token semicolonToken = this.formatToken(externalFunctionBodyNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return externalFunctionBodyNode.modify().withEqualsToken(equalsToken).withAnnotations(annotations).withExternalKeyword(externalKeyword).withSemicolonToken(semicolonToken).apply();
    }

    public AnnotationNode transform(AnnotationNode annotationNode) {
        Token atToken = this.formatToken(annotationNode.atToken(), 0, 0);
        Node annotReference = annotationNode.annotValue().isPresent() ? this.formatNode(annotationNode.annotReference(), 1, 0) : this.formatNode(annotationNode.annotReference(), this.env.trailingWS, this.env.trailingNL);
        MappingConstructorExpressionNode annotValue = this.formatNode(annotationNode.annotValue().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return annotationNode.modify().withAtToken(atToken).withAnnotReference(annotReference).withAnnotValue(annotValue).apply();
    }

    public MappingConstructorExpressionNode transform(MappingConstructorExpressionNode mappingConstructorExpressionNode) {
        int fieldTrailingWS = 0;
        int fieldTrailingNL = 0;
        if (this.shouldExpand((Node)mappingConstructorExpressionNode)) {
            ++fieldTrailingNL;
        } else {
            ++fieldTrailingWS;
        }
        int innerWS = this.options.spacingFormattingOptions().aroundRecordBraces() ? 1 : 0;
        Token openBrace = this.formatToken(mappingConstructorExpressionNode.openBrace(), innerWS, fieldTrailingNL);
        this.indent();
        SeparatedNodeList fields = this.formatSeparatedNodeList(mappingConstructorExpressionNode.fields(), 0, 0, fieldTrailingWS, fieldTrailingNL, innerWS, fieldTrailingNL);
        this.unindent();
        Token closeBrace = this.formatToken(mappingConstructorExpressionNode.closeBrace(), this.env.trailingWS, this.env.trailingNL);
        return mappingConstructorExpressionNode.modify().withOpenBrace(openBrace).withFields(fields).withCloseBrace(closeBrace).apply();
    }

    public SpecificFieldNode transform(SpecificFieldNode specificFieldNode) {
        Token readOnlyKeyword = this.formatToken(specificFieldNode.readonlyKeyword().orElse(null), 1, 0);
        Token fieldName = specificFieldNode.fieldName() instanceof BasicLiteralNode ? ((BasicLiteralNode)specificFieldNode.fieldName()).literalToken() : (Token)specificFieldNode.fieldName();
        fieldName = specificFieldNode.colon().isPresent() ? this.formatToken(fieldName, 0, 0) : this.formatToken(fieldName, this.env.trailingWS, this.env.trailingNL);
        Token colon = this.formatToken(specificFieldNode.colon().orElse(null), 1, 0);
        ExpressionNode expressionNode = this.formatNode(specificFieldNode.valueExpr().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return specificFieldNode.modify().withReadonlyKeyword(readOnlyKeyword).withFieldName((Node)fieldName).withColon(colon).withValueExpr(expressionNode).apply();
    }

    public ListConstructorExpressionNode transform(ListConstructorExpressionNode listConstructorExpressionNode) {
        int fieldTrailingWS = 0;
        int fieldTrailingNL = 0;
        if (this.shouldExpand((Node)listConstructorExpressionNode)) {
            ++fieldTrailingNL;
        } else {
            ++fieldTrailingWS;
        }
        Token openBracket = this.formatToken(listConstructorExpressionNode.openBracket(), 0, fieldTrailingNL);
        this.indent();
        SeparatedNodeList expressions = this.formatSeparatedNodeList(listConstructorExpressionNode.expressions(), 0, 0, fieldTrailingWS, fieldTrailingNL, 0, fieldTrailingNL);
        this.unindent();
        Token closeBracket = this.formatToken(listConstructorExpressionNode.closeBracket(), this.env.trailingWS, this.env.trailingNL);
        return listConstructorExpressionNode.modify().withOpenBracket(openBracket).withExpressions(expressions).withCloseBracket(closeBracket).apply();
    }

    public ParameterizedTypeDescriptorNode transform(ParameterizedTypeDescriptorNode parameterizedTypeDescNode) {
        Token keywordToken = parameterizedTypeDescNode.typeParamNode().isPresent() ? this.formatToken(parameterizedTypeDescNode.keywordToken(), 0, 0) : this.formatToken(parameterizedTypeDescNode.keywordToken(), this.env.trailingWS, this.env.trailingNL);
        TypeParameterNode typeParamNode = this.formatNode(parameterizedTypeDescNode.typeParamNode().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return parameterizedTypeDescNode.modify().withKeywordToken(keywordToken).withTypeParamNode(typeParamNode).apply();
    }

    public PanicStatementNode transform(PanicStatementNode panicStatementNode) {
        Token panicKeyword = this.formatToken(panicStatementNode.panicKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(panicStatementNode.expression(), 0, 0);
        Token semicolonToken = this.formatToken(panicStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return panicStatementNode.modify().withPanicKeyword(panicKeyword).withExpression(expression).withSemicolonToken(semicolonToken).apply();
    }

    public IntersectionTypeDescriptorNode transform(IntersectionTypeDescriptorNode intersectionTypeDescriptorNode) {
        Node leftTypeDesc = this.formatNode(intersectionTypeDescriptorNode.leftTypeDesc(), 1, 0);
        Token bitwiseAndToken = this.formatToken(intersectionTypeDescriptorNode.bitwiseAndToken(), 1, 0);
        Node rightTypeDesc = this.formatNode(intersectionTypeDescriptorNode.rightTypeDesc(), this.env.trailingWS, this.env.trailingNL);
        return intersectionTypeDescriptorNode.modify().withLeftTypeDesc(leftTypeDesc).withBitwiseAndToken(bitwiseAndToken).withRightTypeDesc(rightTypeDesc).apply();
    }

    public ModuleVariableDeclarationNode transform(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        MetadataNode metadata = this.formatNode(moduleVariableDeclarationNode.metadata().orElse(null), 0, 1);
        Token visibilityQual = this.formatToken(moduleVariableDeclarationNode.visibilityQualifier().orElse(null), 1, 0);
        NodeList qualifierList = this.formatNodeList(moduleVariableDeclarationNode.qualifiers(), 1, 0, 1, 0);
        TypedBindingPatternNode typedBindingPatternNode = this.formatNode(moduleVariableDeclarationNode.typedBindingPattern(), moduleVariableDeclarationNode.equalsToken().isPresent() ? 1 : 0, 0);
        Token equalsToken = this.formatToken(moduleVariableDeclarationNode.equalsToken().orElse(null), 1, 0);
        boolean prevInlineAnnotation = this.env.inlineAnnotation;
        this.setInlineAnnotation(true);
        ExpressionNode initializer = this.formatNode(moduleVariableDeclarationNode.initializer().orElse(null), 0, 0);
        this.setInlineAnnotation(prevInlineAnnotation);
        Token semicolonToken = this.formatToken(moduleVariableDeclarationNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return moduleVariableDeclarationNode.modify().withMetadata(metadata).withVisibilityQualifier(visibilityQual).withQualifiers(qualifierList).withTypedBindingPattern(typedBindingPatternNode).withEqualsToken(equalsToken).withInitializer(initializer).withSemicolonToken(semicolonToken).apply();
    }

    public ExpressionFunctionBodyNode transform(ExpressionFunctionBodyNode expressionFunctionBodyNode) {
        Token rightDoubleArrow = this.formatToken(expressionFunctionBodyNode.rightDoubleArrow(), 1, 0);
        ExpressionNode expression = expressionFunctionBodyNode.semicolon().isPresent() ? this.formatNode(expressionFunctionBodyNode.expression(), 0, 0) : this.formatNode(expressionFunctionBodyNode.expression(), this.env.trailingWS, this.env.trailingNL);
        Token semicolon = this.formatToken(expressionFunctionBodyNode.semicolon().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return expressionFunctionBodyNode.modify().withRightDoubleArrow(rightDoubleArrow).withExpression(expression).withSemicolon(semicolon).apply();
    }

    public TypeCastExpressionNode transform(TypeCastExpressionNode typeCastExpressionNode) {
        Token ltToken = this.formatToken(typeCastExpressionNode.ltToken(), 0, 0);
        TypeCastParamNode typeCastParam = this.formatNode(typeCastExpressionNode.typeCastParam(), 0, 0);
        Token gtToken = this.formatToken(typeCastExpressionNode.gtToken(), this.options.spacingFormattingOptions().afterTypeCast() ? 1 : 0, 0);
        ExpressionNode expression = this.formatNode(typeCastExpressionNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return typeCastExpressionNode.modify().withLtToken(ltToken).withTypeCastParam(typeCastParam).withGtToken(gtToken).withExpression(expression).apply();
    }

    public TypeCastParamNode transform(TypeCastParamNode typeCastParamNode) {
        NodeList annotations;
        Node type = null;
        if (typeCastParamNode.type().isPresent()) {
            annotations = this.formatNodeList(typeCastParamNode.annotations(), 1, 0, 1, 0);
            type = this.formatNode((Node)typeCastParamNode.type().get(), this.env.trailingWS, this.env.trailingNL);
        } else {
            annotations = this.formatNodeList(typeCastParamNode.annotations(), 1, 0, this.env.trailingWS, this.env.trailingNL);
        }
        return typeCastParamNode.modify().withAnnotations(annotations).withType(type).apply();
    }

    public IndexedExpressionNode transform(IndexedExpressionNode indexedExpressionNode) {
        ExpressionNode containerExpression = this.formatNode(indexedExpressionNode.containerExpression(), 0, 0);
        Token openBracket = this.formatToken(indexedExpressionNode.openBracket(), 0, 0);
        SeparatedNodeList keyExpression = this.formatSeparatedNodeList(indexedExpressionNode.keyExpression(), 0, 0, 0, 0);
        Token closeBracket = this.formatToken(indexedExpressionNode.closeBracket(), this.env.trailingWS, this.env.trailingNL);
        return indexedExpressionNode.modify().withContainerExpression(containerExpression).withOpenBracket(openBracket).withKeyExpression(keyExpression).withCloseBracket(closeBracket).apply();
    }

    public ComputedNameFieldNode transform(ComputedNameFieldNode computedNameFieldNode) {
        Token openBracket = this.formatToken(computedNameFieldNode.openBracket(), 0, 0);
        ExpressionNode fieldNameExpr = this.formatNode(computedNameFieldNode.fieldNameExpr(), 0, 0);
        Token closeBracket = this.formatToken(computedNameFieldNode.closeBracket(), 0, 0);
        Token colonToken = this.formatToken(computedNameFieldNode.colonToken(), 1, 0);
        ExpressionNode valueExpr = this.formatNode(computedNameFieldNode.valueExpr(), this.env.trailingWS, this.env.trailingNL);
        return computedNameFieldNode.modify().withOpenBracket(openBracket).withFieldNameExpr(fieldNameExpr).withCloseBracket(closeBracket).withColonToken(colonToken).withValueExpr(valueExpr).apply();
    }

    public TupleTypeDescriptorNode transform(TupleTypeDescriptorNode tupleTypeDescriptorNode) {
        Token openBracketToken = this.formatToken(tupleTypeDescriptorNode.openBracketToken(), 0, 0);
        SeparatedNodeList memberTypeDesc = this.formatSeparatedNodeList(tupleTypeDescriptorNode.memberTypeDesc(), 0, 0, 0, 0);
        Token closeBracketToken = this.formatToken(tupleTypeDescriptorNode.closeBracketToken(), this.env.trailingWS, this.env.trailingNL);
        return tupleTypeDescriptorNode.modify().withOpenBracketToken(openBracketToken).withMemberTypeDesc(memberTypeDesc).withCloseBracketToken(closeBracketToken).apply();
    }

    public ListBindingPatternNode transform(ListBindingPatternNode listBindingPatternNode) {
        Token openBracket = this.formatToken(listBindingPatternNode.openBracket(), 0, 0);
        SeparatedNodeList bindingPatternNodes = this.formatSeparatedNodeList(listBindingPatternNode.bindingPatterns(), 0, 0, 0, 0);
        Token closeBracket = this.formatToken(listBindingPatternNode.closeBracket(), this.env.trailingWS, this.env.trailingNL);
        return listBindingPatternNode.modify().withOpenBracket(openBracket).withBindingPatterns(bindingPatternNodes).withCloseBracket(closeBracket).apply();
    }

    public RestBindingPatternNode transform(RestBindingPatternNode restBindingPatternNode) {
        Token ellipsisToken = this.formatToken(restBindingPatternNode.ellipsisToken(), 0, 0);
        SimpleNameReferenceNode variableName = this.formatNode(restBindingPatternNode.variableName(), this.env.trailingWS, this.env.trailingNL);
        return restBindingPatternNode.modify().withEllipsisToken(ellipsisToken).withVariableName(variableName).apply();
    }

    public TableTypeDescriptorNode transform(TableTypeDescriptorNode tableTypeDescriptorNode) {
        Token tableKeywordToken = this.formatToken(tableTypeDescriptorNode.tableKeywordToken(), 0, 0);
        Node rowTypeParameterNode = tableTypeDescriptorNode.keyConstraintNode().isPresent() ? this.formatNode(tableTypeDescriptorNode.rowTypeParameterNode(), 1, 0) : this.formatNode(tableTypeDescriptorNode.rowTypeParameterNode(), this.env.trailingWS, this.env.trailingNL);
        Node keyConstraintNode = this.formatNode(tableTypeDescriptorNode.keyConstraintNode().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return tableTypeDescriptorNode.modify().withTableKeywordToken(tableKeywordToken).withRowTypeParameterNode(rowTypeParameterNode).withKeyConstraintNode(keyConstraintNode).apply();
    }

    public KeyTypeConstraintNode transform(KeyTypeConstraintNode keyTypeConstraintNode) {
        Token keyKeywordToken = this.formatToken(keyTypeConstraintNode.keyKeywordToken(), 0, 0);
        Node typeParameterNode = this.formatNode(keyTypeConstraintNode.typeParameterNode(), this.env.trailingWS, this.env.trailingNL);
        return keyTypeConstraintNode.modify().withKeyKeywordToken(keyKeywordToken).withTypeParameterNode(typeParameterNode).apply();
    }

    public MatchStatementNode transform(MatchStatementNode matchStatementNode) {
        boolean hasOnFailClause = matchStatementNode.onFailClause().isPresent();
        Token matchKeyword = this.formatToken(matchStatementNode.matchKeyword(), 1, 0);
        ExpressionNode condition = this.formatNode(matchStatementNode.condition(), 1, 0);
        Token openBrace = this.formatToken(matchStatementNode.openBrace(), 0, 1);
        this.indent();
        NodeList matchClauses = this.formatNodeList(matchStatementNode.matchClauses(), 0, 1, 0, 1);
        this.unindent();
        Token closeBrace = hasOnFailClause ? this.formatToken(matchStatementNode.closeBrace(), 1, 0) : this.formatToken(matchStatementNode.closeBrace(), this.env.trailingWS, this.env.trailingNL);
        OnFailClauseNode onFailClause = this.formatNode(matchStatementNode.onFailClause().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return matchStatementNode.modify().withMatchKeyword(matchKeyword).withCondition(condition).withOpenBrace(openBrace).withMatchClauses(matchClauses).withCloseBrace(closeBrace).withOnFailClause(onFailClause).apply();
    }

    public MatchClauseNode transform(MatchClauseNode matchClauseNode) {
        SeparatedNodeList matchPatterns = this.formatSeparatedNodeList(matchClauseNode.matchPatterns(), 0, 0, 0, 0, 1, 0);
        MatchGuardNode matchGuard = this.formatNode(matchClauseNode.matchGuard().orElse(null), 1, 0);
        Token rightDoubleArrow = this.formatToken(matchClauseNode.rightDoubleArrow(), 1, 0);
        BlockStatementNode blockStatement = this.formatNode(matchClauseNode.blockStatement(), this.env.trailingWS, this.env.trailingNL);
        return matchClauseNode.modify().withMatchPatterns(matchPatterns).withMatchGuard(matchGuard).withRightDoubleArrow(rightDoubleArrow).withBlockStatement(blockStatement).apply();
    }

    public MatchGuardNode transform(MatchGuardNode matchGuardNode) {
        Token ifKeyword = this.formatToken(matchGuardNode.ifKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(matchGuardNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return matchGuardNode.modify().withIfKeyword(ifKeyword).withExpression(expression).apply();
    }

    public LockStatementNode transform(LockStatementNode lockStatementNode) {
        Token lockKeyword = this.formatToken(lockStatementNode.lockKeyword(), 1, 0);
        BlockStatementNode blockStatement = lockStatementNode.onFailClause().isPresent() ? this.formatNode(lockStatementNode.blockStatement(), 1, 0) : this.formatNode(lockStatementNode.blockStatement(), this.env.trailingWS, this.env.trailingNL);
        OnFailClauseNode onFailClause = this.formatNode(lockStatementNode.onFailClause().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return lockStatementNode.modify().withLockKeyword(lockKeyword).withBlockStatement(blockStatement).withOnFailClause(onFailClause).apply();
    }

    public FieldAccessExpressionNode transform(FieldAccessExpressionNode fieldAccessExpressionNode) {
        ExpressionNode expression = this.formatNode(fieldAccessExpressionNode.expression(), 0, 0);
        Token dotToken = this.formatToken(fieldAccessExpressionNode.dotToken(), 0, 0);
        NameReferenceNode fieldName = this.formatNode(fieldAccessExpressionNode.fieldName(), this.env.trailingWS, this.env.trailingNL);
        return fieldAccessExpressionNode.modify().withExpression(expression).withDotToken(dotToken).withFieldName(fieldName).apply();
    }

    public MetadataNode transform(MetadataNode metadataNode) {
        if (metadataNode.documentationString().isPresent()) {
            Node documentationString = this.formatNode(metadataNode.documentationString().orElse(null), 0, 1);
            metadataNode = metadataNode.modify().withDocumentationString(documentationString).apply();
        }
        NodeList annotations = this.formatNodeList(metadataNode.annotations(), 0, 1, this.env.trailingWS, this.env.trailingNL);
        return metadataNode.modify().withAnnotations(annotations).apply();
    }

    public EnumDeclarationNode transform(EnumDeclarationNode enumDeclarationNode) {
        MetadataNode metadata = this.formatNode(enumDeclarationNode.metadata().orElse(null), 0, 1);
        Token qualifier = this.formatToken(enumDeclarationNode.qualifier().orElse(null), 1, 0);
        Token enumKeywordToken = this.formatToken(enumDeclarationNode.enumKeywordToken(), 1, 0);
        IdentifierToken identifier = this.formatNode(enumDeclarationNode.identifier(), 1, 0);
        Token openBraceToken = this.formatToken(enumDeclarationNode.openBraceToken(), 0, 1);
        int separatorTrailingWS = 0;
        int separatorTrailingNL = 0;
        if (this.shouldExpand((Node)enumDeclarationNode)) {
            ++separatorTrailingNL;
        } else {
            ++separatorTrailingWS;
        }
        this.indent();
        SeparatedNodeList enumMemberList = this.formatSeparatedNodeList(enumDeclarationNode.enumMemberList(), 0, 0, separatorTrailingWS, separatorTrailingNL, 0, 1);
        this.unindent();
        Optional optSemicolon = enumDeclarationNode.semicolonToken();
        Token closeBraceToken = optSemicolon.isPresent() ? this.formatToken(enumDeclarationNode.closeBraceToken(), 0, 0) : this.formatToken(enumDeclarationNode.closeBraceToken(), this.env.trailingWS, this.env.trailingNL);
        Token semicolon = this.formatToken(optSemicolon.orElse(null), this.env.trailingWS, this.env.trailingNL);
        return enumDeclarationNode.modify().withMetadata(metadata).withQualifier(qualifier).withEnumKeywordToken(enumKeywordToken).withIdentifier(identifier).withOpenBraceToken(openBraceToken).withEnumMemberList(enumMemberList).withCloseBraceToken(closeBraceToken).withSemicolonToken(semicolon).apply();
    }

    public EnumMemberNode transform(EnumMemberNode enumMemberNode) {
        MetadataNode metadata = this.formatNode(enumMemberNode.metadata().orElse(null), 0, 1);
        IdentifierToken identifier = enumMemberNode.equalToken().isPresent() ? this.formatNode(enumMemberNode.identifier(), 1, 0) : this.formatNode(enumMemberNode.identifier(), this.env.trailingWS, this.env.trailingNL);
        Token equalToken = this.formatToken(enumMemberNode.equalToken().orElse(null), 1, 0);
        ExpressionNode constExprNode = this.formatNode(enumMemberNode.constExprNode().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return enumMemberNode.modify().withMetadata(metadata).withIdentifier(identifier).withEqualToken(equalToken).withConstExprNode(constExprNode).apply();
    }

    public MarkdownDocumentationNode transform(MarkdownDocumentationNode markdownDocumentationNode) {
        NodeList documentationLines = this.formatNodeList(markdownDocumentationNode.documentationLines(), 0, 1, this.env.trailingWS, this.env.trailingNL);
        return markdownDocumentationNode.modify().withDocumentationLines(documentationLines).apply();
    }

    public MarkdownDocumentationLineNode transform(MarkdownDocumentationLineNode markdownDocumentationLineNode) {
        Token hashToken = markdownDocumentationLineNode.documentElements().isEmpty() ? this.formatToken(markdownDocumentationLineNode.hashToken(), this.env.trailingWS, this.env.trailingNL) : this.formatToken(markdownDocumentationLineNode.hashToken(), 1, 0);
        NodeList documentElements = this.formatNodeList(markdownDocumentationLineNode.documentElements(), 0, 0, this.env.trailingWS, this.env.trailingNL);
        return markdownDocumentationLineNode.modify().withDocumentElements(documentElements).withHashToken(hashToken).apply();
    }

    public MarkdownParameterDocumentationLineNode transform(MarkdownParameterDocumentationLineNode markdownParameterDocumentationLineNode) {
        Token hashToken = this.formatToken(markdownParameterDocumentationLineNode.hashToken(), 1, 0);
        Token plusToken = markdownParameterDocumentationLineNode.plusToken();
        Token parameterName = markdownParameterDocumentationLineNode.parameterName();
        Token minusToken = markdownParameterDocumentationLineNode.minusToken();
        NodeList documentElements = markdownParameterDocumentationLineNode.documentElements();
        if (parameterName.isMissing() && minusToken.isMissing() && documentElements.isEmpty()) {
            plusToken = this.formatToken(plusToken, this.env.trailingWS, this.env.trailingNL);
        } else {
            plusToken = this.formatToken(plusToken, 1, 0);
            if (minusToken.isMissing() && documentElements.isEmpty()) {
                parameterName = this.formatToken(parameterName, this.env.trailingWS, this.env.trailingNL);
            } else {
                parameterName = this.formatToken(parameterName, 1, 0);
                if (documentElements.isEmpty()) {
                    minusToken = this.formatToken(minusToken, this.env.trailingWS, this.env.trailingNL);
                } else {
                    minusToken = this.formatToken(minusToken, 1, 0);
                    documentElements = this.formatNodeList(markdownParameterDocumentationLineNode.documentElements(), 0, 0, this.env.trailingWS, this.env.trailingNL);
                }
            }
        }
        return markdownParameterDocumentationLineNode.modify().withHashToken(hashToken).withPlusToken(plusToken).withParameterName(parameterName).withMinusToken(minusToken).withDocumentElements(documentElements).apply();
    }

    public BallerinaNameReferenceNode transform(BallerinaNameReferenceNode ballerinaNameReferenceNode) {
        Token referenceType = this.formatToken(ballerinaNameReferenceNode.referenceType().orElse(null), 1, 0);
        Token startBacktick = this.formatToken(ballerinaNameReferenceNode.startBacktick(), 0, 0);
        Node backtickContent = this.formatNode(ballerinaNameReferenceNode.nameReference(), 0, 0);
        Token endBacktick = this.formatToken(ballerinaNameReferenceNode.endBacktick(), this.env.trailingWS, this.env.trailingNL);
        return ballerinaNameReferenceNode.modify().withReferenceType(referenceType).withStartBacktick(startBacktick).withNameReference(backtickContent).withEndBacktick(endBacktick).apply();
    }

    public InlineCodeReferenceNode transform(InlineCodeReferenceNode inlineCodeReferenceNode) {
        Token startBacktick = this.formatToken(inlineCodeReferenceNode.startBacktick(), 0, 0);
        Token codeReference = this.formatToken(inlineCodeReferenceNode.codeReference(), 0, 0);
        Token endBacktick = this.formatToken(inlineCodeReferenceNode.endBacktick(), this.env.trailingWS, this.env.trailingNL);
        return inlineCodeReferenceNode.modify().withStartBacktick(startBacktick).withCodeReference(codeReference).withEndBacktick(endBacktick).apply();
    }

    public MarkdownCodeBlockNode transform(MarkdownCodeBlockNode markdownCodeBlockNode) {
        Token startLineHash = this.formatToken(markdownCodeBlockNode.startLineHashToken(), 1, 0);
        boolean hasLangAttribute = markdownCodeBlockNode.langAttribute().isPresent();
        Token startBacktick = this.formatToken(markdownCodeBlockNode.startBacktick(), 0, hasLangAttribute ? 0 : 1);
        Token langAttribute = this.formatToken(markdownCodeBlockNode.langAttribute().orElse(null), 0, 1);
        NodeList codeLines = this.formatNodeList(markdownCodeBlockNode.codeLines(), 0, 1, 0, 1);
        Token endLineHash = this.formatToken(markdownCodeBlockNode.endLineHashToken(), 1, 0);
        Token endBacktick = this.formatToken(markdownCodeBlockNode.endBacktick(), this.env.trailingWS, this.env.trailingNL);
        return markdownCodeBlockNode.modify().withStartLineHashToken(startLineHash).withStartBacktick(startBacktick).withLangAttribute(langAttribute).withCodeLines(codeLines).withEndLineHashToken(endLineHash).withEndBacktick(endBacktick).apply();
    }

    public MarkdownCodeLineNode transform(MarkdownCodeLineNode markdownCodeLineNode) {
        Token hashToken;
        boolean hasDescription;
        Token codeDescription = markdownCodeLineNode.codeDescription();
        boolean bl = hasDescription = !codeDescription.text().isEmpty();
        if (hasDescription) {
            hashToken = this.formatToken(markdownCodeLineNode.hashToken(), 1, 0);
            codeDescription = this.formatToken(codeDescription, this.env.trailingWS, this.env.trailingNL);
        } else {
            hashToken = this.formatToken(markdownCodeLineNode.hashToken(), this.env.trailingWS, this.env.trailingNL);
        }
        return markdownCodeLineNode.modify().withHashToken(hashToken).withCodeDescription(codeDescription).apply();
    }

    public PositionalArgumentNode transform(PositionalArgumentNode positionalArgumentNode) {
        if (this.env.lineLength != 0 && this.isScopedFunctionArgument((FunctionArgumentNode)positionalArgumentNode)) {
            this.align();
        }
        ExpressionNode expression = this.formatNode(positionalArgumentNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return positionalArgumentNode.modify().withExpression(expression).apply();
    }

    public MappingBindingPatternNode transform(MappingBindingPatternNode mappingBindingPatternNode) {
        Token openBraceToken = this.formatToken(mappingBindingPatternNode.openBrace(), 0, 0);
        SeparatedNodeList fieldBindingPatternNodes = this.formatSeparatedNodeList(mappingBindingPatternNode.fieldBindingPatterns(), 0, 0, 0, 0);
        Token closeBraceToken = this.formatToken(mappingBindingPatternNode.closeBrace(), this.env.trailingWS, this.env.trailingNL);
        return mappingBindingPatternNode.modify().withOpenBrace(openBraceToken).withFieldBindingPatterns(fieldBindingPatternNodes).withCloseBrace(closeBraceToken).apply();
    }

    public FieldBindingPatternFullNode transform(FieldBindingPatternFullNode fieldBindingPatternFullNode) {
        SimpleNameReferenceNode variableName = this.formatNode(fieldBindingPatternFullNode.variableName(), 0, 0);
        Token colon = this.formatToken(fieldBindingPatternFullNode.colon(), 1, 0);
        BindingPatternNode bindingPatternNode = this.formatNode(fieldBindingPatternFullNode.bindingPattern(), this.env.trailingWS, this.env.leadingNL);
        return fieldBindingPatternFullNode.modify().withVariableName(variableName).withColon(colon).withBindingPattern(bindingPatternNode).apply();
    }

    public FieldBindingPatternVarnameNode transform(FieldBindingPatternVarnameNode fieldBindingPatternVarnameNode) {
        SimpleNameReferenceNode variableName = this.formatNode(fieldBindingPatternVarnameNode.variableName(), this.env.trailingWS, this.env.leadingNL);
        return fieldBindingPatternVarnameNode.modify().withVariableName(variableName).apply();
    }

    public TypeTestExpressionNode transform(TypeTestExpressionNode typeTestExpressionNode) {
        ExpressionNode expression = this.formatNode(typeTestExpressionNode.expression(), 1, 0);
        Token isToken = this.formatToken(typeTestExpressionNode.isKeyword(), 1, 0);
        Node typeDescriptor = this.formatNode(typeTestExpressionNode.typeDescriptor(), this.env.trailingWS, this.env.trailingNL);
        return typeTestExpressionNode.modify().withExpression(expression).withIsKeyword(isToken).withTypeDescriptor(typeDescriptor).apply();
    }

    public ListenerDeclarationNode transform(ListenerDeclarationNode listenerDeclarationNode) {
        Token visibilityQualifier = this.formatToken(listenerDeclarationNode.visibilityQualifier().orElse(null), 1, 0);
        MetadataNode metadata = this.formatNode(listenerDeclarationNode.metadata().orElse(null), 0, 1);
        Token listenerKeyword = this.formatToken(listenerDeclarationNode.listenerKeyword(), 1, 0);
        TypeDescriptorNode typeDescriptor = this.formatNode(listenerDeclarationNode.typeDescriptor().orElse(null), 1, 0);
        Token variableName = this.formatToken(listenerDeclarationNode.variableName(), 1, 0);
        Token equalsToken = this.formatToken(listenerDeclarationNode.equalsToken(), 1, 0);
        Node initializer = this.formatNode(listenerDeclarationNode.initializer(), 0, 0);
        Token semicolonToken = this.formatToken(listenerDeclarationNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return listenerDeclarationNode.modify().withMetadata(metadata).withVisibilityQualifier(visibilityQualifier).withListenerKeyword(listenerKeyword).withTypeDescriptor(typeDescriptor).withVariableName(variableName).withEqualsToken(equalsToken).withInitializer(initializer).withSemicolonToken(semicolonToken).apply();
    }

    public MethodCallExpressionNode transform(MethodCallExpressionNode methodCallExpressionNode) {
        ExpressionNode expression = this.formatNode(methodCallExpressionNode.expression(), 0, 0);
        Token dotToken = this.formatToken(methodCallExpressionNode.dotToken(), 0, 0);
        NameReferenceNode methodName = this.formatNode(methodCallExpressionNode.methodName(), 0, 0);
        Token openParenToken = this.formatToken(methodCallExpressionNode.openParenToken(), 0, 0);
        SeparatedNodeList arguments = this.formatSeparatedNodeList(methodCallExpressionNode.arguments(), 0, 0, 0, 0);
        Token closeParenToken = this.formatToken(methodCallExpressionNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return methodCallExpressionNode.modify().withExpression(expression).withDotToken(dotToken).withMethodName(methodName).withOpenParenToken(openParenToken).withArguments(arguments).withCloseParenToken(closeParenToken).apply();
    }

    public NilLiteralNode transform(NilLiteralNode nilLiteralNode) {
        Token openParenToken = this.formatToken(nilLiteralNode.openParenToken(), 0, 0);
        Token closeParenToken = this.formatToken(nilLiteralNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return nilLiteralNode.modify().withOpenParenToken(openParenToken).withCloseParenToken(closeParenToken).apply();
    }

    public XMLNamespaceDeclarationNode transform(XMLNamespaceDeclarationNode xMLNamespaceDeclarationNode) {
        Token xmlnsKeyword = this.formatToken(xMLNamespaceDeclarationNode.xmlnsKeyword(), 1, 0);
        boolean hasPrefix = xMLNamespaceDeclarationNode.asKeyword().isPresent();
        ExpressionNode namespaceUri = this.formatNode(xMLNamespaceDeclarationNode.namespaceuri(), hasPrefix ? 1 : 0, 0);
        Token asKeyword = this.formatToken(xMLNamespaceDeclarationNode.asKeyword().orElse(null), 1, 0);
        IdentifierToken namespacePrefix = this.formatNode(xMLNamespaceDeclarationNode.namespacePrefix().orElse(null), 0, 0);
        Token semicolonToken = this.formatToken(xMLNamespaceDeclarationNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return xMLNamespaceDeclarationNode.modify().withXmlnsKeyword(xmlnsKeyword).withNamespaceuri(namespaceUri).withAsKeyword(asKeyword).withNamespacePrefix(namespacePrefix).withSemicolonToken(semicolonToken).apply();
    }

    public ModuleXMLNamespaceDeclarationNode transform(ModuleXMLNamespaceDeclarationNode moduleXMLNamespaceDeclarationNode) {
        Token xmlnsKeyword = this.formatToken(moduleXMLNamespaceDeclarationNode.xmlnsKeyword(), 1, 0);
        boolean hasPrefix = moduleXMLNamespaceDeclarationNode.asKeyword().isPresent();
        ExpressionNode namespaceUri = this.formatNode(moduleXMLNamespaceDeclarationNode.namespaceuri(), hasPrefix ? 1 : 0, 0);
        Token asKeyword = this.formatToken(moduleXMLNamespaceDeclarationNode.asKeyword().orElse(null), 1, 0);
        IdentifierToken namespacePrefix = this.formatNode(moduleXMLNamespaceDeclarationNode.namespacePrefix().orElse(null), 0, 0);
        Token semicolonToken = this.formatToken(moduleXMLNamespaceDeclarationNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return moduleXMLNamespaceDeclarationNode.modify().withAsKeyword(asKeyword).withNamespacePrefix(namespacePrefix).withXmlnsKeyword(xmlnsKeyword).withNamespaceuri(namespaceUri).withSemicolonToken(semicolonToken).apply();
    }

    public XMLSimpleNameNode transform(XMLSimpleNameNode xMLSimpleNameNode) {
        Token name = this.formatToken(xMLSimpleNameNode.name(), this.env.trailingWS, this.env.trailingNL);
        return xMLSimpleNameNode.modify().withName(name).apply();
    }

    public XMLQualifiedNameNode transform(XMLQualifiedNameNode xMLQualifiedNameNode) {
        XMLSimpleNameNode prefix = this.formatNode(xMLQualifiedNameNode.prefix(), 0, 0);
        Token colon = this.formatToken(xMLQualifiedNameNode.colon(), 0, 0);
        XMLSimpleNameNode name = this.formatNode(xMLQualifiedNameNode.name(), this.env.trailingWS, this.env.trailingNL);
        return xMLQualifiedNameNode.modify().withPrefix(prefix).withName(name).withColon(colon).apply();
    }

    public XMLEmptyElementNode transform(XMLEmptyElementNode xMLEmptyElementNode) {
        Token ltToken = this.formatToken(xMLEmptyElementNode.ltToken(), 0, 0);
        XMLNameNode name = xMLEmptyElementNode.attributes().isEmpty() ? this.formatNode(xMLEmptyElementNode.name(), 0, 0) : this.formatNode(xMLEmptyElementNode.name(), 1, 0);
        NodeList attributes = this.formatNodeList(xMLEmptyElementNode.attributes(), 1, 0, 0, 0);
        Token slashToken = this.formatToken(xMLEmptyElementNode.slashToken(), 0, 0);
        Token getToken = this.formatToken(xMLEmptyElementNode.getToken(), this.env.trailingWS, this.env.trailingNL);
        return xMLEmptyElementNode.modify().withLtToken(ltToken).withName(name).withAttributes(attributes).withSlashToken(slashToken).withGetToken(getToken).apply();
    }

    public XMLTextNode transform(XMLTextNode xMLTextNode) {
        Token content = this.formatToken(xMLTextNode.content(), this.env.trailingWS, this.env.trailingNL);
        for (char c : content.text().toCharArray()) {
            if (c == '\n') {
                this.env.lineLength = 0;
                continue;
            }
            ++this.env.lineLength;
        }
        return xMLTextNode.modify().withContent(content).apply();
    }

    public XMLComment transform(XMLComment xMLComment) {
        Token commentStart = this.formatToken(xMLComment.commentStart(), 0, 0);
        NodeList content = this.formatNodeList(xMLComment.content(), 0, 0, 0, 0);
        Token commentEnd = this.formatToken(xMLComment.commentEnd(), this.env.trailingWS, this.env.trailingNL);
        return xMLComment.modify().withCommentStart(commentStart).withContent(content).withCommentEnd(commentEnd).apply();
    }

    public XMLCDATANode transform(XMLCDATANode xmlCdataNode) {
        Token cdataStart = this.formatToken(xmlCdataNode.cdataStart(), 0, 0);
        NodeList content = this.formatNodeList(xmlCdataNode.content(), 0, 0, 0, 0);
        Token cdataEnd = this.formatToken(xmlCdataNode.cdataEnd(), this.env.trailingWS, this.env.trailingNL);
        return xmlCdataNode.modify().withCdataStart(cdataStart).withContent(content).withCdataEnd(cdataEnd).apply();
    }

    public XMLProcessingInstruction transform(XMLProcessingInstruction xMLProcessingInstruction) {
        Token piStart = this.formatToken(xMLProcessingInstruction.piStart(), 0, 0);
        XMLNameNode target = xMLProcessingInstruction.data().isEmpty() ? this.formatNode(xMLProcessingInstruction.target(), 0, 0) : this.formatNode(xMLProcessingInstruction.target(), 1, 0);
        NodeList data = this.formatNodeList(xMLProcessingInstruction.data(), 0, 0, 0, 0);
        Token piEnd = this.formatToken(xMLProcessingInstruction.piEnd(), this.env.trailingWS, this.env.trailingNL);
        return xMLProcessingInstruction.modify().withTarget(target).withPiStart(piStart).withData(data).withPiEnd(piEnd).apply();
    }

    public XMLFilterExpressionNode transform(XMLFilterExpressionNode xMLFilterExpressionNode) {
        ExpressionNode expression = this.formatNode(xMLFilterExpressionNode.expression(), 0, 0);
        XMLNamePatternChainingNode xmlPatternChain = this.formatNode(xMLFilterExpressionNode.xmlPatternChain(), this.env.trailingWS, this.env.trailingNL);
        return xMLFilterExpressionNode.modify().withExpression(expression).withXmlPatternChain(xmlPatternChain).apply();
    }

    public XMLStepExpressionNode transform(XMLStepExpressionNode xMLStepExpressionNode) {
        ExpressionNode expression = this.formatNode(xMLStepExpressionNode.expression(), 0, 0);
        NodeList xmlStepExtend = xMLStepExpressionNode.xmlStepExtend();
        Node xmlStepStart = xmlStepExtend.isEmpty() ? this.formatNode(xMLStepExpressionNode.xmlStepStart(), this.env.trailingWS, this.env.trailingNL) : this.formatNode(xMLStepExpressionNode.xmlStepStart(), 0, 0);
        xmlStepExtend = this.formatNodeList(xmlStepExtend, 0, 0, this.env.trailingWS, this.env.trailingNL);
        return xMLStepExpressionNode.modify().withExpression(expression).withXmlStepStart(xmlStepStart).withXmlStepExtend(xmlStepExtend).apply();
    }

    public XMLStepIndexedExtendNode transform(XMLStepIndexedExtendNode xMLStepIndexedExtendNode) {
        Token openBracket = this.formatToken(xMLStepIndexedExtendNode.openBracket(), 0, 0);
        ExpressionNode expression = this.formatNode(xMLStepIndexedExtendNode.expression(), 0, 0);
        Token closeBracket = this.formatToken(xMLStepIndexedExtendNode.closeBracket(), this.env.trailingWS, this.env.trailingNL);
        return xMLStepIndexedExtendNode.modify().withOpenBracket(openBracket).withExpression(expression).withCloseBracket(closeBracket).apply();
    }

    public XMLStepMethodCallExtendNode transform(XMLStepMethodCallExtendNode xMLStepMethodCallExtendNode) {
        Token dotToken = this.formatToken(xMLStepMethodCallExtendNode.dotToken(), 0, 0);
        SimpleNameReferenceNode methodName = this.formatNode(xMLStepMethodCallExtendNode.methodName(), 0, 0);
        ParenthesizedArgList parenthesizedArgList = this.formatNode(xMLStepMethodCallExtendNode.parenthesizedArgList(), this.env.trailingWS, this.env.trailingNL);
        return xMLStepMethodCallExtendNode.modify().withDotToken(dotToken).withMethodName(methodName).withParenthesizedArgList(parenthesizedArgList).apply();
    }

    public XMLNamePatternChainingNode transform(XMLNamePatternChainingNode xMLNamePatternChainingNode) {
        Token startToken = this.formatToken(xMLNamePatternChainingNode.startToken(), 0, 0);
        SeparatedNodeList xmlNamePattern = this.formatSeparatedNodeList(xMLNamePatternChainingNode.xmlNamePattern(), 0, 0, 0, 0, 0, 0);
        Token gtToken = this.formatToken(xMLNamePatternChainingNode.gtToken(), this.env.trailingWS, this.env.trailingNL);
        return xMLNamePatternChainingNode.modify().withStartToken(startToken).withXmlNamePattern(xmlNamePattern).withGtToken(gtToken).apply();
    }

    public XMLAtomicNamePatternNode transform(XMLAtomicNamePatternNode xMLAtomicNamePatternNode) {
        Token prefix = this.formatToken(xMLAtomicNamePatternNode.prefix(), 0, 0);
        Token colon = this.formatToken(xMLAtomicNamePatternNode.colon(), 0, 0);
        Token name = this.formatToken(xMLAtomicNamePatternNode.name(), this.env.trailingWS, this.env.trailingNL);
        return xMLAtomicNamePatternNode.modify().withPrefix(prefix).withColon(colon).withName(name).apply();
    }

    public TemplateExpressionNode transform(TemplateExpressionNode templateExpressionNode) {
        Token type = this.formatToken(templateExpressionNode.type().orElse(null), 1, 0);
        Token startBacktick = this.formatToken(templateExpressionNode.startBacktick(), 0, 0);
        NodeList content = this.formatNodeList(templateExpressionNode.content(), 0, 0, 0, 0);
        Token endBacktick = this.formatToken(templateExpressionNode.endBacktick(), this.env.trailingWS, this.env.trailingNL);
        return templateExpressionNode.modify().withType(type).withStartBacktick(startBacktick).withContent(content).withEndBacktick(endBacktick).apply();
    }

    public ByteArrayLiteralNode transform(ByteArrayLiteralNode byteArrayLiteralNode) {
        Token type = this.formatToken(byteArrayLiteralNode.type(), 1, 0);
        Token startBacktick = this.formatToken(byteArrayLiteralNode.startBacktick(), 0, 0);
        Token content = this.formatToken(byteArrayLiteralNode.content().orElse(null), 0, 0);
        Token endBacktick = this.formatToken(byteArrayLiteralNode.endBacktick(), this.env.trailingWS, this.env.trailingNL);
        return byteArrayLiteralNode.modify().withType(type).withStartBacktick(startBacktick).withContent(content).withEndBacktick(endBacktick).apply();
    }

    public TypeReferenceNode transform(TypeReferenceNode typeReferenceNode) {
        Token asteriskToken = this.formatToken(typeReferenceNode.asteriskToken(), 0, 0);
        Node typeName = this.formatNode(typeReferenceNode.typeName(), 0, 0);
        Token semicolonToken = this.formatToken(typeReferenceNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return typeReferenceNode.modify().withAsteriskToken(asteriskToken).withTypeName(typeName).withSemicolonToken(semicolonToken).apply();
    }

    public MappingMatchPatternNode transform(MappingMatchPatternNode mappingMatchPatternNode) {
        Token openBraceToken = this.formatToken(mappingMatchPatternNode.openBraceToken(), 0, 0);
        SeparatedNodeList fieldMatchPatterns = this.formatSeparatedNodeList(mappingMatchPatternNode.fieldMatchPatterns(), 0, 0, 0, 0);
        Token closeBraceToken = this.formatToken(mappingMatchPatternNode.closeBraceToken(), this.env.trailingWS, this.env.trailingNL);
        return mappingMatchPatternNode.modify().withOpenBraceToken(openBraceToken).withFieldMatchPatterns(fieldMatchPatterns).withCloseBraceToken(closeBraceToken).apply();
    }

    public StartActionNode transform(StartActionNode startActionNode) {
        NodeList annotations = this.env.inlineAnnotation ? this.formatNodeList(startActionNode.annotations(), 1, 0, 1, 0) : this.formatNodeList(startActionNode.annotations(), 0, 1, 0, 1);
        Token startKeyword = this.formatToken(startActionNode.startKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(startActionNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return startActionNode.modify().withAnnotations(annotations).withStartKeyword(startKeyword).withExpression(expression).apply();
    }

    public FlushActionNode transform(FlushActionNode flushActionNode) {
        Token flushKeyword = flushActionNode.peerWorker().isPresent() ? this.formatToken(flushActionNode.flushKeyword(), 1, 0) : this.formatToken(flushActionNode.flushKeyword(), this.env.trailingWS, this.env.trailingNL);
        NameReferenceNode peerWorker = this.formatNode(flushActionNode.peerWorker().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return flushActionNode.modify().withFlushKeyword(flushKeyword).withPeerWorker(peerWorker).apply();
    }

    public FailStatementNode transform(FailStatementNode failStatementNode) {
        Token failKeyword = this.formatToken(failStatementNode.failKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(failStatementNode.expression(), 0, 0);
        Token semicolonToken = this.formatToken(failStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return failStatementNode.modify().withFailKeyword(failKeyword).withExpression(expression).withSemicolonToken(semicolonToken).apply();
    }

    public ContinueStatementNode transform(ContinueStatementNode continueStatementNode) {
        Token continueToken = this.formatToken(continueStatementNode.continueToken(), 0, 0);
        Token semicolonToken = this.formatToken(continueStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return continueStatementNode.modify().withContinueToken(continueToken).withSemicolonToken(semicolonToken).apply();
    }

    public LocalTypeDefinitionStatementNode transform(LocalTypeDefinitionStatementNode localTypeDefinitionStatementNode) {
        NodeList annotations = this.formatNodeList(localTypeDefinitionStatementNode.annotations(), 1, 0, 1, 0);
        Token typeKeyword = this.formatToken(localTypeDefinitionStatementNode.typeKeyword(), 1, 0);
        Node typeName = this.formatNode(localTypeDefinitionStatementNode.typeName(), 1, 0);
        Node typeDescriptor = this.formatNode(localTypeDefinitionStatementNode.typeDescriptor(), 1, 0);
        Token semicolonToken = this.formatToken(localTypeDefinitionStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return localTypeDefinitionStatementNode.modify().withAnnotations(annotations).withTypeKeyword(typeKeyword).withTypeName(typeName).withTypeDescriptor(typeDescriptor).withSemicolonToken(semicolonToken).apply();
    }

    public ForkStatementNode transform(ForkStatementNode forkStatementNode) {
        Token forkKeyword = this.formatToken(forkStatementNode.forkKeyword(), 1, 0);
        Token openBraceToken = this.formatToken(forkStatementNode.openBraceToken(), 0, 1);
        this.indent();
        NodeList namedWorkerDeclarations = this.formatNodeList(forkStatementNode.namedWorkerDeclarations(), 0, 1, 0, 1);
        this.unindent();
        Token closeBraceToken = this.formatToken(forkStatementNode.closeBraceToken(), this.env.trailingWS, this.env.trailingNL);
        return forkStatementNode.modify().withForkKeyword(forkKeyword).withOpenBraceToken(openBraceToken).withNamedWorkerDeclarations(namedWorkerDeclarations).withCloseBraceToken(closeBraceToken).apply();
    }

    public TypeofExpressionNode transform(TypeofExpressionNode typeofExpressionNode) {
        Token typeofKeyword = this.formatToken(typeofExpressionNode.typeofKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(typeofExpressionNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return typeofExpressionNode.modify().withTypeofKeyword(typeofKeyword).withExpression(expression).apply();
    }

    public UnaryExpressionNode transform(UnaryExpressionNode unaryExpressionNode) {
        Token unaryOperator = this.formatToken(unaryExpressionNode.unaryOperator(), 0, 0);
        ExpressionNode expression = this.formatNode(unaryExpressionNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return unaryExpressionNode.modify().withUnaryOperator(unaryOperator).withExpression(expression).apply();
    }

    public DefaultableParameterNode transform(DefaultableParameterNode defaultableParameterNode) {
        NodeList annotations = this.formatNodeList(defaultableParameterNode.annotations(), 1, 0, 1, 0);
        Node typeName = this.formatNode(defaultableParameterNode.typeName(), 1, 0);
        Token paramName = this.formatToken(defaultableParameterNode.paramName().orElse(null), 1, 0);
        Token equalsToken = this.formatToken(defaultableParameterNode.equalsToken(), 1, 0);
        Node expression = this.formatNode(defaultableParameterNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return defaultableParameterNode.modify().withAnnotations(annotations).withTypeName(typeName).withParamName(paramName).withEqualsToken(equalsToken).withExpression(expression).apply();
    }

    public RestParameterNode transform(RestParameterNode restParameterNode) {
        NodeList annotations = this.formatNodeList(restParameterNode.annotations(), 0, 1, 0, 1);
        Node typeName = this.formatNode(restParameterNode.typeName(), 0, 0);
        Token ellipsisToken = restParameterNode.paramName().isPresent() ? this.formatToken(restParameterNode.ellipsisToken(), 1, 0) : this.formatToken(restParameterNode.ellipsisToken(), this.env.trailingWS, this.env.trailingNL);
        Token paramName = this.formatToken(restParameterNode.paramName().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return restParameterNode.modify().withAnnotations(annotations).withTypeName(typeName).withParamName(paramName).withEllipsisToken(ellipsisToken).apply();
    }

    public SpreadFieldNode transform(SpreadFieldNode spreadFieldNode) {
        Token ellipsis = this.formatToken(spreadFieldNode.ellipsis(), 0, 0);
        ExpressionNode valueExpr = this.formatNode(spreadFieldNode.valueExpr(), this.env.trailingWS, this.env.trailingNL);
        return spreadFieldNode.modify().withEllipsis(ellipsis).withValueExpr(valueExpr).apply();
    }

    public SpreadMemberNode transform(SpreadMemberNode spreadMemberNode) {
        Token ellipsis = this.formatToken(spreadMemberNode.ellipsis(), 0, 0);
        ExpressionNode valueExpr = this.formatNode(spreadMemberNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return spreadMemberNode.modify().withEllipsis(ellipsis).withExpression(valueExpr).apply();
    }

    public NamedArgumentNode transform(NamedArgumentNode namedArgumentNode) {
        SimpleNameReferenceNode argumentName = this.formatNode(namedArgumentNode.argumentName(), 1, 0);
        Token equalsToken = this.formatToken(namedArgumentNode.equalsToken(), 1, 0);
        ExpressionNode expression = this.formatNode(namedArgumentNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return namedArgumentNode.modify().withArgumentName(argumentName).withEqualsToken(equalsToken).withExpression(expression).apply();
    }

    public RestArgumentNode transform(RestArgumentNode restArgumentNode) {
        Token ellipsis = this.formatToken(restArgumentNode.ellipsis(), 0, 0);
        ExpressionNode expression = this.formatNode(restArgumentNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return restArgumentNode.modify().withEllipsis(ellipsis).withExpression(expression).apply();
    }

    public ObjectTypeDescriptorNode transform(ObjectTypeDescriptorNode objectTypeDescriptorNode) {
        NodeList objectTypeQualifiers = this.formatNodeList(objectTypeDescriptorNode.objectTypeQualifiers(), 1, 0, 1, 0);
        Token objectKeyword = this.formatToken(objectTypeDescriptorNode.objectKeyword(), 1, 0);
        int fieldTrailingWS = 0;
        int fieldTrailingNL = 0;
        if (this.shouldExpand((Node)objectTypeDescriptorNode)) {
            ++fieldTrailingNL;
        } else {
            ++fieldTrailingWS;
        }
        Token openBrace = this.formatToken(objectTypeDescriptorNode.openBrace(), 0, fieldTrailingNL);
        this.indent();
        NodeList members = this.formatNodeList(objectTypeDescriptorNode.members(), fieldTrailingWS, fieldTrailingNL, 0, fieldTrailingNL);
        this.unindent();
        Token closeBrace = this.formatToken(objectTypeDescriptorNode.closeBrace(), this.env.trailingWS, this.env.trailingNL);
        return objectTypeDescriptorNode.modify().withObjectTypeQualifiers(objectTypeQualifiers).withObjectKeyword(objectKeyword).withOpenBrace(openBrace).withMembers(members).withCloseBrace(closeBrace).apply();
    }

    public ObjectConstructorExpressionNode transform(ObjectConstructorExpressionNode objectConstructorExpressionNode) {
        NodeList annotations = this.formatNodeList(objectConstructorExpressionNode.annotations(), 1, 0, 1, 0);
        NodeList objectTypeQualifiers = this.formatNodeList(objectConstructorExpressionNode.objectTypeQualifiers(), 1, 0, 1, 0);
        Token objectKeyword = this.formatToken(objectConstructorExpressionNode.objectKeyword(), 1, 0);
        int fieldTrailingWS = 0;
        int fieldTrailingNL = 0;
        if (this.shouldExpand((Node)objectConstructorExpressionNode)) {
            ++fieldTrailingNL;
        } else {
            ++fieldTrailingWS;
        }
        TypeDescriptorNode typeReference = this.formatNode(objectConstructorExpressionNode.typeReference().orElse(null), 1, 0);
        Token openBraceToken = this.formatToken(objectConstructorExpressionNode.openBraceToken(), 0, fieldTrailingNL);
        this.indent();
        NodeList members = this.formatNodeList(objectConstructorExpressionNode.members(), fieldTrailingWS, fieldTrailingNL, 0, fieldTrailingNL);
        this.unindent();
        Token closeBraceToken = this.formatToken(objectConstructorExpressionNode.closeBraceToken(), this.env.trailingWS, this.env.trailingNL);
        return objectConstructorExpressionNode.modify().withAnnotations(annotations).withObjectTypeQualifiers(objectTypeQualifiers).withObjectKeyword(objectKeyword).withTypeReference(typeReference).withOpenBraceToken(openBraceToken).withMembers(members).withCloseBraceToken(closeBraceToken).apply();
    }

    public ObjectFieldNode transform(ObjectFieldNode objectFieldNode) {
        MetadataNode metadata = this.formatNode(objectFieldNode.metadata().orElse(null), 0, 1);
        Token visibilityQualifier = this.formatToken(objectFieldNode.visibilityQualifier().orElse(null), 1, 0);
        NodeList qualifierList = this.formatNodeList(objectFieldNode.qualifierList(), 1, 0, 1, 0);
        Node typeName = this.formatNode(objectFieldNode.typeName(), 1, 0);
        Token fieldName = objectFieldNode.equalsToken().isPresent() && objectFieldNode.expression().isPresent() ? this.formatToken(objectFieldNode.fieldName(), 1, 0) : this.formatToken(objectFieldNode.fieldName(), 0, 0);
        Token equalsToken = this.formatToken(objectFieldNode.equalsToken().orElse(null), 1, 0);
        ExpressionNode expression = this.formatNode(objectFieldNode.expression().orElse(null), 0, 0);
        Token semicolonToken = this.formatToken(objectFieldNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return objectFieldNode.modify().withMetadata(metadata).withVisibilityQualifier(visibilityQualifier).withQualifierList(qualifierList).withTypeName(typeName).withFieldName(fieldName).withEqualsToken(equalsToken).withExpression(expression).withSemicolonToken(semicolonToken).apply();
    }

    public RecordRestDescriptorNode transform(RecordRestDescriptorNode recordRestDescriptorNode) {
        Node typeName = this.formatNode(recordRestDescriptorNode.typeName(), 0, 0);
        Token ellipsisToken = this.formatToken(recordRestDescriptorNode.ellipsisToken(), 0, 0);
        Token semicolonToken = this.formatToken(recordRestDescriptorNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return recordRestDescriptorNode.modify().withTypeName(typeName).withEllipsisToken(ellipsisToken).withSemicolonToken(semicolonToken).apply();
    }

    public AnnotationDeclarationNode transform(AnnotationDeclarationNode annotationDeclarationNode) {
        MetadataNode metadata = this.formatNode(annotationDeclarationNode.metadata().orElse(null), 0, 1);
        Token visibilityQualifier = this.formatToken(annotationDeclarationNode.visibilityQualifier().orElse(null), 1, 0);
        Token constKeyword = this.formatToken(annotationDeclarationNode.constKeyword().orElse(null), 1, 0);
        Token annotationKeyword = this.formatToken(annotationDeclarationNode.annotationKeyword(), 1, 0);
        Node typeDescriptor = this.formatNode(annotationDeclarationNode.typeDescriptor().orElse(null), 1, 0);
        Token annotationTag = annotationDeclarationNode.onKeyword().isPresent() ? this.formatToken(annotationDeclarationNode.annotationTag(), 1, 0) : this.formatToken(annotationDeclarationNode.annotationTag(), 0, 0);
        Token onKeyword = this.formatToken(annotationDeclarationNode.onKeyword().orElse(null), 1, 0);
        int currentIndentation = this.env.currentIndentation;
        this.setIndentation(this.env.lineLength);
        SeparatedNodeList attachPoints = this.formatSeparatedNodeList(annotationDeclarationNode.attachPoints(), 0, 0, 0, 0);
        this.setIndentation(currentIndentation);
        Token semicolonToken = this.formatToken(annotationDeclarationNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return annotationDeclarationNode.modify().withMetadata(metadata).withVisibilityQualifier(visibilityQualifier).withConstKeyword(constKeyword).withAnnotationKeyword(annotationKeyword).withTypeDescriptor(typeDescriptor).withAnnotationTag(annotationTag).withOnKeyword(onKeyword).withAttachPoints(attachPoints).withSemicolonToken(semicolonToken).apply();
    }

    public AnnotationAttachPointNode transform(AnnotationAttachPointNode annotationAttachPointNode) {
        Token sourceKeyword = this.formatToken(annotationAttachPointNode.sourceKeyword().orElse(null), 1, 0);
        NodeList identifiers = this.formatNodeList(annotationAttachPointNode.identifiers(), 1, 0, this.env.trailingWS, this.env.trailingNL);
        return annotationAttachPointNode.modify().withSourceKeyword(sourceKeyword).withIdentifiers(identifiers).apply();
    }

    public TrapExpressionNode transform(TrapExpressionNode trapExpressionNode) {
        Token trapKeyword = this.formatToken(trapExpressionNode.trapKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(trapExpressionNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return trapExpressionNode.modify().withTrapKeyword(trapKeyword).withExpression(expression).apply();
    }

    public TableConstructorExpressionNode transform(TableConstructorExpressionNode tableConstructorExpressionNode) {
        Token tableKeyword = this.formatToken(tableConstructorExpressionNode.tableKeyword(), 1, 0);
        KeySpecifierNode keySpecifier = this.formatNode(tableConstructorExpressionNode.keySpecifier().orElse(null), 1, 0);
        int rowTrailingWS = 0;
        int rowTrailingNL = 0;
        if (this.shouldExpand((Node)tableConstructorExpressionNode)) {
            ++rowTrailingNL;
        } else {
            ++rowTrailingWS;
        }
        Token openBracket = this.formatToken(tableConstructorExpressionNode.openBracket(), 0, rowTrailingNL);
        this.indent();
        SeparatedNodeList mappingConstructors = this.formatSeparatedNodeList(tableConstructorExpressionNode.rows(), 0, 0, rowTrailingWS, rowTrailingNL, 0, rowTrailingNL);
        this.unindent();
        Token closeBracket = this.formatToken(tableConstructorExpressionNode.closeBracket(), this.env.trailingWS, this.env.trailingNL);
        return tableConstructorExpressionNode.modify().withTableKeyword(tableKeyword).withKeySpecifier(keySpecifier).withOpenBracket(openBracket).withRows(mappingConstructors).withCloseBracket(closeBracket).apply();
    }

    public KeySpecifierNode transform(KeySpecifierNode keySpecifierNode) {
        Token keyKeyword = this.formatToken(keySpecifierNode.keyKeyword(), 0, 0);
        Token openParenToken = this.formatToken(keySpecifierNode.openParenToken(), 0, 0);
        SeparatedNodeList fieldNames = this.formatSeparatedNodeList(keySpecifierNode.fieldNames(), 0, 0, 0, 0);
        Token closeParenToken = this.formatToken(keySpecifierNode.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return keySpecifierNode.modify().withKeyKeyword(keyKeyword).withOpenParenToken(openParenToken).withFieldNames(fieldNames).withCloseParenToken(closeParenToken).apply();
    }

    public StreamTypeDescriptorNode transform(StreamTypeDescriptorNode streamTypeDescriptorNode) {
        Token streamKeywordToken = streamTypeDescriptorNode.streamTypeParamsNode().isPresent() ? this.formatToken(streamTypeDescriptorNode.streamKeywordToken(), 0, 0) : this.formatToken(streamTypeDescriptorNode.streamKeywordToken(), this.env.trailingWS, this.env.trailingNL);
        Node streamTypeParamsNode = this.formatNode(streamTypeDescriptorNode.streamTypeParamsNode().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return streamTypeDescriptorNode.modify().withStreamKeywordToken(streamKeywordToken).withStreamTypeParamsNode(streamTypeParamsNode).apply();
    }

    public StreamTypeParamsNode transform(StreamTypeParamsNode streamTypeParamsNode) {
        Token ltToken = this.formatToken(streamTypeParamsNode.ltToken(), 0, 0);
        Node leftTypeDescNode = this.formatNode(streamTypeParamsNode.leftTypeDescNode(), 0, 0);
        Token commaToken = this.formatToken(streamTypeParamsNode.commaToken().orElse(null), 1, 0);
        Node rightTypeDescNode = this.formatNode(streamTypeParamsNode.rightTypeDescNode().orElse(null), 0, 0);
        Token gtToken = this.formatToken(streamTypeParamsNode.gtToken(), this.env.trailingWS, this.env.trailingNL);
        return streamTypeParamsNode.modify().withLtToken(ltToken).withLeftTypeDescNode(leftTypeDescNode).withCommaToken(commaToken).withRightTypeDescNode(rightTypeDescNode).withGtToken(gtToken).apply();
    }

    public LetExpressionNode transform(LetExpressionNode letExpressionNode) {
        Token letKeyword = this.formatToken(letExpressionNode.letKeyword(), 1, 0);
        int listTrailingNL = 0;
        int listTrailingWS = 0;
        if (this.shouldExpand((Node)letExpressionNode)) {
            ++listTrailingNL;
        } else {
            ++listTrailingWS;
        }
        this.indent();
        SeparatedNodeList letVarDeclarations = this.formatSeparatedNodeList(letExpressionNode.letVarDeclarations(), 0, 0, listTrailingWS, listTrailingNL);
        Token inKeyword = this.formatToken(letExpressionNode.inKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(letExpressionNode.expression(), this.env.trailingWS, this.env.trailingNL);
        this.unindent();
        return letExpressionNode.modify().withLetKeyword(letKeyword).withLetVarDeclarations(letVarDeclarations).withInKeyword(inKeyword).withExpression(expression).apply();
    }

    public LetVariableDeclarationNode transform(LetVariableDeclarationNode letVariableDeclarationNode) {
        NodeList annotations = this.formatNodeList(letVariableDeclarationNode.annotations(), 0, 1, 0, 1);
        TypedBindingPatternNode typedBindingPattern = this.formatNode(letVariableDeclarationNode.typedBindingPattern(), 1, 0);
        Token equalsToken = this.formatToken(letVariableDeclarationNode.equalsToken(), 1, 0);
        ExpressionNode expression = this.formatNode(letVariableDeclarationNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return letVariableDeclarationNode.modify().withAnnotations(annotations).withTypedBindingPattern(typedBindingPattern).withEqualsToken(equalsToken).withExpression(expression).apply();
    }

    public InterpolationNode transform(InterpolationNode interpolationNode) {
        Token interpolationStartToken = this.formatToken(interpolationNode.interpolationStartToken(), 0, 0);
        ExpressionNode expression = this.formatNode(interpolationNode.expression(), 0, 0);
        Token interpolationEndToken = this.formatToken(interpolationNode.interpolationEndToken(), this.env.trailingWS, this.env.trailingNL);
        return interpolationNode.modify().withInterpolationStartToken(interpolationStartToken).withExpression(expression).withInterpolationEndToken(interpolationEndToken).apply();
    }

    public ExplicitAnonymousFunctionExpressionNode transform(ExplicitAnonymousFunctionExpressionNode explicitAnonymousFunctionExpressionNode) {
        NodeList annotations = this.formatNodeList(explicitAnonymousFunctionExpressionNode.annotations(), 0, 1, 0, 1);
        NodeList qualifierList = this.formatNodeList(explicitAnonymousFunctionExpressionNode.qualifierList(), 1, 0, 1, 0);
        Token functionKeyword = this.formatToken(explicitAnonymousFunctionExpressionNode.functionKeyword(), 0, 0);
        FunctionSignatureNode functionSignature = this.formatNode(explicitAnonymousFunctionExpressionNode.functionSignature(), 1, 0);
        FunctionBodyNode functionBody = this.formatNode(explicitAnonymousFunctionExpressionNode.functionBody(), this.env.trailingWS, this.env.trailingNL);
        return explicitAnonymousFunctionExpressionNode.modify().withQualifierList(qualifierList).withAnnotations(annotations).withFunctionKeyword(functionKeyword).withFunctionSignature(functionSignature).withFunctionBody(functionBody).apply();
    }

    public ImplicitNewExpressionNode transform(ImplicitNewExpressionNode implicitNewExpressionNode) {
        Token newKeyword = implicitNewExpressionNode.parenthesizedArgList().isPresent() ? this.formatToken(implicitNewExpressionNode.newKeyword(), 1, 0) : this.formatToken(implicitNewExpressionNode.newKeyword(), this.env.trailingWS, this.env.trailingNL);
        ParenthesizedArgList parenthesizedArgList = this.formatNode(implicitNewExpressionNode.parenthesizedArgList().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return implicitNewExpressionNode.modify().withNewKeyword(newKeyword).withParenthesizedArgList(parenthesizedArgList).apply();
    }

    public QueryConstructTypeNode transform(QueryConstructTypeNode queryConstructTypeNode) {
        Token keyword = queryConstructTypeNode.keySpecifier().isPresent() ? this.formatToken(queryConstructTypeNode.keyword(), 1, 0) : this.formatToken(queryConstructTypeNode.keyword(), this.env.trailingWS, this.env.trailingNL);
        KeySpecifierNode keySpecifier = this.formatNode(queryConstructTypeNode.keySpecifier().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return queryConstructTypeNode.modify().withKeyword(keyword).withKeySpecifier(keySpecifier).apply();
    }

    public FromClauseNode transform(FromClauseNode fromClauseNode) {
        Token fromKeyword = this.formatToken(fromClauseNode.fromKeyword(), 1, 0);
        TypedBindingPatternNode typedBindingPattern = this.formatNode(fromClauseNode.typedBindingPattern(), 1, 0);
        Token inKeyword = this.formatToken(fromClauseNode.inKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(fromClauseNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return fromClauseNode.modify().withFromKeyword(fromKeyword).withTypedBindingPattern(typedBindingPattern).withInKeyword(inKeyword).withExpression(expression).apply();
    }

    public WhereClauseNode transform(WhereClauseNode whereClauseNode) {
        Token whereKeyword = this.formatToken(whereClauseNode.whereKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(whereClauseNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return whereClauseNode.modify().withWhereKeyword(whereKeyword).withExpression(expression).apply();
    }

    public LetClauseNode transform(LetClauseNode letClauseNode) {
        Token letKeyword = this.formatToken(letClauseNode.letKeyword(), 1, 0);
        SeparatedNodeList letVarDeclarations = this.formatSeparatedNodeList(letClauseNode.letVarDeclarations(), 0, 0, this.env.trailingWS, this.env.trailingNL);
        return letClauseNode.modify().withLetKeyword(letKeyword).withLetVarDeclarations(letVarDeclarations).apply();
    }

    public QueryPipelineNode transform(QueryPipelineNode queryPipelineNode) {
        FromClauseNode fromClause = this.formatNode(queryPipelineNode.fromClause(), 0, 1);
        NodeList intermediateClauses = this.formatNodeList(queryPipelineNode.intermediateClauses(), 0, 1, this.env.trailingWS, this.env.trailingNL);
        return queryPipelineNode.modify().withFromClause(fromClause).withIntermediateClauses(intermediateClauses).apply();
    }

    public SelectClauseNode transform(SelectClauseNode selectClauseNode) {
        Token selectKeyword = this.formatToken(selectClauseNode.selectKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(selectClauseNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return selectClauseNode.modify().withSelectKeyword(selectKeyword).withExpression(expression).apply();
    }

    public CollectClauseNode transform(CollectClauseNode collectClauseNode) {
        Token collectKeyword = this.formatToken(collectClauseNode.collectKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(collectClauseNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return collectClauseNode.modify().withCollectKeyword(collectKeyword).withExpression(expression).apply();
    }

    public QueryExpressionNode transform(QueryExpressionNode queryExpressionNode) {
        int length;
        boolean alignMultiLineQueries = this.options.queryFormattingOptions().alignMultiLineQueries();
        int n = length = alignMultiLineQueries ? this.env.currentIndentation : this.env.lineLength;
        if (length != 0) {
            this.alignOrIndent(alignMultiLineQueries);
        }
        QueryConstructTypeNode queryConstructType = this.formatNode(queryExpressionNode.queryConstructType().orElse(null), 1, 0);
        QueryPipelineNode queryPipeline = this.formatNode(queryExpressionNode.queryPipeline(), 0, 1);
        ClauseNode resultClause = queryExpressionNode.onConflictClause().isPresent() ? this.formatNode(queryExpressionNode.resultClause(), 0, 1) : this.formatNode(queryExpressionNode.resultClause(), this.env.trailingWS, this.env.trailingNL);
        OnConflictClauseNode onConflictClause = this.formatNode(queryExpressionNode.onConflictClause().orElse(null), this.env.trailingWS, this.env.trailingNL);
        if (length != 0) {
            this.unalignOrUnindent(alignMultiLineQueries);
        }
        return queryExpressionNode.modify().withQueryConstructType(queryConstructType).withQueryPipeline(queryPipeline).withResultClause(resultClause).withOnConflictClause(onConflictClause).apply();
    }

    public ImplicitAnonymousFunctionParameters transform(ImplicitAnonymousFunctionParameters implicitAnonymousFunctionParameters) {
        Token openParenToken = this.formatToken(implicitAnonymousFunctionParameters.openParenToken(), 0, 0);
        SeparatedNodeList parameters = this.formatSeparatedNodeList(implicitAnonymousFunctionParameters.parameters(), 0, 0, 0, 0);
        Token closeParenToken = this.formatToken(implicitAnonymousFunctionParameters.closeParenToken(), this.env.trailingWS, this.env.trailingNL);
        return implicitAnonymousFunctionParameters.modify().withOpenParenToken(openParenToken).withParameters(parameters).withCloseParenToken(closeParenToken).apply();
    }

    public ImplicitAnonymousFunctionExpressionNode transform(ImplicitAnonymousFunctionExpressionNode implicitAnonymousFunctionExpressionNode) {
        Node params = this.formatNode(implicitAnonymousFunctionExpressionNode.params(), 1, 0);
        Token rightDoubleArrow = this.formatToken(implicitAnonymousFunctionExpressionNode.rightDoubleArrow(), 1, 0);
        ExpressionNode expression = this.formatNode(implicitAnonymousFunctionExpressionNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return implicitAnonymousFunctionExpressionNode.modify().withParams(params).withRightDoubleArrow(rightDoubleArrow).withExpression(expression).apply();
    }

    public MethodDeclarationNode transform(MethodDeclarationNode methodDeclarationNode) {
        MetadataNode metadata = this.formatNode(methodDeclarationNode.metadata().orElse(null), 0, 1);
        NodeList qualifierList = this.formatNodeList(methodDeclarationNode.qualifierList(), 1, 0, 1, 0);
        Token functionKeyword = this.formatToken(methodDeclarationNode.functionKeyword(), 1, 0);
        IdentifierToken methodName = methodDeclarationNode.relativeResourcePath().isEmpty() ? this.formatNode(methodDeclarationNode.methodName(), 0, 0) : this.formatNode(methodDeclarationNode.methodName(), 1, 0);
        NodeList relativeResourcePath = this.formatNodeList(methodDeclarationNode.relativeResourcePath(), 0, 0, 0, 0);
        FunctionSignatureNode methodSignature = this.formatNode(methodDeclarationNode.methodSignature(), 0, 0);
        Token semicolon = this.formatToken(methodDeclarationNode.semicolon(), this.env.trailingWS, this.env.trailingNL);
        return methodDeclarationNode.modify().withMetadata(metadata).withQualifierList(qualifierList).withFunctionKeyword(functionKeyword).withMethodName(methodName).withRelativeResourcePath(relativeResourcePath).withMethodSignature(methodSignature).withSemicolon(semicolon).apply();
    }

    public WildcardBindingPatternNode transform(WildcardBindingPatternNode wildcardBindingPatternNode) {
        Token underscoreToken = this.formatToken(wildcardBindingPatternNode.underscoreToken(), this.env.trailingWS, this.env.trailingNL);
        return wildcardBindingPatternNode.modify().withUnderscoreToken(underscoreToken).apply();
    }

    public ErrorBindingPatternNode transform(ErrorBindingPatternNode errorBindingPatternNode) {
        Token errorKeyword = errorBindingPatternNode.typeReference().isPresent() ? this.formatToken(errorBindingPatternNode.errorKeyword(), 1, 0) : this.formatToken(errorBindingPatternNode.errorKeyword(), 0, 0);
        Node typeReference = this.formatNode(errorBindingPatternNode.typeReference().orElse(null), 0, 0);
        Token openParenthesis = this.formatToken(errorBindingPatternNode.openParenthesis(), 0, 0);
        SeparatedNodeList argListBindingPatterns = this.formatSeparatedNodeList(errorBindingPatternNode.argListBindingPatterns(), 0, 0, 0, 0);
        Token closeParenthesis = this.formatToken(errorBindingPatternNode.closeParenthesis(), this.env.trailingWS, this.env.trailingNL);
        return errorBindingPatternNode.modify().withErrorKeyword(errorKeyword).withTypeReference(typeReference).withOpenParenthesis(openParenthesis).withArgListBindingPatterns(argListBindingPatterns).withCloseParenthesis(closeParenthesis).apply();
    }

    public NamedArgBindingPatternNode transform(NamedArgBindingPatternNode namedArgBindingPatternNode) {
        IdentifierToken argName = this.formatToken(namedArgBindingPatternNode.argName(), 1, 0);
        Token equalsToken = this.formatToken(namedArgBindingPatternNode.equalsToken(), 1, 0);
        BindingPatternNode bindingPattern = this.formatNode(namedArgBindingPatternNode.bindingPattern(), this.env.trailingWS, this.env.leadingNL);
        return namedArgBindingPatternNode.modify().withArgName(argName).withEqualsToken(equalsToken).withBindingPattern(bindingPattern).apply();
    }

    public AsyncSendActionNode transform(AsyncSendActionNode asyncSendActionNode) {
        ExpressionNode expression = this.formatNode(asyncSendActionNode.expression(), 1, 0);
        Token rightArrowToken = this.formatToken(asyncSendActionNode.rightArrowToken(), 1, 0);
        SimpleNameReferenceNode peerWorker = this.formatNode(asyncSendActionNode.peerWorker(), this.env.trailingWS, this.env.trailingNL);
        return asyncSendActionNode.modify().withExpression(expression).withRightArrowToken(rightArrowToken).withPeerWorker(peerWorker).apply();
    }

    public SyncSendActionNode transform(SyncSendActionNode syncSendActionNode) {
        ExpressionNode expression = this.formatNode(syncSendActionNode.expression(), 1, 0);
        Token syncSendToken = this.formatToken(syncSendActionNode.syncSendToken(), 1, 0);
        SimpleNameReferenceNode peerWorker = this.formatNode(syncSendActionNode.peerWorker(), this.env.trailingWS, this.env.trailingNL);
        return syncSendActionNode.modify().withExpression(expression).withSyncSendToken(syncSendToken).withPeerWorker(peerWorker).apply();
    }

    public ReceiveActionNode transform(ReceiveActionNode receiveActionNode) {
        Token leftArrow = this.formatToken(receiveActionNode.leftArrow(), 1, 0);
        Node receiveWorkers = this.formatNode(receiveActionNode.receiveWorkers(), this.env.trailingWS, this.env.trailingNL);
        return receiveActionNode.modify().withLeftArrow(leftArrow).withReceiveWorkers(receiveWorkers).apply();
    }

    public ReceiveFieldsNode transform(ReceiveFieldsNode receiveFieldsNode) {
        boolean preserveIndent = this.env.preserveIndentation;
        this.preserveIndentation(false);
        boolean isMultiline = this.shouldExpand((Node)receiveFieldsNode);
        int trailingNL = isMultiline ? 1 : 0;
        int trailingWS = isMultiline ? 0 : 1;
        Token openBrace = this.formatToken(receiveFieldsNode.openBrace(), 0, trailingNL);
        this.indent();
        SeparatedNodeList receiveFields = this.formatSeparatedNodeList(receiveFieldsNode.receiveFields(), 0, 0, trailingWS, trailingNL, 0, trailingNL);
        this.unindent();
        Token closeBrace = this.formatToken(receiveFieldsNode.closeBrace(), this.env.trailingWS, this.env.trailingNL);
        this.preserveIndentation(preserveIndent);
        return receiveFieldsNode.modify().withOpenBrace(openBrace).withReceiveFields(receiveFields).withCloseBrace(closeBrace).apply();
    }

    public AlternateReceiveNode transform(AlternateReceiveNode alternateReceiveNode) {
        SeparatedNodeList workers = this.formatSeparatedNodeList(alternateReceiveNode.workers(), 1, 0, this.env.trailingWS, this.env.trailingNL);
        return alternateReceiveNode.modify().withWorkers(workers).apply();
    }

    public ReceiveFieldNode transform(ReceiveFieldNode receiveFieldNode) {
        SimpleNameReferenceNode fieldName = this.formatNode(receiveFieldNode.fieldName(), 0, 0);
        Token colon = this.formatToken(receiveFieldNode.colon(), 1, 0);
        SimpleNameReferenceNode peerWorker = this.formatNode(receiveFieldNode.peerWorker(), this.env.trailingWS, this.env.trailingNL);
        return receiveFieldNode.modify().withFieldName(fieldName).withColon(colon).withPeerWorker(peerWorker).apply();
    }

    public RestDescriptorNode transform(RestDescriptorNode restDescriptorNode) {
        TypeDescriptorNode typeDescriptor = this.formatNode(restDescriptorNode.typeDescriptor(), 0, 0);
        Token ellipsisToken = this.formatToken(restDescriptorNode.ellipsisToken(), this.env.trailingWS, this.env.trailingNL);
        return restDescriptorNode.modify().withTypeDescriptor(typeDescriptor).withEllipsisToken(ellipsisToken).apply();
    }

    public DoubleGTTokenNode transform(DoubleGTTokenNode doubleGTTokenNode) {
        Token openGTToken = this.formatToken(doubleGTTokenNode.openGTToken(), 0, 0);
        Token endGTToken = this.formatToken(doubleGTTokenNode.endGTToken(), this.env.trailingWS, this.env.trailingNL);
        return doubleGTTokenNode.modify().withOpenGTToken(openGTToken).withEndGTToken(endGTToken).apply();
    }

    public TrippleGTTokenNode transform(TrippleGTTokenNode trippleGTTokenNode) {
        Token openGTToken = this.formatToken(trippleGTTokenNode.openGTToken(), 0, 0);
        Token middleGTToken = this.formatToken(trippleGTTokenNode.middleGTToken(), 0, 0);
        Token endGTToken = this.formatToken(trippleGTTokenNode.endGTToken(), this.env.trailingWS, this.env.trailingNL);
        return trippleGTTokenNode.modify().withOpenGTToken(openGTToken).withMiddleGTToken(middleGTToken).withEndGTToken(endGTToken).apply();
    }

    public WaitActionNode transform(WaitActionNode waitActionNode) {
        Token waitKeyword = this.formatToken(waitActionNode.waitKeyword(), 1, 0);
        Node waitFutureExpr = this.formatNode(waitActionNode.waitFutureExpr(), this.env.trailingWS, this.env.trailingNL);
        return waitActionNode.modify().withWaitKeyword(waitKeyword).withWaitFutureExpr(waitFutureExpr).apply();
    }

    public WaitFieldsListNode transform(WaitFieldsListNode waitFieldsListNode) {
        Token openBrace = this.formatToken(waitFieldsListNode.openBrace(), 0, 0);
        SeparatedNodeList waitFields = this.formatSeparatedNodeList(waitFieldsListNode.waitFields(), 0, 0, 0, 0);
        Token closeBrace = this.formatToken(waitFieldsListNode.closeBrace(), this.env.trailingWS, this.env.trailingNL);
        return waitFieldsListNode.modify().withOpenBrace(openBrace).withWaitFields(waitFields).withCloseBrace(closeBrace).apply();
    }

    public WaitFieldNode transform(WaitFieldNode waitFieldNode) {
        SimpleNameReferenceNode fieldName = this.formatNode(waitFieldNode.fieldName(), 0, 0);
        Token colon = this.formatToken(waitFieldNode.colon(), 1, 0);
        ExpressionNode waitFutureExpr = this.formatNode(waitFieldNode.waitFutureExpr(), this.env.trailingWS, this.env.trailingNL);
        return waitFieldNode.modify().withFieldName(fieldName).withColon(colon).withWaitFutureExpr(waitFutureExpr).apply();
    }

    public AnnotAccessExpressionNode transform(AnnotAccessExpressionNode annotAccessExpressionNode) {
        ExpressionNode expression = this.formatNode(annotAccessExpressionNode.expression(), 0, 0);
        Token annotChainingToken = this.formatToken(annotAccessExpressionNode.annotChainingToken(), 0, 0);
        NameReferenceNode annotTagReference = this.formatNode(annotAccessExpressionNode.annotTagReference(), this.env.trailingWS, this.env.trailingNL);
        return annotAccessExpressionNode.modify().withExpression(expression).withAnnotChainingToken(annotChainingToken).withAnnotTagReference(annotTagReference).apply();
    }

    public QueryActionNode transform(QueryActionNode queryActionNode) {
        int lineLength = this.env.lineLength;
        if (lineLength != 0) {
            this.indent();
        }
        QueryPipelineNode queryPipeline = this.formatNode(queryActionNode.queryPipeline(), 0, 1);
        Token doKeyword = this.formatToken(queryActionNode.doKeyword(), 1, 0);
        BlockStatementNode blockStatement = this.formatNode(queryActionNode.blockStatement(), this.env.trailingWS, this.env.trailingNL);
        if (lineLength != 0) {
            this.unindent();
        }
        return queryActionNode.modify().withQueryPipeline(queryPipeline).withDoKeyword(doKeyword).withBlockStatement(blockStatement).apply();
    }

    public OptionalFieldAccessExpressionNode transform(OptionalFieldAccessExpressionNode optionalFieldAccessExpressionNode) {
        ExpressionNode expression = this.formatNode(optionalFieldAccessExpressionNode.expression(), 0, 0);
        Token optionalChainingToken = this.formatToken(optionalFieldAccessExpressionNode.optionalChainingToken(), 0, 0);
        NameReferenceNode fieldName = this.formatNode(optionalFieldAccessExpressionNode.fieldName(), this.env.trailingWS, this.env.trailingNL);
        return optionalFieldAccessExpressionNode.modify().withExpression(expression).withOptionalChainingToken(optionalChainingToken).withFieldName(fieldName).apply();
    }

    public ConditionalExpressionNode transform(ConditionalExpressionNode conditionalExpressionNode) {
        this.indent();
        ExpressionNode lhsExpression = this.formatNode(conditionalExpressionNode.lhsExpression(), 1, 0, !this.env.hasNewline);
        Token questionMarkToken = this.formatToken(conditionalExpressionNode.questionMarkToken(), 1, 0, !this.env.hasNewline);
        ExpressionNode middleExpression = this.formatNode(conditionalExpressionNode.middleExpression(), 1, 0, !this.env.hasNewline);
        Token colonToken = this.formatToken(conditionalExpressionNode.colonToken(), 1, 0, !this.env.hasNewline);
        ExpressionNode endExpression = this.formatNode(conditionalExpressionNode.endExpression(), this.env.trailingWS, this.env.trailingNL, !this.env.hasNewline);
        this.unindent();
        return conditionalExpressionNode.modify().withLhsExpression(lhsExpression).withQuestionMarkToken(questionMarkToken).withMiddleExpression(middleExpression).withColonToken(colonToken).withEndExpression(endExpression).apply();
    }

    public TransactionStatementNode transform(TransactionStatementNode transactionStatementNode) {
        Token transactionKeyword = this.formatToken(transactionStatementNode.transactionKeyword(), 1, 0);
        BlockStatementNode blockStatement = transactionStatementNode.onFailClause().isPresent() ? this.formatNode(transactionStatementNode.blockStatement(), 1, 0) : this.formatNode(transactionStatementNode.blockStatement(), this.env.trailingWS, this.env.trailingNL);
        OnFailClauseNode onFailClause = this.formatNode(transactionStatementNode.onFailClause().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return transactionStatementNode.modify().withTransactionKeyword(transactionKeyword).withBlockStatement(blockStatement).withOnFailClause(onFailClause).apply();
    }

    public RollbackStatementNode transform(RollbackStatementNode rollbackStatementNode) {
        Token rollbackKeyword = rollbackStatementNode.expression().isPresent() ? this.formatToken(rollbackStatementNode.rollbackKeyword(), 1, 0) : this.formatToken(rollbackStatementNode.rollbackKeyword(), 0, 0);
        ExpressionNode expression = this.formatNode(rollbackStatementNode.expression().orElse(null), 0, 0);
        Token semicolon = this.formatToken(rollbackStatementNode.semicolon(), this.env.trailingWS, this.env.trailingNL);
        return rollbackStatementNode.modify().withRollbackKeyword(rollbackKeyword).withExpression(expression).withSemicolon(semicolon).apply();
    }

    public RetryStatementNode transform(RetryStatementNode retryStatementNode) {
        Token retryKeyword = retryStatementNode.typeParameter().isPresent() || retryStatementNode.arguments().isPresent() ? this.formatToken(retryStatementNode.retryKeyword(), 0, 0) : this.formatToken(retryStatementNode.retryKeyword(), 1, 0);
        TypeParameterNode typeParameter = this.formatNode(retryStatementNode.typeParameter().orElse(null), 1, 0);
        ParenthesizedArgList arguments = this.formatNode(retryStatementNode.arguments().orElse(null), 1, 0);
        StatementNode retryBody = retryStatementNode.onFailClause().isPresent() ? this.formatNode(retryStatementNode.retryBody(), 1, 0) : this.formatNode(retryStatementNode.retryBody(), this.env.trailingWS, this.env.trailingNL);
        OnFailClauseNode onFailClause = this.formatNode(retryStatementNode.onFailClause().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return retryStatementNode.modify().withRetryKeyword(retryKeyword).withTypeParameter(typeParameter).withArguments(arguments).withRetryBody(retryBody).withOnFailClause(onFailClause).apply();
    }

    public CommitActionNode transform(CommitActionNode commitActionNode) {
        Token commitKeyword = this.formatToken(commitActionNode.commitKeyword(), this.env.trailingWS, this.env.trailingNL);
        return commitActionNode.modify().withCommitKeyword(commitKeyword).apply();
    }

    public TransactionalExpressionNode transform(TransactionalExpressionNode transactionalExpressionNode) {
        Token transactionalKeyword = this.formatToken(transactionalExpressionNode.transactionalKeyword(), this.env.trailingWS, this.env.trailingNL);
        return transactionalExpressionNode.modify().withTransactionalKeyword(transactionalKeyword).apply();
    }

    public TypeReferenceTypeDescNode transform(TypeReferenceTypeDescNode typeReferenceTypeDescNode) {
        NameReferenceNode typeRef = this.formatNode(typeReferenceTypeDescNode.typeRef(), this.env.trailingWS, this.env.trailingNL);
        return typeReferenceTypeDescNode.modify().withTypeRef(typeRef).apply();
    }

    public DistinctTypeDescriptorNode transform(DistinctTypeDescriptorNode distinctTypeDescriptorNode) {
        Token distinctKeyword = this.formatToken(distinctTypeDescriptorNode.distinctKeyword(), 1, 0);
        TypeDescriptorNode typeDescriptor = this.formatNode(distinctTypeDescriptorNode.typeDescriptor(), this.env.trailingWS, this.env.trailingNL);
        return distinctTypeDescriptorNode.modify().withDistinctKeyword(distinctKeyword).withTypeDescriptor(typeDescriptor).apply();
    }

    public OnConflictClauseNode transform(OnConflictClauseNode onConflictClauseNode) {
        Token onKeyword = this.formatToken(onConflictClauseNode.onKeyword(), 1, 0);
        Token conflictKeyword = this.formatToken(onConflictClauseNode.conflictKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(onConflictClauseNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return onConflictClauseNode.modify().withOnKeyword(onKeyword).withConflictKeyword(conflictKeyword).withExpression(expression).apply();
    }

    public LimitClauseNode transform(LimitClauseNode limitClauseNode) {
        Token limitKeyword = this.formatToken(limitClauseNode.limitKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(limitClauseNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return limitClauseNode.modify().withLimitKeyword(limitKeyword).withExpression(expression).apply();
    }

    public JoinClauseNode transform(JoinClauseNode joinClauseNode) {
        Token outerKeyword = this.formatToken(joinClauseNode.outerKeyword().orElse(null), 1, 0);
        Token joinKeyword = this.formatToken(joinClauseNode.joinKeyword(), 1, 0);
        TypedBindingPatternNode typedBindingPattern = this.formatNode(joinClauseNode.typedBindingPattern(), 1, 0);
        Token inKeyword = this.formatToken(joinClauseNode.inKeyword(), 1, 0);
        ExpressionNode expression = this.formatNode(joinClauseNode.expression(), 1, 0);
        OnClauseNode joinOnCondition = this.formatNode(joinClauseNode.joinOnCondition(), this.env.trailingWS, this.env.trailingNL);
        return joinClauseNode.modify().withOuterKeyword(outerKeyword).withJoinKeyword(joinKeyword).withTypedBindingPattern(typedBindingPattern).withInKeyword(inKeyword).withExpression(expression).withJoinOnCondition(joinOnCondition).apply();
    }

    public OnClauseNode transform(OnClauseNode onClauseNode) {
        Token onKeyword = this.formatToken(onClauseNode.onKeyword(), 1, 0);
        ExpressionNode lhsExpr = this.formatNode(onClauseNode.lhsExpression(), 1, 0);
        Token equalsKeyword = this.formatToken(onClauseNode.equalsKeyword(), 1, 0);
        ExpressionNode rhsExpr = this.formatNode(onClauseNode.rhsExpression(), this.env.trailingWS, this.env.trailingNL);
        return onClauseNode.modify().withOnKeyword(onKeyword).withLhsExpression(lhsExpr).withEqualsKeyword(equalsKeyword).withRhsExpression(rhsExpr).apply();
    }

    public ListMatchPatternNode transform(ListMatchPatternNode listMatchPatternNode) {
        Token openBracket = this.formatToken(listMatchPatternNode.openBracket(), 0, 0);
        SeparatedNodeList matchPatterns = this.formatSeparatedNodeList(listMatchPatternNode.matchPatterns(), 0, 0, 0, 0);
        Token closeBracket = this.formatToken(listMatchPatternNode.closeBracket(), this.env.trailingWS, this.env.trailingNL);
        return listMatchPatternNode.modify().withOpenBracket(openBracket).withMatchPatterns(matchPatterns).withCloseBracket(closeBracket).apply();
    }

    public RestMatchPatternNode transform(RestMatchPatternNode restMatchPatternNode) {
        Token ellipsisToken = this.formatToken(restMatchPatternNode.ellipsisToken(), 0, 0);
        Token varKeywordToken = this.formatToken(restMatchPatternNode.varKeywordToken(), 1, 0);
        SimpleNameReferenceNode variableName = this.formatNode(restMatchPatternNode.variableName(), this.env.trailingWS, this.env.trailingNL);
        return restMatchPatternNode.modify().withEllipsisToken(ellipsisToken).withVarKeywordToken(varKeywordToken).withVariableName(variableName).apply();
    }

    public FieldMatchPatternNode transform(FieldMatchPatternNode fieldMatchPatternNode) {
        IdentifierToken fieldNameNode = this.formatNode(fieldMatchPatternNode.fieldNameNode(), 0, 0);
        Token colonToken = this.formatToken(fieldMatchPatternNode.colonToken(), 1, 0);
        Node matchPattern = this.formatNode(fieldMatchPatternNode.matchPattern(), this.env.trailingWS, this.env.trailingNL);
        return fieldMatchPatternNode.modify().withFieldNameNode(fieldNameNode).withColonToken(colonToken).withMatchPattern(matchPattern).apply();
    }

    public ErrorMatchPatternNode transform(ErrorMatchPatternNode errorMatchPatternNode) {
        boolean hasTypeRef = errorMatchPatternNode.typeReference().isPresent();
        Token errorKeywordToken = this.formatToken(errorMatchPatternNode.errorKeyword(), hasTypeRef ? 1 : 0, 0);
        NameReferenceNode typeRef = this.formatNode(errorMatchPatternNode.typeReference().orElse(null), 0, 0);
        Token openParenthesisToken = this.formatToken(errorMatchPatternNode.openParenthesisToken(), 0, 0);
        SeparatedNodeList argListMatchPatternNode = this.formatSeparatedNodeList(errorMatchPatternNode.argListMatchPatternNode(), 0, 0, 0, 0);
        Token closeParenthesisToken = this.formatToken(errorMatchPatternNode.closeParenthesisToken(), this.env.trailingWS, this.env.trailingNL);
        return errorMatchPatternNode.modify().withErrorKeyword(errorKeywordToken).withTypeReference(typeRef).withOpenParenthesisToken(openParenthesisToken).withArgListMatchPatternNode(argListMatchPatternNode).withCloseParenthesisToken(closeParenthesisToken).apply();
    }

    public NamedArgMatchPatternNode transform(NamedArgMatchPatternNode namedArgMatchPatternNode) {
        IdentifierToken identifier = this.formatToken(namedArgMatchPatternNode.identifier(), 1, 0);
        Token equalToken = this.formatToken(namedArgMatchPatternNode.equalToken(), 1, 0);
        Node matchPattern = this.formatNode(namedArgMatchPatternNode.matchPattern(), this.env.trailingWS, this.env.trailingNL);
        return namedArgMatchPatternNode.modify().withIdentifier(identifier).withEqualToken(equalToken).withMatchPattern(matchPattern).apply();
    }

    public OrderByClauseNode transform(OrderByClauseNode orderByClauseNode) {
        Token orderKeyword = this.formatToken(orderByClauseNode.orderKeyword(), 1, 0);
        Token byKeyword = this.formatToken(orderByClauseNode.byKeyword(), 1, 0);
        SeparatedNodeList orderKey = this.formatSeparatedNodeList(orderByClauseNode.orderKey(), 0, 0, this.env.trailingWS, this.env.trailingNL);
        return orderByClauseNode.modify().withOrderKeyword(orderKeyword).withByKeyword(byKeyword).withOrderKey(orderKey).apply();
    }

    public GroupByClauseNode transform(GroupByClauseNode groupByClauseNode) {
        Token groupKeyword = this.formatToken(groupByClauseNode.groupKeyword(), 1, 0);
        Token byKeyword = this.formatToken(groupByClauseNode.byKeyword(), 1, 0);
        SeparatedNodeList groupingKey = this.formatSeparatedNodeList(groupByClauseNode.groupingKey(), 0, 0, this.env.trailingWS, this.env.trailingNL);
        return groupByClauseNode.modify().withGroupKeyword(groupKeyword).withByKeyword(byKeyword).withGroupingKey(groupingKey).apply();
    }

    public GroupingKeyVarDeclarationNode transform(GroupingKeyVarDeclarationNode groupingKeyVarDeclarationNode) {
        TypeDescriptorNode typeDescriptor = this.formatNode(groupingKeyVarDeclarationNode.typeDescriptor(), 1, 0);
        BindingPatternNode simpleBP = this.formatNode(groupingKeyVarDeclarationNode.simpleBindingPattern(), 1, 0);
        Token equalsToken = this.formatToken(groupingKeyVarDeclarationNode.equalsToken(), 1, 0);
        ExpressionNode expression = this.formatNode(groupingKeyVarDeclarationNode.expression(), this.env.trailingWS, this.env.trailingNL);
        return groupingKeyVarDeclarationNode.modify().withTypeDescriptor(typeDescriptor).withSimpleBindingPattern(simpleBP).withEqualsToken(equalsToken).withExpression(expression).apply();
    }

    public OrderKeyNode transform(OrderKeyNode orderKeyNode) {
        ExpressionNode expression = orderKeyNode.orderDirection().isPresent() ? this.formatNode(orderKeyNode.expression(), 1, 0) : this.formatNode(orderKeyNode.expression(), this.env.trailingWS, this.env.trailingNL);
        Token orderDirection = this.formatToken(orderKeyNode.orderDirection().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return orderKeyNode.modify().withExpression(expression).withOrderDirection(orderDirection).apply();
    }

    public ClassDefinitionNode transform(ClassDefinitionNode classDefinitionNode) {
        MetadataNode metadata = this.formatNode(classDefinitionNode.metadata().orElse(null), 0, 1);
        Token visibilityQualifier = this.formatToken(classDefinitionNode.visibilityQualifier().orElse(null), 1, 0);
        NodeList classTypeQualifiers = this.formatNodeList(classDefinitionNode.classTypeQualifiers(), 1, 0, 1, 0);
        Token classKeyword = this.formatToken(classDefinitionNode.classKeyword(), 1, 0);
        int trailingNL = this.options.braceFormattingOptions().classBraceStyle() == BraceStyle.NewLine ? 1 : 0;
        Token className = this.formatToken(classDefinitionNode.className(), this.invert(trailingNL), trailingNL);
        Token openBrace = this.formatToken(classDefinitionNode.openBrace(), 0, 1);
        this.indent();
        NodeList members = this.formatMemberDeclarations(classDefinitionNode.members(), n -> this.isClassOrServiceMultiLineMember((Node)n));
        this.unindent();
        Optional optSemicolon = classDefinitionNode.semicolonToken();
        Token closeBrace = optSemicolon.isPresent() ? this.formatToken(classDefinitionNode.closeBrace(), 0, 0) : this.formatToken(classDefinitionNode.closeBrace(), this.env.trailingWS, this.env.trailingNL);
        Token semicolon = this.formatToken(optSemicolon.orElse(null), this.env.trailingWS, this.env.trailingNL);
        return classDefinitionNode.modify().withMetadata(metadata).withVisibilityQualifier(visibilityQualifier).withClassTypeQualifiers(classTypeQualifiers).withClassKeyword(classKeyword).withClassName(className).withOpenBrace(openBrace).withMembers(members).withCloseBrace(closeBrace).withSemicolonToken(semicolon).apply();
    }

    public BreakStatementNode transform(BreakStatementNode breakStatementNode) {
        Token breakToken = this.formatToken(breakStatementNode.breakToken(), 0, 0);
        Token semicolonToken = this.formatToken(breakStatementNode.semicolonToken(), this.env.trailingWS, this.env.trailingNL);
        return breakStatementNode.modify().withBreakToken(breakToken).withSemicolonToken(semicolonToken).apply();
    }

    public NamedWorkerDeclarationNode transform(NamedWorkerDeclarationNode namedWorkerDeclarationNode) {
        OnFailClauseNode onFailClause;
        BlockStatementNode workerBody;
        NodeList annotations = this.formatNodeList(namedWorkerDeclarationNode.annotations(), 0, 1, 0, 1);
        Token transactionalKeyword = this.formatToken(namedWorkerDeclarationNode.transactionalKeyword().orElse(null), 1, 0);
        Token workerKeyword = this.formatToken(namedWorkerDeclarationNode.workerKeyword(), 1, 0);
        IdentifierToken workerName = this.formatToken(namedWorkerDeclarationNode.workerName(), 1, 0);
        Node returnTypeDesc = this.formatNode(namedWorkerDeclarationNode.returnTypeDesc().orElse(null), 1, 0);
        Optional onFailClauseNode = namedWorkerDeclarationNode.onFailClause();
        if (onFailClauseNode.isPresent()) {
            workerBody = this.formatNode(namedWorkerDeclarationNode.workerBody(), 1, 0);
            onFailClause = this.formatNode((OnFailClauseNode)onFailClauseNode.get(), this.env.trailingWS, this.env.trailingNL);
        } else {
            workerBody = this.formatNode(namedWorkerDeclarationNode.workerBody(), this.env.trailingWS, this.env.trailingNL);
            onFailClause = null;
        }
        return namedWorkerDeclarationNode.modify().withAnnotations(annotations).withTransactionalKeyword(transactionalKeyword).withWorkerKeyword(workerKeyword).withWorkerName(workerName).withReturnTypeDesc(returnTypeDesc).withWorkerBody(workerBody).withOnFailClause(onFailClause).apply();
    }

    public NamedWorkerDeclarator transform(NamedWorkerDeclarator namedWorkerDeclarator) {
        NodeList workerInitStatements = this.formatNodeList(namedWorkerDeclarator.workerInitStatements(), 0, 1, 0, 1);
        NodeList namedWorkerDeclarations = this.formatNodeList(namedWorkerDeclarator.namedWorkerDeclarations(), 0, 1, 0, 1);
        return namedWorkerDeclarator.modify().withWorkerInitStatements(workerInitStatements).withNamedWorkerDeclarations(namedWorkerDeclarations).apply();
    }

    public ArrayTypeDescriptorNode transform(ArrayTypeDescriptorNode arrayTypeDescriptorNode) {
        TypeDescriptorNode memberTypeDesc = this.formatNode(arrayTypeDescriptorNode.memberTypeDesc(), 0, 0);
        NodeList dimensions = this.formatNodeList(arrayTypeDescriptorNode.dimensions(), 0, 0, this.env.trailingWS, this.env.trailingNL);
        return arrayTypeDescriptorNode.modify().withMemberTypeDesc(memberTypeDesc).withDimensions(dimensions).apply();
    }

    public ArrayDimensionNode transform(ArrayDimensionNode arrayDimensionNode) {
        Token openBracket = this.formatToken(arrayDimensionNode.openBracket(), 0, 0);
        Node arrayLength = this.formatNode(arrayDimensionNode.arrayLength().orElse(null), 0, 0);
        Token closeBracket = this.formatToken(arrayDimensionNode.closeBracket(), this.env.trailingWS, this.env.trailingNL);
        return arrayDimensionNode.modify().withOpenBracket(openBracket).withArrayLength(arrayLength).withCloseBracket(closeBracket).apply();
    }

    public XMLElementNode transform(XMLElementNode xMLElementNode) {
        XMLStartTagNode startTagNode = this.formatNode(xMLElementNode.startTag(), 0, 0);
        NodeList content = this.formatNodeList(xMLElementNode.content(), 0, 0, 0, 0);
        XMLEndTagNode endTagNode = this.formatNode(xMLElementNode.endTag(), this.env.trailingWS, this.env.trailingNL);
        return xMLElementNode.modify().withStartTag(startTagNode).withContent(content).withEndTag(endTagNode).apply();
    }

    public XMLStartTagNode transform(XMLStartTagNode xMLStartTagNode) {
        Token ltToken = this.formatToken(xMLStartTagNode.ltToken(), 0, 0);
        int nameTrailingWS = xMLStartTagNode.attributes().isEmpty() ? 0 : 1;
        XMLNameNode name = this.formatNode(xMLStartTagNode.name(), nameTrailingWS, 0);
        NodeList attributes = this.formatNodeList(xMLStartTagNode.attributes(), 1, 0, 0, 0);
        Token getToken = this.formatToken(xMLStartTagNode.getToken(), this.env.trailingWS, this.env.trailingNL);
        return xMLStartTagNode.modify().withLtToken(ltToken).withName(name).withAttributes(attributes).withGetToken(getToken).apply();
    }

    public XMLEndTagNode transform(XMLEndTagNode xMLEndTagNode) {
        Token ltToken = this.formatToken(xMLEndTagNode.ltToken(), 0, 0);
        Token slashToken = this.formatToken(xMLEndTagNode.slashToken(), 0, 0);
        XMLNameNode name = this.formatNode(xMLEndTagNode.name(), 0, 0);
        Token getToken = this.formatToken(xMLEndTagNode.getToken(), this.env.trailingWS, this.env.trailingNL);
        return xMLEndTagNode.modify().withLtToken(ltToken).withSlashToken(slashToken).withName(name).withGetToken(getToken).apply();
    }

    public XMLAttributeNode transform(XMLAttributeNode xMLAttributeNode) {
        XMLNameNode attributeName = this.formatNode(xMLAttributeNode.attributeName(), 0, 0);
        Token equalToken = this.formatToken(xMLAttributeNode.equalToken(), 0, 0);
        XMLAttributeValue value = this.formatNode(xMLAttributeNode.value(), this.env.trailingWS, this.env.trailingNL);
        return xMLAttributeNode.modify().withAttributeName(attributeName).withEqualToken(equalToken).withValue(value).apply();
    }

    public XMLAttributeValue transform(XMLAttributeValue xMLAttributeValue) {
        Token startQuote = this.formatToken(xMLAttributeValue.startQuote(), 0, 0);
        NodeList value = this.formatNodeList(xMLAttributeValue.value(), 0, 0, 0, 0);
        Token endQuote = this.formatToken(xMLAttributeValue.endQuote(), this.env.trailingWS, this.env.trailingNL);
        return xMLAttributeValue.modify().withStartQuote(startQuote).withValue(value).withEndQuote(endQuote).apply();
    }

    public ClientResourceAccessActionNode transform(ClientResourceAccessActionNode clientResourceAccessActionNode) {
        ExpressionNode expressionNode = this.formatNode(clientResourceAccessActionNode.expression(), 0, 0);
        Token rightArrowToken = this.formatNode(clientResourceAccessActionNode.rightArrowToken(), 0, 0);
        Token slashToken = clientResourceAccessActionNode.resourceAccessPath().isEmpty() && clientResourceAccessActionNode.methodName().isEmpty() && clientResourceAccessActionNode.arguments().isEmpty() ? this.formatNode(clientResourceAccessActionNode.slashToken(), this.env.trailingWS, this.env.trailingNL) : this.formatNode(clientResourceAccessActionNode.slashToken(), 0, 0);
        SeparatedNodeList resourceAccessPath = clientResourceAccessActionNode.methodName().isEmpty() && clientResourceAccessActionNode.arguments().isEmpty() ? this.formatSeparatedNodeList(clientResourceAccessActionNode.resourceAccessPath(), 0, 0, 0, 0, this.env.trailingWS, this.env.trailingNL) : this.formatSeparatedNodeList(clientResourceAccessActionNode.resourceAccessPath(), 0, 0, 0, 0, 0, 0);
        SimpleNameReferenceNode methodName = clientResourceAccessActionNode.arguments().isEmpty() ? this.formatNode(clientResourceAccessActionNode.methodName().orElse(null), this.env.trailingWS, this.env.trailingNL) : this.formatNode(clientResourceAccessActionNode.methodName().orElse(null), 0, 0);
        Token dotToken = this.formatToken(clientResourceAccessActionNode.dotToken().orElse(null), 0, 0);
        ParenthesizedArgList argumentNode = this.formatNode(clientResourceAccessActionNode.arguments().orElse(null), this.env.trailingWS, this.env.trailingNL);
        return clientResourceAccessActionNode.modify().withExpression(expressionNode).withRightArrowToken(rightArrowToken).withSlashToken(slashToken).withResourceAccessPath(resourceAccessPath).withDotToken(dotToken).withMethodName(methodName).withArguments(argumentNode).apply();
    }

    public ComputedResourceAccessSegmentNode transform(ComputedResourceAccessSegmentNode computedResourceAccessSegmentNode) {
        Token openBracket = this.formatToken(computedResourceAccessSegmentNode.openBracketToken(), 0, 0);
        ExpressionNode expressionNode = this.formatNode(computedResourceAccessSegmentNode.expression(), 0, 0);
        Token closeBracket = this.formatToken(computedResourceAccessSegmentNode.closeBracketToken(), this.env.trailingWS, this.env.trailingNL);
        return computedResourceAccessSegmentNode.modify().withOpenBracketToken(openBracket).withExpression(expressionNode).withCloseBracketToken(closeBracket).apply();
    }

    public ResourceAccessRestSegmentNode transform(ResourceAccessRestSegmentNode resourceAccessRestSegmentNode) {
        Token openBracket = this.formatToken(resourceAccessRestSegmentNode.openBracketToken(), 0, 0);
        Token ellipsis = this.formatToken(resourceAccessRestSegmentNode.ellipsisToken(), 0, 0);
        ExpressionNode expressionNode = this.formatNode(resourceAccessRestSegmentNode.expression(), 0, 0);
        Token closeBracket = this.formatToken(resourceAccessRestSegmentNode.closeBracketToken(), this.env.trailingWS, this.env.trailingNL);
        return resourceAccessRestSegmentNode.modify().withOpenBracketToken(openBracket).withEllipsisToken(ellipsis).withExpression(expressionNode).withCloseBracketToken(closeBracket).apply();
    }

    public NaturalExpressionNode transform(NaturalExpressionNode naturalExpressionNode) {
        String afterNewline;
        String lastPromptString;
        int lastNewline;
        Token constKeyword = this.formatToken(naturalExpressionNode.constKeyword().orElse(null), 1, 0);
        Token naturalKeyword = this.formatToken(naturalExpressionNode.naturalKeyword(), 1, 0);
        ParenthesizedArgList parenthesizedArgList = this.formatNode(naturalExpressionNode.parenthesizedArgList().orElse(null), 1, 0);
        Token openBrace = this.formatToken(naturalExpressionNode.openBraceToken(), 0, 1);
        NodeList prompt = naturalExpressionNode.prompt();
        Node lastPromptContent = prompt.get(prompt.size() - 1);
        int promptTrailingNL = 1;
        if (lastPromptContent.kind() == SyntaxKind.PROMPT_CONTENT && (lastNewline = (lastPromptString = ((LiteralValueToken)lastPromptContent).text()).lastIndexOf(10)) != -1 && (afterNewline = lastPromptString.substring(lastNewline + 1)).matches("\\s*")) {
            promptTrailingNL = 0;
        }
        boolean preserveIndentation = this.env.preserveIndentation;
        this.env.preserveIndentation = true;
        prompt = this.formatNodeList(naturalExpressionNode.prompt(), 0, 0, 0, promptTrailingNL);
        this.env.hasNewline = preserveIndentation;
        Token closeBrace = this.formatToken(naturalExpressionNode.closeBraceToken(), this.env.trailingWS, this.env.trailingNL);
        return naturalExpressionNode.modify().withConstKeyword(constKeyword).withNaturalKeyword(naturalKeyword).withParenthesizedArgList(parenthesizedArgList).withOpenBraceToken(openBrace).withPrompt(prompt).withCloseBraceToken(closeBrace).apply();
    }

    public IdentifierToken transform(IdentifierToken identifier) {
        return this.formatToken(identifier, this.env.trailingWS, this.env.trailingNL);
    }

    public Token transform(Token token) {
        return this.formatToken(token, this.env.trailingWS, this.env.trailingNL);
    }

    private <T extends Node> T formatNode(T node, int trailingWS, int trailingNL, Boolean preserveIndentation) {
        try {
            if (node == null) {
                return null;
            }
            if (!FormatterUtils.isInlineRange(node, this.lineRange)) {
                this.checkForNewline(node);
                return node;
            }
            int prevTrailingNL = this.env.trailingNL;
            int prevTrailingWS = this.env.trailingWS;
            this.env.trailingNL = trailingNL;
            this.env.trailingWS = trailingWS;
            if (preserveIndentation != null) {
                this.env.preserveIndentation = preserveIndentation;
            }
            T oldNode = node;
            NonTerminalNode parent = node.parent();
            node = (Node)node.apply((NodeTransformer)this);
            if (this.options.wrappingFormattingOptions().lineWrap() && this.shouldWrapLine(oldNode, (Node)parent)) {
                node = this.wrapLine(oldNode, (Node)parent);
            }
            this.env.trailingNL = prevTrailingNL;
            this.env.trailingWS = prevTrailingWS;
        }
        catch (Exception e) {
            this.checkForNewline(node);
            LOGGER.error(String.format("Error while formatting [kind: %s] [line: %s] [column:%s]: %s", node.kind().name(), node.lineRange().startLine().line() + 1, node.lineRange().startLine().offset(), e));
        }
        return node;
    }

    private <T extends Node> T formatNode(T node, int trailingWS, int trailingNL) {
        return this.formatNode(node, trailingWS, trailingNL, null);
    }

    private <T extends Token> T formatToken(T token, int trailingWS, int trailingNL, Boolean preserveIndentation) {
        try {
            if (token == null) {
                return null;
            }
            if (!FormatterUtils.isInlineRange(token, this.lineRange)) {
                this.checkForNewline(token);
                return token;
            }
            int prevTrailingNL = this.env.trailingNL;
            int prevTrailingWS = this.env.trailingWS;
            this.env.trailingNL = trailingNL > 0 ? 1 : 0;
            this.env.trailingWS = trailingWS;
            if (preserveIndentation != null) {
                this.env.preserveIndentation = preserveIndentation;
            }
            token = this.formatTokenInternal(token);
            this.env.leadingNL = trailingNL > 0 ? trailingNL - 1 : 0;
            this.env.hasNewline = trailingNL > 0 || this.hasTrailingNL(token);
            this.env.trailingNL = prevTrailingNL;
            this.env.trailingWS = prevTrailingWS;
            this.env.prevTokensTrailingWS = trailingWS;
        }
        catch (Exception e) {
            this.checkForNewline(token);
            LOGGER.error(String.format("Error while formatting [kind: %s] [line: %s] [column:%s]: %s", token.kind().name(), token.lineRange().startLine().line() + 1, token.lineRange().startLine().offset(), e));
        }
        return token;
    }

    private <T extends Token> T formatToken(T token, int trailingWS, int trailingNL) {
        return this.formatToken(token, trailingWS, trailingNL, null);
    }

    protected <T extends Node> NodeList<T> formatMemberDeclarations(NodeList<T> members, Predicate<Node> filter) {
        if (members.isEmpty()) {
            return members;
        }
        boolean nodeModified = false;
        int size = members.size();
        if (this.options.spacingFormattingOptions().alignConsecutiveDefinitions()) {
            this.env.maxConstDefWidth = members.stream().filter(member -> member.kind() == SyntaxKind.CONST_DECLARATION).mapToInt(member -> FormatterUtils.getConstDefWidth((ConstantDeclarationNode)member)).max().orElse(1);
        }
        Node[] newNodes = new Node[size];
        for (int index = 0; index < size; ++index) {
            Node newMember;
            Node currentMember = members.get(index);
            Node nextMember = null;
            if (index < size - 1) {
                nextMember = members.get(index + 1);
            }
            int itemTrailingNL = 1;
            if (filter.test(currentMember) || filter.test(nextMember)) {
                ++itemTrailingNL;
            }
            if (currentMember != (newMember = this.formatListItem(0, itemTrailingNL, 0, 1, size, index, currentMember))) {
                nodeModified = true;
            }
            newNodes[index] = newMember;
        }
        if (!nodeModified) {
            return members;
        }
        return NodeFactory.createNodeList((Node[])newNodes);
    }

    private <T extends Node> boolean isMultilineModuleMember(T node) {
        if (node == null) {
            return false;
        }
        return switch (node.kind()) {
            case SyntaxKind.FUNCTION_DEFINITION, SyntaxKind.CLASS_DEFINITION, SyntaxKind.SERVICE_DECLARATION, SyntaxKind.TYPE_DEFINITION, SyntaxKind.ENUM_DECLARATION, SyntaxKind.ANNOTATION_DECLARATION -> true;
            default -> false;
        };
    }

    private boolean isClassOrServiceMultiLineMember(Node node) {
        if (node == null) {
            return false;
        }
        return switch (node.kind()) {
            case SyntaxKind.OBJECT_METHOD_DEFINITION, SyntaxKind.RESOURCE_ACCESSOR_DEFINITION -> true;
            default -> false;
        };
    }

    protected <T extends Node> NodeList<T> formatNodeList(NodeList<T> nodeList, int itemTrailingWS, int itemTrailingNL, int listTrailingWS, int listTrailingNL) {
        if (nodeList.isEmpty()) {
            return nodeList;
        }
        boolean nodeModified = false;
        int size = nodeList.size();
        Node[] newNodes = new Node[size];
        for (int index = 0; index < size; ++index) {
            Node newNode;
            Node oldNode = nodeList.get(index);
            if (oldNode != (newNode = this.formatListItem(itemTrailingWS, itemTrailingNL, listTrailingWS, listTrailingNL, size, index, oldNode))) {
                nodeModified = true;
            }
            newNodes[index] = newNode;
        }
        if (!nodeModified) {
            return nodeList;
        }
        return NodeFactory.createNodeList((Node[])newNodes);
    }

    private <T extends Node> T formatListItem(int itemTrailingWS, int itemTrailingNL, int listTrailingWS, int listTrailingNL, int size, int index, T oldNode) {
        T newNode = index == size - 1 ? this.formatNode(oldNode, listTrailingWS, listTrailingNL) : this.formatNode(oldNode, itemTrailingWS, itemTrailingNL);
        return newNode;
    }

    protected <T extends Node> SeparatedNodeList<T> formatSeparatedNodeList(SeparatedNodeList<T> nodeList, int itemTrailingWS, int itemTrailingNL, int listTrailingWS, int listTrailingNL) {
        return this.formatSeparatedNodeList(nodeList, itemTrailingWS, itemTrailingNL, 1, 0, listTrailingWS, listTrailingNL);
    }

    protected <T extends Node> SeparatedNodeList<T> formatSeparatedNodeList(SeparatedNodeList<T> nodeList, int itemTrailingWS, int itemTrailingNL, int listTrailingWS, int listTrailingNL, boolean allowMultiLineParams) {
        return this.formatSeparatedNodeList(nodeList, itemTrailingWS, itemTrailingNL, 1, 0, listTrailingWS, listTrailingNL, allowMultiLineParams);
    }

    protected <T extends Node> SeparatedNodeList<T> formatSeparatedNodeList(SeparatedNodeList<T> nodeList, int itemTrailingWS, int itemTrailingNL, int separatorTrailingWS, int separatorTrailingNL, int listTrailingWS, int listTrailingNL) {
        return this.formatSeparatedNodeList(nodeList, itemTrailingWS, itemTrailingNL, separatorTrailingWS, separatorTrailingNL, listTrailingWS, listTrailingNL, false);
    }

    protected <T extends Node> SeparatedNodeList<T> formatSeparatedNodeList(SeparatedNodeList<T> nodeList, int itemTrailingWS, int itemTrailingNL, int separatorTrailingWS, int separatorTrailingNL, int listTrailingWS, int listTrailingNL, boolean allowInAndMultiLine) {
        if (nodeList.isEmpty()) {
            return nodeList;
        }
        boolean nodeModified = false;
        int size = nodeList.size();
        Node[] newNodes = new Node[size * 2 - 1];
        int prevSeparatorTrailingNL = separatorTrailingNL;
        int prevSeparatorTrailingWS = separatorTrailingWS;
        for (int index = 0; index < size; ++index) {
            Node newNode;
            Node oldNode = nodeList.get(index);
            newNodes[2 * index] = newNode = this.formatListItem(itemTrailingWS, itemTrailingNL, listTrailingWS, listTrailingNL, size, index, oldNode);
            if (oldNode != newNode) {
                nodeModified = true;
            }
            if (index == nodeList.size() - 1) break;
            Token oldSeparator = nodeList.getSeparator(index);
            separatorTrailingNL = prevSeparatorTrailingNL;
            separatorTrailingWS = prevSeparatorTrailingWS;
            if (allowInAndMultiLine && this.hasNonWSMinutiae(oldSeparator.trailingMinutiae())) {
                prevSeparatorTrailingNL = separatorTrailingNL;
                prevSeparatorTrailingWS = separatorTrailingWS;
                separatorTrailingNL = separatorTrailingNL > 0 ? separatorTrailingNL : 1;
                separatorTrailingWS = 0;
            }
            Token newSeparator = this.formatToken(oldSeparator, separatorTrailingWS, separatorTrailingNL);
            newNodes[2 * index + 1] = newSeparator;
            if (oldSeparator == newSeparator) continue;
            nodeModified = true;
        }
        if (!nodeModified) {
            return nodeList;
        }
        return NodeFactory.createSeparatedNodeList((Node[])newNodes);
    }

    private <T extends Token> T formatTokenInternal(T token) {
        MinutiaeList newLeadingMinutiaeList = this.getLeadingMinutiae(token);
        this.env.lineLength += token.text().length();
        MinutiaeList newTrailingMinutiaeList = this.getTrailingMinutiae(token);
        if (token.isMissing()) {
            return (T)NodeFactory.createMissingToken((SyntaxKind)token.kind(), (MinutiaeList)newLeadingMinutiaeList, (MinutiaeList)newTrailingMinutiaeList);
        }
        return (T)token.modify(newLeadingMinutiaeList, newTrailingMinutiaeList);
    }

    private <T extends Node> void checkForNewline(T node) {
        this.env.hasNewline = false;
        for (Minutiae minutiae : node.trailingMinutiae()) {
            if (minutiae.kind() != SyntaxKind.END_OF_LINE_MINUTIAE) continue;
            this.env.hasNewline = true;
            break;
        }
        this.env.lineLength = this.env.hasNewline ? 0 : node.location().lineRange().endLine().offset();
    }

    private boolean shouldWrapLine(Node node, Node parent) {
        boolean descendantNeedWrapping;
        boolean exceedsColumnLimit = this.env.lineLength > this.options.wrappingFormattingOptions().maxLineLength();
        boolean bl = descendantNeedWrapping = this.env.nodeToWrap == node;
        if (!exceedsColumnLimit && !descendantNeedWrapping) {
            return false;
        }
        SyntaxKind kind = node.kind();
        switch (kind) {
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: {
                if (node.parent().kind() == SyntaxKind.ANNOTATION) break;
                return true;
            }
            case DEFAULTABLE_PARAM: 
            case REQUIRED_PARAM: 
            case REST_PARAM: 
            case RETURN_TYPE_DESCRIPTOR: {
                return this.options.functionDefFormattingOptions().parametersWrap() != WrappingMethod.NoWrap;
            }
            case POSITIONAL_ARG: 
            case NAMED_ARG: 
            case REST_ARG: {
                return this.options.functionCallFormattingOptions().argumentsWrap() != WrappingMethod.NoWrap;
            }
            case ANNOTATION_ATTACH_POINT: {
                return true;
            }
            case XML_TEMPLATE_EXPRESSION: 
            case STRING_TEMPLATE_EXPRESSION: 
            case TEMPLATE_STRING: {
                break;
            }
            default: {
                if (SyntaxKind.BINARY_EXPRESSION.compareTo((Enum)kind) > 0 || SyntaxKind.OBJECT_CONSTRUCTOR.compareTo((Enum)kind) < 0) break;
                return true;
            }
        }
        this.env.nodeToWrap = parent;
        return false;
    }

    private <T extends Node> T wrapLine(T node, Node parent) {
        ++this.env.leadingNL;
        this.env.lineLength = 0;
        this.env.hasNewline = true;
        node = (Node)node.apply((NodeTransformer)this);
        this.env.nodeToWrap = this.env.lineLength > this.options.wrappingFormattingOptions().maxLineLength() ? parent : null;
        return node;
    }

    private MinutiaeList getLeadingMinutiae(Token token) {
        ArrayList<Minutiae> leadingMinutiae = new ArrayList<Minutiae>();
        int consecutiveNewlines = 0;
        Minutiae prevMinutiae = null;
        if (this.env.hasNewline) {
            ++consecutiveNewlines;
            if (!token.isMissing()) {
                for (int i = 0; i < this.env.leadingNL; ++i) {
                    prevMinutiae = this.getNewline();
                    leadingMinutiae.add(prevMinutiae);
                    ++consecutiveNewlines;
                }
            }
        }
        block6: for (Minutiae minutiae : token.leadingMinutiae()) {
            switch (minutiae.kind()) {
                case END_OF_LINE_MINUTIAE: {
                    if (consecutiveNewlines > 1 || !this.env.hasPreservedNewline) continue block6;
                    ++consecutiveNewlines;
                    leadingMinutiae.add(this.getNewline());
                    break;
                }
                case WHITESPACE_MINUTIAE: {
                    if (!this.shouldAddWS(prevMinutiae) && !this.env.preserveIndentation) continue block6;
                    if (this.env.preserveIndentation && (prevMinutiae == null || prevMinutiae.kind() == SyntaxKind.END_OF_LINE_MINUTIAE)) {
                        this.addWhitespace(this.getPreservedIndentation(token), leadingMinutiae);
                        break;
                    }
                    this.addWhitespace(1, leadingMinutiae);
                    break;
                }
                case COMMENT_MINUTIAE: {
                    if (consecutiveNewlines == 0) {
                        leadingMinutiae.add(this.getNewline());
                    }
                    if (!this.env.preserveIndentation) {
                        int indentation = this.env.currentIndentation;
                        if (this.isClosingTypeToken(token)) {
                            indentation += this.options.indentFormattingOptions().indentSize();
                        }
                        this.addWhitespace(indentation, leadingMinutiae);
                    }
                    leadingMinutiae.add(minutiae);
                    consecutiveNewlines = 0;
                    break;
                }
                default: {
                    consecutiveNewlines = 0;
                    leadingMinutiae.add(minutiae);
                }
            }
            prevMinutiae = minutiae;
        }
        if (consecutiveNewlines > 0 && !this.env.preserveIndentation) {
            this.addWhitespace(this.env.currentIndentation, leadingMinutiae);
        }
        if (!leadingMinutiae.isEmpty() && ((Minutiae)leadingMinutiae.get(leadingMinutiae.size() - 1)).kind().equals((Object)SyntaxKind.COMMENT_MINUTIAE)) {
            leadingMinutiae.add(this.getNewline());
        }
        MinutiaeList newLeadingMinutiaeList = NodeFactory.createMinutiaeList(leadingMinutiae);
        this.preserveIndentation(false);
        return newLeadingMinutiaeList;
    }

    private void addWhitespace(int wsLength, List<Minutiae> minutiaeList) {
        if (wsLength <= 0) {
            return;
        }
        String wsContent = this.getWSContent(wsLength);
        minutiaeList.add(NodeFactory.createWhitespaceMinutiae((String)wsContent));
    }

    private boolean shouldAddWS(Minutiae prevMinutiae) {
        if (prevMinutiae == null) {
            return false;
        }
        return prevMinutiae.kind() == SyntaxKind.INVALID_TOKEN_MINUTIAE_NODE || prevMinutiae.kind() == SyntaxKind.INVALID_NODE_MINUTIAE;
    }

    private MinutiaeList getTrailingMinutiae(Token token) {
        ArrayList<Minutiae> trailingMinutiae = new ArrayList<Minutiae>();
        Minutiae prevMinutiae = null;
        if (this.env.trailingWS > 0 && (!token.isMissing() || this.env.prevTokensTrailingWS <= 0 && this.env.prevTokensTrailingNL <= 0)) {
            this.addWhitespace(this.env.trailingWS, trailingMinutiae);
        }
        int consecutiveNewlines = 0;
        int size = token.trailingMinutiae().size();
        block5: for (int i = 0; i < size; ++i) {
            Minutiae minutiae = token.trailingMinutiae().get(i);
            switch (minutiae.kind()) {
                case END_OF_LINE_MINUTIAE: {
                    this.preserveIndentation(true);
                    this.removeTrailingWS(trailingMinutiae);
                    trailingMinutiae.add(this.getNewline());
                    ++consecutiveNewlines;
                    break;
                }
                case WHITESPACE_MINUTIAE: {
                    if (!this.shouldAddWS(prevMinutiae)) continue block5;
                    if (i == size - 1) {
                        this.addWhitespace(this.env.trailingWS, trailingMinutiae);
                        break;
                    }
                    this.addWhitespace(1, trailingMinutiae);
                    break;
                }
                case COMMENT_MINUTIAE: {
                    if (!this.matchesMinutiaeKind(prevMinutiae, SyntaxKind.WHITESPACE_MINUTIAE)) {
                        this.addWhitespace(1, trailingMinutiae);
                    }
                    trailingMinutiae.add(minutiae);
                    consecutiveNewlines = 0;
                    break;
                }
                default: {
                    if (this.matchesMinutiaeKind(prevMinutiae, SyntaxKind.END_OF_LINE_MINUTIAE)) {
                        this.addWhitespace(this.env.currentIndentation, trailingMinutiae);
                    }
                    trailingMinutiae.add(minutiae);
                    consecutiveNewlines = 0;
                }
            }
            prevMinutiae = minutiae;
        }
        if (consecutiveNewlines == 0 && this.env.trailingNL > 0 && !token.isMissing() && this.env.hasPreservedNewline) {
            trailingMinutiae.add(this.getNewline());
        }
        this.env.prevTokensTrailingNL = consecutiveNewlines;
        MinutiaeList newTrailingMinutiaeList = NodeFactory.createMinutiaeList(trailingMinutiae);
        return newTrailingMinutiaeList;
    }

    private Minutiae getNewline() {
        this.env.lineLength = 0;
        return NodeFactory.createEndOfLineMinutiae((String)FormatterUtils.NEWLINE_SYMBOL);
    }

    private List<Minutiae> removeTrailingWS(List<Minutiae> trailingMinutiae) {
        int minutiaeCount = trailingMinutiae.size();
        for (int i = minutiaeCount - 1; i > -1; --i) {
            if (trailingMinutiae.get(i).kind() != SyntaxKind.WHITESPACE_MINUTIAE) {
                return trailingMinutiae;
            }
            trailingMinutiae.remove(i);
        }
        return trailingMinutiae;
    }

    private void indent() {
        this.indent(this.options.indentFormattingOptions().indentSize());
    }

    private void indent(int step) {
        this.env.currentIndentation += step;
    }

    private void align() {
        this.env.preservedIndentation = this.env.currentIndentation;
        this.env.currentIndentation = this.env.lineLength;
    }

    private void unindent() {
        this.unindent(this.options.indentFormattingOptions().indentSize());
    }

    private void unindent(int step) {
        if (this.env.currentIndentation < step) {
            this.env.currentIndentation = 0;
            return;
        }
        this.env.currentIndentation -= step;
    }

    private void unalign() {
        this.env.currentIndentation = this.env.preservedIndentation;
    }

    private void alignOrIndent(boolean shouldAlign) {
        if (shouldAlign) {
            this.align();
        } else {
            this.indent();
        }
    }

    private void alignOrIndent(boolean shouldAlign, int step) {
        if (shouldAlign) {
            this.align();
        } else {
            this.indent(step);
        }
    }

    private void unalignOrUnindent(boolean shouldAlign) {
        if (shouldAlign) {
            this.unalign();
        } else {
            this.unindent();
        }
    }

    private void unalignOrUnindent(boolean shouldAlign, int step) {
        if (shouldAlign) {
            this.unalign();
        } else {
            this.unindent(step);
        }
    }

    private void setIndentation(int value) {
        this.env.currentIndentation = value;
    }

    private void preserveIndentation(boolean value) {
        if (value) {
            if (this.env.trailingNL < 1) {
                this.env.preserveIndentation = true;
            }
        } else {
            this.env.preserveIndentation = false;
        }
    }

    private int getPreservedIndentation(Token token) {
        int tabSize;
        LinePosition startLinePos = token.lineRange().startLine();
        int position = startLinePos.offset();
        int startLine = startLinePos.line();
        for (Token invalidToken : token.leadingInvalidTokens()) {
            LinePosition invalidTokenStartLinePos = invalidToken.lineRange().startLine();
            if (invalidTokenStartLinePos.line() != startLine) continue;
            position = invalidTokenStartLinePos.offset();
            break;
        }
        if (this.env.currentIndentation % (tabSize = this.options.indentFormattingOptions().indentSize()) == 0 && this.env.currentIndentation > position) {
            return this.env.currentIndentation;
        }
        int offset = position % tabSize;
        if (offset != 0) {
            return offset > 2 ? position + tabSize - offset : position - offset;
        }
        return position;
    }

    private void setPreserveNewline(boolean value) {
        this.env.hasPreservedNewline = value;
    }

    private void setInlineAnnotation(boolean value) {
        this.env.inlineAnnotation = value;
    }

    private String getWSContent(int count) {
        this.env.lineLength += count;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(this.options.indentFormattingOptions().wsCharacter());
        }
        return sb.toString();
    }

    private boolean shouldExpand(Node node) {
        switch (node.kind()) {
            case OBJECT_TYPE_DESC: {
                ObjectTypeDescriptorNode objectTypeDesc = (ObjectTypeDescriptorNode)node;
                if (objectTypeDesc.parent().kind() == SyntaxKind.TYPE_DEFINITION) {
                    return true;
                }
                if (this.hasNonWSMinutiae(objectTypeDesc.openBrace().trailingMinutiae()) || this.hasNonWSMinutiae(objectTypeDesc.closeBrace().leadingMinutiae())) {
                    return true;
                }
                NodeList objectTypeDescMembers = objectTypeDesc.members();
                return this.shouldExpandObjectMembers((NodeList<Node>)objectTypeDescMembers);
            }
            case OBJECT_CONSTRUCTOR: {
                ObjectConstructorExpressionNode objectConstructor = (ObjectConstructorExpressionNode)node;
                if (this.hasNonWSMinutiae(objectConstructor.openBraceToken().trailingMinutiae()) || this.hasNonWSMinutiae(objectConstructor.closeBraceToken().leadingMinutiae())) {
                    return true;
                }
                NodeList objectConstructorMembers = objectConstructor.members();
                return this.shouldExpandObjectMembers((NodeList<Node>)objectConstructorMembers);
            }
            case RECORD_TYPE_DESC: {
                if (this.options.forceFormattingOptions().forceFormatRecordFields()) {
                    return true;
                }
                RecordTypeDescriptorNode recordTypeDesc = (RecordTypeDescriptorNode)node;
                if (recordTypeDesc.parent().kind() == SyntaxKind.TYPE_DEFINITION) {
                    return true;
                }
                if (this.hasNonWSMinutiae(recordTypeDesc.bodyStartDelimiter().trailingMinutiae()) || this.hasNonWSMinutiae(recordTypeDesc.bodyEndDelimiter().leadingMinutiae())) {
                    return true;
                }
                for (Node field : recordTypeDesc.fields()) {
                    if (!this.hasNonWSMinutiae(field.leadingMinutiae()) && !this.hasNonWSMinutiae(field.trailingMinutiae()) && !field.toSourceCode().contains(System.lineSeparator())) continue;
                    return true;
                }
                return false;
            }
            case LET_EXPRESSION: {
                LetExpressionNode letExpressionNode = (LetExpressionNode)node;
                SeparatedNodeList letVarDeclarations = letExpressionNode.letVarDeclarations();
                LetVariableDeclarationNode lastLetVarDeclarationNode = (LetVariableDeclarationNode)letVarDeclarations.get(letVarDeclarations.size() - 1);
                return this.hasNonWSMinutiae(lastLetVarDeclarationNode.trailingMinutiae()) || lastLetVarDeclarationNode.toSourceCode().contains(System.lineSeparator());
            }
            case ENUM_DECLARATION: {
                EnumDeclarationNode enumDeclarationNode = (EnumDeclarationNode)node;
                SeparatedNodeList enumMemberList = enumDeclarationNode.enumMemberList();
                for (int index = 0; index < enumMemberList.size() - 1; ++index) {
                    Token separator = enumMemberList.getSeparator(index);
                    if (!this.hasNonWSMinutiae(separator.leadingMinutiae()) && !this.hasNonWSMinutiae(separator.trailingMinutiae()) && !separator.toSourceCode().contains(System.lineSeparator())) continue;
                    return true;
                }
                return false;
            }
            case TABLE_CONSTRUCTOR: {
                TableConstructorExpressionNode tableConstructor = (TableConstructorExpressionNode)node;
                SeparatedNodeList rows = tableConstructor.rows();
                return rows.size() > 1 || rows.size() == 1 && this.shouldExpand(rows.get(0));
            }
            case MAPPING_CONSTRUCTOR: {
                MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)node;
                return mappingConstructorExpressionNode.toSourceCode().trim().contains(System.lineSeparator());
            }
            case LIST_CONSTRUCTOR: {
                ListConstructorExpressionNode listConstructorExpressionNode = (ListConstructorExpressionNode)node;
                return listConstructorExpressionNode.toSourceCode().trim().contains(System.lineSeparator());
            }
            case RECEIVE_FIELDS: {
                ReceiveFieldsNode receiveFieldsNode = (ReceiveFieldsNode)node;
                return receiveFieldsNode.toSourceCode().trim().contains(System.lineSeparator());
            }
        }
        return false;
    }

    private boolean shouldExpandObjectMembers(NodeList<Node> members) {
        for (Node member : members) {
            if (member.kind() != SyntaxKind.METHOD_DECLARATION && !this.hasNonWSMinutiae(member.leadingMinutiae()) && !this.hasNonWSMinutiae(member.trailingMinutiae()) && !member.toSourceCode().contains(System.lineSeparator())) continue;
            return true;
        }
        return false;
    }

    private <T extends Node> boolean shouldIndentParenthesizedArgs(SeparatedNodeList<T> nodeList) {
        int size = nodeList.size();
        for (int index = 0; index < size - 1; ++index) {
            if (!this.hasNonWSMinutiae(nodeList.getSeparator(index).trailingMinutiae())) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonWSMinutiae(MinutiaeList minutiaeList) {
        block3: for (Minutiae minutiae : minutiaeList) {
            switch (minutiae.kind()) {
                case WHITESPACE_MINUTIAE: {
                    continue block3;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isClosingTypeToken(Token token) {
        return switch (token.kind()) {
            case SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.CLOSE_BRACE_PIPE_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> true;
            default -> false;
        };
    }

    private boolean hasTrailingNL(Token token) {
        for (Minutiae minutiae : token.trailingMinutiae()) {
            if (minutiae.kind() != SyntaxKind.END_OF_LINE_MINUTIAE) continue;
            return true;
        }
        return false;
    }

    private boolean matchesMinutiaeKind(Minutiae minutiae, SyntaxKind kind) {
        return minutiae != null && minutiae.kind() == kind;
    }

    private NodeList<ImportDeclarationNode> arrangeAndFormatImportDeclarations(NodeList<ImportDeclarationNode> importDeclarationNodes) {
        if (importDeclarationNodes.isEmpty()) {
            return importDeclarationNodes;
        }
        ImportDeclarationNode firstImport = (ImportDeclarationNode)importDeclarationNodes.get(0);
        ArrayList<ImportDeclarationNode> moduleImports = new ArrayList<ImportDeclarationNode>();
        ArrayList<ImportDeclarationNode> stdLibImports = new ArrayList<ImportDeclarationNode>();
        ArrayList<ImportDeclarationNode> thirdPartyImports = new ArrayList<ImportDeclarationNode>();
        for (ImportDeclarationNode importDeclarationNode : importDeclarationNodes) {
            if (importDeclarationNode.orgName().isEmpty() || !this.options.importFormattingOptions().groupImports()) {
                moduleImports.add(importDeclarationNode);
                continue;
            }
            if (List.of("ballerina", "ballerinax").contains(((ImportOrgNameNode)importDeclarationNode.orgName().get()).orgName().text())) {
                stdLibImports.add(importDeclarationNode);
                continue;
            }
            thirdPartyImports.add(importDeclarationNode);
        }
        if (this.options.importFormattingOptions().sortImports()) {
            FormatterUtils.sortImportDeclarations(moduleImports);
            FormatterUtils.sortImportDeclarations(stdLibImports);
            FormatterUtils.sortImportDeclarations(thirdPartyImports);
        }
        NodeList moduleImportNodes = this.formatNodeList(NodeFactory.createNodeList(moduleImports), 0, 1, 0, 2);
        NodeList stdLibImportNodes = this.formatNodeList(NodeFactory.createNodeList(stdLibImports), 0, 1, 0, 2);
        NodeList thirdPartyImportNodes = this.formatNodeList(NodeFactory.createNodeList(thirdPartyImports), 0, 1, 0, 2);
        ArrayList<ImportDeclarationNode> imports = new ArrayList<ImportDeclarationNode>();
        imports.addAll(moduleImportNodes.stream().toList());
        imports.addAll(stdLibImportNodes.stream().toList());
        imports.addAll(thirdPartyImportNodes.stream().toList());
        if (this.hasLeadingComments((Node)firstImport)) {
            FormatterUtils.swapLeadingMinutiae(firstImport, imports);
        }
        return NodeFactory.createNodeList(imports);
    }

    private boolean isScopedFunctionArgument(FunctionArgumentNode functionArgumentNode) {
        SyntaxKind kind;
        return functionArgumentNode.parent().kind() == SyntaxKind.FUNCTION_CALL && functionArgumentNode.children().size() > 0 && ((kind = functionArgumentNode.children().get(0).kind()) == SyntaxKind.OBJECT_CONSTRUCTOR || kind == SyntaxKind.MAPPING_CONSTRUCTOR);
    }

    private boolean hasLeadingComments(Node node) {
        MinutiaeList minutiaeList = node.leadingMinutiae();
        for (Minutiae minutiae : minutiaeList) {
            if (minutiae.kind() != SyntaxKind.COMMENT_MINUTIAE) continue;
            return true;
        }
        return false;
    }

    private int invert(int val) {
        int inverted = 1 - val;
        return inverted >= 0 ? inverted : 0;
    }
}

