/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormatSection;
import org.ballerinalang.formatter.core.options.WrappingMethod;

public class FunctionCallFormattingOptions {
    private final WrappingMethod argumentsWrap;
    private final boolean alignMultilineArguments;
    private final boolean newLineAfterLeftParen;
    private final boolean rightParenOnNewLine;

    private FunctionCallFormattingOptions(WrappingMethod argumentsWrap, boolean alignMultilineArguments, boolean newLineAfterLeftParen, boolean rightParenOnNewLine) {
        this.argumentsWrap = argumentsWrap;
        this.alignMultilineArguments = alignMultilineArguments;
        this.newLineAfterLeftParen = newLineAfterLeftParen;
        this.rightParenOnNewLine = rightParenOnNewLine;
    }

    public WrappingMethod argumentsWrap() {
        return this.argumentsWrap;
    }

    public boolean alignMultilineArguments() {
        return this.alignMultilineArguments;
    }

    public boolean newLineAfterLeftParen() {
        return this.newLineAfterLeftParen;
    }

    public boolean rightParenOnNewLine() {
        return this.rightParenOnNewLine;
    }

    public static FunctionCallFormattingOptionsBuilder builder() {
        return new FunctionCallFormattingOptionsBuilder();
    }

    public static class FunctionCallFormattingOptionsBuilder {
        private static final String ARGUMENTS_WRAP = "argumentsWrap";
        private static final String ALIGN_MULTILINE_ARGUMENTS = "alignMultilineArguments";
        private static final String NEWLINE_AFTER_LEFT_PAREN = "newLineAfterLeftParen";
        private static final String RIGHT_PAREN_ON_NEWLINE = "rightParenOnNewLine";
        private WrappingMethod argumentsWrap = WrappingMethod.valueOf(FormatterUtils.getDefaultString(FormatSection.FUNCTION_CALL, "argumentsWrap"));
        private boolean alignMultilineArguments = FormatterUtils.getDefaultBoolean(FormatSection.FUNCTION_CALL, "alignMultilineArguments");
        private boolean newLineAfterLeftParen = FormatterUtils.getDefaultBoolean(FormatSection.FUNCTION_CALL, "newLineAfterLeftParen");
        private boolean rightParenOnNewLine = FormatterUtils.getDefaultBoolean(FormatSection.FUNCTION_CALL, "rightParenOnNewLine");

        public FunctionCallFormattingOptionsBuilder setArgumentsWrap(WrappingMethod argumentsWrap) {
            this.argumentsWrap = argumentsWrap;
            return this;
        }

        public FunctionCallFormattingOptionsBuilder setAlignMultilineArguments(boolean alignMultilineArguments) {
            this.alignMultilineArguments = alignMultilineArguments;
            return this;
        }

        public FunctionCallFormattingOptionsBuilder setNewLineAfterLeftParen(boolean newLineAfterLeftParen) {
            this.newLineAfterLeftParen = newLineAfterLeftParen;
            return this;
        }

        public FunctionCallFormattingOptionsBuilder setRightParenOnNewLine(boolean rightParenOnNewLine) {
            this.rightParenOnNewLine = rightParenOnNewLine;
            return this;
        }

        public FunctionCallFormattingOptions build() {
            return new FunctionCallFormattingOptions(this.argumentsWrap, this.alignMultilineArguments, this.newLineAfterLeftParen, this.rightParenOnNewLine);
        }

        public FunctionCallFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            block12: for (Map.Entry<String, Object> funcCallEntry : configs.entrySet()) {
                String funcCallKey;
                switch (funcCallKey = funcCallEntry.getKey()) {
                    case "argumentsWrap": {
                        this.setArgumentsWrap(WrappingMethod.fromString((String)funcCallEntry.getValue()));
                        continue block12;
                    }
                    case "alignMultilineArguments": {
                        this.setAlignMultilineArguments((Boolean)funcCallEntry.getValue());
                        continue block12;
                    }
                    case "newLineAfterLeftParen": {
                        this.setNewLineAfterLeftParen((Boolean)funcCallEntry.getValue());
                        continue block12;
                    }
                    case "rightParenOnNewLine": {
                        this.setRightParenOnNewLine((Boolean)funcCallEntry.getValue());
                        continue block12;
                    }
                }
                throw new FormatterException("invalid function call formatting option: " + funcCallKey);
            }
            return this.build();
        }
    }
}

