/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormatSection;

public class SpacingFormattingOptions {
    private final boolean afterTypeCast;
    private final boolean aroundRecordBraces;
    private final boolean alignConsecutiveDefinitions;

    private SpacingFormattingOptions(boolean afterTypeCast, boolean aroundRecordBraces, boolean alignConsecutiveDefinitions) {
        this.afterTypeCast = afterTypeCast;
        this.aroundRecordBraces = aroundRecordBraces;
        this.alignConsecutiveDefinitions = alignConsecutiveDefinitions;
    }

    public boolean afterTypeCast() {
        return this.afterTypeCast;
    }

    public boolean aroundRecordBraces() {
        return this.aroundRecordBraces;
    }

    public boolean alignConsecutiveDefinitions() {
        return this.alignConsecutiveDefinitions;
    }

    public static SpacingFormattingOptionsBuilder builder() {
        return new SpacingFormattingOptionsBuilder();
    }

    public static class SpacingFormattingOptionsBuilder {
        private static final String AFTER_TYPE_CAST = "afterTypeCast";
        private static final String AROUND_RECORD_BRACES = "aroundRecordBraces";
        private static final String ALIGN_CONSECUTIVE_DEFINITIONS = "alignConsecutiveDefinitions";
        private boolean afterTypeCast = FormatterUtils.getDefaultBoolean(FormatSection.SPACING, "afterTypeCast");
        private boolean aroundRecordBraces = FormatterUtils.getDefaultBoolean(FormatSection.SPACING, "aroundRecordBraces");
        private boolean alignConsecutiveDefinitions = FormatterUtils.getDefaultBoolean(FormatSection.SPACING, "alignConsecutiveDefinitions");

        public SpacingFormattingOptionsBuilder setAfterTypeCast(boolean afterTypeCast) {
            this.afterTypeCast = afterTypeCast;
            return this;
        }

        public SpacingFormattingOptionsBuilder setAroundRecordBraces(boolean aroundRecordBraces) {
            this.aroundRecordBraces = aroundRecordBraces;
            return this;
        }

        public SpacingFormattingOptionsBuilder setAlignConsecutiveDefinitions(boolean alignConsecutiveDefinitions) {
            this.alignConsecutiveDefinitions = alignConsecutiveDefinitions;
            return this;
        }

        public SpacingFormattingOptions build() {
            return new SpacingFormattingOptions(this.afterTypeCast, this.aroundRecordBraces, this.alignConsecutiveDefinitions);
        }

        public SpacingFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            block10: for (Map.Entry<String, Object> spacingEntry : configs.entrySet()) {
                String spacingKey;
                switch (spacingKey = spacingEntry.getKey()) {
                    case "afterTypeCast": {
                        this.setAfterTypeCast((Boolean)spacingEntry.getValue());
                        continue block10;
                    }
                    case "aroundRecordBraces": {
                        this.setAroundRecordBraces((Boolean)spacingEntry.getValue());
                        continue block10;
                    }
                    case "alignConsecutiveDefinitions": {
                        this.setAlignConsecutiveDefinitions((Boolean)spacingEntry.getValue());
                        continue block10;
                    }
                }
                throw new FormatterException("invalid spacing formatting option: " + spacingKey);
            }
            return this.build();
        }
    }
}

