/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.model;

import io.ballerina.modelgenerator.commons.Annotation;
import io.ballerina.servicemodelgenerator.extension.ServiceModelGeneratorConstants;
import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.FunctionReturnType;
import io.ballerina.servicemodelgenerator.extension.model.MetaData;
import io.ballerina.servicemodelgenerator.extension.model.Parameter;
import io.ballerina.servicemodelgenerator.extension.model.PropertyTypeMemberInfo;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.ServiceClassUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Function {
    private MetaData metadata;
    private List<String> qualifiers;
    private String kind;
    private Value accessor;
    private Value name;
    private List<Parameter> parameters;
    private Map<String, Parameter> schema;
    private FunctionReturnType returnType;
    private boolean enabled;
    private boolean optional;
    private boolean editable;
    private boolean canAddParameters;
    private Codedata codedata;
    private Map<String, Value> annotations;

    public Function(MetaData metadata, List<String> qualifiers, String kind, Value accessor, Value name, List<Parameter> parameters, Map<String, Parameter> schema, FunctionReturnType returnType, boolean enabled, boolean optional, boolean editable, boolean canAddParameters, Codedata codedata, Map<String, Value> annotations) {
        this.metadata = metadata;
        this.qualifiers = qualifiers;
        this.kind = kind;
        this.accessor = accessor;
        this.name = name;
        this.parameters = parameters;
        this.schema = schema;
        this.returnType = returnType;
        this.enabled = enabled;
        this.optional = optional;
        this.editable = editable;
        this.codedata = codedata;
        this.annotations = annotations;
    }

    public static Function getNewFunctionModel(ServiceClassUtil.ServiceClassContext context) {
        FunctionBuilder functionBuilder = new FunctionBuilder().metadata("", "").accessor(Function.functionAccessor()).parameters(new ArrayList<Parameter>()).kind("OBJECT_METHOD").enabled(true);
        if (context == ServiceClassUtil.ServiceClassContext.GRAPHQL_DIAGRAM) {
            functionBuilder.name(Function.name(ServiceModelGeneratorConstants.FIELD_NAME_METADATA)).returnType(Function.returnType(ServiceModelGeneratorConstants.FIELD_TYPE_METADATA)).schema(Map.of("parameter", Parameter.graphQLParamSchema()));
        } else if (context == ServiceClassUtil.ServiceClassContext.TYPE_DIAGRAM) {
            functionBuilder.name(Function.name(ServiceModelGeneratorConstants.RESOURCE_NAME_METADATA)).returnType(Function.returnType(ServiceModelGeneratorConstants.RESOURCE_FUNCTION_RETURN_TYPE_METADATA)).schema(Map.of("parameter", Parameter.functionParamSchema()));
        } else {
            functionBuilder.name(Function.name(ServiceModelGeneratorConstants.FUNCTION_NAME_METADATA)).returnType(Function.returnType(ServiceModelGeneratorConstants.FUNCTION_RETURN_TYPE_METADATA));
        }
        if (context == ServiceClassUtil.ServiceClassContext.SERVICE_DIAGRAM) {
            functionBuilder.schema(Map.of("parameter", Parameter.functionParamSchema()));
        }
        return functionBuilder.build();
    }

    private static Value functionAccessor() {
        return new Value.ValueBuilder().setMetadata(ServiceModelGeneratorConstants.FUNCTION_ACCESSOR_METADATA).valueType("IDENTIFIER").enabled(true).editable(true).build();
    }

    private static Value name(MetaData metadata) {
        return new Value.ValueBuilder().setMetadata(metadata).valueType("IDENTIFIER").enabled(true).editable(true).build();
    }

    public static FunctionReturnType returnType(MetaData metadata) {
        Value value = new Value.ValueBuilder().setMetadata(metadata).valueType("TYPE").enabled(true).editable(true).optional(true).build();
        return new FunctionReturnType(value);
    }

    public static Map<String, Value> createAnnotationsMap(List<Annotation> annotations) {
        HashMap<String, Value> annotationMap = new HashMap<String, Value>();
        for (Annotation annotation : annotations) {
            Codedata codedata = new Codedata.Builder().setType("ANNOTATION_ATTACHMENT").setOriginalName(annotation.annotationName()).setOrgName(annotation.orgName()).setModuleName(annotation.moduleName()).build();
            String[] parts = annotation.typeConstrain().split(":");
            String type = parts.length > 1 ? parts[1] : parts[0];
            Value value = new Value.ValueBuilder().setMetadata(new MetaData(annotation.displayName(), annotation.description())).setCodedata(codedata).valueType("EXPRESSION").setPlaceholder("{}").setValueTypeConstraint(annotation.typeConstrain()).enabled(true).editable(true).optional(true).setAdvanced(true).setMembers(List.of(new PropertyTypeMemberInfo(type, annotation.packageIdentifier(), "RECORD_TYPE", false))).build();
            String annotKey = "annot" + annotation.annotationName();
            annotationMap.put(annotKey, value);
        }
        return annotationMap;
    }

    public MetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetaData metadata) {
        this.metadata = metadata;
    }

    public List<String> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(List<String> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public void addQualifier(String qualifier) {
        this.qualifiers.add(qualifier);
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public Value getAccessor() {
        return this.accessor;
    }

    public void setAccessor(Value accessor) {
        this.accessor = accessor;
    }

    public Value getName() {
        return this.name;
    }

    public void setName(Value name) {
        this.name = name;
    }

    public List<Parameter> getParameters() {
        return Objects.isNull(this.parameters) ? new ArrayList() : this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public FunctionReturnType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(FunctionReturnType returnType) {
        this.returnType = returnType;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Codedata getCodedata() {
        return this.codedata;
    }

    public void setCodedata(Codedata codedata) {
        this.codedata = codedata;
    }

    public Map<String, Parameter> getSchema() {
        return this.schema;
    }

    public void setSchema(Map<String, Parameter> schema) {
        this.schema = schema;
    }

    public Map<String, Value> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, Value>();
        }
        return this.annotations;
    }

    public void setAnnotations(Map<String, Value> annotations) {
        this.annotations = annotations;
    }

    public boolean isCanAddParameters() {
        return this.canAddParameters;
    }

    public void setCanAddParameters(boolean canAddParameters) {
        this.canAddParameters = canAddParameters;
    }

    public static class FunctionBuilder {
        private MetaData metadata;
        private Codedata codedata;
        private List<String> qualifiers;
        private String kind;
        private Value accessor;
        private Value name;
        private List<Parameter> parameters;
        private Map<String, Parameter> schema;
        private FunctionReturnType returnType;
        private boolean enabled = false;
        private boolean optional = false;
        private boolean editable = false;
        private boolean canAddParameters = false;
        private Map<String, Value> annotations;

        public FunctionBuilder metadata(String label, String description) {
            this.metadata = new MetaData(label, description);
            return this;
        }

        public FunctionBuilder setMetadata(MetaData metadata) {
            this.metadata = metadata;
            return this;
        }

        public FunctionBuilder setQualifiers(List<String> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public FunctionBuilder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public FunctionBuilder accessor(Value accessor) {
            this.accessor = accessor;
            return this;
        }

        public FunctionBuilder name(Value name) {
            this.name = name;
            return this;
        }

        public FunctionBuilder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public FunctionBuilder schema(Map<String, Parameter> schema) {
            this.schema = schema;
            return this;
        }

        public FunctionBuilder returnType(FunctionReturnType returnType) {
            this.returnType = returnType;
            return this;
        }

        public FunctionBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public FunctionBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public FunctionBuilder editable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public FunctionBuilder canAddParameters(boolean canAddParameters) {
            this.canAddParameters = canAddParameters;
            return this;
        }

        public FunctionBuilder setCodedata(Codedata codedata) {
            this.codedata = codedata;
            return this;
        }

        public FunctionBuilder setAnnotations(Map<String, Value> annotations) {
            this.annotations = annotations;
            return this;
        }

        public Function build() {
            return new Function(this.metadata, this.qualifiers, this.kind, this.accessor, this.name, this.parameters, this.schema, this.returnType, this.enabled, this.optional, this.editable, this.canAddParameters, this.codedata, this.annotations);
        }
    }
}

