/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.model;

import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.DisplayAnnotation;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class Listener {
    private String id;
    private String name;
    private String type;
    private String displayName;
    private String description;
    private DisplayAnnotation displayAnnotation;
    private String moduleName;
    private String orgName;
    private String version;
    private String packageName;
    private String listenerProtocol;
    private String icon;
    private Map<String, Value> properties;
    private Codedata codedata;

    public Listener(String id, String name, String type, String displayName, String description, DisplayAnnotation displayAnnotation, String moduleName, String orgName, String version, String packageName, String listenerProtocol, String icon, Map<String, Value> properties, Codedata codedata) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.displayName = displayName;
        this.description = description;
        this.displayAnnotation = displayAnnotation;
        this.moduleName = moduleName;
        this.orgName = orgName;
        this.version = version;
        this.packageName = packageName;
        this.listenerProtocol = listenerProtocol;
        this.icon = icon;
        this.properties = properties;
        this.codedata = codedata;
    }

    public boolean isListenerInitProperty(Value value) {
        Codedata codedata = value.getCodedata();
        return Objects.nonNull(codedata) && Objects.nonNull(codedata.getType()) && codedata.getType().equals("LISTENER_INIT_PARAM");
    }

    public boolean isRequiredArgument(Value value) {
        Codedata codedata = value.getCodedata();
        return Objects.nonNull(codedata) && Objects.nonNull(codedata.getArgType()) && codedata.getArgType().equals("REQUIRED");
    }

    public String getDeclaration() {
        ArrayList params = new ArrayList();
        StringBuilder listenerDeclaration = new StringBuilder();
        listenerDeclaration.append("listener ");
        listenerDeclaration.append(this.listenerProtocol);
        listenerDeclaration.append(":Listener ");
        listenerDeclaration.append(Utils.getValueString(this.properties.get("name")));
        listenerDeclaration.append(" = new ");
        listenerDeclaration.append("(");
        this.properties.forEach((key, value) -> {
            if (value.isEnabledWithValue() && this.isListenerInitProperty((Value)value)) {
                if (this.isRequiredArgument((Value)value)) {
                    params.add(Utils.getValueString(value));
                } else {
                    params.add(String.format("%s = %s", key, Utils.getValueString(value)));
                }
            }
        });
        listenerDeclaration.append(String.join((CharSequence)", ", params));
        listenerDeclaration.append(");");
        return listenerDeclaration.toString();
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Value getProperty(String key) {
        return this.properties.get(key);
    }

    public Map<String, Value> getProperties() {
        return this.properties;
    }

    public String getListenerProtocol() {
        return this.listenerProtocol;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public DisplayAnnotation getDisplayAnnotation() {
        return this.displayAnnotation;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Codedata getCodedata() {
        return this.codedata;
    }

    public void setCodedata(Codedata codedata) {
        this.codedata = codedata;
    }

    public void setProperties(Map<String, Value> properties) {
        this.properties = properties;
    }

    public static class ListenerBuilder {
        private String id;
        private String name;
        private String type;
        private String displayName;
        private String description;
        private DisplayAnnotation displayAnnotation;
        private String moduleName;
        private String orgName;
        private String version;
        private String packageName;
        private String listenerProtocol;
        private String icon;
        private Map<String, Value> properties;
        private Codedata codedata;

        public ListenerBuilder setId(String id) {
            this.id = id;
            return this;
        }

        public ListenerBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public ListenerBuilder setType(String type) {
            this.type = type;
            return this;
        }

        public ListenerBuilder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ListenerBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public ListenerBuilder setDisplayAnnotation(DisplayAnnotation displayAnnotation) {
            this.displayAnnotation = displayAnnotation;
            return this;
        }

        public ListenerBuilder setModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public ListenerBuilder setOrgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public ListenerBuilder setVersion(String version) {
            this.version = version;
            return this;
        }

        public ListenerBuilder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public ListenerBuilder setListenerProtocol(String listenerProtocol) {
            this.listenerProtocol = listenerProtocol;
            return this;
        }

        public ListenerBuilder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public ListenerBuilder setProperties(Map<String, Value> properties) {
            this.properties = properties;
            return this;
        }

        public ListenerBuilder setCodedata(Codedata codedata) {
            this.codedata = codedata;
            return this;
        }

        public Listener build() {
            return new Listener(this.id, this.name, this.type, this.displayName, this.description, this.displayAnnotation, this.moduleName, this.orgName, this.version, this.packageName, this.listenerProtocol, this.icon, this.properties, this.codedata);
        }
    }
}

