/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.util;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.Document;
import io.ballerina.servicemodelgenerator.extension.ServiceModelGeneratorConstants;
import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.Function;
import io.ballerina.servicemodelgenerator.extension.model.FunctionReturnType;
import io.ballerina.servicemodelgenerator.extension.model.HttpResponse;
import io.ballerina.servicemodelgenerator.extension.model.MetaData;
import io.ballerina.servicemodelgenerator.extension.model.Parameter;
import io.ballerina.servicemodelgenerator.extension.model.Service;
import io.ballerina.servicemodelgenerator.extension.model.TriggerProperty;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.request.TriggerListRequest;
import io.ballerina.servicemodelgenerator.extension.request.TriggerRequest;
import io.ballerina.servicemodelgenerator.extension.util.HttpUtil;
import io.ballerina.servicemodelgenerator.extension.util.ServiceClassUtil;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public final class Utils {
    private Utils() {
    }

    public static Range toRange(LineRange lineRange) {
        return new Range(Utils.toPosition(lineRange.startLine()), Utils.toPosition(lineRange.endLine()));
    }

    public static Range toRange(LinePosition position) {
        return new Range(Utils.toPosition(position), Utils.toPosition(position));
    }

    public static Position toPosition(LinePosition linePosition) {
        return new Position(linePosition.line(), linePosition.offset());
    }

    public static void populateRequiredFuncsDesignApproachAndServiceType(Service service) {
        Utils.populateRequiredFunctions(service);
        Utils.populateServiceType(service);
        Utils.populateDesignApproach(service);
    }

    public static void populateRequiredFunctions(Service service) {
        Value value = service.getProperty("requiredFunctions");
        if (Objects.nonNull(value) && value.isEnabledWithValue()) {
            String requiredFunction = value.getValue();
            service.getFunctions().forEach(function -> function.setEnabled(function.getName().getValue().equals(requiredFunction)));
        }
    }

    private static void populateServiceType(Service service) {
        String serviceType;
        Value serviceValue = service.getServiceType();
        if (Objects.nonNull(serviceValue) && serviceValue.isEnabledWithValue() && Objects.nonNull(serviceType = service.getServiceTypeName())) {
            Utils.getServiceByServiceType(serviceType.toLowerCase(Locale.ROOT)).ifPresent(serviceTypeModel -> service.setFunctions(serviceTypeModel.getFunctions()));
        }
    }

    public static void populateDesignApproach(Service service) {
        Value designApproach = service.getDesignApproach();
        if (Objects.nonNull(designApproach) && designApproach.isEnabled() && Objects.nonNull(designApproach.getChoices()) && !designApproach.getChoices().isEmpty()) {
            designApproach.getChoices().stream().filter(Value::isEnabled).findFirst().ifPresent(selectedApproach -> service.addProperties(selectedApproach.getProperties()));
            service.getProperties().remove("designApproach");
        }
    }

    private static Optional<Service> getServiceByServiceType(String serviceType) {
        Optional<Service> optional;
        InputStream resourceStream = Utils.class.getClassLoader().getResourceAsStream(String.format("services/%s.json", serviceType.replaceAll(":", ".")));
        if (resourceStream == null) {
            return Optional.empty();
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
        try {
            optional = Optional.of((Service)new Gson().fromJson(reader, Service.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public static Optional<ExpressionNode> getListenerExpression(ServiceDeclarationNode serviceNode) {
        SeparatedNodeList expressions = serviceNode.expressions();
        if (expressions.isEmpty()) {
            return Optional.empty();
        }
        ExpressionNode expressionNode = (ExpressionNode)expressions.get(0);
        return Optional.of(expressionNode);
    }

    public static Optional<Symbol> getHttpServiceContractSym(SemanticModel semanticModel, TypeDescriptorNode serviceTypeDesc) {
        Object t;
        Object t2;
        Optional svcTypeSymbol = semanticModel.symbol((Node)serviceTypeDesc);
        if (svcTypeSymbol.isEmpty() || !((t2 = svcTypeSymbol.get()) instanceof TypeReferenceTypeSymbol)) {
            return Optional.empty();
        }
        TypeReferenceTypeSymbol svcTypeRef = (TypeReferenceTypeSymbol)t2;
        Optional contractSymbol = semanticModel.types().getTypeByName("ballerina", "http", "", "ServiceContract");
        if (contractSymbol.isEmpty() || !((t = contractSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return Optional.empty();
        }
        TypeDefinitionSymbol contractTypeDef = (TypeDefinitionSymbol)t;
        if (svcTypeRef.subtypeOf(contractTypeDef.typeDescriptor())) {
            return svcTypeSymbol;
        }
        return Optional.empty();
    }

    public static String getPath(NodeList<Node> paths) {
        return paths.stream().map(Node::toString).map(String::trim).collect(Collectors.joining(""));
    }

    public static Function getFunctionModel(MethodDeclarationNode functionDefinitionNode, SemanticModel semanticModel, boolean isHttp, boolean isGraphQL, Map<String, Value> annotations) {
        boolean isInit = Utils.isInitFunction(functionDefinitionNode);
        ServiceClassUtil.ServiceClassContext context = Utils.deriveContext(isGraphQL, isHttp, isInit);
        Function functionModel = Function.getNewFunctionModel(context);
        functionModel.setAnnotations(annotations);
        Value functionName = functionModel.getName();
        functionName.setValue(functionDefinitionNode.methodName().text().trim());
        functionName.setValueType("IDENTIFIER");
        Value accessor = functionModel.getAccessor();
        for (Token qualifier : functionDefinitionNode.qualifierList()) {
            String qualifierText = qualifier.text().trim();
            if (qualifierText.matches("remote")) {
                functionModel.setKind("REMOTE");
                continue;
            }
            if (!qualifierText.matches("resource")) continue;
            functionModel.setKind("RESOURCE");
            accessor.setValue(functionDefinitionNode.methodName().text().trim());
            functionName.setValue(Utils.getPath((NodeList<Node>)functionDefinitionNode.relativeResourcePath()));
        }
        FunctionSignatureNode functionSignatureNode = functionDefinitionNode.methodSignature();
        Optional returnTypeDesc = functionSignatureNode.returnTypeDesc();
        if (returnTypeDesc.isPresent()) {
            FunctionReturnType returnType = functionModel.getReturnType();
            returnType.setValue(((ReturnTypeDescriptorNode)returnTypeDesc.get()).type().toString().trim());
            if (isHttp) {
                Utils.populateHttpResponses(functionDefinitionNode, returnType, semanticModel);
            }
        }
        SeparatedNodeList parameters = functionSignatureNode.parameters();
        ArrayList<Parameter> parameterModels = new ArrayList<Parameter>();
        parameters.forEach(parameterNode -> {
            Optional<Parameter> parameterModel = Utils.getParameterModel(parameterNode, isHttp, isGraphQL);
            parameterModel.ifPresent(parameterModels::add);
        });
        functionModel.setParameters(parameterModels);
        functionModel.setCodedata(new Codedata(functionDefinitionNode.lineRange()));
        return functionModel;
    }

    public static Function getFunctionModel(FunctionDefinitionNode functionDefinitionNode, SemanticModel semanticModel, boolean isHttp, boolean isGraphQL, Map<String, Value> annotations) {
        FunctionSignatureNode functionSignatureNode;
        Optional returnTypeDesc;
        boolean isInit = Utils.isInitFunction(functionDefinitionNode);
        ServiceClassUtil.ServiceClassContext context = Utils.deriveContext(isGraphQL, isHttp, isInit);
        Function functionModel = Function.getNewFunctionModel(context);
        functionModel.setAnnotations(annotations);
        if (isInit) {
            functionModel.setKind("DEFAULT");
        }
        Value functionName = functionModel.getName();
        functionName.setValue(functionDefinitionNode.functionName().text().trim());
        functionName.setValueType("IDENTIFIER");
        Value accessor = functionModel.getAccessor();
        for (Token qualifier : functionDefinitionNode.qualifierList()) {
            String qualifierText = qualifier.text().trim();
            if (qualifierText.matches("remote")) {
                functionModel.setKind(isGraphQL ? "MUTATION" : "REMOTE");
                break;
            }
            if (!qualifierText.matches("resource")) continue;
            if (isGraphQL) {
                functionModel.setKind(functionName.getValue().equals("subscribe") ? "SUBSCRIPTION" : "QUERY");
            } else {
                functionModel.setKind("RESOURCE");
            }
            accessor.setValue(functionDefinitionNode.functionName().text().trim());
            functionName.setValue(Utils.getPath((NodeList<Node>)functionDefinitionNode.relativeResourcePath()));
            break;
        }
        if ((returnTypeDesc = (functionSignatureNode = functionDefinitionNode.functionSignature()).returnTypeDesc()).isPresent()) {
            FunctionReturnType returnType = functionModel.getReturnType();
            returnType.setValue(((ReturnTypeDescriptorNode)returnTypeDesc.get()).type().toString().trim());
            if (isHttp) {
                Utils.populateHttpResponses(functionDefinitionNode, returnType, semanticModel);
            }
        }
        SeparatedNodeList parameters = functionSignatureNode.parameters();
        ArrayList<Parameter> parameterModels = new ArrayList<Parameter>();
        parameters.forEach(parameterNode -> {
            Optional<Parameter> parameterModel = Utils.getParameterModel(parameterNode, isHttp, isGraphQL);
            parameterModel.ifPresent(parameterModels::add);
        });
        functionModel.setParameters(parameterModels);
        functionModel.setCodedata(new Codedata(functionDefinitionNode.lineRange()));
        functionModel.setCanAddParameters(true);
        Utils.updateAnnotationAttachmentProperty(functionDefinitionNode, functionModel);
        return functionModel;
    }

    private static ServiceClassUtil.ServiceClassContext deriveContext(boolean isGraphQL, boolean isHttp, boolean isInit) {
        if (isGraphQL && !isInit) {
            return ServiceClassUtil.ServiceClassContext.GRAPHQL_DIAGRAM;
        }
        if (isHttp && isInit) {
            return ServiceClassUtil.ServiceClassContext.HTTP_DIAGRAM;
        }
        return ServiceClassUtil.ServiceClassContext.SERVICE_DIAGRAM;
    }

    private static boolean isInitFunction(FunctionDefinitionNode functionDefinitionNode) {
        return functionDefinitionNode.functionName().text().trim().equals("init");
    }

    private static boolean isInitFunction(MethodDeclarationNode functionDefinitionNode) {
        return functionDefinitionNode.methodName().text().trim().equals("init");
    }

    private static void populateHttpResponses(MethodDeclarationNode functionDefinitionNode, FunctionReturnType returnType, SemanticModel semanticModel) {
        Object t;
        Optional functionDefSymbol = semanticModel.symbol((Node)functionDefinitionNode);
        if (functionDefSymbol.isEmpty() || !((t = functionDefSymbol.get()) instanceof ResourceMethodSymbol)) {
            return;
        }
        ResourceMethodSymbol resource = (ResourceMethodSymbol)t;
        HttpUtil.populateHttpResponses(returnType, semanticModel, resource);
    }

    private static void populateHttpResponses(FunctionDefinitionNode functionDefinitionNode, FunctionReturnType returnType, SemanticModel semanticModel) {
        Object t;
        Optional functionDefSymbol = semanticModel.symbol((Node)functionDefinitionNode);
        if (functionDefSymbol.isEmpty() || !((t = functionDefSymbol.get()) instanceof ResourceMethodSymbol)) {
            return;
        }
        ResourceMethodSymbol resource = (ResourceMethodSymbol)t;
        HttpUtil.populateHttpResponses(returnType, semanticModel, resource);
    }

    public static Optional<Parameter> getParameterModel(ParameterNode parameterNode, boolean isHttp, boolean isGraphQL) {
        if (parameterNode instanceof RequiredParameterNode) {
            RequiredParameterNode parameter = (RequiredParameterNode)parameterNode;
            if (parameter.paramName().isEmpty()) {
                return Optional.empty();
            }
            String paramName = ((Token)parameter.paramName().get()).text().trim();
            Parameter parameterModel = Utils.createParameter(paramName, "REQUIRED", parameter.typeName().toString().trim(), (NodeList<AnnotationNode>)parameter.annotations(), isHttp, isGraphQL);
            return Optional.of(parameterModel);
        }
        if (parameterNode instanceof DefaultableParameterNode) {
            DefaultableParameterNode parameter = (DefaultableParameterNode)parameterNode;
            if (parameter.paramName().isEmpty()) {
                return Optional.empty();
            }
            String paramName = ((Token)parameter.paramName().get()).text().trim();
            Parameter parameterModel = Utils.createParameter(paramName, "DEFAULTABLE", parameter.typeName().toString().trim(), (NodeList<AnnotationNode>)parameter.annotations(), isHttp, isGraphQL);
            Value defaultValue = parameterModel.getDefaultValue();
            defaultValue.setValue(parameter.expression().toString().trim());
            defaultValue.setValueType("EXPRESSION");
            defaultValue.setEnabled(true);
            return Optional.of(parameterModel);
        }
        return Optional.empty();
    }

    private static Parameter createParameter(String paramName, String paramKind, String typeName, NodeList<AnnotationNode> annotationNodes, boolean isHttp, boolean isGraphQL) {
        Parameter parameterModel = Parameter.getNewParameter(isGraphQL);
        parameterModel.setMetadata(new MetaData(paramName, paramName));
        parameterModel.setKind(paramKind);
        parameterModel.getType().setValue(typeName);
        parameterModel.getName().setValue(paramName);
        if (isHttp) {
            Optional<String> httpParameterType = HttpUtil.getHttpParameterType(annotationNodes);
            if (httpParameterType.isPresent()) {
                parameterModel.setHttpParamType(httpParameterType.get());
            } else if (!(typeName.equals("http:Request") || typeName.equals("http:Caller") || typeName.equals("http:Headers") || typeName.equals("http:RequestContext"))) {
                parameterModel.setHttpParamType("QUERY");
                parameterModel.setEditable(true);
            }
        }
        return parameterModel;
    }

    public static Optional<String> getPath(TypeDefinitionNode serviceTypeNode) {
        Optional metadata = serviceTypeNode.metadata();
        if (metadata.isEmpty()) {
            return Optional.empty();
        }
        Optional<AnnotationNode> httpServiceConfig = ((MetadataNode)metadata.get()).annotations().stream().filter(annotation -> annotation.annotReference().toString().trim().equals("http:ServiceConfig")).findFirst();
        if (httpServiceConfig.isEmpty()) {
            return Optional.empty();
        }
        Optional mapExpr = httpServiceConfig.get().annotValue();
        if (mapExpr.isEmpty()) {
            return Optional.empty();
        }
        Optional<SpecificFieldNode> basePathField = ((MappingConstructorExpressionNode)mapExpr.get()).fields().stream().filter(fieldNode -> fieldNode.kind().equals((Object)SyntaxKind.SPECIFIC_FIELD)).map(fieldNode -> (SpecificFieldNode)fieldNode).filter(fieldNode -> fieldNode.fieldName().toString().trim().equals("basePath")).findFirst();
        if (basePathField.isEmpty()) {
            return Optional.empty();
        }
        Optional valueExpr = basePathField.get().valueExpr();
        if (valueExpr.isPresent() && ((ExpressionNode)valueExpr.get()).kind().equals((Object)SyntaxKind.STRING_LITERAL)) {
            String value = ((BasicLiteralNode)valueExpr.get()).literalToken().text();
            return Optional.of(value.substring(1, value.length() - 1));
        }
        return Optional.empty();
    }

    public static Optional<Function> getFunctionModel(String serviceType, String functionNameOrType) {
        Optional<Function> optional;
        String resourcePath = String.format("functions/%s_%s.json", serviceType.toLowerCase(Locale.US), functionNameOrType.toLowerCase(Locale.US));
        InputStream resourceStream = Utils.class.getClassLoader().getResourceAsStream(resourcePath);
        if (resourceStream == null) {
            return Optional.empty();
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
        try {
            optional = Optional.of((Function)new Gson().fromJson(reader, Function.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public static void populateListenerInfo(Service serviceModel, ServiceDeclarationNode serviceNode) {
        SeparatedNodeList expressions = serviceNode.expressions();
        int size = expressions.size();
        if (size == 1) {
            serviceModel.getListener().setValue(Utils.getListenerExprName((ExpressionNode)expressions.get(0)));
        } else if (size > 1) {
            for (int i = 0; i < size; ++i) {
                ExpressionNode expressionNode = (ExpressionNode)expressions.get(i);
                serviceModel.getListener().addValue(Utils.getListenerExprName(expressionNode));
            }
        }
    }

    public static void updateAnnotationAttachmentProperty(ServiceDeclarationNode serviceNode, Service service) {
        Optional metadata = serviceNode.metadata();
        if (metadata.isEmpty()) {
            return;
        }
        ((MetadataNode)metadata.get()).annotations().forEach(annotationNode -> {
            if (annotationNode.annotValue().isEmpty()) {
                return;
            }
            String annotName = annotationNode.annotReference().toString().trim();
            String[] split = annotName.split(":");
            annotName = split[split.length - 1];
            String propertyName = "annot" + annotName;
            if (service.getProperties().containsKey(propertyName)) {
                Value property = service.getProperties().get(propertyName);
                property.setValue(((MappingConstructorExpressionNode)annotationNode.annotValue().get()).toSourceCode().trim());
            }
        });
    }

    public static void updateAnnotationAttachmentProperty(FunctionDefinitionNode functionDef, Function function) {
        Optional metadata = functionDef.metadata();
        if (metadata.isEmpty()) {
            return;
        }
        ((MetadataNode)metadata.get()).annotations().forEach(annotationNode -> {
            if (annotationNode.annotValue().isEmpty()) {
                return;
            }
            String annotName = annotationNode.annotReference().toString().trim();
            String[] split = annotName.split(":");
            annotName = split[split.length - 1];
            String propertyName = "annot" + annotName;
            if (function.getAnnotations().containsKey(propertyName)) {
                Value property = function.getAnnotations().get(propertyName);
                property.setValue(((MappingConstructorExpressionNode)annotationNode.annotValue().get()).toSourceCode().trim());
            }
        });
    }

    private static String getListenerExprName(ExpressionNode expressionNode) {
        if (expressionNode instanceof NameReferenceNode) {
            NameReferenceNode nameReferenceNode = (NameReferenceNode)expressionNode;
            return nameReferenceNode.toSourceCode().trim();
        }
        if (expressionNode instanceof ExplicitNewExpressionNode) {
            ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)expressionNode;
            return explicitNewExpressionNode.toSourceCode().trim();
        }
        return "";
    }

    public static boolean isPresent(Function functionModel, Function newFunction) {
        return newFunction.getName().getValue().equals(functionModel.getName().getValue()) && (Objects.isNull(newFunction.getAccessor()) || Objects.isNull(functionModel.getAccessor()) || newFunction.getAccessor().getValue().equals(functionModel.getAccessor().getValue()));
    }

    public static void updateValue(Value target, Value source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            return;
        }
        target.setEnabled(source.isEnabledWithValue());
        target.setValue(source.getValue());
        target.setValueType(source.getValueType());
    }

    public static void updateValue(FunctionReturnType target, FunctionReturnType source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            return;
        }
        target.setEnabled(source.isEnabledWithValue());
        target.setValue(source.getValue());
        target.setValueType(source.getValueType());
        if (Objects.nonNull(source.getResponses())) {
            target.setResponses(source.getResponses());
        }
    }

    public static String getServiceDeclarationNode(Service service, FunctionAddContext context, Map<String, String> imports) {
        StringBuilder builder = new StringBuilder();
        List<String> annots = Utils.getAnnotationEdits(service);
        if (!annots.isEmpty()) {
            builder.append(String.join((CharSequence)ServiceModelGeneratorConstants.NEW_LINE, annots));
            builder.append(System.lineSeparator());
        }
        builder.append("service").append(" ");
        if (Objects.nonNull(service.getServiceType()) && service.getServiceType().isEnabledWithValue()) {
            builder.append(service.getServiceTypeName());
            builder.append(" ");
        }
        if (Objects.nonNull(service.getServiceContractTypeNameValue()) && service.getServiceContractTypeNameValue().isEnabledWithValue()) {
            builder.append(service.getServiceContractTypeName());
            builder.append(" ");
        } else if (Objects.nonNull(service.getBasePath()) && service.getBasePath().isEnabledWithValue()) {
            builder.append(Utils.getValueString(service.getBasePath()));
            builder.append(" ");
        } else if (Objects.nonNull(service.getStringLiteralProperty()) && service.getStringLiteralProperty().isEnabledWithValue()) {
            builder.append(Utils.getValueString(service.getStringLiteralProperty()));
            builder.append(" ");
        }
        builder.append("on").append(" ");
        if (Objects.nonNull(service.getListener()) && service.getListener().isEnabledWithValue()) {
            builder.append(service.getListener().getValue());
        }
        builder.append(" ").append("{");
        builder.append(System.lineSeparator());
        ArrayList<String> functions = new ArrayList<String>();
        boolean isNewTcpService = Utils.isTcpService(service.getOrgName(), service.getPackageName()) && service.getProperties().containsKey("returningServiceClass");
        boolean isAiAgent = Utils.isAiAgentModule(service.getOrgName(), service.getPackageName());
        if (isNewTcpService) {
            String serviceClassName = service.getProperties().get("returningServiceClass").getValue();
            String onConnectFunc = Utils.getTcpOnConnectTemplate().formatted(serviceClassName, serviceClassName);
            functions.add(onConnectFunc);
        } else if (isAiAgent) {
            String chatFunction = Utils.getAgentChatFunction();
            functions.add(chatFunction);
        } else {
            service.getFunctions().forEach(function -> {
                if (function.isEnabled()) {
                    String functionNode = "\t" + Utils.generateFunctionDefSource(function, new ArrayList<String>(), context, FunctionSignatureContext.FUNCTION_ADD, imports).replace(System.lineSeparator(), System.lineSeparator() + "\t");
                    functions.add(functionNode);
                }
            });
        }
        builder.append(String.join((CharSequence)(System.lineSeparator() + System.lineSeparator()), functions));
        builder.append(System.lineSeparator());
        builder.append("}");
        return builder.toString();
    }

    private static String getAgentChatFunction() {
        return "    resource function post chat(@http:Payload ai:ChatReqMessage request) returns ai:ChatRespMessage|error {" + System.lineSeparator() + "    }";
    }

    public static List<String> getAnnotationEdits(Service service) {
        Map<String, Value> properties = service.getProperties();
        ArrayList<String> annots = new ArrayList<String>();
        for (Map.Entry<String, Value> property : properties.entrySet()) {
            Value value = property.getValue();
            if (!Objects.nonNull(value.getCodedata()) || !Objects.nonNull(value.getCodedata().getType()) || !value.getCodedata().getType().equals("ANNOTATION_ATTACHMENT") || !value.isEnabledWithValue()) continue;
            String ref = service.getModuleName() + ":" + value.getCodedata().getOriginalName();
            String annotTemplate = "@%s%s".formatted(ref, value.getValue());
            annots.add(annotTemplate);
        }
        return annots;
    }

    public static List<String> getAnnotationEdits(Function function) {
        Map<String, Value> properties = function.getAnnotations();
        ArrayList<String> annots = new ArrayList<String>();
        for (Map.Entry<String, Value> property : properties.entrySet()) {
            Value value = property.getValue();
            if (!Objects.nonNull(value.getCodedata()) || !Objects.nonNull(value.getCodedata().getType()) || !value.getCodedata().getType().equals("ANNOTATION_ATTACHMENT") || !value.isEnabledWithValue()) continue;
            Codedata codedata = value.getCodedata();
            String ref = codedata.getModuleName() + ":" + codedata.getOriginalName();
            String annotTemplate = "@%s%s".formatted(ref, value.getValue());
            annots.add(annotTemplate);
        }
        return annots;
    }

    public static int addServiceAnnotationTextEdits(Service service, ServiceDeclarationNode serviceNode, List<TextEdit> edits) {
        Token serviceKeyword = serviceNode.serviceKeyword();
        List<String> annots = Utils.getAnnotationEdits(service);
        Object annotEdit = String.join((CharSequence)System.lineSeparator(), annots);
        Optional metadata = serviceNode.metadata();
        if (metadata.isEmpty()) {
            if (!((String)annotEdit).isEmpty()) {
                annotEdit = (String)annotEdit + System.lineSeparator();
                edits.add(new TextEdit(Utils.toRange(serviceKeyword.lineRange().startLine()), (String)annotEdit));
            }
            return annots.size();
        }
        NodeList annotations = ((MetadataNode)metadata.get()).annotations();
        if (annotations.isEmpty()) {
            if (!((String)annotEdit).isEmpty()) {
                annotEdit = (String)annotEdit + System.lineSeparator();
                edits.add(new TextEdit(Utils.toRange(((MetadataNode)metadata.get()).lineRange()), (String)annotEdit));
            }
            return annots.size();
        }
        int size = annotations.size();
        LinePosition firstAnnotationEndLinePos = ((AnnotationNode)annotations.get(0)).lineRange().startLine();
        LinePosition lastAnnotationEndLinePos = ((AnnotationNode)annotations.get(size - 1)).lineRange().endLine();
        LineRange range = LineRange.from((String)serviceKeyword.lineRange().fileName(), (LinePosition)firstAnnotationEndLinePos, (LinePosition)lastAnnotationEndLinePos);
        if (!((String)annotEdit).isEmpty()) {
            edits.add(new TextEdit(Utils.toRange(range), (String)annotEdit));
        }
        return annots.size();
    }

    public static int addFunctionAnnotationTextEdits(Function function, FunctionDefinitionNode functionDef, List<TextEdit> edits) {
        Token firstToken = functionDef.qualifierList().isEmpty() ? functionDef.functionKeyword() : (Token)functionDef.qualifierList().get(0);
        List<String> annots = Utils.getAnnotationEdits(function);
        Object annotEdit = String.join((CharSequence)System.lineSeparator(), annots);
        Optional metadata = functionDef.metadata();
        if (metadata.isEmpty()) {
            if (!((String)annotEdit).isEmpty()) {
                annotEdit = (String)annotEdit + System.lineSeparator();
                edits.add(new TextEdit(Utils.toRange(firstToken.lineRange().startLine()), (String)annotEdit));
            }
            return annots.size();
        }
        NodeList annotations = ((MetadataNode)metadata.get()).annotations();
        if (annotations.isEmpty()) {
            if (!((String)annotEdit).isEmpty()) {
                annotEdit = (String)annotEdit + System.lineSeparator();
                edits.add(new TextEdit(Utils.toRange(((MetadataNode)metadata.get()).lineRange()), (String)annotEdit));
            }
            return annots.size();
        }
        int size = annotations.size();
        LinePosition firstAnnotationEndLinePos = ((AnnotationNode)annotations.get(0)).lineRange().startLine();
        LinePosition lastAnnotationEndLinePos = ((AnnotationNode)annotations.get(size - 1)).lineRange().endLine();
        LineRange range = LineRange.from((String)firstToken.lineRange().fileName(), (LinePosition)firstAnnotationEndLinePos, (LinePosition)lastAnnotationEndLinePos);
        if (!((String)annotEdit).isEmpty()) {
            edits.add(new TextEdit(Utils.toRange(range), (String)annotEdit));
        }
        return annots.size();
    }

    public static String getValueString(Value value) {
        if (Objects.isNull(value)) {
            return "";
        }
        if (!value.isEnabledWithValue()) {
            return "";
        }
        if (!value.getValue().trim().isEmpty()) {
            return !Objects.isNull(value.getValueType()) && value.getValueType().equals("STRING") ? String.format("\"%s\"", value.getValue()) : value.getValue();
        }
        Map<String, Value> properties = value.getProperties();
        if (Objects.isNull(properties)) {
            return "";
        }
        ArrayList params = new ArrayList();
        properties.forEach((key, val) -> {
            if (val.isEnabledWithValue()) {
                params.add(String.format("%s: %s", key, Utils.getValueString(val)));
            }
        });
        return String.format("{%s}", String.join((CharSequence)", ", params));
    }

    public static String generateFunctionDefSource(Function function, List<String> statusCodeResponses, FunctionAddContext addContext, FunctionSignatureContext signatureContext, Map<String, String> imports) {
        boolean hasErrorInReturn;
        String functionQualifiers;
        StringBuilder builder = new StringBuilder();
        List<String> functionAnnotations = Utils.getAnnotationEdits(function);
        if (!functionAnnotations.isEmpty()) {
            builder.append(String.join((CharSequence)ServiceModelGeneratorConstants.NEW_LINE, functionAnnotations)).append(ServiceModelGeneratorConstants.NEW_LINE);
        }
        if (!(functionQualifiers = Utils.getFunctionQualifiers(function)).isEmpty()) {
            builder.append(functionQualifiers).append(" ");
        }
        builder.append("function ");
        Value accessor = function.getAccessor();
        if (function.getKind().equals("RESOURCE") && Objects.nonNull(accessor) && accessor.isEnabledWithValue()) {
            builder.append(Utils.getValueString(accessor).toLowerCase(Locale.ROOT)).append(" ");
        }
        if (function.getKind().equals("SUBSCRIPTION")) {
            builder.append("subscribe").append(" ");
        }
        if (function.getKind().equals("QUERY")) {
            builder.append("get").append(" ");
        }
        builder.append(Utils.getValueString(function.getName()));
        FunctionSignatureContext sigContext = addContext.equals((Object)FunctionAddContext.HTTP_SERVICE_ADD) ? FunctionSignatureContext.HTTP_RESOURCE_ADD : signatureContext;
        String functionSignature = Utils.generateFunctionSignatureSource(function, statusCodeResponses, sigContext, imports);
        builder.append(functionSignature);
        FunctionReturnType returnType = function.getReturnType();
        boolean bl = hasErrorInReturn = returnType.hasError() || addContext.equals((Object)FunctionAddContext.HTTP_SERVICE_ADD) || signatureContext.equals((Object)FunctionSignatureContext.HTTP_RESOURCE_ADD);
        if (!hasErrorInReturn && Objects.nonNull(returnType.getValue())) {
            List<String> returnParts = Arrays.stream(returnType.getValue().split("\\|")).toList();
            hasErrorInReturn = returnParts.contains("error") || returnParts.contains("error?");
        }
        builder.append("{").append(ServiceModelGeneratorConstants.NEW_LINE);
        if (hasErrorInReturn) {
            builder.append("\tdo {").append(ServiceModelGeneratorConstants.NEW_LINE);
            builder.append("\t} on fail error err {").append(ServiceModelGeneratorConstants.NEW_LINE).append("\t\t// handle error").append(ServiceModelGeneratorConstants.NEW_LINE).append("\t\treturn error(\"unhandled error\", err);").append(ServiceModelGeneratorConstants.NEW_LINE).append("\t}").append(ServiceModelGeneratorConstants.NEW_LINE);
        }
        builder.append("}");
        return builder.toString();
    }

    public static String generateFunctionSignatureSource(Function function, List<String> statusCodeResponses, FunctionSignatureContext context, Map<String, String> imports) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(Utils.generateFunctionParamListSource(function.getParameters(), imports));
        builder.append(")");
        FunctionReturnType returnType = function.getReturnType();
        boolean addError = context.equals((Object)FunctionSignatureContext.HTTP_RESOURCE_ADD);
        if (Objects.nonNull(returnType)) {
            ArrayList<String> responses;
            if (returnType.isEnabledWithValue()) {
                builder.append(" returns ");
                Object returnTypeStr = Utils.getValueString(returnType);
                if (addError && !((String)returnTypeStr).contains("error")) {
                    returnTypeStr = "error|" + (String)returnTypeStr;
                }
                builder.append((String)returnTypeStr);
                if (Objects.nonNull(returnType.getImports())) {
                    imports.putAll(returnType.getImports());
                }
            } else if (returnType.isEnabled() && Objects.nonNull(returnType.getResponses()) && !returnType.getResponses().isEmpty() && !(responses = new ArrayList<String>(returnType.getResponses().stream().filter(HttpResponse::isEnabled).map(response -> HttpUtil.getStatusCodeResponse(response, statusCodeResponses, imports)).filter(Objects::nonNull).toList())).isEmpty()) {
                if (addError && !statusCodeResponses.contains("error")) {
                    responses.addFirst("error");
                }
                builder.append(" returns ");
                builder.append(String.join((CharSequence)"|", responses));
            }
        }
        builder.append(" ");
        return builder.toString();
    }

    private static String generateFunctionParamListSource(List<Parameter> parameters, Map<String, String> imports) {
        parameters.sort(new Parameter.RequiredParamSorter());
        ArrayList params = new ArrayList();
        parameters.forEach(param -> {
            if (param.isEnabled()) {
                String paramDef;
                Value defaultValue = param.getDefaultValue();
                if (Objects.nonNull(defaultValue) && defaultValue.isEnabled() && Objects.nonNull(defaultValue.getValue()) && !defaultValue.getValue().isEmpty()) {
                    Value paramType = param.getType();
                    paramDef = String.format("%s %s = %s", Utils.getValueString(paramType), Utils.getValueString(param.getName()), Utils.getValueString(defaultValue));
                    if (Objects.nonNull(paramType.getImports())) {
                        imports.putAll(paramType.getImports());
                    }
                } else {
                    Value paramType = param.getType();
                    if (Objects.nonNull(paramType.getImports())) {
                        imports.putAll(paramType.getImports());
                    }
                    paramDef = String.format("%s %s", Utils.getValueString(paramType), Utils.getValueString(param.getName()));
                }
                if (Objects.nonNull(param.getHttpParamType()) && !param.getHttpParamType().equals("Query")) {
                    paramDef = String.format("@http:%s %s", param.getHttpParamType(), paramDef);
                }
                params.add(paramDef);
            }
        });
        return String.join((CharSequence)", ", params);
    }

    public static String getFunctionQualifiers(Function function) {
        String kind;
        ArrayList<String> qualifiers = function.getQualifiers();
        qualifiers = Objects.isNull(qualifiers) ? new ArrayList<String>() : qualifiers;
        switch (kind = function.getKind()) {
            case "QUERY": 
            case "SUBSCRIPTION": 
            case "RESOURCE": {
                qualifiers.add("resource");
                break;
            }
            case "REMOTE": 
            case "MUTATION": {
                qualifiers.add("remote");
                break;
            }
        }
        return String.join((CharSequence)" ", qualifiers);
    }

    public static boolean importExists(ModulePartNode node, String org, String module) {
        return node.imports().stream().anyMatch(importDeclarationNode -> {
            String moduleName = importDeclarationNode.moduleName().stream().map(Token::text).collect(Collectors.joining("."));
            return importDeclarationNode.orgName().isPresent() && org.equals(((ImportOrgNameNode)importDeclarationNode.orgName().get()).orgName().text()) && module.equals(moduleName);
        });
    }

    public static String getImportStmt(String org, String module) {
        return String.format("%nimport %s/%s;%n", org, module);
    }

    public static boolean filterTriggers(TriggerProperty triggerProperty, TriggerListRequest request) {
        return !(request != null && (request.organization() != null && !request.organization().equals(triggerProperty.orgName()) || request.packageName() != null && !request.packageName().equals(triggerProperty.packageName()) || request.keyWord() != null && !triggerProperty.keywords().stream().anyMatch(keyword -> keyword.equalsIgnoreCase(request.keyWord())) || request.query() != null && !triggerProperty.keywords().stream().anyMatch(keyword -> keyword.contains(request.query()))));
    }

    public static boolean expectsTriggerByName(TriggerRequest request) {
        return request.id() == null && request.organization() != null && request.packageName() != null;
    }

    public static boolean isTcpService(String org, String module) {
        return org.equals("ballerina") && module.equals("tcp");
    }

    public static String getTcpOnConnectTemplate() {
        return "    remote function onConnect(tcp:Caller caller) returns tcp:ConnectionService|tcp:Error? {%n        do {%n            %s connectionService = new %s();%n            return connectionService;%n        } on fail error err {%n            // handle error%n            return error(\"unhandled error\", err);%n        }%n    }";
    }

    public static FunctionAddContext getTriggerAddContext(String org, String module) {
        if (org.equals("ballerina")) {
            if (module.equals("http")) {
                return FunctionAddContext.HTTP_SERVICE_ADD;
            }
            if (module.equals("graphql")) {
                return FunctionAddContext.GRAPHQL_SERVICE_ADD;
            }
            if (module.equals("tcp")) {
                return FunctionAddContext.TCP_SERVICE_ADD;
            }
        }
        return FunctionAddContext.TRIGGER_ADD;
    }

    public static String generateVariableIdentifier(SemanticModel semanticModel, Document document, LinePosition linePosition, String prefix) {
        Set names = semanticModel.visibleSymbols(document, linePosition).parallelStream().filter(s -> s.getName().isPresent()).map(s -> (String)s.getName().get()).collect(Collectors.toSet());
        return NameUtil.generateVariableName((String)prefix, names);
    }

    public static String generateTypeIdentifier(SemanticModel semanticModel, Document document, LinePosition linePosition, String prefix) {
        Set names = semanticModel.visibleSymbols(document, linePosition).parallelStream().filter(s -> s.getName().isPresent()).map(s -> (String)s.getName().get()).collect(Collectors.toSet());
        return NameUtil.generateTypeName((String)prefix, names);
    }

    public static String upperCaseFirstLetter(String value) {
        return value.substring(0, 1).toUpperCase(Locale.ROOT) + value.substring(1).toLowerCase(Locale.ROOT);
    }

    public static String removeLeadingSingleQuote(String input) {
        if (input != null && input.startsWith("'")) {
            return input.substring(1);
        }
        return input;
    }

    public static boolean isAiAgentModule(String org, String module) {
        return org.equals("ballerinax") && module.equals("ai");
    }

    public static enum FunctionAddContext {
        HTTP_SERVICE_ADD,
        TCP_SERVICE_ADD,
        GRAPHQL_SERVICE_ADD,
        TRIGGER_ADD,
        FUNCTION_ADD,
        RESOURCE_ADD;

    }

    public static enum FunctionSignatureContext {
        FUNCTION_ADD,
        HTTP_RESOURCE_ADD,
        FUNCTION_UPDATE;

    }
}

