/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.plugin;

import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websocket.WebSocketResourceDispatcher;
import io.ballerina.stdlib.websocket.plugin.PluginConstants;
import io.ballerina.stdlib.websocket.plugin.Utils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class WebSocketServiceValidator {
    public static final String GENERIC_FUNCTION = "generic function";
    private final Set<String> specialRemoteMethods = Set.of("onOpen", "onClose", "onError", "onIdleTimeout", "onTextMessage", "onBinaryMessage", "onMessage", "onPing", "onPong");
    private SyntaxNodeAnalysisContext ctx;

    WebSocketServiceValidator(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        this.ctx = syntaxNodeAnalysisContext;
    }

    private static Optional<String> getDispatcherConfigAnnotatedFunctionName(FunctionDefinitionNode node, SyntaxNodeAnalysisContext ctx) {
        if (node.metadata().isEmpty()) {
            return Optional.empty();
        }
        for (AnnotationNode annotationNode : ((MetadataNode)node.metadata().get()).annotations()) {
            Optional annotationType = ctx.semanticModel().symbol((Node)annotationNode);
            if (annotationType.isEmpty() || !((Symbol)annotationType.get()).getModule().flatMap(Symbol::getName).orElse("").equals("websocket") || !((Symbol)annotationType.get()).getName().orElse("").equals("DispatcherConfig")) continue;
            if (annotationNode.annotValue().isEmpty()) {
                return Optional.empty();
            }
            MappingConstructorExpressionNode annotationValue = (MappingConstructorExpressionNode)annotationNode.annotValue().get();
            for (Node field : annotationValue.fields()) {
                if (!field.kind().equals((Object)SyntaxKind.SPECIFIC_FIELD)) continue;
                String fieldName = ((SpecificFieldNode)field).fieldName().toString().strip();
                Optional filedValue = ((SpecificFieldNode)field).valueExpr();
                if (!fieldName.equals("dispatcherValue") || filedValue.isEmpty()) continue;
                return Optional.of(((ExpressionNode)filedValue.get()).toString().replaceAll("\"", "").strip());
            }
        }
        return Optional.empty();
    }

    public void validate() {
        ClassDefinitionNode classDefNode = (ClassDefinitionNode)this.ctx.node();
        Map<String, Boolean> functionSet = classDefNode.members().stream().filter(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).map(node -> {
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
            NodeList qualifierList = functionDefinitionNode.qualifierList();
            if (qualifierList.isEmpty()) {
                return GENERIC_FUNCTION;
            }
            String qualifier = ((Token)qualifierList.get(0)).text();
            if (qualifier.equals(Qualifier.REMOTE.getValue())) {
                this.filterRemoteFunctions(functionDefinitionNode);
                return functionDefinitionNode.functionName().toString();
            }
            if (qualifier.equals(Qualifier.RESOURCE.getValue())) {
                this.reportInvalidFunction(functionDefinitionNode);
            }
            return GENERIC_FUNCTION;
        }).collect(Collectors.toMap(node -> node, node -> true, (node1, node2) -> node1));
        if (functionSet.containsKey("onMessage") && functionSet.containsKey("onTextMessage")) {
            Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.INVALID_REMOTE_FUNCTIONS, classDefNode.location(), "onTextMessage");
        }
        if (functionSet.containsKey("onMessage") && functionSet.containsKey("onBinaryMessage")) {
            Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.INVALID_REMOTE_FUNCTIONS, classDefNode.location(), "onBinaryMessage");
        }
        if (!functionSet.containsKey("onTextMessage") && !functionSet.containsKey("onMessage")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_TEXT_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onBinaryMessage") && !functionSet.containsKey("onMessage")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_BINARY_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onClose")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_CLOSE_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onOpen")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_OPEN_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onPing")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_PING_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onPong")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_PONG_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onIdleTimeout")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_IDLE_TIMEOUT_GENERATION_HINT);
        }
        if (!functionSet.containsKey("onError")) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_ERROR_GENERATION_HINT);
        }
        if (!(functionSet.containsKey("onMessage") || functionSet.containsKey("onTextMessage") || functionSet.containsKey("onBinaryMessage"))) {
            this.reportDiagnostic(classDefNode, PluginConstants.CompilationErrors.ON_MESSAGE_GENERATION_HINT);
        }
        this.validateDispatcherConfigAnnotations(classDefNode, functionSet);
    }

    private void validateDispatcherConfigAnnotations(ClassDefinitionNode classDefNode, Map<String, Boolean> functionSet) {
        HashSet<String> seenAnnotationValues = new HashSet<String>();
        for (Node node : classDefNode.members()) {
            FunctionDefinitionNode funcDefinitionNode;
            if (!node.kind().equals((Object)SyntaxKind.OBJECT_METHOD_DEFINITION) || (funcDefinitionNode = (FunctionDefinitionNode)node).qualifierList().stream().noneMatch(token -> token.text().equals(Qualifier.REMOTE.getValue()))) continue;
            Optional funcName = this.ctx.semanticModel().symbol((Node)funcDefinitionNode).flatMap(Symbol::getName);
            Optional<String> annoDispatchingValue = WebSocketServiceValidator.getDispatcherConfigAnnotatedFunctionName(funcDefinitionNode, this.ctx);
            if (funcName.isEmpty() || annoDispatchingValue.isEmpty()) continue;
            if (seenAnnotationValues.contains(annoDispatchingValue.get())) {
                Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.DUPLICATED_DISPATCHER_MAPPING_DISPATCHER_VALUE, funcDefinitionNode.location(), annoDispatchingValue.get());
                continue;
            }
            seenAnnotationValues.add(annoDispatchingValue.get());
            String customRemoteFunctionName = WebSocketResourceDispatcher.createCustomRemoteFunction((String)annoDispatchingValue.get());
            if (this.specialRemoteMethods.contains(funcName.get())) {
                Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.INVALID_FUNCTION_ANNOTATION, funcDefinitionNode.location(), funcName.get());
                continue;
            }
            if (!functionSet.containsKey(customRemoteFunctionName) || customRemoteFunctionName.equals(funcName.get()) || this.specialRemoteMethods.contains(customRemoteFunctionName)) continue;
            Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.RE_DECLARED_REMOTE_FUNCTIONS, classDefNode.location(), customRemoteFunctionName, annoDispatchingValue.get(), funcName.get());
        }
    }

    private void filterRemoteFunctions(FunctionDefinitionNode functionDefinitionNode) {
        FunctionTypeSymbol functionTypeSymbol = ((MethodSymbol)this.ctx.semanticModel().symbol((Node)functionDefinitionNode).get()).typeDescriptor();
        switch (functionDefinitionNode.functionName().toString()) {
            case "onOpen": {
                Utils.validateOnOpenFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onClose": {
                Utils.validateOnCloseFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onError": {
                Utils.validateOnErrorFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onIdleTimeout": {
                Utils.validateOnIdleTimeoutFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onTextMessage": {
                Utils.validateOnTextMessageFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            case "onBinaryMessage": {
                Utils.validateOnBinaryMessageFunction(functionTypeSymbol, this.ctx, functionDefinitionNode);
                break;
            }
            default: {
                Utils.validateOnDataFunctions(functionTypeSymbol, this.ctx, functionDefinitionNode);
            }
        }
    }

    private void reportDiagnostic(ClassDefinitionNode classDefNode, PluginConstants.CompilationErrors hint) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(hint.getErrorCode(), hint.getError(), DiagnosticSeverity.INTERNAL);
        this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)classDefNode.location(), (Object[])new Object[0]));
    }

    private void reportInvalidFunction(FunctionDefinitionNode functionDefinitionNode) {
        Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.FUNCTION_NOT_ACCEPTED_BY_THE_SERVICE, functionDefinitionNode.location(), functionDefinitionNode.functionName().toString());
    }
}

