/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websocket.plugin.ListenerInitExpressionNodeVisitor;
import io.ballerina.stdlib.websocket.plugin.PluginConstants;
import io.ballerina.stdlib.websocket.plugin.Utils;
import io.ballerina.stdlib.websocket.plugin.WebSocketUpgradeServiceValidator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.List;
import java.util.Optional;

public class WebSocketUpgradeServiceValidatorTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext ctx) {
        Optional<Double> timeoutValue;
        List diagnostics = ctx.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)ctx.node();
        boolean disptacherKeyAnnotation = this.getDispatcherConfigAnnotation(serviceDeclarationNode, ctx.semanticModel(), "dispatcherKey");
        boolean disptacherStreamIdAnnotation = this.getDispatcherConfigAnnotation(serviceDeclarationNode, ctx.semanticModel(), "dispatcherStreamId");
        if (disptacherStreamIdAnnotation && !disptacherKeyAnnotation) {
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.DISPATCHER_STREAM_ID_WITHOUT_KEY, serviceDeclarationNode.location(), new Object[0]);
        }
        if ((timeoutValue = this.getConnectionClosureTimeoutValue(serviceDeclarationNode, ctx.semanticModel())).isPresent() && timeoutValue.get() < 0.0 && timeoutValue.get().intValue() != -1) {
            Utils.reportDiagnostics(ctx, PluginConstants.CompilationErrors.INVALID_CONNECTION_CLOSURE_TIMEOUT, ((MetadataNode)serviceDeclarationNode.metadata().get()).location(), new Object[0]);
        }
        String modulePrefix = Utils.getPrefix(ctx);
        Optional serviceDeclarationSymbol = ctx.semanticModel().symbol((Node)serviceDeclarationNode);
        if (serviceDeclarationSymbol.isPresent()) {
            List listenerTypes = ((ServiceDeclarationSymbol)serviceDeclarationSymbol.get()).listenerTypes();
            for (TypeSymbol listenerType : listenerTypes) {
                if (!this.isListenerBelongsToWebSocketModule(listenerType)) continue;
                ListenerInitExpressionNodeVisitor visitor = new ListenerInitExpressionNodeVisitor(ctx);
                serviceDeclarationNode.syntaxTree().rootNode().accept((NodeVisitor)visitor);
                this.validateListenerArguments(ctx, visitor);
                this.validateService(ctx, modulePrefix, disptacherKeyAnnotation);
                return;
            }
        }
    }

    private boolean isAnnotationFieldPresent(AnnotationNode annotation, SemanticModel semanticModel, String annotationName) {
        if (annotation.annotValue().isEmpty()) {
            return false;
        }
        for (MappingFieldNode field : ((MappingConstructorExpressionNode)annotation.annotValue().get()).fields()) {
            Optional symbol;
            Node fieldNameNode;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (fieldNameNode = ((SpecificFieldNode)field).fieldName()).kind() != SyntaxKind.IDENTIFIER_TOKEN || (symbol = semanticModel.symbol(fieldNameNode)).isEmpty() || ((Symbol)symbol.get()).getName().isEmpty() || !annotationName.equals(((Symbol)symbol.get()).getName().get())) continue;
            return true;
        }
        return false;
    }

    private boolean getDispatcherConfigAnnotation(ServiceDeclarationNode serviceNode, SemanticModel semanticModel, String annotationName) {
        if (serviceNode.metadata().isEmpty()) {
            return false;
        }
        MetadataNode metaData = (MetadataNode)serviceNode.metadata().get();
        NodeList annotations = metaData.annotations();
        return annotations.stream().anyMatch(ann -> this.isAnnotationFieldPresent((AnnotationNode)ann, semanticModel, annotationName));
    }

    private Optional<Double> getConnectionClosureTimeoutValue(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        if (serviceNode.metadata().isEmpty()) {
            return Optional.empty();
        }
        NodeList annotations = ((MetadataNode)serviceNode.metadata().get()).annotations();
        return annotations.stream().filter(ann -> this.isAnnotationFieldPresent((AnnotationNode)ann, semanticModel, "connectionClosureTimeout")).map(ann -> this.getAnnotationValue((AnnotationNode)ann, semanticModel, "connectionClosureTimeout")).filter(Optional::isPresent).map(Optional::get).findFirst().map(Double::parseDouble);
    }

    private Optional<String> getAnnotationValue(AnnotationNode annotation, SemanticModel semanticModel, String annotationName) {
        if (annotation.annotValue().isEmpty()) {
            return Optional.empty();
        }
        for (MappingFieldNode field : ((MappingConstructorExpressionNode)annotation.annotValue().get()).fields()) {
            SpecificFieldNode specificFieldNode;
            Optional symbol;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (symbol = semanticModel.symbol((Node)(specificFieldNode = (SpecificFieldNode)field))).isEmpty() || ((Symbol)symbol.get()).getName().isEmpty() || !annotationName.equals(((Symbol)symbol.get()).getName().get())) continue;
            if (specificFieldNode.valueExpr().isEmpty()) {
                return Optional.empty();
            }
            if (((ExpressionNode)specificFieldNode.valueExpr().get()).kind() != SyntaxKind.UNARY_EXPRESSION) {
                return Optional.empty();
            }
            return Optional.of(((ExpressionNode)specificFieldNode.valueExpr().get()).toString().strip());
        }
        return Optional.empty();
    }

    private boolean isListenerBelongsToWebSocketModule(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(typeReferenceTypeSymbol -> this.isWebSocketModule((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()));
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return this.isWebSocketModule((ModuleSymbol)((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().get());
        }
        return false;
    }

    private void validateListenerArguments(SyntaxNodeAnalysisContext context, ListenerInitExpressionNodeVisitor visitor) {
        visitor.getExplicitNewExpressionNodes().forEach(explicitNewExpressionNode -> {
            SeparatedNodeList functionArgs = explicitNewExpressionNode.parenthesizedArgList().arguments();
            this.verifyListenerArgType(context, explicitNewExpressionNode.location(), (SeparatedNodeList<FunctionArgumentNode>)functionArgs);
        });
        visitor.getImplicitNewExpressionNodes().forEach(implicitNewExpressionNode -> {
            Optional argListOpt = implicitNewExpressionNode.parenthesizedArgList();
            if (argListOpt.isPresent()) {
                SeparatedNodeList functionArgs = ((ParenthesizedArgList)argListOpt.get()).arguments();
                this.verifyListenerArgType(context, implicitNewExpressionNode.location(), (SeparatedNodeList<FunctionArgumentNode>)functionArgs);
            }
        });
    }

    private void verifyListenerArgType(SyntaxNodeAnalysisContext context, NodeLocation location, SeparatedNodeList<FunctionArgumentNode> functionArgs) {
        if (functionArgs.size() >= 2) {
            PositionalArgumentNode firstArg = (PositionalArgumentNode)functionArgs.get(0);
            SyntaxKind firstArgSyntaxKind = firstArg.expression().kind();
            SyntaxKind secondArgSyntaxKind = null;
            if (functionArgs.get(1) instanceof PositionalArgumentNode) {
                secondArgSyntaxKind = ((PositionalArgumentNode)functionArgs.get(1)).expression().kind();
            } else if (functionArgs.get(1) instanceof NamedArgumentNode) {
                secondArgSyntaxKind = ((NamedArgumentNode)functionArgs.get(1)).expression().kind();
            }
            if (secondArgSyntaxKind != null && (firstArgSyntaxKind != SyntaxKind.NUMERIC_LITERAL || secondArgSyntaxKind != SyntaxKind.SIMPLE_NAME_REFERENCE && secondArgSyntaxKind != SyntaxKind.MAPPING_CONSTRUCTOR)) {
                Utils.reportDiagnostics(context, PluginConstants.CompilationErrors.INVALID_LISTENER_INIT_PARAMS, location, "websocket");
            }
        }
    }

    private boolean isWebSocketModule(ModuleSymbol moduleSymbol) {
        return Utils.equals((String)moduleSymbol.getName().get(), "websocket") && Utils.equals(moduleSymbol.id().orgName(), "ballerina");
    }

    private void validateService(SyntaxNodeAnalysisContext ctx, String modulePrefix, boolean disptacherAnnotation) {
        WebSocketUpgradeServiceValidator wsServiceValidator = new WebSocketUpgradeServiceValidator(ctx, modulePrefix + SyntaxKind.COLON_TOKEN.stringValue());
        wsServiceValidator.validate(disptacherAnnotation);
    }
}

