/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.datasource;

import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.transactions.BallerinaTransactionContext;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import io.ballerina.stdlib.sql.Constants;
import io.ballerina.stdlib.sql.datasource.PoolKey;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.transaction.SQLTransactionContext;
import io.ballerina.stdlib.sql.utils.ErrorGenerator;
import io.ballerina.stdlib.sql.utils.Utils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class SQLDatasource {
    private AtomicInteger clientCounter = new AtomicInteger(0);
    private Lock mutex = new ReentrantLock();
    private boolean poolShutdown = false;
    private boolean xaConn;
    private AtomikosDataSourceBean atomikosDataSourceBean;
    private HikariDataSource hikariDataSource;
    private XADataSource xaDataSource;
    private boolean executeGKFlag;
    private boolean batchExecuteGKFlag;
    private static final String POOL_MAP_KEY = UUID.randomUUID().toString();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLDatasource(SQLDatasourceParams sqlDatasourceParams) {
        Connection connection = null;
        try {
            Class<?> dataSourceClass;
            if (sqlDatasourceParams.datasourceName != null && !sqlDatasourceParams.datasourceName.isEmpty() && TransactionResourceManager.getInstance().getTransactionManagerEnabled() && XADataSource.class.isAssignableFrom(dataSourceClass = ClassLoader.getSystemClassLoader().loadClass(sqlDatasourceParams.datasourceName))) {
                this.xaConn = true;
                this.atomikosDataSourceBean = this.buildXAAwareDataSource(sqlDatasourceParams);
                connection = this.getConnection();
                return;
            }
            this.hikariDataSource = this.buildNonXADataSource(sqlDatasourceParams);
            if (this.hikariDataSource.isWrapperFor(XADataSource.class)) {
                this.xaConn = true;
                this.xaDataSource = (XADataSource)this.hikariDataSource.unwrap(XADataSource.class);
                connection = this.xaDataSource.getXAConnection().getConnection();
                return;
            }
            connection = this.getConnection();
            return;
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e, "error while verifying the connection for SQLClientConnector, ");
        }
        catch (ClassNotFoundException e) {
            throw ErrorGenerator.getSQLApplicationError("error while loading datasource class for SQLClientConnector, ");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static synchronized Map<PoolKey, SQLDatasource> putDatasourceContainer(BMap<BString, Object> poolOptions, ConcurrentHashMap<PoolKey, SQLDatasource> datasourceMap) {
        Map existingDataSourceMap = (Map)poolOptions.getNativeData(POOL_MAP_KEY);
        if (existingDataSourceMap != null) {
            return existingDataSourceMap;
        }
        poolOptions.addNativeData(POOL_MAP_KEY, datasourceMap);
        return datasourceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLDatasource retrieveDatasource(SQLDatasourceParams sqlDatasourceParams, boolean executeGKFlag, boolean batchExecuteGKFlag) {
        SQLDatasource existingSqlDatasource;
        PoolKey poolKey = new PoolKey(sqlDatasourceParams.url, sqlDatasourceParams.options);
        Map<PoolKey, SQLDatasource> hikariDatasourceMap = (Map<PoolKey, SQLDatasource>)sqlDatasourceParams.connectionPool.getNativeData(POOL_MAP_KEY);
        if (hikariDatasourceMap == null) {
            hikariDatasourceMap = SQLDatasource.putDatasourceContainer((BMap<BString, Object>)sqlDatasourceParams.connectionPool, new ConcurrentHashMap<PoolKey, SQLDatasource>());
        }
        SQLDatasource sqlDatasourceToBeReturned = existingSqlDatasource = (SQLDatasource)hikariDatasourceMap.get(poolKey);
        if (existingSqlDatasource != null) {
            existingSqlDatasource.acquireMutex();
            try {
                if (!existingSqlDatasource.isPoolShutdown()) {
                    existingSqlDatasource.incrementClientCounter();
                }
                sqlDatasourceToBeReturned = hikariDatasourceMap.compute(poolKey, (key, value) -> SQLDatasource.createAndInitDatasource(sqlDatasourceParams));
            }
            finally {
                existingSqlDatasource.releaseMutex();
            }
        } else {
            sqlDatasourceToBeReturned = hikariDatasourceMap.computeIfAbsent(poolKey, key -> SQLDatasource.createAndInitDatasource(sqlDatasourceParams));
        }
        sqlDatasourceToBeReturned.setExecuteGKFlag(executeGKFlag);
        sqlDatasourceToBeReturned.setBatchExecuteGKFlag(batchExecuteGKFlag);
        return sqlDatasourceToBeReturned;
    }

    public static Connection getConnection(boolean isInTrx, BObject client, SQLDatasource datasource, TransactionLocalContext transactionLocalContext, boolean trxManagerEnabled) throws SQLException {
        Connection conn;
        try {
            if (!isInTrx) {
                return datasource.getConnection();
            }
            String connectorId = (String)client.getNativeData("sql-transaction-id");
            boolean isXAConnection = datasource.isXADataSource();
            String globalTxId = transactionLocalContext.getGlobalTransactionId();
            String currentTxBlockId = transactionLocalContext.getCurrentTransactionBlockId();
            BallerinaTransactionContext txContext = transactionLocalContext.getTransactionContext(connectorId);
            if (txContext == null) {
                if (isXAConnection && !trxManagerEnabled) {
                    XAConnection xaConn = datasource.getXAConnection();
                    XAResource xaResource = xaConn.getXAResource();
                    TransactionResourceManager.getInstance().beginXATransaction(globalTxId, currentTxBlockId, xaResource);
                    conn = xaConn.getConnection();
                    txContext = new SQLTransactionContext(conn, xaResource);
                } else if (isXAConnection) {
                    TransactionResourceManager.getInstance().beginXATransaction(globalTxId, currentTxBlockId, null);
                    conn = datasource.getConnection();
                    conn.setAutoCommit(false);
                    txContext = new SQLTransactionContext(conn);
                } else {
                    conn = datasource.getConnection();
                    conn.setAutoCommit(false);
                    txContext = new SQLTransactionContext(conn);
                }
                transactionLocalContext.registerTransactionContext(connectorId, txContext);
                TransactionResourceManager.getInstance().register(globalTxId, currentTxBlockId, txContext);
            } else {
                conn = ((SQLTransactionContext)txContext).getConnection();
            }
        }
        catch (SQLException e) {
            SQLException rootSQLException = Utils.getRootSQLException(e);
            throw new SQLException("error while getting the connection for SQLClientConnector. " + rootSQLException.getMessage(), rootSQLException.getSQLState(), rootSQLException.getErrorCode());
        }
        return conn;
    }

    public static SQLDatasourceParams createSQLDatasourceParams(BMap<BString, Object> sqlDatasourceParams, BMap<BString, Object> globalConnectionPool) {
        BString userVal;
        BMap connPoolProps = sqlDatasourceParams.getMapValue(Constants.SQLParamsFields.CONNECTION_POOL_OPTIONS);
        Properties poolProperties = null;
        if (connPoolProps != null) {
            poolProperties = new Properties();
            for (BString key : (BString[])connPoolProps.getKeys()) {
                poolProperties.setProperty(key.getValue(), connPoolProps.getStringValue(key).getValue());
            }
        }
        String user = (userVal = sqlDatasourceParams.getStringValue(Constants.SQLParamsFields.USER)) == null ? null : userVal.getValue();
        BString passwordVal = sqlDatasourceParams.getStringValue(Constants.SQLParamsFields.PASSWORD);
        String password = passwordVal == null ? null : passwordVal.getValue();
        BString dataSourceNamVal = sqlDatasourceParams.getStringValue(Constants.SQLParamsFields.DATASOURCE_NAME);
        String datasourceName = dataSourceNamVal == null ? null : dataSourceNamVal.getValue();
        return new SQLDatasourceParams().setUrl(sqlDatasourceParams.getStringValue(Constants.SQLParamsFields.URL).getValue()).setUser(user).setPassword(password).setDatasourceName(datasourceName).setOptions(sqlDatasourceParams.getMapValue(Constants.SQLParamsFields.OPTIONS)).setConnectionPool(sqlDatasourceParams.getMapValue(Constants.SQLParamsFields.CONNECTION_POOL), globalConnectionPool).setPoolProperties(poolProperties);
    }

    private static SQLDatasource createAndInitDatasource(SQLDatasourceParams sqlDatasourceParams) {
        SQLDatasource newSqlDatasource = new SQLDatasource(sqlDatasourceParams);
        newSqlDatasource.incrementClientCounter();
        return newSqlDatasource;
    }

    private Connection getConnection() throws SQLException {
        if (this.atomikosDataSourceBean != null) {
            return this.atomikosDataSourceBean.getConnection();
        }
        return this.hikariDataSource.getConnection();
    }

    private XAConnection getXAConnection() throws SQLException {
        if (this.isXADataSource()) {
            return this.xaDataSource.getXAConnection();
        }
        return null;
    }

    private boolean isXADataSource() {
        return this.xaConn;
    }

    private void closeConnectionPool() {
        if (this.hikariDataSource != null) {
            this.hikariDataSource.close();
        }
        if (this.atomikosDataSourceBean != null) {
            this.atomikosDataSourceBean.close();
        }
        this.poolShutdown = true;
    }

    private boolean isPoolShutdown() {
        return this.poolShutdown;
    }

    private void incrementClientCounter() {
        this.clientCounter.incrementAndGet();
    }

    public void decrementClientCounterAndAttemptPoolShutdown() {
        this.acquireMutex();
        if (!this.poolShutdown && this.clientCounter.decrementAndGet() == 0) {
            this.closeConnectionPool();
        }
        this.releaseMutex();
    }

    private void releaseMutex() {
        this.mutex.unlock();
    }

    private void acquireMutex() {
        this.mutex.lock();
    }

    private HikariDataSource buildNonXADataSource(SQLDatasourceParams sqlDatasourceParams) {
        try {
            HikariConfig config = sqlDatasourceParams.poolProperties != null ? new HikariConfig(sqlDatasourceParams.poolProperties) : new HikariConfig();
            config.setJdbcUrl(sqlDatasourceParams.url);
            config.setUsername(sqlDatasourceParams.user);
            config.setPassword(sqlDatasourceParams.password);
            if (sqlDatasourceParams.datasourceName != null && !sqlDatasourceParams.datasourceName.isEmpty()) {
                if (sqlDatasourceParams.options == null || !sqlDatasourceParams.options.containsKey((Object)Constants.Options.URL)) {
                    config.addDataSourceProperty(Constants.Options.URL.getValue(), (Object)sqlDatasourceParams.url);
                }
                if (sqlDatasourceParams.user != null) {
                    config.addDataSourceProperty("user", (Object)sqlDatasourceParams.user);
                }
                if (sqlDatasourceParams.password != null) {
                    config.addDataSourceProperty("password", (Object)sqlDatasourceParams.password);
                }
            }
            config.setDataSourceClassName(sqlDatasourceParams.datasourceName);
            if (sqlDatasourceParams.connectionPool != null) {
                Object connectionInitSql;
                Object connectionTestQuery;
                int maxOpenConn = sqlDatasourceParams.connectionPool.getIntValue(Constants.ConnectionPool.MAX_OPEN_CONNECTIONS).intValue();
                if (maxOpenConn < 1) {
                    throw new ApplicationError("ConnectionPool field 'maxOpenConnections' cannot be less than one.");
                }
                config.setMaximumPoolSize(maxOpenConn);
                double connLifeTimeSec = this.getDoubleFromBDecimal((BMap<BString, Object>)sqlDatasourceParams.connectionPool, Constants.ConnectionPool.MAX_CONNECTION_LIFE_TIME);
                if (connLifeTimeSec < 0.0 || connLifeTimeSec > 0.0 && connLifeTimeSec < 30.0) {
                    throw new ApplicationError("ConnectionPool field 'maxConnectionLifeTime' can either be 0 or greater than or equal to 30.");
                }
                long connLifeTimeMS = (long)(connLifeTimeSec * 1000.0);
                config.setMaxLifetime(connLifeTimeMS);
                int minIdleConnections = sqlDatasourceParams.connectionPool.getIntValue(Constants.ConnectionPool.MIN_IDLE_CONNECTIONS).intValue();
                if (minIdleConnections < 0) {
                    throw new ApplicationError("ConnectionPool field 'minIdleConnections' cannot be negative.");
                }
                config.setMinimumIdle(minIdleConnections);
                double connectionTimeout = this.getDoubleFromBDecimal((BMap<BString, Object>)sqlDatasourceParams.connectionPool, Constants.ConnectionPool.CONNECTION_TIMEOUT);
                if (connectionTimeout < 0.0) {
                    throw new ApplicationError("ConnectionPool field 'connectionTimeout' cannot be negative.");
                }
                long connectionTimeoutMS = (long)(connectionTimeout * 1000.0);
                config.setConnectionTimeout(connectionTimeoutMS);
                double idleTimeout = this.getDoubleFromBDecimal((BMap<BString, Object>)sqlDatasourceParams.connectionPool, Constants.ConnectionPool.IDLE_TIMEOUT);
                if (idleTimeout < 0.0) {
                    throw new ApplicationError("ConnectionPool field 'idleTimeout' cannot be negative.");
                }
                long idleTimeoutMS = (long)(idleTimeout * 1000.0);
                config.setIdleTimeout(idleTimeoutMS);
                double validationTimeout = this.getDoubleFromBDecimal((BMap<BString, Object>)sqlDatasourceParams.connectionPool, Constants.ConnectionPool.VALIDATION_TIMEOUT);
                if (validationTimeout < 0.0) {
                    throw new ApplicationError("ConnectionPool field 'validationTimeout' cannot be negative.");
                }
                long validationTimeoutMS = (long)(validationTimeout * 1000.0);
                config.setValidationTimeout(validationTimeoutMS);
                double leakDetectionThreshold = this.getDoubleFromBDecimal((BMap<BString, Object>)sqlDatasourceParams.connectionPool, Constants.ConnectionPool.LEAK_DETECTION_THRESHOLD);
                if (leakDetectionThreshold < 0.0) {
                    throw new ApplicationError("ConnectionPool field 'leakDetectionThreshold' cannot be negative.");
                }
                long leakDetectionThresholdMS = (long)(leakDetectionThreshold * 1000.0);
                config.setLeakDetectionThreshold(leakDetectionThresholdMS);
                double keepAliveTime = this.getDoubleFromBDecimal((BMap<BString, Object>)sqlDatasourceParams.connectionPool, Constants.ConnectionPool.KEEP_ALIVE_TIME);
                if (keepAliveTime < 0.0) {
                    throw new ApplicationError("ConnectionPool field 'keepAliveTime' cannot be negative.");
                }
                long keepAliveTimeMS = (long)(keepAliveTime * 1000.0);
                config.setKeepaliveTime(keepAliveTimeMS);
                Object connectionPoolName = sqlDatasourceParams.connectionPool.get((Object)Constants.ConnectionPool.POOL_NAME);
                if (connectionPoolName instanceof BString) {
                    BString poolName = (BString)connectionPoolName;
                    config.setPoolName(poolName.getValue());
                }
                double initializationFailTimeout = this.getDoubleFromBDecimal((BMap<BString, Object>)sqlDatasourceParams.connectionPool, Constants.ConnectionPool.INITIALIZATION_FAIL_TIMEOUT);
                long initializationFailTimeoutMS = (long)(initializationFailTimeout * 1000.0);
                config.setInitializationFailTimeout(initializationFailTimeoutMS);
                Object transactionIsolation = sqlDatasourceParams.connectionPool.get((Object)Constants.ConnectionPool.TRANSACTION_ISOLATION);
                if (transactionIsolation instanceof BString) {
                    BString isolation = (BString)transactionIsolation;
                    config.setTransactionIsolation(isolation.getValue());
                }
                if ((connectionTestQuery = sqlDatasourceParams.connectionPool.get((Object)Constants.ConnectionPool.CONNECTION_TEST_QUERY)) instanceof BString) {
                    BString testQuery = (BString)connectionTestQuery;
                    config.setConnectionTestQuery(testQuery.getValue());
                }
                if ((connectionInitSql = sqlDatasourceParams.connectionPool.get((Object)Constants.ConnectionPool.CONNECTION_INIT_SQL)) != null) {
                    if (connectionInitSql instanceof BString) {
                        BString sqlString = (BString)connectionInitSql;
                        config.setConnectionInitSql(sqlString.getValue());
                    } else if (connectionInitSql instanceof BArray) {
                        BArray sqlArray = (BArray)connectionInitSql;
                        StringBuilder sqlBuilder = new StringBuilder();
                        for (int i = 0; i < sqlArray.size(); ++i) {
                            if (i > 0) {
                                sqlBuilder.append("; ");
                            }
                            sqlBuilder.append(((BString)sqlArray.get((long)i)).getValue());
                        }
                        config.setConnectionInitSql(sqlBuilder.toString());
                    }
                }
                boolean readOnly = sqlDatasourceParams.connectionPool.getBooleanValue(Constants.ConnectionPool.READ_ONLY);
                config.setReadOnly(readOnly);
                boolean allowPoolSuspension = sqlDatasourceParams.connectionPool.getBooleanValue(Constants.ConnectionPool.ALLOW_POOL_SUSPENSION);
                config.setAllowPoolSuspension(allowPoolSuspension);
                boolean isolateInternalQueries = sqlDatasourceParams.connectionPool.getBooleanValue(Constants.ConnectionPool.ISOLATE_INTERNAL_QUERIES);
                config.setIsolateInternalQueries(isolateInternalQueries);
            }
            if (sqlDatasourceParams.options != null) {
                BMap optionMap = sqlDatasourceParams.options;
                optionMap.entrySet().forEach(entry -> config.addDataSourceProperty(((BString)entry.getKey()).getValue(), entry.getValue()));
            }
            HikariDataSource hikariDataSource = new HikariDataSource(config);
            Runtime.getRuntime().addShutdownHook(new Thread(this::closeConnectionPool));
            return hikariDataSource;
        }
        catch (Throwable t) {
            throw ErrorGenerator.getSQLApplicationError(this.buildErrorMessage(t));
        }
    }

    private AtomikosDataSourceBean buildXAAwareDataSource(SQLDatasourceParams sqlDatasourceParams) {
        AtomikosDataSourceBean atomikosDataSource = new AtomikosDataSourceBean();
        try {
            Properties xaProperties = new Properties();
            if (sqlDatasourceParams.datasourceName != null && !sqlDatasourceParams.datasourceName.isEmpty()) {
                if (sqlDatasourceParams.options == null || !sqlDatasourceParams.options.containsKey((Object)Constants.Options.URL)) {
                    xaProperties.setProperty(Constants.Options.URL.getValue(), sqlDatasourceParams.url);
                }
                if (sqlDatasourceParams.user != null) {
                    xaProperties.setProperty("user", sqlDatasourceParams.user);
                }
                if (sqlDatasourceParams.password != null) {
                    xaProperties.setProperty("password", sqlDatasourceParams.password);
                }
            }
            if (sqlDatasourceParams.connectionPool != null) {
                BDecimal connLifeTime;
                Object connLifeTimeSec;
                int maxOpenConn = sqlDatasourceParams.connectionPool.getIntValue(Constants.ConnectionPool.MAX_OPEN_CONNECTIONS).intValue();
                if (maxOpenConn > 0) {
                    atomikosDataSource.setMaxPoolSize(maxOpenConn);
                }
                if ((connLifeTimeSec = sqlDatasourceParams.connectionPool.get((Object)Constants.ConnectionPool.MAX_CONNECTION_LIFE_TIME)) instanceof BDecimal && (connLifeTime = (BDecimal)connLifeTimeSec).floatValue() > 0.0) {
                    atomikosDataSource.setMaxLifetime(Double.valueOf(connLifeTime.floatValue()).intValue());
                }
            }
            if (sqlDatasourceParams.options != null) {
                BMap optionMap = sqlDatasourceParams.options;
                optionMap.entrySet().forEach(entry -> xaProperties.setProperty(((BString)entry.getKey()).getValue(), entry.getValue().toString()));
            }
            atomikosDataSource.setXaProperties(xaProperties);
            atomikosDataSource.setUniqueResourceName(UUID.randomUUID().toString());
            atomikosDataSource.setXaDataSourceClassName(sqlDatasourceParams.datasourceName);
            Runtime.getRuntime().addShutdownHook(new Thread(this::closeConnectionPool));
            return atomikosDataSource;
        }
        catch (Throwable t) {
            throw ErrorGenerator.getSQLApplicationError(this.buildErrorMessage(t));
        }
    }

    private String buildErrorMessage(Throwable t) {
        if (t.getCause() instanceof ClassNotFoundException) {
            return "Error while loading database driver. This may be because the database driver path is not configured correctly in the `Ballerina.toml` file or provided database driver version is not supported by the connector";
        }
        StringBuilder message = new StringBuilder("Error in SQL connector configuration: " + t.getMessage());
        int count = 0;
        while (t.getCause() != null && count < 3) {
            String lastCauseMessage = t.getCause().getMessage();
            message.append(" Caused by :").append(lastCauseMessage);
            ++count;
            t = t.getCause();
        }
        return message.toString();
    }

    private void setExecuteGKFlag(boolean flag) {
        this.executeGKFlag = flag;
    }

    private void setBatchExecuteGKFlag(boolean flag) {
        this.batchExecuteGKFlag = flag;
    }

    public boolean getExecuteGKFlag() {
        return this.executeGKFlag;
    }

    public boolean getBatchExecuteGKFlag() {
        return this.batchExecuteGKFlag;
    }

    private double getDoubleFromBDecimal(BMap<BString, Object> map, BString key) {
        Object value = map.get((Object)key);
        if (value instanceof BDecimal) {
            return ((BDecimal)value).floatValue();
        }
        return 0.0;
    }

    public static class SQLDatasourceParams {
        private String url;
        private String user;
        private String password;
        private String datasourceName;
        private BMap connectionPool = null;
        private BMap options;
        private Properties poolProperties;

        public SQLDatasourceParams setConnectionPool(BMap connectionPool, BMap globalConnectionPool) {
            this.connectionPool = connectionPool != null ? connectionPool : globalConnectionPool;
            return this;
        }

        public SQLDatasourceParams setUrl(String url) {
            this.url = url;
            return this;
        }

        public SQLDatasourceParams setUser(String user) {
            this.user = user;
            return this;
        }

        public SQLDatasourceParams setPassword(String password) {
            this.password = password;
            return this;
        }

        public SQLDatasourceParams setDatasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return this;
        }

        public SQLDatasourceParams setOptions(BMap options) {
            this.options = options;
            return this;
        }

        public SQLDatasourceParams setPoolProperties(Properties properties) {
            this.poolProperties = properties;
            return this;
        }
    }
}

