/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.exception;

import io.ballerina.stdlib.sql.exception.DataError;
import java.util.Arrays;

public class TypeMismatchError
extends DataError {
    public TypeMismatchError(String sqlType, String typeFound, String typeExpected) {
        super(String.format("The ballerina type expected for '%s' type is '%s' but found type '%s'.", sqlType, typeExpected, typeFound));
    }

    public TypeMismatchError(String sqlType, String typeFound, String[] typeExpected) {
        super(String.format("The ballerina type expected for '%s' type are '%s' but found type '%s'.", sqlType, String.join((CharSequence)"', and '", String.join((CharSequence)"', '", Arrays.copyOf(typeExpected, typeExpected.length - 1)), typeExpected[typeExpected.length - 1]), typeFound));
    }

    public TypeMismatchError(String sqlType, String typeFound) {
        super(String.format("SQL Type '%s' cannot be converted to ballerina type '%s'.", sqlType, typeFound));
    }

    public TypeMismatchError(String message) {
        super(message);
    }

    public TypeMismatchError(String message, Exception error) {
        super(message, error);
    }
}

