/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.nativeimpl;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.sql.datasource.SQLDatasource;
import io.ballerina.stdlib.sql.utils.Utils;
import java.util.UUID;

public class ClientProcessor {
    private ClientProcessor() {
    }

    public static Object close(BObject client) {
        Utils.disableHikariLogs();
        Object datasourceObj = client.getNativeData("Client");
        if (datasourceObj != null) {
            ((SQLDatasource)datasourceObj).decrementClientCounterAndAttemptPoolShutdown();
            client.addNativeData("clientActive", (Object)Boolean.FALSE);
        }
        return null;
    }

    public static Object createClient(BObject client, SQLDatasource.SQLDatasourceParams sqlDatasourceParams, boolean executeGKFlag, boolean batchExecuteGKFlag) {
        try {
            Utils.disableHikariLogs();
            SQLDatasource sqlDatasource = SQLDatasource.retrieveDatasource(sqlDatasourceParams, executeGKFlag, batchExecuteGKFlag);
            client.addNativeData("Client", (Object)sqlDatasource);
            client.addNativeData("sql-transaction-id", (Object)UUID.randomUUID().toString());
            client.addNativeData("clientActive", (Object)Boolean.TRUE);
            return null;
        }
        catch (BError errorValue) {
            return errorValue;
        }
    }
}

