/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.exception.ConversionError;
import io.ballerina.stdlib.sql.exception.DataError;
import io.ballerina.stdlib.sql.exception.FieldMismatchError;
import io.ballerina.stdlib.sql.exception.TypeMismatchError;
import io.ballerina.stdlib.sql.exception.UnsupportedTypeError;
import io.ballerina.stdlib.sql.utils.ModuleUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class ErrorGenerator {
    public static final String JAVA_CLASS_NAME_REGEX = "([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)+[\\p{L}_$][\\p{L}\\p{N}_$]*: ";

    private ErrorGenerator() {
    }

    public static BError getSQLBatchExecuteError(SQLException exception, List<BMap<BString, Object>> executionResults, String messagePrefix) {
        String sqlErrorMessage = exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName();
        int vendorCode = exception.getErrorCode();
        String sqlState = exception.getSQLState();
        String errorMessage = messagePrefix + sqlErrorMessage + ".";
        return ErrorGenerator.getSQLBatchExecuteError(errorMessage, vendorCode, sqlState, executionResults);
    }

    public static BError getSQLDatabaseError(SQLException exception, String messagePrefix) {
        String sqlErrorMessage = exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName();
        int vendorCode = exception.getErrorCode();
        String sqlState = exception.getSQLState();
        String errorMessage = messagePrefix + sqlErrorMessage + ".";
        return ErrorGenerator.getSQLDatabaseError(errorMessage, vendorCode, sqlState);
    }

    public static BError getSQLApplicationError(String errorMessage) {
        errorMessage = ErrorGenerator.removeJavaClassNames(errorMessage);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"ApplicationError", (BString)StringUtils.fromString((String)errorMessage), null, null);
    }

    public static BError getSQLApplicationError(ApplicationError error) {
        return ErrorGenerator.getSQLApplicationError(error, "");
    }

    public static BError getSQLApplicationError(ApplicationError error, String messagePrefix) {
        Object message = error.getMessage() != null ? error.getMessage() : error.getClass().getSimpleName();
        message = messagePrefix + (String)message;
        String errorName = error instanceof ConversionError ? "ConversionError" : (error instanceof TypeMismatchError ? "TypeMismatchError" : (error instanceof FieldMismatchError ? "FieldMismatchError" : (error instanceof UnsupportedTypeError ? "UnsupportedTypeError" : (error instanceof DataError ? "DataError" : "ApplicationError"))));
        message = ErrorGenerator.removeJavaClassNames((String)message);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorName, (BString)StringUtils.fromString((String)message), null, null);
    }

    public static BError getSQLError(Throwable th, String thMessage) {
        String message = th.getMessage() != null ? th.getMessage() : th.getClass().getSimpleName();
        thMessage = ErrorGenerator.removeJavaClassNames(thMessage);
        message = ErrorGenerator.removeJavaClassNames(message);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"Error", (BString)StringUtils.fromString((String)(thMessage + message)), null, null);
    }

    public static BError getNoRowsError(String message) {
        message = ErrorGenerator.removeJavaClassNames(message);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"NoRowsError", (BString)StringUtils.fromString((String)message), null, null);
    }

    private static BError getSQLBatchExecuteError(String message, int vendorCode, String sqlState, List<BMap<BString, Object>> executionResults) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("errorCode", vendorCode);
        valueMap.put("sqlState", sqlState);
        valueMap.put("executionResults", ValueCreator.createArrayValue((Object[])executionResults.toArray(), (ArrayType)TypeCreator.createArrayType((Type)TypeCreator.createRecordType((String)"ExecutionResult", (Module)ModuleUtils.getModule(), (long)0L, (boolean)false, (int)0))));
        BMap sqlClientErrorDetailRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"BatchExecuteErrorDetail", valueMap);
        message = ErrorGenerator.removeJavaClassNames(message);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"BatchExecuteError", (BString)StringUtils.fromString((String)message), null, (BMap)sqlClientErrorDetailRecord);
    }

    private static BError getSQLDatabaseError(String message, int vendorCode, String sqlState) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("errorCode", vendorCode);
        valueMap.put("sqlState", sqlState);
        BMap sqlClientErrorDetailRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"DatabaseErrorDetail", valueMap);
        message = ErrorGenerator.removeJavaClassNames(message);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"DatabaseError", (BString)StringUtils.fromString((String)message), null, (BMap)sqlClientErrorDetailRecord);
    }

    private static String removeJavaClassNames(String message) {
        return message.replaceAll(JAVA_CLASS_NAME_REGEX, "");
    }
}

