/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.BallerinaTypes;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.projects.Document;
import java.util.Map;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public abstract class Types {
    protected static final CompilerContext.Key<BallerinaTypes> TYPES_KEY = new CompilerContext.Key();
    protected final CompilerContext context;
    protected final SymbolFactory symbolFactory;
    protected final SymbolTable symbolTable;
    protected final PackageCache packageCache;
    protected final BLangPackage bLangPackage;
    public final TypeSymbol BOOLEAN;
    public final TypeSymbol INT;
    public final TypeSymbol FLOAT;
    public final TypeSymbol DECIMAL;
    public final TypeSymbol STRING;
    public final TypeSymbol NIL;
    public final TypeSymbol XML;
    public final TypeSymbol ERROR;
    public final TypeSymbol FUNCTION;
    public final TypeSymbol FUTURE;
    public final TypeSymbol TYPEDESC;
    public final TypeSymbol HANDLE;
    public final TypeSymbol STREAM;
    public final TypeSymbol ANY;
    public final TypeSymbol ANYDATA;
    public final TypeSymbol NEVER;
    public final TypeSymbol READONLY;
    public final TypeSymbol JSON;
    public final TypeSymbol BYTE;
    public final TypeSymbol COMPILATION_ERROR;
    public final TypeSymbol REGEX;
    public final TypeSymbol RAW_TEMPLATE;

    protected Types(BLangPackage bLangPackage, CompilerContext context) {
        this.bLangPackage = bLangPackage;
        this.context = context;
        TypesFactory typesFactory = TypesFactory.getInstance(context);
        this.symbolFactory = SymbolFactory.getInstance(context);
        this.symbolTable = SymbolTable.getInstance(context);
        this.packageCache = PackageCache.getInstance(context);
        this.BOOLEAN = typesFactory.getTypeDescriptor(this.symbolTable.booleanType);
        this.INT = typesFactory.getTypeDescriptor(this.symbolTable.intType);
        this.FLOAT = typesFactory.getTypeDescriptor(this.symbolTable.floatType);
        this.DECIMAL = typesFactory.getTypeDescriptor(this.symbolTable.decimalType);
        this.STRING = typesFactory.getTypeDescriptor(this.symbolTable.stringType);
        this.NIL = typesFactory.getTypeDescriptor(this.symbolTable.nilType);
        this.XML = typesFactory.getTypeDescriptor(this.symbolTable.xmlType);
        this.ERROR = typesFactory.getTypeDescriptor(this.symbolTable.errorType);
        this.FUNCTION = typesFactory.getTypeDescriptor(this.symbolTable.invokableType);
        this.FUTURE = typesFactory.getTypeDescriptor(this.symbolTable.futureType);
        this.TYPEDESC = typesFactory.getTypeDescriptor(this.symbolTable.typeDesc);
        this.HANDLE = typesFactory.getTypeDescriptor(this.symbolTable.handleType);
        this.STREAM = typesFactory.getTypeDescriptor(this.symbolTable.streamType);
        this.ANY = typesFactory.getTypeDescriptor(this.symbolTable.anyType);
        this.ANYDATA = typesFactory.getTypeDescriptor(this.symbolTable.anydataType);
        this.NEVER = typesFactory.getTypeDescriptor(this.symbolTable.neverType);
        this.READONLY = typesFactory.getTypeDescriptor(this.symbolTable.readonlyType);
        this.JSON = typesFactory.getTypeDescriptor(this.symbolTable.jsonType);
        this.BYTE = typesFactory.getTypeDescriptor(this.symbolTable.byteType);
        this.COMPILATION_ERROR = typesFactory.getTypeDescriptor(this.symbolTable.semanticError);
        this.REGEX = typesFactory.getTypeDescriptor(this.symbolTable.regExpType);
        this.RAW_TEMPLATE = typesFactory.getTypeDescriptor(this.symbolTable.rawTemplateType);
    }

    public abstract Optional<TypeSymbol> getType(Document var1, String var2);

    public abstract Optional<TypeSymbol> getType(Document var1, String var2, Map<String, BLangPackage> var3);

    public abstract Optional<Symbol> getTypeByName(String var1, String var2, String var3, String var4);

    public abstract Optional<Map<String, Symbol>> typesInModule(String var1, String var2, String var3);

    public abstract TypeBuilder builder();
}

