/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.impl.BallerinaTypes;
import io.ballerina.compiler.api.impl.EnvironmentResolver;
import io.ballerina.compiler.api.impl.ExpectedTypeFinder;
import io.ballerina.compiler.api.impl.NodeFinder;
import io.ballerina.compiler.api.impl.PositionUtil;
import io.ballerina.compiler.api.impl.ReferenceFinder;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.SymbolFinder;
import io.ballerina.compiler.api.impl.SyntaxNodeToLocationMapper;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeReferenceTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.DiagnosticState;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import io.ballerina.types.Core;
import io.ballerina.types.SemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.SourceKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BallerinaSemanticModel
implements SemanticModel {
    private final BLangPackage bLangPackage;
    private final CompilerContext compilerContext;
    private final SymbolFactory symbolFactory;
    private final TypesFactory typesFactory;
    private final SymbolTable symbolTable;
    private final Types types;

    public BallerinaSemanticModel(BLangPackage bLangPackage, CompilerContext context) {
        this.compilerContext = context;
        this.bLangPackage = bLangPackage;
        this.symbolFactory = SymbolFactory.getInstance(context);
        this.typesFactory = TypesFactory.getInstance(context);
        this.symbolTable = SymbolTable.getInstance(context);
        this.types = new BallerinaTypes(bLangPackage, this.compilerContext);
    }

    @Override
    public Types types() {
        return this.types;
    }

    @Override
    public List<Symbol> visibleSymbols(Document srcFile, LinePosition linePosition) {
        return this.visibleSymbols(srcFile, linePosition, DiagnosticState.VALID, DiagnosticState.UNKNOWN_TYPE);
    }

    @Override
    public List<Symbol> visibleSymbols(Document sourceFile, LinePosition position, DiagnosticState ... states) {
        Optional<BLangCompilationUnit> optionalCompUnit = this.getCompilationUnit(sourceFile);
        if (optionalCompUnit.isEmpty()) {
            return Collections.emptyList();
        }
        BLangCompilationUnit compilationUnit = optionalCompUnit.get();
        BPackageSymbol moduleSymbol = this.getModuleSymbol(compilationUnit);
        SymbolTable symbolTable = SymbolTable.getInstance(this.compilerContext);
        SymbolEnv pkgEnv = symbolTable.pkgEnvMap.get(moduleSymbol);
        EnvironmentResolver envResolver = new EnvironmentResolver(pkgEnv);
        SymbolResolver symbolResolver = SymbolResolver.getInstance(this.compilerContext);
        SymbolEnv symbolEnv = envResolver.lookUp(compilationUnit, position);
        Map<Name, List<Scope.ScopeEntry>> scopeSymbols = symbolResolver.getAllVisibleInScopeSymbols(symbolEnv);
        BLangDiagnosticLocation cursorPos = new BLangDiagnosticLocation(compilationUnit.name, position.line(), position.line(), position.offset(), position.offset());
        HashSet<DiagnosticState> statesSet = new HashSet<DiagnosticState>(Arrays.asList(states));
        HashSet<Symbol> compiledSymbols = new HashSet<Symbol>();
        for (Map.Entry<Name, List<Scope.ScopeEntry>> entry : scopeSymbols.entrySet()) {
            Name name = entry.getKey();
            List<Scope.ScopeEntry> scopeEntries = entry.getValue();
            for (Scope.ScopeEntry scopeEntry : scopeEntries) {
                this.addToCompiledSymbols(compiledSymbols, scopeEntry, cursorPos, name, symbolEnv, statesSet, compilationUnit.getName());
            }
        }
        return new ArrayList<Symbol>(compiledSymbols);
    }

    @Override
    public Optional<Symbol> symbol(Document sourceDocument, LinePosition position) {
        Optional<BLangCompilationUnit> compilationUnit = this.getCompilationUnit(sourceDocument);
        if (compilationUnit.isEmpty()) {
            return Optional.empty();
        }
        return this.lookupSymbol(compilationUnit.get(), position);
    }

    @Override
    public Optional<Symbol> symbol(Node node) {
        Optional nodeIdentifierLocation = (Optional)node.apply((NodeTransformer)new SyntaxNodeToLocationMapper());
        if (nodeIdentifierLocation.isEmpty()) {
            return Optional.empty();
        }
        Optional<BLangCompilationUnit> compilationUnit = this.getCompilationUnit(((Location)nodeIdentifierLocation.get()).lineRange().fileName());
        if (compilationUnit.isEmpty()) {
            return Optional.empty();
        }
        return this.lookupSymbol(compilationUnit.get(), ((Location)nodeIdentifierLocation.get()).lineRange().startLine());
    }

    @Override
    public List<Symbol> moduleSymbols() {
        ArrayList<Symbol> compiledSymbols = new ArrayList<Symbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> e : this.bLangPackage.symbol.scope.entries.entrySet()) {
            Scope.ScopeEntry value = e.getValue();
            BSymbol symbol = value.symbol;
            if (symbol.origin != SymbolOrigin.SOURCE) continue;
            compiledSymbols.add(this.symbolFactory.getBCompiledSymbol(symbol, symbol.getOriginalName().getValue()));
        }
        return compiledSymbols;
    }

    @Override
    public List<Location> references(Symbol symbol) {
        return this.references(symbol, true);
    }

    @Override
    public List<Location> references(Document sourceDocument, LinePosition position) {
        BSymbol symbolAtCursor = this.findSymbolAtCursorPosition(sourceDocument, position);
        if (symbolAtCursor == null) {
            return Collections.emptyList();
        }
        Location symbolLocation = symbolAtCursor.getPosition();
        BLangNode node = new NodeFinder(false).lookupEnclosingContainer(this.bLangPackage, symbolLocation.lineRange());
        return this.getReferences(symbolAtCursor, node, true);
    }

    @Override
    public List<Location> references(Symbol symbol, boolean withDefinition) {
        BSymbol symbolAtCursor = this.getInternalSymbol(symbol);
        Optional<Location> symbolLocation = symbol.getLocation();
        if (symbolLocation.isEmpty()) {
            return Collections.emptyList();
        }
        BLangNode node = new NodeFinder(false).lookupEnclosingContainer(this.bLangPackage, symbolLocation.get().lineRange());
        return this.getReferences(symbolAtCursor, node, withDefinition);
    }

    @Override
    public List<Location> references(Document sourceDocument, LinePosition position, boolean withDefinition) {
        BSymbol symbolAtCursor = this.findSymbolAtCursorPosition(sourceDocument, position);
        if (symbolAtCursor == null) {
            return Collections.emptyList();
        }
        Location symbolLocation = symbolAtCursor.getPosition();
        BLangNode node = new NodeFinder(false).lookupEnclosingContainer(this.bLangPackage, symbolLocation.lineRange());
        return this.getReferences(symbolAtCursor, node, withDefinition);
    }

    @Override
    public List<Location> references(Symbol symbol, Document targetDocument, boolean withDefinition) {
        BSymbol symbolAtCursor = this.getInternalSymbol(symbol);
        Optional<Location> symbolLocation = symbol.getLocation();
        if (symbolLocation.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<BLangCompilationUnit> compilationUnit = this.getCompilationUnit(targetDocument);
        if (compilationUnit.isEmpty()) {
            return Collections.emptyList();
        }
        BLangNode node = new NodeFinder(false).lookupEnclosingContainer(compilationUnit.get(), symbolLocation.get().lineRange());
        return this.getReferences(symbolAtCursor, node, withDefinition);
    }

    @Override
    public List<Location> references(Document sourceDocument, Document targetDocument, LinePosition position, boolean withDefinition) {
        BSymbol symbolAtCursor = this.findSymbolAtCursorPosition(sourceDocument, position);
        if (symbolAtCursor == null) {
            return Collections.emptyList();
        }
        Location symbolLocation = symbolAtCursor.getPosition();
        Optional<BLangCompilationUnit> compilationUnit = this.getCompilationUnit(targetDocument);
        if (compilationUnit.isEmpty()) {
            return Collections.emptyList();
        }
        BLangNode node = new NodeFinder(false).lookupEnclosingContainer(compilationUnit.get(), symbolLocation.lineRange());
        return this.getReferences(symbolAtCursor, node, withDefinition);
    }

    private BSymbol findSymbolAtCursorPosition(Document sourceDocument, LinePosition linePosition) {
        Optional<BLangCompilationUnit> sourceCompilationUnit = this.getCompilationUnit(sourceDocument);
        if (sourceCompilationUnit.isEmpty()) {
            return null;
        }
        SymbolFinder symbolFinder = new SymbolFinder();
        return symbolFinder.lookup(sourceCompilationUnit.get(), linePosition);
    }

    private List<Location> getReferences(BSymbol symbol, BLangNode node, boolean withDefinition) {
        ReferenceFinder refFinder = new ReferenceFinder(withDefinition);
        return refFinder.findReferences(node, symbol);
    }

    @Override
    public Optional<TypeSymbol> type(LineRange range) {
        Optional<BLangCompilationUnit> compilationUnit = this.getCompilationUnit(range.fileName());
        if (compilationUnit.isEmpty()) {
            return Optional.empty();
        }
        NodeFinder nodeFinder = new NodeFinder(true);
        BLangNode node = nodeFinder.lookup(compilationUnit.get(), range);
        if (node == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.typesFactory.getTypeDescriptor(node.getBType()));
    }

    @Override
    public Optional<TypeSymbol> typeOf(LineRange range) {
        Optional<BLangCompilationUnit> compilationUnit = this.getCompilationUnit(range.fileName());
        if (compilationUnit.isEmpty()) {
            return Optional.empty();
        }
        NodeFinder nodeFinder = new NodeFinder(false);
        BLangNode node = nodeFinder.lookup(compilationUnit.get(), range);
        if (!(this.isNonNamedArgExprNode(node) || this.isObjectConstructorExpr(node) || this.isAnonFunctionExpr(node))) {
            return Optional.empty();
        }
        BType determinedType = this.getDeterminedType(node, range);
        return Optional.ofNullable(this.typesFactory.getTypeDescriptor(determinedType));
    }

    private BType getDeterminedType(BLangNode node, LineRange range) {
        BLangInvocation invocationNode;
        if (node.getKind() == NodeKind.INVOCATION && node.getDeterminedType() != null && node.getDeterminedType().getKind() == TypeKind.FUTURE && (invocationNode = (BLangInvocation)node).isAsync() && PositionUtil.withinBlock(range.startLine(), invocationNode.getName().getPosition())) {
            return ((BFutureType)node.getDeterminedType()).getConstraint();
        }
        return node.getDeterminedType();
    }

    @Override
    public Optional<TypeSymbol> type(Node node) {
        Optional nodeIdentifierLocation = (Optional)node.apply((NodeTransformer)new SyntaxNodeToLocationMapper());
        if (nodeIdentifierLocation.isEmpty()) {
            return Optional.empty();
        }
        return this.type(node.location().lineRange());
    }

    @Override
    public Optional<TypeSymbol> typeOf(Node node) {
        Optional nodeIdentifierLocation = (Optional)node.apply((NodeTransformer)new SyntaxNodeToLocationMapper());
        if (nodeIdentifierLocation.isEmpty()) {
            return Optional.empty();
        }
        return this.typeOf(node.location().lineRange());
    }

    @Override
    public List<Diagnostic> diagnostics(LineRange range) {
        List<Diagnostic> allDiagnostics = this.bLangPackage.getDiagnostics();
        ArrayList<Diagnostic> filteredDiagnostics = new ArrayList<Diagnostic>();
        for (Diagnostic diagnostic : allDiagnostics) {
            LineRange lineRange = diagnostic.location().lineRange();
            if (!lineRange.fileName().equals(range.fileName()) || !PositionUtil.withinRange(lineRange, range)) continue;
            filteredDiagnostics.add(diagnostic);
        }
        return filteredDiagnostics;
    }

    @Override
    public List<Diagnostic> diagnostics() {
        return this.bLangPackage.getDiagnostics();
    }

    @Override
    public Optional<TypeSymbol> expectedType(Document sourceDocument, LinePosition linePosition) {
        Optional typeSymbol = null;
        Optional<BLangCompilationUnit> compilationUnit = this.getCompilationUnit(sourceDocument);
        if (compilationUnit.isEmpty()) {
            return Optional.empty();
        }
        SyntaxTree syntaxTree = sourceDocument.syntaxTree();
        ExpectedTypeFinder expectedTypeFinder = new ExpectedTypeFinder(this, compilationUnit.get(), this.compilerContext, linePosition, sourceDocument);
        for (NonTerminalNode node = BallerinaSemanticModel.findInnerMostNode(linePosition, syntaxTree); node != null; node = node.parent()) {
            try {
                typeSymbol = (Optional)node.apply((NodeTransformer)expectedTypeFinder);
            }
            catch (IllegalStateException e) {
                break;
            }
            if (typeSymbol != null && typeSymbol.isPresent()) break;
        }
        return typeSymbol == null ? Optional.empty() : typeSymbol;
    }

    private Optional<Symbol> lookupSymbol(BLangCompilationUnit compilationUnit, LinePosition position) {
        SymbolFinder symbolFinder = new SymbolFinder();
        BSymbol symbolAtCursor = symbolFinder.lookup(compilationUnit, position);
        if (symbolAtCursor == null || symbolAtCursor == this.symbolTable.notFoundSymbol) {
            return Optional.empty();
        }
        if (symbolAtCursor.kind == org.ballerinalang.model.symbols.SymbolKind.TYPE_DEF && this.isCursorNotAtDefinition(compilationUnit, symbolAtCursor, position)) {
            return Optional.ofNullable(this.typesFactory.getTypeDescriptor(((BTypeDefinitionSymbol)symbolAtCursor).referenceType));
        }
        if (this.isTypeSymbol(symbolAtCursor) && (this.isInlineSingletonType(symbolAtCursor) || this.isInlineErrorType(symbolAtCursor) || this.isCursorNotAtDefinition(compilationUnit, symbolAtCursor, position))) {
            return Optional.ofNullable(this.typesFactory.getTypeDescriptor(symbolAtCursor.type, symbolAtCursor));
        }
        return Optional.ofNullable(this.symbolFactory.getBCompiledSymbol(symbolAtCursor, symbolAtCursor.getOriginalName().getValue()));
    }

    private boolean hasCursorPosPassedSymbolPos(BSymbol symbol, Location cursorPos) {
        if (symbol.origin != SymbolOrigin.SOURCE) {
            return false;
        }
        if (symbol.owner.getKind() == org.ballerinalang.model.symbols.SymbolKind.OBJECT || symbol.owner.getKind() == org.ballerinalang.model.symbols.SymbolKind.PACKAGE || Symbols.isFlagOn(symbol.flags, 0x800000L)) {
            return true;
        }
        if (!this.bLangPackage.packageID.equals(symbol.pkgID)) {
            return false;
        }
        LinePosition cursorPosStartLine = cursorPos.lineRange().startLine();
        LinePosition symbolStartLine = symbol.pos.lineRange().startLine();
        if (cursorPosStartLine.line() < symbolStartLine.line()) {
            return false;
        }
        if (cursorPosStartLine.line() > symbolStartLine.line()) {
            return true;
        }
        return cursorPosStartLine.offset() > symbolStartLine.offset();
    }

    private boolean isImportedSymbol(BSymbol symbol) {
        return symbol.origin == SymbolOrigin.COMPILED_SOURCE && (Symbols.isFlagOn(symbol.flags, 1L) || symbol.getKind() == org.ballerinalang.model.symbols.SymbolKind.PACKAGE);
    }

    private Optional<BLangCompilationUnit> getCompilationUnit(Document srcFile) {
        return this.getCompilationUnit(srcFile.name());
    }

    private Optional<BLangCompilationUnit> getCompilationUnit(String srcFile) {
        ArrayList testSrcs = new ArrayList();
        for (BLangTestablePackage pkg : this.bLangPackage.testablePkgs) {
            testSrcs.addAll(pkg.compUnits);
        }
        Stream units = Stream.concat(this.bLangPackage.compUnits.stream(), testSrcs.stream());
        return units.filter(unit -> unit.name.equals(srcFile)).findFirst();
    }

    private boolean isCursorNotAtDefinition(BLangCompilationUnit compilationUnit, BSymbol symbolAtCursor, LinePosition cursorPos) {
        return !compilationUnit.getPackageID().equals(symbolAtCursor.pkgID) || !compilationUnit.getName().equals(symbolAtCursor.pos.lineRange().fileName()) || !PositionUtil.withinBlock(cursorPos, symbolAtCursor.pos);
    }

    private boolean isInlineSingletonType(BSymbol symbol) {
        BType type = org.wso2.ballerinalang.compiler.semantics.analyzer.Types.getImpliedType(symbol.type);
        return symbol.kind != org.ballerinalang.model.symbols.SymbolKind.TYPE_DEF && type.tag == 33 && Core.singleShape((SemType)symbol.type.semType()).isPresent();
    }

    private boolean isInlineErrorType(BSymbol symbol) {
        return org.wso2.ballerinalang.compiler.semantics.analyzer.Types.getImpliedType((BType)symbol.type).tag == 29 && Symbols.isFlagOn(symbol.type.getFlags(), 2048L);
    }

    private boolean isTypeSymbol(BSymbol tSymbol) {
        if (tSymbol.kind == org.ballerinalang.model.symbols.SymbolKind.TYPE_DEF) {
            return true;
        }
        return tSymbol instanceof BTypeSymbol && !Symbols.isTagOn(tSymbol, 4097L) && !Symbols.isTagOn(tSymbol, 2L);
    }

    private BSymbol getInternalSymbol(Symbol symbol) {
        if (symbol.kind() == SymbolKind.TYPE) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)symbol;
            if (abstractTypeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                return ((BallerinaSymbol)((BallerinaTypeReferenceTypeSymbol)symbol).definition()).getInternalSymbol();
            }
            return abstractTypeSymbol.getBType().tsymbol;
        }
        return ((BallerinaSymbol)symbol).getInternalSymbol();
    }

    private BPackageSymbol getModuleSymbol(BLangCompilationUnit compilationUnit) {
        return compilationUnit.getSourceKind() == SourceKind.REGULAR_SOURCE ? this.bLangPackage.symbol : this.bLangPackage.getTestablePkg().symbol;
    }

    private void addToCompiledSymbols(Set<Symbol> compiledSymbols, Scope.ScopeEntry scopeEntry, Location cursorPos, Name name, SymbolEnv symbolEnv, Set<DiagnosticState> states, String compUnitName) {
        if (scopeEntry == null || scopeEntry.symbol == null || this.isFilteredVarSymbol(scopeEntry.symbol, states)) {
            return;
        }
        BSymbol symbol = scopeEntry.symbol;
        BSymbol symbolEnvScopeOwner = symbolEnv.scope.owner;
        if (this.isIgnorableSelfSymbol(name, symbol, symbolEnvScopeOwner)) {
            return;
        }
        if (this.isWithinCurrentWorker(symbolEnvScopeOwner.flags, symbolEnv.enclEnv, symbol) || this.isCursorWithinClassFieldDecl(symbolEnvScopeOwner.flags) && this.isClassMemberMethod(symbol)) {
            return;
        }
        if (!(!this.hasCursorPosPassedSymbolPos(symbol, cursorPos) && !this.isImportedSymbol(symbol) || this.isServiceDeclSymbol(symbol) || this.isResourceFunction(symbol) || symbol.getKind() == org.ballerinalang.model.symbols.SymbolKind.PACKAGE && !this.isPackageImportedOnTheCompUnit(symbol, compUnitName))) {
            Symbol compiledSymbol = symbol.getKind() == org.ballerinalang.model.symbols.SymbolKind.PACKAGE ? this.symbolFactory.getBCompiledSymbol(symbol, name.getValue()) : this.symbolFactory.getBCompiledSymbol(symbol, symbol.getOriginalName().getValue());
            if (compiledSymbol == null || this.checkAndUpdateModuleSymbols(compiledSymbols, compiledSymbol, symbol)) {
                return;
            }
            if (this.isFieldSymbol(compiledSymbol)) {
                BSymbol scopeEntryOwner = scopeEntry.symbol.owner;
                if (symbolEnvScopeOwner.getName().equals(scopeEntryOwner.getName()) && symbolEnvScopeOwner.pkgID.equals(scopeEntryOwner.pkgID) && symbolEnvScopeOwner.getPosition().equals((Object)scopeEntryOwner.getPosition())) {
                    return;
                }
            }
            compiledSymbols.add(compiledSymbol);
        }
        this.addToCompiledSymbols(compiledSymbols, scopeEntry.next, cursorPos, name, symbolEnv, states, compUnitName);
    }

    private boolean checkAndUpdateModuleSymbols(Set<Symbol> compiledSymbols, Symbol evaluatingSymbol, BSymbol symbol) {
        boolean symbolExists = compiledSymbols.contains(evaluatingSymbol);
        if (!symbolExists) {
            return false;
        }
        if (evaluatingSymbol.kind() != SymbolKind.MODULE) {
            return true;
        }
        if (((BPackageSymbol)symbol).importPrefix != null) {
            compiledSymbols.remove(evaluatingSymbol);
            return false;
        }
        return true;
    }

    private boolean isWithinCurrentWorker(long symbolEnvScopeOwnerFlags, SymbolEnv enclEnv, BSymbol symbol) {
        if (Symbols.isFlagOn(symbolEnvScopeOwnerFlags, 0x800000L) && Symbols.isFlagOn(symbol.flags, 0x800000L) && enclEnv != null && enclEnv.node.getKind() == NodeKind.FUNCTION) {
            BLangIdentifier defaultWorkerName = ((BLangFunction)enclEnv.node).defaultWorkerName;
            return defaultWorkerName.getValue().equals(symbol.getName().getValue()) && defaultWorkerName.getPosition().equals((Object)symbol.getPosition());
        }
        return false;
    }

    private boolean isCursorWithinClassFieldDecl(long symbolEnvScopeOwnerFlags) {
        return Symbols.isFlagOn(symbolEnvScopeOwnerFlags, 0x10000000L);
    }

    private boolean isClassMemberMethod(BSymbol symbol) {
        return symbol.getKind() == org.ballerinalang.model.symbols.SymbolKind.FUNCTION && Symbols.isFlagOn(symbol.flags, 8L) && Symbols.isFlagOn(symbol.owner.flags, 0x10000000L);
    }

    private boolean isFieldSymbol(Symbol symbol) {
        return symbol.kind() == SymbolKind.CLASS_FIELD || symbol.kind() == SymbolKind.OBJECT_FIELD || symbol.kind() == SymbolKind.RECORD_FIELD;
    }

    private boolean isServiceDeclSymbol(BSymbol symbol) {
        return symbol.kind == org.ballerinalang.model.symbols.SymbolKind.SERVICE;
    }

    private boolean isResourceFunction(BSymbol symbol) {
        return Symbols.isFlagOn(symbol.flags, 131072L);
    }

    private boolean isIgnorableSelfSymbol(Name name, BSymbol symbol, BSymbol symbolEnvScopeOwner) {
        return name.value.equals("self") && !symbol.owner.owner.equals(symbolEnvScopeOwner.owner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFilteredVarSymbol(BSymbol symbol, Set<DiagnosticState> states) {
        if (!(symbol instanceof BVarSymbol)) return false;
        BVarSymbol varSymbol = (BVarSymbol)symbol;
        if (states.contains((Object)varSymbol.state)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isObjectConstructorExpr(BLangNode node) {
        if (!(node instanceof BLangClassDefinition)) return false;
        BLangClassDefinition classDefinition = (BLangClassDefinition)node;
        if (!classDefinition.flagSet.contains((Object)Flag.OBJECT_CTOR)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAnonFunctionExpr(BLangNode node) {
        if (node instanceof BLangFunction) {
            BLangFunction bLangFunction = (BLangFunction)node;
            if (bLangFunction.flagSet.contains((Object)Flag.LAMBDA)) return true;
        }
        if (!(node instanceof BLangArrowFunction)) return false;
        return true;
    }

    private boolean isNonNamedArgExprNode(BLangNode node) {
        return node instanceof BLangExpression && !(node instanceof BLangNamedArgsExpression);
    }

    private boolean isPackageImportedOnTheCompUnit(BSymbol symbol, String compUnit) {
        return symbol.getKind() == org.ballerinalang.model.symbols.SymbolKind.PACKAGE && ((BPackageSymbol)symbol).compUnit.getValue().equals(compUnit);
    }

    private static NonTerminalNode findInnerMostNode(LinePosition linePosition, SyntaxTree syntaxTree) {
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(linePosition);
        int end = textDocument.textPositionFrom(linePosition);
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }
}

