/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.TypeParamFinder;
import io.ballerina.compiler.api.impl.TypeParamResolver;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.symbols.AnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class LangLibFunctionBinder {
    private final Types types;
    private final CompilerContext context;

    public LangLibFunctionBinder(Types types, CompilerContext context) {
        this.types = types;
        this.context = context;
    }

    public LangLibFunctionBinder(CompilerContext context) {
        this.types = Types.getInstance(context);
        this.context = context;
    }

    public BInvokableSymbol cloneAndBind(BInvokableSymbol original, BType type, BType boundType) {
        if (boundType == null || original.params.isEmpty()) {
            return original;
        }
        BVarSymbol firstParam = original.params.get(0);
        BType typeParam = new TypeParamFinder().find(firstParam.getType());
        if (typeParam == null || !this.types.isAssignable(type, firstParam.getType())) {
            return original;
        }
        TypeParamResolver resolver = new TypeParamResolver(typeParam, this.context);
        BInvokableSymbol duplicate = this.duplicateSymbol(original);
        for (BVarSymbol param : original.params) {
            BVarSymbol newParamSymbol = this.createNewVarSymbol(param, boundType, resolver);
            duplicate.params.add(newParamSymbol);
        }
        duplicate.restParam = this.createNewVarSymbol(original.restParam, boundType, resolver);
        duplicate.retType = resolver.resolve(original.retType, boundType);
        duplicate.type = this.duplicateType(original.getType(), duplicate.params, duplicate.restParam, duplicate.retType);
        return duplicate;
    }

    private BVarSymbol createNewVarSymbol(BVarSymbol param, BType boundType, TypeParamResolver resolver) {
        BType newParamType;
        if (param == null) {
            return null;
        }
        BType originalParamType = param.getType();
        if (originalParamType == (newParamType = resolver.resolve(originalParamType, boundType))) {
            return param;
        }
        BVarSymbol duplicateParam = this.duplicateSymbol(param);
        duplicateParam.type = newParamType;
        return duplicateParam;
    }

    private BInvokableSymbol duplicateSymbol(BInvokableSymbol original) {
        BInvokableSymbol duplicate = Symbols.createInvokableSymbol(original.tag, original.flags, original.name, original.originalName, original.pkgID, original.type, original.owner, original.pos, original.origin);
        duplicate.getAnnotations().addAll(original.getAnnotations());
        duplicate.bodyExist = original.bodyExist;
        duplicate.markdownDocumentation = original.markdownDocumentation;
        duplicate.receiverSymbol = original.receiverSymbol;
        return duplicate;
    }

    private BInvokableType duplicateType(BInvokableType original, List<BVarSymbol> newParams, BVarSymbol newRestParam, BType newRetType) {
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        if (newParams.size() == original.paramTypes.size()) {
            paramTypes.addAll(newParams.stream().map(BSymbol::getType).toList());
        } else {
            paramTypes.addAll(original.paramTypes);
        }
        BInvokableType duplicate = new BInvokableType(this.types.typeEnv(), paramTypes, original.restType, original.retType, null);
        BInvokableTypeSymbol originalSym = (BInvokableTypeSymbol)original.tsymbol;
        BInvokableTypeSymbol duplicateTSym = new BInvokableTypeSymbol(original.tag, originalSym.flags, originalSym.pkgID, duplicate, originalSym.owner, originalSym.pos, originalSym.origin);
        duplicate.retType = newRetType;
        duplicateTSym.params.addAll(newParams);
        duplicateTSym.restParam = newRestParam;
        duplicateTSym.returnType = newRetType;
        duplicateTSym.returnTypeAnnots.addAll(originalSym.returnTypeAnnots);
        duplicate.tsymbol = duplicateTSym;
        return duplicate;
    }

    private BVarSymbol duplicateSymbol(BVarSymbol original) {
        BVarSymbol duplicate = new BVarSymbol(original.flags, original.isWildcard, original.name, original.originalName, original.pkgID, original.type, original.owner, original.pos, original.origin);
        duplicate.markdownDocumentation = original.markdownDocumentation;
        for (AnnotationAttachmentSymbol annotationAttachmentSymbol : original.getAnnotations()) {
            duplicate.addAnnotation(annotationAttachmentSymbol);
        }
        duplicate.isDefaultable = original.isDefaultable;
        duplicate.state = original.state;
        return duplicate;
    }
}

