/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.BaseVisitor;
import io.ballerina.compiler.api.impl.PositionUtil;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.AnnotatableNode;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeyTypeConstraint;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangCaptureBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorCauseBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorFieldBindingPatterns;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorMessageBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangFieldBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangListBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangMappingBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangNamedArgBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangRestBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangSimpleBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCollectContextInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNaturalExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAssertion;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomCharOrEscape;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCapturingGroups;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSet;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSetRange;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharacterClass;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReDisjunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagsOnOff;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReSequence;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorCauseMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorFieldMatchPatterns;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMessageMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangFieldMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMappingMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangNamedArgMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangRestMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangSimpleMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

class NodeFinder
extends BaseVisitor {
    private LineRange range;
    private BLangNode enclosingNode;
    private BLangNode enclosingContainer;
    private final boolean allowExprStmts;

    NodeFinder(boolean allowExprStmts) {
        this.allowExprStmts = allowExprStmts;
    }

    BLangNode lookup(BLangPackage module, LineRange range) {
        ArrayList<TopLevelNode> topLevelNodes = new ArrayList<TopLevelNode>(module.topLevelNodes);
        BLangTestablePackage tests = module.getTestablePkg();
        if (tests != null) {
            topLevelNodes.addAll(tests.topLevelNodes);
        }
        return this.lookupTopLevelNodes(topLevelNodes, range);
    }

    BLangNode lookup(BLangCompilationUnit unit, LineRange range) {
        return this.lookupTopLevelNodes(unit.topLevelNodes, range);
    }

    BLangNode lookupEnclosingContainer(BLangPackage module, LineRange range) {
        this.enclosingContainer = module;
        this.lookup(module, range);
        return this.enclosingContainer;
    }

    BLangNode lookupEnclosingContainer(BLangCompilationUnit compilationUnit, LineRange range) {
        this.enclosingContainer = compilationUnit;
        this.lookup(compilationUnit, range);
        return this.enclosingContainer;
    }

    private BLangNode lookupTopLevelNodes(List<TopLevelNode> nodes, LineRange range) {
        this.range = range;
        this.enclosingNode = null;
        for (TopLevelNode node : nodes) {
            if (!PositionUtil.isRangeWithinNode(this.range, node.getPosition()) && !this.isWithinNodeMetaData(node) || this.isLambdaFunction(node) || this.isClassForService(node)) continue;
            ((BLangNode)((Object)node)).accept(this);
            break;
        }
        return this.enclosingNode;
    }

    private void lookupNodes(List<? extends BLangNode> nodes) {
        for (BLangNode bLangNode : nodes) {
            if (!PositionUtil.isRangeWithinNode(this.range, bLangNode.pos)) continue;
            bLangNode.accept(this);
            if (this.enclosingNode != null || bLangNode.internal || !PositionUtil.withinRange(bLangNode.pos.lineRange(), this.range)) continue;
            this.enclosingNode = bLangNode;
            return;
        }
    }

    private void lookupNode(BLangNode node) {
        if (node == null) {
            return;
        }
        if (!PositionUtil.isRangeWithinNode(this.range, node.pos)) {
            return;
        }
        node.accept(this);
        if (this.enclosingNode == null && !node.internal && PositionUtil.withinRange(node.pos.lineRange(), this.range)) {
            this.enclosingNode = node;
        }
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        this.lookupNode(xmlnsNode.namespaceURI);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        this.lookupNodes(funcNode.annAttachments);
        for (BLangSimpleVariable requiredParam : funcNode.requiredParams) {
            this.lookupNodes(requiredParam.annAttachments);
        }
        this.lookupNodes(funcNode.requiredParams);
        if (funcNode.restParam != null) {
            this.lookupNodes(funcNode.restParam.annAttachments);
        }
        this.lookupNode(funcNode.restParam);
        this.lookupNode(funcNode.returnTypeNode);
        this.lookupNodes(funcNode.returnTypeAnnAttachments);
        this.lookupNode(funcNode.body);
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction) {
        this.visit((BLangFunction)resourceFunction);
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        this.enclosingContainer = blockFuncBody;
        this.lookupNodes(blockFuncBody.stmts);
    }

    @Override
    public void visit(BLangExprFunctionBody exprFuncBody) {
        this.lookupNode(exprFuncBody.expr);
    }

    @Override
    public void visit(BLangExternalFunctionBody externFuncBody) {
        this.lookupNodes(externFuncBody.annAttachments);
    }

    @Override
    public void visit(BLangService serviceNode) {
        this.lookupNodes(serviceNode.annAttachments);
        this.lookupNode(serviceNode.serviceClass);
        this.lookupNodes(serviceNode.attachedExprs);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.lookupNode(typeDefinition.typeNode);
        this.lookupNodes(typeDefinition.annAttachments);
    }

    @Override
    public void visit(BLangConstant constant) {
        this.lookupNode(constant.typeNode);
        this.lookupNode(constant.expr);
        this.lookupNodes(constant.annAttachments);
        this.setEnclosingNode(constant, constant.name.pos);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        this.lookupNodes(varNode.annAttachments);
        this.lookupNode(varNode.typeNode);
        this.lookupNode(varNode.expr);
        this.setEnclosingNode(varNode, varNode.name.pos);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        this.lookupNode(annotationNode.typeNode);
        this.lookupNodes(annotationNode.annAttachments);
        this.setEnclosingNode(annotationNode, annotationNode.name.pos);
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        this.lookupNode(annAttachmentNode.expr);
        this.setEnclosingNode(annAttachmentNode, annAttachmentNode.annotationName.pos);
    }

    @Override
    public void visit(BLangTableKeySpecifier tableKeySpecifierNode) {
    }

    @Override
    public void visit(BLangTableKeyTypeConstraint tableKeyTypeConstraint) {
        this.lookupNode(tableKeyTypeConstraint.keyType);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        this.enclosingContainer = blockNode;
        this.lookupNodes(blockNode.stmts);
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmtNode) {
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        this.lookupNode(varDefNode.var);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        this.lookupNode(assignNode.varRef);
        this.lookupNode(assignNode.expr);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        this.lookupNode(compoundAssignNode.varRef);
        this.lookupNode(compoundAssignNode.expr);
    }

    @Override
    public void visit(BLangRetry retryNode) {
        this.lookupNode(retryNode.retryBody);
        this.lookupNode(retryNode.retrySpec);
        this.lookupNode(retryNode.onFailClause);
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        this.lookupNode(retryTransaction.transaction);
        this.lookupNode(retryTransaction.retrySpec);
    }

    @Override
    public void visit(BLangRetrySpec retrySpec) {
        this.lookupNode(retrySpec.retryManagerType);
        this.lookupNodes(retrySpec.argExprs);
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.lookupNode(returnNode.expr);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.lookupNode(panicNode.expr);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.lookupNode(xmlnsStmtNode.xmlnsDecl);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.lookupNode(exprStmtNode.expr);
        if (this.allowExprStmts) {
            this.setEnclosingNode(exprStmtNode.expr, exprStmtNode.pos);
        }
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.lookupNode(ifNode.expr);
        this.lookupNode(ifNode.body);
        this.lookupNode(ifNode.elseStmt);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        this.lookupNodes(queryAction.queryClauseList);
        this.lookupNode(queryAction.doClause);
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.lookupNode((BLangNode)((Object)foreach.variableDefinitionNode));
        this.lookupNode(foreach.collection);
        this.lookupNode(foreach.body);
        this.lookupNode(foreach.onFailClause);
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.lookupNode(fromClause.collection);
        this.lookupNode((BLangNode)((Object)fromClause.variableDefinitionNode));
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        this.lookupNode(joinClause.collection);
        this.lookupNode((BLangNode)((Object)joinClause.variableDefinitionNode));
        this.lookupNode(joinClause.onClause);
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable var : letClause.letVarDeclarations) {
            this.lookupNode((BLangNode)((Object)var.definitionNode));
        }
    }

    @Override
    public void visit(BLangOnClause onClause) {
        this.lookupNode(onClause.lhsExpr);
        this.lookupNode(onClause.rhsExpr);
    }

    @Override
    public void visit(BLangOrderKey orderKeyClause) {
        this.lookupNode(orderKeyClause.expression);
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        for (OrderKeyNode key : orderByClause.orderByKeyList) {
            this.lookupNode((BLangNode)((Object)key));
        }
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.lookupNode(selectClause.expression);
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.lookupNode(whereClause.expression);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.lookupNode(doClause.body);
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        this.lookupNode(onConflictClause.expression);
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        this.lookupNode(limitClause.expression);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.lookupNode(whileNode.expr);
        this.lookupNode(whileNode.body);
        this.lookupNode(whileNode.onFailClause);
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.lookupNode(lockNode.body);
        this.lookupNode(lockNode.onFailClause);
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.lookupNode(transactionNode.transactionBody);
        this.lookupNode(transactionNode.onFailClause);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        this.lookupNode(stmt.expr);
        this.lookupNode(stmt.varRef);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        this.lookupNode(stmt.expr);
        this.lookupNode(stmt.varRef);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        this.lookupNode(stmt.expr);
        this.lookupNode(stmt.varRef);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.lookupNodes(forkJoin.workers);
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        this.lookupNode(asyncSendExpr.expr);
        this.setEnclosingNode(asyncSendExpr, asyncSendExpr.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangAlternateWorkerReceive alternateWorkerReceive) {
        for (BLangWorkerReceive workerReceive : alternateWorkerReceive.getWorkerReceives()) {
            if (!this.setEnclosingNode(alternateWorkerReceive, workerReceive.workerIdentifier.pos)) continue;
            return;
        }
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        for (BLangMultipleWorkerReceive.BLangReceiveField receiveField : multipleWorkerReceive.getReceiveFields()) {
            if (!this.setEnclosingNode(multipleWorkerReceive, receiveField.getWorkerReceive().workerIdentifier.pos)) continue;
            return;
        }
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.setEnclosingNode(workerReceiveNode, workerReceiveNode.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        this.lookupNode(rollbackNode.expr);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            this.lookupNode((BLangNode)((Object)field));
        }
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.lookupNodes(varRefExpr.expressions);
        this.lookupNode(varRefExpr.restParam);
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : varRefExpr.recordRefFields) {
            this.lookupNode(recordRefField.getBindingPattern());
        }
        this.lookupNode(varRefExpr.restParam);
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.lookupNode(varRefExpr.message);
        this.lookupNodes(varRefExpr.detail);
        this.lookupNode(varRefExpr.cause);
        this.lookupNode(varRefExpr.restVar);
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        if (this.setEnclosingNode(varRefExpr, varRefExpr.variableName.pos)) {
            return;
        }
        this.setEnclosingNode(varRefExpr, varRefExpr.pos);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        if (this.setEnclosingNode(fieldAccessExpr, fieldAccessExpr.field.pos)) {
            return;
        }
        this.lookupNode(fieldAccessExpr.expr);
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.lookupNode(indexAccessExpr.expr);
        this.lookupNode(indexAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.lookupNodes(invocationExpr.argExprs);
        this.lookupNode(invocationExpr.expr);
        if (this.setEnclosingNode(invocationExpr, invocationExpr.name.pos)) {
            return;
        }
        this.setEnclosingNode(invocationExpr, invocationExpr.pos);
    }

    @Override
    public void visit(BLangTypeInit typeInit) {
        this.lookupNode(typeInit.userDefinedType);
        this.lookupNodes(typeInit.argsExpr);
        this.setEnclosingNode(typeInit, typeInit.pos);
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
        this.lookupNodes(actionInvocationExpr.argExprs);
        this.lookupNodes(actionInvocationExpr.restArgs);
        this.lookupNode(actionInvocationExpr.expr);
        this.lookupNodes(actionInvocationExpr.annAttachments);
        if (this.setEnclosingNode(actionInvocationExpr, actionInvocationExpr.name.pos)) {
            return;
        }
        this.setEnclosingNode(actionInvocationExpr, actionInvocationExpr.pos);
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.lookupNode(ternaryExpr.expr);
        this.lookupNode(ternaryExpr.thenExpr);
        this.lookupNode(ternaryExpr.elseExpr);
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr) {
        this.lookupNodes(awaitExpr.exprList);
        this.setEnclosingNode(awaitExpr, awaitExpr.pos);
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.lookupNode(trapExpr.expr);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.lookupNode(binaryExpr.lhsExpr);
        this.lookupNode(binaryExpr.rhsExpr);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.lookupNode(elvisExpr.lhsExpr);
        this.lookupNode(elvisExpr.rhsExpr);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.lookupNode(groupExpr.expression);
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        for (BLangLetVariable var : letExpr.letVarDeclarations) {
            this.lookupNode((BLangNode)((Object)var.definitionNode));
        }
        this.lookupNode(letExpr.expr);
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        this.lookupNodes(listConstructorExpr.exprs);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangListConstructorSpreadOpExpr spreadOpExpr) {
        this.lookupNode(spreadOpExpr.expr);
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.lookupNode(tableConstructorExpr.tableKeySpecifier);
        this.lookupNodes(tableConstructorExpr.recordLiteralList);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        this.lookupNodes(tupleLiteral.exprs);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        this.lookupNodes(arrayLiteral.exprs);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.lookupNode(unaryExpr.expr);
    }

    @Override
    public void visit(BLangTypedescExpr typedescExpr) {
        this.lookupNode(typedescExpr.typeNode);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.lookupNodes(conversionExpr.annAttachments);
        this.lookupNode(conversionExpr.typeNode);
        this.lookupNode(conversionExpr.expr);
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        if (this.setEnclosingNode(xmlQName, xmlQName.pos) || this.setEnclosingNode(xmlQName, xmlQName.prefix.pos)) {
            return;
        }
        this.setEnclosingNode(xmlQName, xmlQName.localname.pos);
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        this.lookupNode(xmlElementLiteral.startTagName);
        this.lookupNodes(xmlElementLiteral.attributes);
        this.lookupNodes(xmlElementLiteral.children);
        this.lookupNode(xmlElementLiteral.endTagName);
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        this.lookupNode(xmlTextLiteral.concatExpr);
        this.lookupNodes(xmlTextLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        this.lookupNode(xmlCommentLiteral.concatExpr);
        this.lookupNodes(xmlCommentLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        this.lookupNode(xmlProcInsLiteral.dataConcatExpr);
        this.lookupNodes(xmlProcInsLiteral.dataFragments);
        this.lookupNode(xmlProcInsLiteral.target);
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        this.lookupNode(xmlQuotedString.concatExpr);
        this.lookupNodes(xmlQuotedString.textFragments);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.lookupNodes(stringTemplateLiteral.exprs);
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        this.lookupNodes(rawTemplateLiteral.strings);
        this.lookupNodes(rawTemplateLiteral.insertions);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        this.lookupNode(bLangLambdaFunction.function);
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.lookupNodes(bLangArrowFunction.params);
        this.lookupNode(bLangArrowFunction.body);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.lookupNode(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.lookupNode(bLangNamedArgsExpression.expr);
        this.setEnclosingNode(bLangNamedArgsExpression.name, bLangNamedArgsExpression.name.pos);
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        this.lookupNode(assignableExpr.lhsExpr);
        this.lookupNode(assignableExpr.typeNode);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.lookupNode(checkedExpr.expr);
    }

    @Override
    public void visit(BLangFail failExpr) {
        this.lookupNode(failExpr.expr);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        this.lookupNode(checkPanickedExpr.expr);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.lookupNode(serviceConstructorExpr.serviceNode);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.lookupNode(typeTestExpr.expr);
        this.lookupNode(typeTestExpr.typeNode);
    }

    @Override
    public void visit(BLangIsLikeExpr typeTestExpr) {
        this.lookupNode(typeTestExpr.expr);
        this.lookupNode(typeTestExpr.typeNode);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.lookupNode(annotAccessExpr.expr);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        this.lookupNodes(queryExpr.queryClauseList);
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.lookupNode(arrayType.elemtype);
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.lookupNode(constrainedType.constraint);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.lookupNode(streamType.constraint);
        this.lookupNode(streamType.error);
    }

    @Override
    public void visit(BLangTableTypeNode tableType) {
        this.lookupNode(tableType.constraint);
        this.lookupNode(tableType.tableKeySpecifier);
        this.lookupNode(tableType.tableKeyTypeConstraint);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        this.setEnclosingNode(userDefinedType, userDefinedType.typeName.pos);
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        this.lookupNodes(functionTypeNode.params);
        this.lookupNode(functionTypeNode.restParam);
        this.lookupNode(functionTypeNode.returnTypeNode);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        this.lookupNodes(unionTypeNode.memberTypeNodes);
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        this.lookupNodes(intersectionTypeNode.constituentTypeNodes);
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        this.lookupNodes(classDefinition.annAttachments);
        for (BLangSimpleVariable field : classDefinition.fields) {
            this.lookupNodes(field.annAttachments);
        }
        this.lookupNodes(classDefinition.fields);
        this.lookupNodes(classDefinition.referencedFields);
        this.lookupNode(classDefinition.initFunction);
        for (BLangFunction method : classDefinition.functions) {
            this.lookupNodes(method.annAttachments);
        }
        this.lookupNodes(classDefinition.functions);
        this.lookupNodes(classDefinition.typeRefs);
        this.setEnclosingNode(classDefinition, classDefinition.name.pos);
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvocation) {
        this.lookupNodes(resourceAccessInvocation.annAttachments);
        this.lookupNode(resourceAccessInvocation.expr);
        this.lookupNode(resourceAccessInvocation.resourceAccessPathSegments);
        this.lookupNodes(resourceAccessInvocation.requiredArgs);
        this.lookupNodes(resourceAccessInvocation.restArgs);
        this.setEnclosingNode(resourceAccessInvocation, resourceAccessInvocation.pos);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            this.lookupNodes(field.annAttachments);
        }
        this.lookupNodes(objectTypeNode.fields);
        for (BLangFunction function : objectTypeNode.functions) {
            this.lookupNodes(function.annAttachments);
        }
        this.lookupNodes(objectTypeNode.functions);
        this.lookupNodes(objectTypeNode.typeRefs);
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression) {
        this.lookupNode(objectConstructorExpression.classNode);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            this.lookupNodes(field.annAttachments);
        }
        this.lookupNodes(recordTypeNode.fields);
        this.lookupNodes(recordTypeNode.typeRefs);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        this.lookupNodes(finiteTypeNode.valueSpace);
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        this.lookupNodes(tupleTypeNode.members);
        this.lookupNode(tupleTypeNode.restParamType);
    }

    @Override
    public void visit(BLangErrorType errorType) {
        this.lookupNode(errorType.detailType);
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        this.lookupNode(errorConstructorExpr.errorTypeRef);
        this.lookupNodes(errorConstructorExpr.positionalArgs);
        this.lookupNodes(errorConstructorExpr.namedArgs);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
        this.lookupNode(fieldAccessExpr.expr);
        this.lookupNode(fieldAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
        if (this.setEnclosingNode(functionVarRef, functionVarRef.field.pos)) {
            return;
        }
        this.lookupNode(functionVarRef.expr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
        this.lookupNode(mapKeyAccessExpr.expr);
        this.lookupNode(mapKeyAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
        this.lookupNode(arrayIndexAccessExpr.expr);
        this.lookupNode(arrayIndexAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableKeyAccessExpr) {
        this.lookupNode(tableKeyAccessExpr.expr);
        this.lookupNode(tableKeyAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlAccessExpr) {
        this.lookupNode(xmlAccessExpr.expr);
        this.lookupNode(xmlAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        for (RecordLiteralNode.RecordField field : mapLiteral.fields) {
            this.lookupNode((BLangNode)((Object)field));
        }
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        for (RecordLiteralNode.RecordField field : structLiteral.fields) {
            this.lookupNode((BLangNode)((Object)field));
        }
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation bFunctionPointerInvocation) {
        this.lookupNodes(bFunctionPointerInvocation.requiredArgs);
        this.lookupNodes(bFunctionPointerInvocation.restArgs);
        this.setEnclosingNode(bFunctionPointerInvocation, bFunctionPointerInvocation.name.pos);
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation iExpr) {
        if (this.setEnclosingNode(iExpr, iExpr.name.pos)) {
            return;
        }
        this.lookupNode(iExpr.expr);
        this.lookupNodes(iExpr.requiredArgs);
        this.lookupNodes(iExpr.restArgs);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        this.lookupNodes(jsonArrayLiteral.exprs);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr jsonAccessExpr) {
        this.lookupNode(jsonAccessExpr.expr);
        this.lookupNode(jsonAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        this.lookupNode(stringAccessExpr.expr);
        this.lookupNode(stringAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        if (this.setEnclosingNode(xmlnsNode, xmlnsNode.prefix.pos)) {
            return;
        }
        this.lookupNode(xmlnsNode.namespaceURI);
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        if (this.setEnclosingNode(xmlnsNode, xmlnsNode.prefix.pos)) {
            return;
        }
        this.lookupNode(xmlnsNode.namespaceURI);
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
        this.lookupNodes(bLangXMLSequenceLiteral.xmlItems);
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        this.lookupNode(bLangStatementExpression.stmt);
        this.lookupNode(bLangStatementExpression.expr);
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        this.lookupNodes(bLangTupleVariable.annAttachments);
        this.lookupNode(bLangTupleVariable.typeNode);
        this.lookupNodes(bLangTupleVariable.memberVariables);
        this.lookupNode(bLangTupleVariable.restVariable);
        this.lookupNode(bLangTupleVariable.expr);
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.lookupNode(bLangTupleVariableDef.var);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        for (BLangRecordVariable.BLangRecordVariableKeyValue var : bLangRecordVariable.variableList) {
            this.lookupNode(var.valueBindingPattern);
        }
        this.lookupNode(bLangRecordVariable.restParam);
        this.lookupNode(bLangRecordVariable.expr);
        this.lookupNodes(bLangRecordVariable.annAttachments);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.lookupNode(bLangRecordVariableDef.var);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.lookupNodes(bLangErrorVariable.annAttachments);
        this.lookupNode(bLangErrorVariable.typeNode);
        this.lookupNode(bLangErrorVariable.message);
        for (BLangErrorVariable.BLangErrorDetailEntry detail : bLangErrorVariable.detail) {
            this.lookupNode(detail.valueBindingPattern);
        }
        this.lookupNode(bLangErrorVariable.detailExpr);
        this.lookupNode(bLangErrorVariable.cause);
        this.lookupNode(bLangErrorVariable.reasonMatchConst);
        this.lookupNode(bLangErrorVariable.restDetail);
        this.lookupNode(bLangErrorVariable.expr);
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.lookupNode(bLangErrorVariableDef.errorVariable);
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.setEnclosingNode(workerFlushExpr, workerFlushExpr.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        this.lookupNode(syncSendExpr.expr);
        this.setEnclosingNode(syncSendExpr, syncSendExpr.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        this.lookupNodes(waitForAllExpr.keyValuePairs);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        this.lookupNodes(waitLiteral.keyValuePairs);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKeyValueField recordKeyValue) {
        this.lookupNode(recordKeyValue.key);
        this.lookupNode(recordKeyValue.valueExpr);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKey recordKey) {
        this.lookupNode(recordKey.expr);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOperatorField) {
        this.lookupNode(spreadOperatorField.expr);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue waitKeyValue) {
        this.lookupNode(waitKeyValue.keyExpr);
        this.lookupNode(waitKeyValue.valueExpr);
    }

    @Override
    public void visit(BLangXMLElementFilter xmlElementFilter) {
        this.setEnclosingNode(xmlElementFilter, xmlElementFilter.elemNamePos);
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.lookupNode(xmlElementAccess.expr);
        this.lookupNodes(xmlElementAccess.filters);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        this.lookupNode(xmlNavigation.expr);
        this.lookupNodes(xmlNavigation.filters);
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess) {
        this.lookupNode(extendedXmlNavigationAccess.stepExpr);
        this.lookupNodes(extendedXmlNavigationAccess.extensions);
    }

    @Override
    public void visit(BLangXMLIndexedStepExtend xmlIndexedStepExtend) {
        this.lookupNode(xmlIndexedStepExtend.indexExpr);
    }

    @Override
    public void visit(BLangXMLFilterStepExtend xmlFilterStepExtend) {
        this.lookupNodes(xmlFilterStepExtend.filters);
        this.setEnclosingNode(xmlFilterStepExtend, xmlFilterStepExtend.pos);
    }

    @Override
    public void visit(BLangXMLMethodCallStepExtend xmlMethodCallStepExtend) {
        this.lookupNode(xmlMethodCallStepExtend.invocation);
    }

    @Override
    public void visit(BLangMatchStatement matchStatementNode) {
        this.lookupNode(matchStatementNode.expr);
        this.lookupNodes(matchStatementNode.matchClauses);
        this.lookupNode(matchStatementNode.onFailClause);
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        this.lookupNodes(matchClause.matchPatterns);
        this.lookupNode(matchClause.matchGuard);
        this.lookupNode(matchClause.blockStmt);
    }

    @Override
    public void visit(BLangMappingMatchPattern mappingMatchPattern) {
        this.lookupNodes(mappingMatchPattern.fieldMatchPatterns);
        this.lookupNode(mappingMatchPattern.restMatchPattern);
    }

    @Override
    public void visit(BLangFieldMatchPattern fieldMatchPattern) {
        this.lookupNode(fieldMatchPattern.matchPattern);
    }

    @Override
    public void visit(BLangListMatchPattern listMatchPattern) {
        this.lookupNodes(listMatchPattern.matchPatterns);
        this.lookupNode(listMatchPattern.restMatchPattern);
    }

    @Override
    public void visit(BLangErrorMatchPattern errorMatchPattern) {
        this.lookupNode(errorMatchPattern.errorTypeReference);
        this.lookupNode(errorMatchPattern.errorMessageMatchPattern);
        this.lookupNode(errorMatchPattern.errorCauseMatchPattern);
        this.lookupNode(errorMatchPattern.errorFieldMatchPatterns);
    }

    @Override
    public void visit(BLangErrorMessageMatchPattern errorMessageMatchPattern) {
        this.lookupNode(errorMessageMatchPattern.simpleMatchPattern);
    }

    @Override
    public void visit(BLangErrorCauseMatchPattern errorCauseMatchPattern) {
        this.lookupNode(errorCauseMatchPattern.simpleMatchPattern);
        this.lookupNode(errorCauseMatchPattern.errorMatchPattern);
    }

    @Override
    public void visit(BLangErrorFieldMatchPatterns errorFieldMatchPatterns) {
        this.lookupNodes(errorFieldMatchPatterns.namedArgMatchPatterns);
        this.lookupNode(errorFieldMatchPatterns.restMatchPattern);
    }

    @Override
    public void visit(BLangSimpleMatchPattern simpleMatchPattern) {
        this.lookupNode(simpleMatchPattern.constPattern);
        this.lookupNode(simpleMatchPattern.varVariableName);
    }

    @Override
    public void visit(BLangNamedArgMatchPattern namedArgMatchPattern) {
        this.lookupNode(namedArgMatchPattern.matchPattern);
    }

    @Override
    public void visit(BLangMatchGuard matchGuard) {
        this.lookupNode(matchGuard.expr);
    }

    @Override
    public void visit(BLangConstPattern constMatchPattern) {
        this.lookupNode(constMatchPattern.expr);
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern) {
        this.lookupNode(varBindingPattern.getBindingPattern());
    }

    @Override
    public void visit(BLangRestMatchPattern restMatchPattern) {
    }

    @Override
    public void visit(BLangMappingBindingPattern mappingBindingPattern) {
        this.lookupNodes(mappingBindingPattern.fieldBindingPatterns);
        this.lookupNode(mappingBindingPattern.restBindingPattern);
    }

    @Override
    public void visit(BLangFieldBindingPattern fieldBindingPattern) {
        this.lookupNode(fieldBindingPattern.bindingPattern);
    }

    @Override
    public void visit(BLangRestBindingPattern restBindingPattern) {
    }

    @Override
    public void visit(BLangErrorBindingPattern errorBindingPattern) {
        this.lookupNode(errorBindingPattern.errorMessageBindingPattern);
        this.lookupNode(errorBindingPattern.errorTypeReference);
        this.lookupNode(errorBindingPattern.errorCauseBindingPattern);
        this.lookupNode(errorBindingPattern.errorFieldBindingPatterns);
    }

    @Override
    public void visit(BLangErrorMessageBindingPattern errorMessageBindingPattern) {
        this.lookupNode(errorMessageBindingPattern.simpleBindingPattern);
    }

    @Override
    public void visit(BLangErrorCauseBindingPattern errorCauseBindingPattern) {
        this.lookupNode(errorCauseBindingPattern.simpleBindingPattern);
        this.lookupNode(errorCauseBindingPattern.errorBindingPattern);
    }

    @Override
    public void visit(BLangErrorFieldBindingPatterns errorFieldBindingPatterns) {
        this.lookupNodes(errorFieldBindingPatterns.namedArgBindingPatterns);
        this.lookupNode(errorFieldBindingPatterns.restBindingPattern);
    }

    @Override
    public void visit(BLangSimpleBindingPattern simpleBindingPattern) {
        this.lookupNode(simpleBindingPattern.captureBindingPattern);
    }

    @Override
    public void visit(BLangNamedArgBindingPattern namedArgBindingPattern) {
        this.lookupNode(namedArgBindingPattern.bindingPattern);
    }

    @Override
    public void visit(BLangCaptureBindingPattern captureBindingPattern) {
        this.setEnclosingNode(captureBindingPattern, captureBindingPattern.getIdentifier().getPosition());
    }

    @Override
    public void visit(BLangListBindingPattern listBindingPattern) {
        this.lookupNodes(listBindingPattern.bindingPatterns);
        this.lookupNode(listBindingPattern.restBindingPattern);
    }

    @Override
    public void visit(BLangDo doNode) {
        this.lookupNode(doNode.body);
        this.lookupNode(doNode.onFailClause);
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        this.lookupNode((BLangNode)((Object)onFailClause.variableDefinitionNode));
        this.lookupNode(onFailClause.body);
        this.enclosingContainer = onFailClause;
    }

    @Override
    public void visit(BLangLiteral literal) {
        this.setEnclosingNode(literal, literal.pos);
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        this.lookupNode(regExpTemplateLiteral.reDisjunction);
    }

    @Override
    public void visit(BLangReSequence reSequence) {
        this.lookupNodes(reSequence.termList);
    }

    @Override
    public void visit(BLangReAtomQuantifier reAtomQuantifier) {
        this.lookupNode(reAtomQuantifier.atom);
        this.lookupNode(reAtomQuantifier.quantifier);
    }

    @Override
    public void visit(BLangReAtomCharOrEscape reAtomCharOrEscape) {
        this.lookupNode(reAtomCharOrEscape.charOrEscape);
    }

    @Override
    public void visit(BLangReQuantifier reQuantifier) {
        this.lookupNode(reQuantifier.quantifier);
        this.lookupNode(reQuantifier.nonGreedyChar);
    }

    @Override
    public void visit(BLangReCharacterClass reCharacterClass) {
        this.lookupNode(reCharacterClass.characterClassStart);
        this.lookupNode(reCharacterClass.negation);
        this.lookupNode(reCharacterClass.charSet);
        this.lookupNode(reCharacterClass.characterClassEnd);
    }

    @Override
    public void visit(BLangReCharSet reCharSet) {
        this.lookupNodes(reCharSet.charSetAtoms);
    }

    @Override
    public void visit(BLangReCharSetRange reCharSetRange) {
        this.lookupNode(reCharSetRange.lhsCharSetAtom);
        this.lookupNode(reCharSetRange.dash);
        this.lookupNode(reCharSetRange.rhsCharSetAtom);
    }

    @Override
    public void visit(BLangReAssertion reAssertion) {
        this.lookupNode(reAssertion.assertion);
    }

    @Override
    public void visit(BLangReCapturingGroups reCapturingGroups) {
        this.lookupNode(reCapturingGroups.openParen);
        this.lookupNode(reCapturingGroups.flagExpr);
        this.lookupNode(reCapturingGroups.disjunction);
        this.lookupNode(reCapturingGroups.closeParen);
    }

    @Override
    public void visit(BLangReDisjunction reDisjunction) {
        this.lookupNodes(reDisjunction.sequenceList);
    }

    @Override
    public void visit(BLangReFlagsOnOff reFlagsOnOff) {
        this.lookupNode(reFlagsOnOff.flags);
    }

    @Override
    public void visit(BLangReFlagExpression reFlagExpression) {
        this.lookupNode(reFlagExpression.questionMark);
        this.lookupNode(reFlagExpression.flagsOnOff);
        this.lookupNode(reFlagExpression.colon);
    }

    @Override
    public void visit(BLangGroupByClause groupByClause) {
        this.lookupNodes(groupByClause.getGroupingKeyList());
    }

    @Override
    public void visit(BLangGroupingKey groupingKeyClause) {
        this.lookupNode((BLangNode)groupingKeyClause.getGroupingKey());
    }

    @Override
    public void visit(BLangCollectClause collectClause) {
        this.lookupNode(collectClause.expression);
    }

    @Override
    public void visit(BLangCollectContextInvocation invocation) {
        this.lookupNode(invocation.invocation);
    }

    @Override
    public void visit(BLangNaturalExpression naturalExpression) {
        this.lookupNodes(naturalExpression.arguments);
        this.lookupNodes(naturalExpression.strings);
        this.lookupNodes(naturalExpression.insertions);
    }

    private boolean setEnclosingNode(BLangNode node, Location pos) {
        if (PositionUtil.isRangeWithinNode(this.range, pos) && (this.enclosingNode == null || PositionUtil.isRangeWithinNode(pos.lineRange(), this.enclosingNode.pos))) {
            this.enclosingNode = node;
            return true;
        }
        return false;
    }

    private boolean isLambdaFunction(TopLevelNode node) {
        if (node.getKind() != NodeKind.FUNCTION) {
            return false;
        }
        BLangFunction func = (BLangFunction)node;
        return func.flagSet.contains((Object)Flag.LAMBDA);
    }

    private boolean isClassForService(TopLevelNode node) {
        if (node.getKind() != NodeKind.CLASS_DEFN) {
            return false;
        }
        return ((BLangClassDefinition)node).flagSet.contains((Object)Flag.SERVICE) && ((BLangClassDefinition)node).flagSet.contains((Object)Flag.ANONYMOUS);
    }

    private boolean isWithinNodeMetaData(TopLevelNode node) {
        if (node instanceof AnnotatableNode) {
            AnnotatableNode annotatableNode = (AnnotatableNode)((Object)node);
            List<? extends AnnotationAttachmentNode> nodes = annotatableNode.getAnnotationAttachments();
            for (AnnotationAttachmentNode annotationAttachmentNode : nodes) {
                if (!PositionUtil.isRangeWithinNode(this.range, annotationAttachmentNode.getPosition())) continue;
                return true;
            }
        }
        return false;
    }
}

