/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;

final class PositionUtil {
    private PositionUtil() {
    }

    static boolean withinBlock(LinePosition cursorPos, Location symbolPosition) {
        if (symbolPosition == null) {
            return false;
        }
        int startLine = symbolPosition.lineRange().startLine().line();
        int endLine = symbolPosition.lineRange().endLine().line();
        int startColumn = symbolPosition.lineRange().startLine().offset();
        int endColumn = symbolPosition.lineRange().endLine().offset();
        int cursorLine = cursorPos.line();
        int cursorColumn = cursorPos.offset();
        return cursorLine >= startLine && cursorLine <= endLine && (cursorLine != startLine || cursorColumn >= startColumn) && (cursorLine != endLine || cursorColumn < endColumn);
    }

    static boolean withinRange(LineRange range, LineRange enclRange) {
        int startLine = range.startLine().line();
        int startOffset = range.startLine().offset();
        int endLine = range.endLine().line();
        int endOffset = range.endLine().offset();
        int enclStartLine = enclRange.startLine().line();
        int enclEndLine = enclRange.endLine().line();
        int enclStartOffset = enclRange.startLine().offset();
        int enclEndOffset = enclRange.endLine().offset();
        return enclRange.fileName().equals(range.fileName()) && (startLine == enclStartLine && startOffset >= enclStartOffset || startLine > enclStartLine) && (endLine == enclEndLine && endOffset <= enclEndOffset || endLine < enclEndLine);
    }

    static boolean isRangeWithinNode(LineRange range, Location nodePosition) {
        return nodePosition != null && PositionUtil.withinRange(range, nodePosition.lineRange());
    }

    static boolean withinRightInclusive(LinePosition cursorPos, Location nodePosition) {
        int startLine = nodePosition.lineRange().startLine().line();
        int startColumn = nodePosition.lineRange().startLine().offset();
        int endLine = nodePosition.lineRange().endLine().line();
        int cursorLine = cursorPos.line();
        int cursorColumn = cursorPos.offset();
        return startLine < cursorLine && endLine > cursorLine || startLine < cursorLine && endLine == cursorLine || startLine == cursorLine && endLine > cursorLine || startLine == endLine && startLine == cursorLine && startColumn <= cursorColumn;
    }

    static boolean isPosWithinRange(LinePosition position, LineRange enclRange) {
        int posLine = position.line();
        int posOffset = position.offset();
        int enclStartLine = enclRange.startLine().line();
        int enclEndLine = enclRange.endLine().line();
        int enclStartOffset = enclRange.startLine().offset();
        int enclEndOffset = enclRange.endLine().offset();
        return (posLine == enclStartLine && posOffset >= enclStartOffset || posLine > enclStartLine) && (posLine == enclEndLine && posOffset <= enclEndOffset || posLine < enclEndLine);
    }

    static boolean isPosWithinOpenCloseLineRanges(LinePosition linePosition, LineRange openParenLineRange, LineRange closeParenLineRange) {
        int posLine = linePosition.line();
        int posOffset = linePosition.offset();
        int openLine = openParenLineRange.startLine().line();
        int openOffset = openParenLineRange.startLine().offset();
        int closeLine = closeParenLineRange.startLine().line();
        int closeOffset = closeParenLineRange.endLine().offset();
        return (posLine == openLine && posOffset >= openOffset || posLine > openLine) && (closeLine == posLine && posOffset <= closeOffset || posLine < closeLine);
    }
}

