/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import java.util.HashSet;
import java.util.Set;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BPackageType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;

public class TypeParamFinder
extends TypeVisitor {
    private final Set<BType> visited = new HashSet<BType>();
    private BType typeParam;

    public BType find(BType type) {
        if (type == null || this.visited.contains(type)) {
            return null;
        }
        this.setContainsTypeParam(type);
        if (this.typeParam != null) {
            return this.typeParam;
        }
        this.visited.add(type);
        type.accept(this);
        return this.typeParam;
    }

    @Override
    public void visit(BAnnotationType bAnnotationType) {
    }

    @Override
    public void visit(BArrayType bArrayType) {
        this.find(bArrayType.eType);
    }

    @Override
    public void visit(BAnyType bAnyType) {
    }

    @Override
    public void visit(BAnydataType bAnydataType) {
    }

    @Override
    public void visit(BErrorType bErrorType) {
        this.find(bErrorType.detailType);
    }

    @Override
    public void visit(BFiniteType bFiniteType) {
    }

    @Override
    public void visit(BInvokableType bInvokableType) {
        for (BType paramType : bInvokableType.paramTypes) {
            this.find(paramType);
        }
        this.find(bInvokableType.restType);
        this.find(bInvokableType.retType);
    }

    @Override
    public void visit(BJSONType bjsonType) {
    }

    @Override
    public void visit(BMapType bMapType) {
        this.find(bMapType.constraint);
    }

    @Override
    public void visit(BStreamType bStreamType) {
        this.find(bStreamType.constraint);
    }

    @Override
    public void visit(BTypedescType bTypedescType) {
        this.find(bTypedescType.constraint);
    }

    @Override
    public void visit(BTypeReferenceType bTypeReferenceType) {
        this.find(bTypeReferenceType.referredType);
    }

    @Override
    public void visit(BParameterizedType bTypedescType) {
    }

    @Override
    public void visit(BNeverType bNeverType) {
    }

    @Override
    public void visitNilType(BType btype) {
    }

    @Override
    public void visit(BNoType bNoType) {
    }

    @Override
    public void visit(BPackageType bPackageType) {
    }

    @Override
    public void visit(BStructureType bStructureType) {
    }

    @Override
    public void visit(BTupleType bTupleType) {
        for (BType tupleMemberType : bTupleType.getTupleTypes()) {
            this.find(tupleMemberType);
        }
        this.find(bTupleType.restType);
    }

    @Override
    public void visit(BUnionType bUnionType) {
        for (BType memberType : bUnionType.getOriginalMemberTypes()) {
            this.find(memberType);
        }
    }

    @Override
    public void visit(BIntersectionType bIntersectionType) {
        for (BType constituentType : bIntersectionType.getConstituentTypes()) {
            this.find(constituentType);
        }
    }

    @Override
    public void visit(BXMLType bxmlType) {
        this.find(bxmlType.constraint);
    }

    @Override
    public void visit(BTableType bTableType) {
        this.find(bTableType.constraint);
    }

    @Override
    public void visit(BRecordType bRecordType) {
        for (BField field : bRecordType.fields.values()) {
            this.find(field.getType());
        }
        if (bRecordType.restFieldType != null) {
            this.find(bRecordType.restFieldType);
        }
    }

    @Override
    public void visit(BObjectType bObjectType) {
        for (BField field : bObjectType.fields.values()) {
            this.find(field.getType());
        }
        for (BAttachedFunction method : ((BObjectTypeSymbol)bObjectType.tsymbol).attachedFuncs) {
            this.find(method.type);
        }
    }

    @Override
    public void visit(BFutureType bFutureType) {
        this.find(bFutureType.constraint);
    }

    @Override
    public void visit(BHandleType bHandleType) {
    }

    private void setContainsTypeParam(BType type) {
        if (Symbols.isFlagOn(type.getFlags(), 0x200000L)) {
            this.typeParam = type;
        }
    }
}

