/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationAttachmentSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaDocumentation;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.model.symbols.AnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaObjectFieldSymbol
extends BallerinaSymbol
implements ObjectFieldSymbol {
    protected final BField bField;
    protected List<Qualifier> qualifiers;
    private final Documentation docAttachment;
    private TypeSymbol typeDescriptor;
    private List<AnnotationSymbol> annots;
    private String signature;
    private final boolean deprecated;
    private List<io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol> annotAttachments;

    public BallerinaObjectFieldSymbol(CompilerContext context, BField bField, SymbolKind kind) {
        super(bField.symbol.getOriginalName().value, kind, bField.symbol, context);
        this.bField = bField;
        this.docAttachment = new BallerinaDocumentation(bField.symbol.markdownDocumentation);
        this.deprecated = Symbols.isFlagOn(bField.symbol.flags, 16L);
    }

    public BallerinaObjectFieldSymbol(CompilerContext context, BField bField) {
        this(context, bField, SymbolKind.OBJECT_FIELD);
    }

    @Override
    public TypeSymbol typeDescriptor() {
        if (this.typeDescriptor == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.typeDescriptor = typesFactory.getTypeDescriptor(this.bField.type);
        }
        return this.typeDescriptor;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        if (this.annots != null) {
            return this.annots;
        }
        ArrayList<BallerinaAnnotationSymbol> annots = new ArrayList<BallerinaAnnotationSymbol>();
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        for (AnnotationAttachmentSymbol annotationAttachmentSymbol : this.bField.symbol.getAnnotations()) {
            annots.add(symbolFactory.createAnnotationSymbol((BAnnotationAttachmentSymbol)annotationAttachmentSymbol));
        }
        this.annots = Collections.unmodifiableList(annots);
        return this.annots;
    }

    @Override
    public List<io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol> annotAttachments() {
        if (this.annotAttachments != null) {
            return this.annotAttachments;
        }
        ArrayList<BallerinaAnnotationAttachmentSymbol> annotAttachments = new ArrayList<BallerinaAnnotationAttachmentSymbol>();
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        for (AnnotationAttachmentSymbol annotationAttachmentSymbol : this.bField.symbol.getAnnotations()) {
            annotAttachments.add(symbolFactory.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol));
        }
        this.annotAttachments = Collections.unmodifiableList(annotAttachments);
        return this.annotAttachments;
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    @Override
    public Optional<Documentation> documentation() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public List<Qualifier> qualifiers() {
        if (this.qualifiers != null) {
            return this.qualifiers;
        }
        ArrayList<Qualifier> quals = new ArrayList<Qualifier>();
        if (Symbols.isFlagOn(this.bField.symbol.flags, 1L)) {
            quals.add(Qualifier.PUBLIC);
        }
        this.qualifiers = Collections.unmodifiableList(quals);
        return this.qualifiers;
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        StringJoiner joiner = new StringJoiner(" ");
        for (Qualifier qualifier : this.qualifiers()) {
            joiner.add(qualifier.getValue());
        }
        this.signature = joiner.add(this.typeDescriptor().signature()).add(this.getName().get()).toString();
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

