/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaMethodSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaObjectFieldSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.impl.util.FieldMap;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaObjectTypeSymbol
extends AbstractTypeSymbol
implements ObjectTypeSymbol {
    private static final String ORG_NAME_BALLERINA = "ballerina";
    private static final String MODULE_NAME_LANG_VALUE = "lang.value";
    private List<Qualifier> qualifiers;
    private Map<String, ObjectFieldSymbol> objectFields;
    private Map<String, MethodSymbol> methods;
    private List<TypeSymbol> typeInclusions;

    public BallerinaObjectTypeSymbol(CompilerContext context, BObjectType objectType) {
        super(context, TypeDescKind.OBJECT, objectType);
    }

    @Override
    public List<Qualifier> qualifiers() {
        if (this.qualifiers != null) {
            return this.qualifiers;
        }
        ArrayList<Qualifier> qualifiers = new ArrayList<Qualifier>();
        BObjectType objectType = (BObjectType)this.getBType();
        long mask = objectType.tsymbol.flags;
        this.addIfFlagSet(qualifiers, mask, 0x8000000L, Qualifier.DISTINCT);
        this.addIfFlagSet(qualifiers, mask, 0x20000000L, Qualifier.ISOLATED);
        this.addIfFlagSet(qualifiers, mask, 65536L, Qualifier.CLIENT);
        this.addIfFlagSet(qualifiers, mask, 262144L, Qualifier.SERVICE);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        return this.qualifiers;
    }

    public Map<String, ObjectFieldSymbol> fieldDescriptors() {
        if (this.objectFields != null) {
            return this.objectFields;
        }
        FieldMap<String, BallerinaObjectFieldSymbol> fields = new FieldMap<String, BallerinaObjectFieldSymbol>();
        BObjectType type = (BObjectType)this.getBType();
        for (BField field : type.fields.values()) {
            fields.put(field.symbol.getOriginalName().value, new BallerinaObjectFieldSymbol(this.context, field));
        }
        this.objectFields = Collections.unmodifiableMap(fields);
        return this.objectFields;
    }

    @Override
    public Map<String, MethodSymbol> methods() {
        if (this.methods != null) {
            return this.methods;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        LinkedHashMap<Object, BallerinaMethodSymbol> methods = new LinkedHashMap<Object, BallerinaMethodSymbol>();
        for (BAttachedFunction attachedFunc : ((BObjectTypeSymbol)this.getBType().tsymbol).attachedFuncs) {
            if (attachedFunc instanceof BResourceFunction) {
                BResourceFunction resFn = (BResourceFunction)attachedFunc;
                String resPath = resFn.pathSegmentSymbols.stream().map(p -> p.name.value).collect(Collectors.joining("/"));
                methods.put(resFn.accessor.value + " " + resPath, symbolFactory.createResourceMethodSymbol(attachedFunc.symbol));
                continue;
            }
            methods.put(attachedFunc.funcName.value, symbolFactory.createMethodSymbol(attachedFunc.symbol, attachedFunc.symbol.getOriginalName().getValue()));
        }
        this.methods = Collections.unmodifiableMap(methods);
        return this.methods;
    }

    @Override
    public List<TypeSymbol> typeInclusions() {
        if (this.typeInclusions == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            List inclusions = ((BObjectType)this.getBType()).typeInclusions;
            ArrayList<TypeSymbol> typeRefs = new ArrayList<TypeSymbol>();
            for (BType inclusion : inclusions) {
                TypeSymbol type = typesFactory.getTypeDescriptor(inclusion);
                if (type == null) continue;
                typeRefs.add(type);
            }
            this.typeInclusions = Collections.unmodifiableList(typeRefs);
        }
        return this.typeInclusions;
    }

    @Override
    public String signature() {
        StringBuilder signature = new StringBuilder();
        StringJoiner qualifierJoiner = new StringJoiner(" ");
        StringJoiner fieldJoiner = new StringJoiner(" ");
        StringJoiner methodJoiner = new StringJoiner(" ");
        for (Qualifier typeQualifier : this.qualifiers()) {
            String value = typeQualifier.getValue();
            qualifierJoiner.add(value);
        }
        qualifierJoiner.add("object {");
        signature.append(qualifierJoiner);
        for (ObjectFieldSymbol objectFieldDescriptor : this.fieldDescriptors().values()) {
            fieldJoiner.add(objectFieldDescriptor.signature() + ";");
        }
        if (!this.methods().isEmpty() && !this.fieldDescriptors().isEmpty()) {
            signature.append(fieldJoiner).append(' ');
        } else {
            signature.append(fieldJoiner);
        }
        for (MethodSymbol method : this.methods().values()) {
            methodJoiner.add(method.signature() + ";");
        }
        return signature.append(methodJoiner).append("}").toString();
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    @Override
    protected List<FunctionSymbol> filterLangLibMethods(List<FunctionSymbol> functions, BType internalType) {
        List<FunctionSymbol> functionSymbols = super.filterLangLibMethods(functions, internalType);
        return functionSymbols.stream().filter(functionSymbol -> functionSymbol.getModule().isPresent()).filter(functionSymbol -> !ORG_NAME_BALLERINA.equals(functionSymbol.getModule().get().id().orgName()) || !MODULE_NAME_LANG_VALUE.equals(functionSymbol.getModule().get().id().moduleName())).collect(Collectors.toList());
    }

    private void addIfFlagSet(List<Qualifier> quals, long mask, long flag, Qualifier qualifier) {
        if (Symbols.isFlagOn(mask, flag)) {
            quals.add(qualifier);
        }
    }
}

