/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.WorkerSymbol;
import java.util.ArrayList;
import java.util.List;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaWorkerSymbol
extends BallerinaSymbol
implements WorkerSymbol {
    private final TypeSymbol returnType;
    private final List<AnnotationSymbol> annots;
    private final List<AnnotationAttachmentSymbol> annotAttachments;

    private BallerinaWorkerSymbol(String name, SymbolKind ballerinaSymbolKind, TypeSymbol returnType, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, BSymbol symbol, CompilerContext context) {
        super(name, ballerinaSymbolKind, symbol, context);
        this.returnType = returnType;
        this.annots = annots;
        this.annotAttachments = annotAttachments;
    }

    @Override
    public TypeSymbol returnType() {
        return this.returnType;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public List<AnnotationAttachmentSymbol> annotAttachments() {
        return this.annotAttachments;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    public static class WorkerSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<WorkerSymbolBuilder> {
        protected TypeSymbol returnType;
        protected List<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        protected List<AnnotationAttachmentSymbol> annotAttachments = new ArrayList<AnnotationAttachmentSymbol>();

        public WorkerSymbolBuilder(String name, BSymbol symbol, CompilerContext context) {
            super(name, SymbolKind.WORKER, symbol, context);
        }

        @Override
        public BallerinaWorkerSymbol build() {
            return new BallerinaWorkerSymbol(this.name, this.ballerinaSymbolKind, this.returnType, this.annots, this.annotAttachments, this.bSymbol, this.context);
        }

        public WorkerSymbolBuilder withReturnType(TypeSymbol typeDescriptor) {
            this.returnType = typeDescriptor;
            return this;
        }

        public WorkerSymbolBuilder withAnnotation(AnnotationSymbol annot) {
            this.annots.add(annot);
            return this;
        }

        public WorkerSymbolBuilder withAnnotationAttachment(AnnotationAttachmentSymbol annotAttachment) {
            this.annotAttachments.add(annotAttachment);
            return this;
        }
    }
}

