/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaFunctionTypeBuilder
implements TypeBuilder.FUNCTION {
    private final CompilerContext context;
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private final List<ParameterSymbol> parameterSymbols = new ArrayList<ParameterSymbol>();
    private ParameterSymbol restParam;
    private TypeSymbol returnTypeSymbol;

    public BallerinaFunctionTypeBuilder(CompilerContext context) {
        this.context = context;
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.FUNCTION withParams(ParameterSymbol ... parameters) {
        this.parameterSymbols.clear();
        this.parameterSymbols.addAll(Arrays.asList(parameters));
        return this;
    }

    @Override
    public TypeBuilder.FUNCTION withRestParam(ParameterSymbol restParam) {
        this.restParam = restParam;
        return this;
    }

    @Override
    public TypeBuilder.FUNCTION withReturnType(TypeSymbol returnType) {
        this.returnTypeSymbol = returnType;
        return this;
    }

    @Override
    public TypeBuilder.FUNCTION.PARAMETER_BUILDER params() {
        return new ParameterBuilder(this.context);
    }

    @Override
    public FunctionTypeSymbol build() {
        List<BType> paramTypes = this.getParamTypes(this.parameterSymbols);
        BType restType = this.getRestType(this.restParam);
        BType returnType = this.getReturnBType(this.returnTypeSymbol);
        BInvokableTypeSymbol tSymbol = Symbols.createInvokableTypeSymbol(33587228L, 1L, this.symTable.rootPkgSymbol.pkgID, this.symTable.invokableType, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        tSymbol.returnType = returnType;
        tSymbol.params = this.getParamSymbols(this.parameterSymbols);
        tSymbol.restParam = this.getRestParamSymbol(this.restParam, restType);
        BInvokableType bInvokableType = new BInvokableType(this.symTable.typeEnv(), paramTypes, restType, returnType, tSymbol);
        FunctionTypeSymbol functionTypeSymbol = (FunctionTypeSymbol)this.typesFactory.getTypeDescriptor(bInvokableType);
        this.parameterSymbols.clear();
        this.restParam = null;
        this.returnTypeSymbol = null;
        return functionTypeSymbol;
    }

    private BVarSymbol getRestParamSymbol(ParameterSymbol restParam, BType restType) {
        if (restParam == null) {
            return null;
        }
        BSymbol internalSymbol = ((BallerinaSymbol)((Object)restParam)).getInternalSymbol();
        if (internalSymbol instanceof BVarSymbol) {
            BVarSymbol varSymbol = (BVarSymbol)internalSymbol;
            varSymbol.type = restType;
            return varSymbol;
        }
        return null;
    }

    private BType getRestType(ParameterSymbol restParam) {
        if (restParam == null) {
            return null;
        }
        BType bType = this.getBType(restParam.typeDescriptor());
        BTypeSymbol restArraySymbol = Symbols.createTypeSymbol(8421404L, 1L, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        BArrayType restArrayType = new BArrayType(this.symTable.typeEnv(), bType, restArraySymbol, -1, BArrayState.OPEN);
        restArraySymbol.type = restArrayType;
        return restArrayType;
    }

    private List<BVarSymbol> getParamSymbols(List<ParameterSymbol> parameterSymbols) {
        ArrayList<BVarSymbol> params = new ArrayList<BVarSymbol>();
        for (ParameterSymbol parameterSymbol : parameterSymbols) {
            BSymbol internalSymbol = ((BallerinaSymbol)((Object)parameterSymbol)).getInternalSymbol();
            if (!(internalSymbol instanceof BVarSymbol)) continue;
            BVarSymbol bVarSymbol = (BVarSymbol)internalSymbol;
            params.add(bVarSymbol);
        }
        return params;
    }

    private List<BType> getParamTypes(List<ParameterSymbol> parameterSymbols) {
        ArrayList<BType> parameterTypes = new ArrayList<BType>();
        for (ParameterSymbol parameterSymbol : parameterSymbols) {
            parameterTypes.add(this.getBType(parameterSymbol.typeDescriptor()));
        }
        return parameterTypes;
    }

    private BType getBType(TypeSymbol typeSymbol) {
        if (typeSymbol instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeSymbol;
            return abstractTypeSymbol.getBType();
        }
        throw new IllegalArgumentException("Invalid type provided");
    }

    private BType getReturnBType(TypeSymbol returnTypeSymbol) {
        if (returnTypeSymbol == null) {
            return this.symTable.nilType;
        }
        if (returnTypeSymbol instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)returnTypeSymbol;
            return abstractTypeSymbol.getBType();
        }
        throw new IllegalArgumentException("Invalid return type provided");
    }

    public class ParameterBuilder
    implements TypeBuilder.FUNCTION.PARAMETER_BUILDER {
        private final SymbolFactory symbolFactory;
        private String name;
        private TypeSymbol type;
        private ParameterKind kind;

        private ParameterBuilder(CompilerContext context) {
            this.symbolFactory = SymbolFactory.getInstance(context);
        }

        @Override
        public TypeBuilder.FUNCTION.PARAMETER_BUILDER withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public TypeBuilder.FUNCTION.PARAMETER_BUILDER withType(TypeSymbol type) {
            this.type = type;
            return this;
        }

        @Override
        public TypeBuilder.FUNCTION.PARAMETER_BUILDER withKind(ParameterKind kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public ParameterSymbol build() {
            if (this.name == null) {
                throw new IllegalArgumentException("Parameter name can not be null");
            }
            long flags = 0x800000000L;
            if (this.kind != null) {
                switch (this.kind) {
                    case DEFAULTABLE: {
                        flags = 0x1000000000L;
                        break;
                    }
                    case REST: {
                        flags = 0x2000000000L;
                        break;
                    }
                    case INCLUDED_RECORD: {
                        flags = 0x400000000L;
                        break;
                    }
                }
            }
            BVarSymbol bVarSymbol = new BVarSymbol(flags, Names.fromString(this.name), BallerinaFunctionTypeBuilder.this.symTable.rootPkgSymbol.pkgID, this.getBType(this.type), BallerinaFunctionTypeBuilder.this.symTable.rootPkgSymbol, BallerinaFunctionTypeBuilder.this.symTable.builtinPos, BallerinaFunctionTypeBuilder.this.symTable.rootPkgSymbol.origin);
            ParameterSymbol parameterSymbol = (ParameterSymbol)this.symbolFactory.getBCompiledSymbol(bVarSymbol, this.name);
            this.name = null;
            this.type = null;
            this.kind = null;
            return parameterSymbol;
        }

        private BType getBType(TypeSymbol typeSymbol) {
            if (typeSymbol instanceof AbstractTypeSymbol) {
                AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeSymbol;
                return abstractTypeSymbol.getBType();
            }
            throw new IllegalArgumentException("Invalid type provided");
        }
    }
}

