/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Flags;

public class BallerinaObjectTypeBuilder
implements TypeBuilder.OBJECT {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private final List<Qualifier> qualifiers = new ArrayList<Qualifier>();
    private final List<TypeBuilder.OBJECT.OBJECT_FIELD> objectFieldList = new ArrayList<TypeBuilder.OBJECT.OBJECT_FIELD>();
    private final List<BAttachedFunction> objectMethodList = new ArrayList<BAttachedFunction>();
    private final List<TypeReferenceTypeSymbol> typeInclusions = new ArrayList<TypeReferenceTypeSymbol>();

    public BallerinaObjectTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.OBJECT withQualifier(Qualifier ... qualifiers) {
        this.qualifiers.clear();
        this.qualifiers.addAll(Arrays.asList(qualifiers));
        return this;
    }

    @Override
    public TypeBuilder.OBJECT withFields(TypeBuilder.OBJECT.OBJECT_FIELD ... fields) {
        this.objectFieldList.clear();
        this.objectFieldList.addAll(Arrays.asList(fields));
        return this;
    }

    @Override
    public TypeBuilder.OBJECT withMethods(TypeBuilder.OBJECT.OBJECT_METHOD ... methods) {
        this.objectMethodList.clear();
        this.objectMethodList.addAll(this.getObjectMethods(Arrays.asList(methods)));
        return this;
    }

    @Override
    public TypeBuilder.OBJECT withTypeInclusions(TypeReferenceTypeSymbol ... inclusions) {
        this.typeInclusions.clear();
        this.typeInclusions.addAll(Arrays.asList(inclusions));
        return this;
    }

    @Override
    public TypeBuilder.OBJECT.OBJECT_FIELD fields() {
        return new ObjectFieldDataHolder();
    }

    @Override
    public TypeBuilder.OBJECT.OBJECT_METHOD methods() {
        return new ObjectMethodDataHolder();
    }

    @Override
    public ObjectTypeSymbol build() {
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        long typeFlags = 0L;
        if (this.qualifiers.contains((Object)Qualifier.ISOLATED)) {
            flags.add(Flag.ISOLATED);
            typeFlags |= 0x20000000L;
        }
        if (this.qualifiers.contains((Object)Qualifier.SERVICE)) {
            flags.add(Flag.SERVICE);
            typeFlags |= 0x40000L;
        } else if (this.qualifiers.contains((Object)Qualifier.CLIENT)) {
            flags.add(Flag.CLIENT);
            typeFlags |= 0x10000L;
        }
        BObjectTypeSymbol objectSymbol = Symbols.createObjectSymbol(Flags.asMask(flags), Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol.owner, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        BObjectType objectType = new BObjectType(this.symTable.typeEnv(), (BTypeSymbol)objectSymbol, typeFlags);
        objectType.fields = this.getObjectFields(this.objectFieldList, objectSymbol);
        objectType.typeInclusions.addAll(this.getTypeInclusions(this.typeInclusions));
        objectSymbol.type = objectType;
        objectSymbol.attachedFuncs = new ArrayList<BAttachedFunction>(this.objectMethodList);
        ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)this.typesFactory.getTypeDescriptor(objectType);
        this.objectFieldList.clear();
        this.objectMethodList.clear();
        this.typeInclusions.clear();
        this.qualifiers.clear();
        return objectTypeSymbol;
    }

    private List<BType> getTypeInclusions(List<TypeReferenceTypeSymbol> typeInclusions) {
        ArrayList<BType> typeInclusionList = new ArrayList<BType>();
        for (TypeReferenceTypeSymbol typeInclusion : typeInclusions) {
            typeInclusionList.add(this.getTypeInclusionBType(typeInclusion));
        }
        return typeInclusionList;
    }

    private List<BAttachedFunction> getObjectMethods(List<TypeBuilder.OBJECT.OBJECT_METHOD> objectMethodList) {
        ArrayList<BAttachedFunction> attachedFunctions = new ArrayList<BAttachedFunction>();
        for (TypeBuilder.OBJECT.OBJECT_METHOD objectMethod : objectMethodList) {
            BInvokableSymbol invokableSymbol = this.getObjectMethodInvokableSymbol(objectMethod);
            attachedFunctions.add(new BAttachedFunction(invokableSymbol.getOriginalName(), invokableSymbol, invokableSymbol.getType(), this.symTable.builtinPos));
        }
        return attachedFunctions;
    }

    private BInvokableSymbol getObjectMethodInvokableSymbol(TypeBuilder.OBJECT.OBJECT_METHOD objectMethod) {
        EnumSet<Flag> flags = EnumSet.of(Flag.ATTACHED);
        Name symbolName = Names.fromString(objectMethod.getName());
        return Symbols.createInvokableSymbol(820L, Flags.asMask(flags), symbolName, symbolName, this.symTable.rootPkgSymbol.pkgID, this.getBInvokableType(objectMethod.getType()), this.symTable.rootPkgSymbol.owner, this.symTable.builtinPos, this.symTable.rootPkgSymbol.origin);
    }

    private BInvokableType getBInvokableType(FunctionTypeSymbol type) {
        AbstractTypeSymbol abstractTypeSymbol;
        BType bType;
        if (type instanceof AbstractTypeSymbol && (bType = (abstractTypeSymbol = (AbstractTypeSymbol)((Object)type)).getBType()) instanceof BInvokableType) {
            BInvokableType bInvokableType = (BInvokableType)bType;
            return bInvokableType;
        }
        throw new IllegalArgumentException("Object method type descriptor can not be null");
    }

    private LinkedHashMap<String, BField> getObjectFields(List<TypeBuilder.OBJECT.OBJECT_FIELD> objectFieldList, BObjectTypeSymbol ownerObjectTypeSymbol) {
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        for (TypeBuilder.OBJECT.OBJECT_FIELD objectField : objectFieldList) {
            BField bField = this.getBField(objectField, ownerObjectTypeSymbol);
            fields.put(bField.getName().getValue(), bField);
        }
        return fields;
    }

    private BField getBField(TypeBuilder.OBJECT.OBJECT_FIELD objectField, BObjectTypeSymbol ownerObjectTypeSymbol) {
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if (objectField.isPublicField()) {
            flags.add(Flag.PUBLIC);
        }
        BVarSymbol fieldSymbol = new BVarSymbol(Flags.asMask(flags), Names.fromString(objectField.getName()), ownerObjectTypeSymbol.pkgID, this.getBType(objectField.getType()), ownerObjectTypeSymbol, this.symTable.builtinPos, ownerObjectTypeSymbol.origin);
        return new BField(Names.fromString(objectField.getName()), this.symTable.builtinPos, fieldSymbol);
    }

    private BType getBType(TypeSymbol typeSymbol) {
        if (typeSymbol != null && typeSymbol instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeSymbol;
            return abstractTypeSymbol.getBType();
        }
        throw new IllegalArgumentException("Invalid type provided");
    }

    private BType getTypeInclusionBType(TypeSymbol typeSymbol) {
        if (typeSymbol != null) {
            if (typeSymbol instanceof AbstractTypeSymbol) {
                AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeSymbol;
                return abstractTypeSymbol.getBType();
            }
            throw new IllegalArgumentException("Invalid type provided");
        }
        return null;
    }

    public static class ObjectFieldDataHolder
    implements TypeBuilder.OBJECT.OBJECT_FIELD {
        private boolean isPublicField = false;
        private TypeSymbol type;
        private String name;

        @Override
        public TypeBuilder.OBJECT.OBJECT_FIELD isPublic() {
            this.isPublicField = true;
            return this;
        }

        @Override
        public TypeBuilder.OBJECT.OBJECT_FIELD withType(TypeSymbol type) {
            this.type = type;
            return this;
        }

        @Override
        public TypeBuilder.OBJECT.OBJECT_FIELD withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public boolean isPublicField() {
            return this.isPublicField;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeSymbol getType() {
            return this.type;
        }

        @Override
        public TypeBuilder.OBJECT.OBJECT_FIELD get() {
            if (this.name == null) {
                throw new IllegalArgumentException("Field name can not be null");
            }
            return this;
        }
    }

    public static class ObjectMethodDataHolder
    implements TypeBuilder.OBJECT.OBJECT_METHOD {
        private List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        private FunctionTypeSymbol type;
        private String name;

        @Override
        public TypeBuilder.OBJECT.OBJECT_METHOD withQualifiers(Qualifier ... qualifiers) {
            if (!this.qualifiers.isEmpty()) {
                this.qualifiers = new ArrayList<Qualifier>();
            }
            this.qualifiers.addAll(Arrays.asList(qualifiers));
            return this;
        }

        @Override
        public TypeBuilder.OBJECT.OBJECT_METHOD withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public TypeBuilder.OBJECT.OBJECT_METHOD withType(FunctionTypeSymbol type) {
            this.type = type;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public FunctionTypeSymbol getType() {
            return this.type;
        }

        @Override
        public TypeBuilder.OBJECT.OBJECT_METHOD get() {
            if (this.name == null) {
                throw new IllegalArgumentException("Method name can not be null");
            }
            return this;
        }
    }
}

