/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaStreamTypeBuilder
implements TypeBuilder.STREAM {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private TypeSymbol valueType;
    private TypeSymbol completionType;

    public BallerinaStreamTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.STREAM withValueType(TypeSymbol valueType) {
        this.valueType = valueType;
        return this;
    }

    @Override
    public TypeBuilder.STREAM withCompletionType(TypeSymbol completionType) {
        this.completionType = completionType;
        return this;
    }

    @Override
    public StreamTypeSymbol build() {
        BTypeSymbol streamSymbol = Symbols.createTypeSymbol(12L, 1L, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, this.symTable.rootPkgSymbol.origin);
        BStreamType streamType = new BStreamType(this.symTable.typeEnv(), 15, this.getValueBType(this.valueType), this.getCompletionBType(this.completionType), streamSymbol);
        streamSymbol.type = streamType;
        StreamTypeSymbol streamTypeSymbol = (StreamTypeSymbol)this.typesFactory.getTypeDescriptor(streamType);
        this.valueType = null;
        this.completionType = null;
        return streamTypeSymbol;
    }

    private BType getValueBType(TypeSymbol valueType) {
        if (valueType == null) {
            return this.symTable.anyType;
        }
        if (valueType instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)valueType;
            return abstractTypeSymbol.getBType();
        }
        return this.symTable.noType;
    }

    private BType getCompletionBType(TypeSymbol completionType) {
        if (completionType instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)completionType;
            return abstractTypeSymbol.getBType();
        }
        return this.symTable.nilType;
    }
}

