/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Package;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.TomlDocumentContext;
import io.ballerina.toml.semantic.ast.TomlTableNode;

public class BalToolToml {
    private final TomlDocumentContext balToolTomlContext;
    private final Package packageInstance;

    private BalToolToml(TomlDocumentContext balToolTomlContext, Package packageInstance) {
        this.balToolTomlContext = balToolTomlContext;
        this.packageInstance = packageInstance;
    }

    public static BalToolToml from(TomlDocumentContext balToolTomlContext, Package pkg) {
        return new BalToolToml(balToolTomlContext, pkg);
    }

    TomlDocumentContext balToolTomlContext() {
        return this.balToolTomlContext;
    }

    public Package packageInstance() {
        return this.packageInstance;
    }

    public String name() {
        return "BalTool.toml";
    }

    public TomlTableNode tomlAstNode() {
        return this.tomlDocument().toml().rootNode();
    }

    public TomlDocument tomlDocument() {
        return this.balToolTomlContext.tomlDocument();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    public static class Modifier {
        private TomlDocument tomlDocument;
        private final Package oldPackage;

        private Modifier(BalToolToml oldDocument) {
            this.tomlDocument = oldDocument.tomlDocument();
            this.oldPackage = oldDocument.packageInstance();
        }

        public Modifier withContent(String content) {
            this.tomlDocument = TomlDocument.from("BalTool.toml", content);
            return this;
        }

        public BalToolToml apply() {
            BalToolToml balToolToml = BalToolToml.from(TomlDocumentContext.from(this.tomlDocument), this.oldPackage);
            Package newPackage = this.oldPackage.modify().updateBalToolToml(balToolToml).apply();
            return newPackage.balToolToml().get();
        }
    }
}

