/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.TomlDocumentContext;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class BalToolsToml {
    private final Path balToolsTomlPath;
    private TomlDocumentContext balToolsTomlContext;

    private BalToolsToml(Path balToolsTomlPath) {
        String content = BalToolsToml.read(balToolsTomlPath);
        this.balToolsTomlContext = TomlDocumentContext.from(TomlDocument.from("bal-tools.toml", content));
        this.balToolsTomlPath = balToolsTomlPath;
    }

    public static BalToolsToml from(Path balToolsTomlPath) {
        return new BalToolsToml(balToolsTomlPath);
    }

    private static String read(Path balToolsTomlPath) {
        StringBuilder content = new StringBuilder();
        if (!balToolsTomlPath.toFile().exists()) {
            try {
                Path parentDirectory = balToolsTomlPath.getParent();
                if (parentDirectory != null && !parentDirectory.toFile().exists()) {
                    Files.createDirectories(parentDirectory, new FileAttribute[0]);
                }
                Files.createFile(balToolsTomlPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while creating bal-tools.toml :" + String.valueOf(e));
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(balToolsTomlPath.toString(), Charset.defaultCharset()));){
            String line = reader.readLine();
            while (line != null) {
                content.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading bal-tools.toml :" + String.valueOf(e));
        }
        return String.valueOf(content);
    }

    TomlDocumentContext ballerinaTomlContext() {
        return this.balToolsTomlContext;
    }

    public String name() {
        return "bal-tools.toml";
    }

    public TomlTableNode tomlAstNode() {
        return this.tomlDocument().toml().rootNode();
    }

    public TomlDocument tomlDocument() {
        return this.balToolsTomlContext.tomlDocument();
    }

    public Path path() {
        return this.balToolsTomlPath;
    }

    public void modify(BalToolsManifest balToolsManifest) {
        String updatedContent = this.generateContent(balToolsManifest);
        this.balToolsTomlContext = TomlDocumentContext.from(TomlDocument.from("bal-tools.toml", updatedContent));
        this.write(updatedContent);
    }

    private String generateContent(BalToolsManifest balToolsManifest) {
        StringBuilder content = new StringBuilder();
        content.append(this.getAutoGenCode());
        for (Map.Entry<String, Map<String, Map<String, BalToolsManifest.Tool>>> toolEntry : balToolsManifest.tools().entrySet()) {
            for (Map.Entry<String, Map<String, BalToolsManifest.Tool>> toolVersions : toolEntry.getValue().entrySet()) {
                for (Map.Entry<String, BalToolsManifest.Tool> tool : toolVersions.getValue().entrySet()) {
                    content.append("[[tool]]\n");
                    content.append("id = \"").append(tool.getValue().id()).append("\"\n");
                    content.append("org = \"").append(tool.getValue().org()).append("\"\n");
                    content.append("name = \"").append(tool.getValue().name()).append("\"\n");
                    content.append("version = \"").append(tool.getValue().version()).append("\"\n");
                    content.append("active = ").append(tool.getValue().active()).append("\n");
                    if (tool.getValue().force()) {
                        content.append("force = ").append(tool.getValue().force()).append("\n");
                    }
                    if (tool.getValue().repository() != null) {
                        content.append("repository = \"").append(tool.getValue().repository()).append("\"\n");
                    }
                    content.append("\n");
                }
            }
        }
        return String.valueOf(content);
    }

    private void write(String content) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(this.balToolsTomlPath), Charset.defaultCharset()));){
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while updating bal-tools.toml :" + String.valueOf(e));
        }
    }

    private String getAutoGenCode() {
        return "# AUTO-GENERATED FILE. DO NOT MODIFY.\n\n# This file is auto-generated by Ballerina for managing tool commands.\n# It should not be modified by hand.\n\n";
    }
}

