/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.util.BalToolsUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BlendedBalToolsManifest {
    private final Map<String, Map<String, Map<String, BalToolsManifest.Tool>>> tools;

    public BlendedBalToolsManifest(Map<String, Map<String, Map<String, BalToolsManifest.Tool>>> tools) {
        this.tools = tools;
    }

    public static BlendedBalToolsManifest from(BalToolsManifest localBalToolManifest, BalToolsManifest distBalToolManifest) {
        return BlendedBalToolsManifest.mergeBalToolManifests(localBalToolManifest, distBalToolManifest);
    }

    private static BlendedBalToolsManifest mergeBalToolManifests(BalToolsManifest localBalToolsManifest, BalToolsManifest distBalToolsManifest) {
        HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>> mergedTools = new HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>>();
        for (Map.Entry<String, Map<String, Map<String, BalToolsManifest.Tool>>> entry : localBalToolsManifest.tools().entrySet()) {
            mergedTools.put(entry.getKey(), new HashMap<String, Map<String, BalToolsManifest.Tool>>(entry.getValue()));
        }
        for (Map.Entry<String, Map<String, Map<String, BalToolsManifest.Tool>>> entry : mergedTools.entrySet()) {
            Optional<PackageVersion> highestVersion;
            String version;
            String name;
            BalToolsManifest.Tool tool2;
            String org;
            SemanticVersion.VersionCompatibilityResult versionCompatibilityResult;
            Optional<BalToolsManifest.Tool> activeTool;
            String toolId = entry.getKey();
            if (BalToolsUtil.getInBuiltToolCommands(distBalToolsManifest).contains(toolId) || (activeTool = localBalToolsManifest.getActiveTool(toolId)).isPresent() && "local".equals(activeTool.get().repository()) || activeTool.isPresent() && activeTool.get().force() || (versionCompatibilityResult = BalToolsUtil.compareToolDistWithCurrentDist(org = (tool2 = (BalToolsManifest.Tool)((Map)mergedTools.get(toolId)).values().stream().flatMap(map -> map.values().stream()).findFirst().orElseThrow()).org(), name = tool2.name(), version = tool2.version(), tool2.repository())).equals((Object)SemanticVersion.VersionCompatibilityResult.INCOMPATIBLE) || versionCompatibilityResult.equals((Object)SemanticVersion.VersionCompatibilityResult.EQUAL) || (highestVersion = BlendedBalToolsManifest.getHighestCompatibleLocalVersion(localBalToolsManifest, toolId, org, name)).isEmpty()) continue;
            ((BalToolsManifest.Tool)((Map)((Map)mergedTools.get(toolId)).get(version)).get(null)).setActive(false);
            ((BalToolsManifest.Tool)((Map)((Map)mergedTools.get(toolId)).get(highestVersion.get().toString())).get(null)).setActive(true);
        }
        for (String string : BalToolsUtil.getInBuiltToolCommands(distBalToolsManifest)) {
            BalToolsManifest.Tool localTool;
            Optional<BalToolsManifest.Tool> activeToolDist = distBalToolsManifest.getActiveTool(string);
            if (!mergedTools.containsKey(string)) {
                BalToolsManifest.Tool tool4 = activeToolDist.orElseThrow();
                BalToolsManifest.Tool toolNew = new BalToolsManifest.Tool(tool4.id(), tool4.org(), tool4.name(), tool4.version(), true, "distribution");
                mergedTools.put(tool4.id(), Map.of(tool4.version(), Map.of("distribution", toolNew)));
                continue;
            }
            Optional<BalToolsManifest.Tool> sameToolInLocal = ((Map)mergedTools.get(string)).values().stream().flatMap(v -> v.values().stream()).filter(tool1 -> tool1.id().equals(((BalToolsManifest.Tool)activeToolDist.orElseThrow()).id()) && tool1.version().equals(((BalToolsManifest.Tool)activeToolDist.orElseThrow()).version())).findFirst();
            if (sameToolInLocal.isEmpty()) {
                BalToolsManifest.Tool toolDist = activeToolDist.orElseThrow();
                BalToolsManifest.Tool toolNew = new BalToolsManifest.Tool(toolDist.id(), toolDist.org(), toolDist.name(), toolDist.version(), false, "distribution");
                if (mergedTools.containsKey(toolDist.id())) {
                    ((Map)mergedTools.get(toolDist.id())).put(toolDist.version(), Map.of("distribution", toolNew));
                } else {
                    mergedTools.put(toolDist.id(), Map.of(toolDist.version(), Map.of("distribution", toolNew)));
                }
            }
            Optional<BalToolsManifest.Tool> activeToolLocal = ((Map)mergedTools.get(string)).values().stream().flatMap(v -> v.values().stream()).filter(BalToolsManifest.Tool::active).findFirst();
            BalToolsManifest.Tool distTool = activeToolDist.orElseThrow();
            if (activeToolLocal.isEmpty()) {
                Optional<PackageVersion> highestVersion = BlendedBalToolsManifest.getHighestCompatibleLocalVersion(localBalToolsManifest, activeToolDist.get().id(), activeToolDist.get().org(), activeToolDist.get().name());
                if (highestVersion.isEmpty()) {
                    BalToolsManifest.Tool toolNew = new BalToolsManifest.Tool(distTool.id(), distTool.org(), distTool.name(), distTool.version(), true, "distribution");
                    if (mergedTools.containsKey(distTool.id())) {
                        ((Map)mergedTools.get(distTool.id())).put(distTool.version(), Map.of("distribution", toolNew));
                        continue;
                    }
                    mergedTools.put(distTool.id(), Map.of(distTool.version(), Map.of("distribution", toolNew)));
                    continue;
                }
                activeToolLocal = ((Map)mergedTools.get(string)).values().stream().flatMap(v -> v.values().stream()).filter(tool -> tool.version().equals(((PackageVersion)highestVersion.get()).toString())).findFirst();
            }
            if ("local".equals((localTool = activeToolLocal.orElseThrow()).repository()) || localTool.force()) continue;
            Optional<PackageVersion> highestVersion = BlendedBalToolsManifest.getHighestCompatibleLocalVersion(localBalToolsManifest, localTool.id(), localTool.org(), localTool.name());
            if (highestVersion.isEmpty() || SemanticVersion.from(highestVersion.get().toString()).lessThan(SemanticVersion.from(activeToolDist.orElseThrow().version()))) {
                ((Map)mergedTools.get(localTool.id())).forEach((k, v) -> v.forEach((k1, v1) -> v1.setActive(false)));
                BalToolsManifest.Tool tool3 = activeToolDist.orElseThrow();
                BalToolsManifest.Tool toolNew = new BalToolsManifest.Tool(tool3.id(), tool3.org(), tool3.name(), tool3.version(), true, "distribution");
                if (mergedTools.containsKey(distTool.id())) {
                    ((Map)mergedTools.get(distTool.id())).put(distTool.version(), Map.of("distribution", toolNew));
                    continue;
                }
                mergedTools.put(distTool.id(), Map.of(distTool.version(), Map.of("distribution", toolNew)));
                continue;
            }
            BalToolsManifest.Tool tool2 = new BalToolsManifest.Tool(localTool.id(), localTool.org(), localTool.name(), highestVersion.toString(), true, localTool.repository());
            ((Map)mergedTools.get(localTool.id())).forEach((k, v) -> v.forEach((k1, v1) -> v1.setActive(false)));
            ((BalToolsManifest.Tool)((Map)((Map)mergedTools.get(tool2.id())).get(highestVersion.get().toString())).get(null)).setActive(true);
            Optional<BalToolsManifest.Tool> distToolInLocal = ((Map)mergedTools.get(string)).values().stream().flatMap(v -> v.values().stream()).filter(tool1 -> tool1.id().equals(((BalToolsManifest.Tool)activeToolDist.orElseThrow()).id()) && tool1.version().equals(((BalToolsManifest.Tool)activeToolDist.orElseThrow()).version())).findFirst();
            if (!distToolInLocal.isEmpty()) continue;
            BalToolsManifest.Tool toolDist = activeToolDist.orElseThrow();
            BalToolsManifest.Tool toolNew = new BalToolsManifest.Tool(toolDist.id(), toolDist.org(), toolDist.name(), toolDist.version(), false, "distribution");
            if (mergedTools.containsKey(toolDist.id())) {
                ((Map)mergedTools.get(toolDist.id())).put(toolDist.version(), Map.of("distribution", toolNew));
                continue;
            }
            mergedTools.put(toolDist.id(), Map.of(toolDist.version(), Map.of("distribution", toolNew)));
        }
        return new BlendedBalToolsManifest(mergedTools);
    }

    private static Optional<PackageVersion> getHighestCompatibleLocalVersion(BalToolsManifest localBalToolsManifest, String toolId, String org, String name) {
        ArrayList<PackageVersion> toolVersions = new ArrayList<PackageVersion>(localBalToolsManifest.tools().get(toolId).keySet().stream().map(PackageVersion::from).filter(version -> !localBalToolsManifest.tools().get(toolId).get(version.toString()).containsKey("local")).toList());
        toolVersions.removeIf(version -> {
            SemanticVersion.VersionCompatibilityResult versionCompatibilityResult = BalToolsUtil.compareToolDistWithCurrentDist(org, name, version.toString(), null);
            return versionCompatibilityResult.equals((Object)SemanticVersion.VersionCompatibilityResult.GREATER_THAN) || versionCompatibilityResult.equals((Object)SemanticVersion.VersionCompatibilityResult.INCOMPATIBLE);
        });
        if (toolVersions.isEmpty()) {
            return Optional.empty();
        }
        PackageVersion highestVersion = (PackageVersion)toolVersions.stream().findFirst().orElseThrow();
        for (PackageVersion toolVersion : toolVersions) {
            highestVersion = ProjectUtils.getLatest(highestVersion, toolVersion);
        }
        return Optional.of(highestVersion);
    }

    public Map<String, Map<String, Map<String, BalToolsManifest.Tool>>> tools() {
        return this.tools;
    }

    public Map<String, Map<String, Map<String, BalToolsManifest.Tool>>> compatibleTools() {
        HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>> compatibleTools = new HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>>(this.tools);
        for (String toolId : this.tools.keySet()) {
            Map versions = (Map)compatibleTools.get(toolId);
            versions.keySet().removeIf(version -> !BalToolsUtil.isCompatibleWithPlatform(((BalToolsManifest.Tool)((Map)versions.get(version)).values().iterator().next()).org(), ((BalToolsManifest.Tool)((Map)versions.get(version)).values().iterator().next()).name(), version, ((BalToolsManifest.Tool)((Map)versions.get(version)).values().iterator().next()).repository()));
        }
        return compatibleTools;
    }

    public Map<String, Map<String, BalToolsManifest.Tool>> compatibleVersions(String toolId) {
        HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>> compatibleTools = new HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>>(this.tools);
        Map versions = (Map)compatibleTools.get(toolId);
        if (versions == null) {
            return new HashMap<String, Map<String, BalToolsManifest.Tool>>();
        }
        versions.keySet().removeIf(version -> !BalToolsUtil.isCompatibleWithPlatform(((BalToolsManifest.Tool)((Map)versions.get(version)).values().iterator().next()).org(), ((BalToolsManifest.Tool)((Map)versions.get(version)).values().iterator().next()).name(), version, ((BalToolsManifest.Tool)((Map)versions.get(version)).values().iterator().next()).repository()));
        return versions;
    }

    public Optional<BalToolsManifest.Tool> getTool(String id, String version, String repository) {
        if (this.tools.containsKey(id) && this.tools.get(id).containsKey(version)) {
            if ("local".equals(repository)) {
                return Optional.ofNullable(this.tools.get(id).get(version).get(repository));
            }
            return Optional.of(this.tools.get(id).get(version).entrySet().iterator().next().getValue());
        }
        return Optional.empty();
    }

    public Optional<BalToolsManifest.Tool> getActiveTool(String id) {
        if (this.tools.containsKey(id)) {
            Optional<BalToolsManifest.Tool> activeTool = this.tools.get(id).values().stream().flatMap(v -> v.values().stream()).filter(BalToolsManifest.Tool::force).findFirst();
            if (activeTool.isEmpty()) {
                activeTool = this.tools.get(id).values().stream().flatMap(v -> v.values().stream()).filter(BalToolsManifest.Tool::active).findFirst();
            }
            return activeTool;
        }
        return Optional.empty();
    }

    public BalToolsManifest.Tool getHighestCompatibleToolVersion(String toolId) {
        Map<String, Map<String, Map<String, BalToolsManifest.Tool>>> compatibleTools = this.compatibleTools();
        ArrayList<PackageVersion> toolVersions = new ArrayList<PackageVersion>(compatibleTools.get(toolId).keySet().stream().map(PackageVersion::from).filter(version -> !((Map)((Map)compatibleTools.get(toolId)).get(version.toString())).containsKey("local")).toList());
        PackageVersion highestVersion = (PackageVersion)toolVersions.stream().findFirst().orElseThrow();
        for (PackageVersion toolVersion : toolVersions) {
            highestVersion = ProjectUtils.getLatest(highestVersion, toolVersion);
        }
        return compatibleTools.get(toolId).get(highestVersion.toString()).values().iterator().next();
    }
}

