/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.environment.PackageLockingMode;
import java.util.Objects;

public class BuildOptions {
    private final Boolean showDependencyDiagnostics;
    private final Boolean testReport;
    private final Boolean codeCoverage;
    private final Boolean dumpBuildTime;
    private final Boolean skipTests;
    private final CompilationOptions compilationOptions;
    private final String targetDir;
    private final Boolean nativeImage;
    private final Boolean exportComponentModel;
    private final String graalVMBuildOptions;

    BuildOptions(Boolean testReport, Boolean codeCoverage, Boolean dumpBuildTime, Boolean skipTests, CompilationOptions compilationOptions, String targetPath, Boolean nativeImage, Boolean exportComponentModel, String graalVMBuildOptions, Boolean showDependencyDiagnostics) {
        this.testReport = testReport;
        this.codeCoverage = codeCoverage;
        this.dumpBuildTime = dumpBuildTime;
        this.skipTests = skipTests;
        this.compilationOptions = compilationOptions;
        this.targetDir = targetPath;
        this.nativeImage = nativeImage;
        this.exportComponentModel = exportComponentModel;
        this.graalVMBuildOptions = graalVMBuildOptions;
        this.showDependencyDiagnostics = showDependencyDiagnostics;
    }

    public boolean testReport() {
        return this.toBooleanDefaultIfNull(this.testReport);
    }

    public boolean codeCoverage() {
        return this.toBooleanDefaultIfNull(this.codeCoverage);
    }

    public boolean dumpBuildTime() {
        return this.toBooleanDefaultIfNull(this.dumpBuildTime);
    }

    public boolean skipTests() {
        return this.toBooleanTrueIfNull(this.skipTests);
    }

    public boolean offlineBuild() {
        return this.compilationOptions.offlineBuild();
    }

    @Deprecated(forRemoval=true, since="2201.13.0")
    public boolean sticky() {
        return this.compilationOptions.sticky();
    }

    public boolean disableSyntaxTree() {
        return this.compilationOptions.disableSyntaxTree();
    }

    public boolean optimizeDependencyCompilation() {
        return this.compilationOptions.optimizeDependencyCompilation();
    }

    public PackageLockingMode lockingMode() {
        if (this.compilationOptions.lockingMode() == null) {
            return PackageLockingMode.MEDIUM;
        }
        return this.compilationOptions.lockingMode();
    }

    public PackageLockingMode rawLockingMode() {
        return this.compilationOptions.lockingMode();
    }

    public boolean experimental() {
        return this.compilationOptions.experimental();
    }

    public boolean observabilityIncluded() {
        return this.compilationOptions.observabilityIncluded();
    }

    public boolean listConflictedClasses() {
        return this.compilationOptions.listConflictedClasses();
    }

    public String cloud() {
        return this.compilationOptions.getCloud();
    }

    public boolean remoteManagement() {
        return this.compilationOptions.remoteManagement();
    }

    CompilationOptions compilationOptions() {
        return this.compilationOptions;
    }

    public boolean exportOpenAPI() {
        return this.compilationOptions.exportOpenAPI();
    }

    public boolean exportComponentModel() {
        return this.compilationOptions.exportComponentModel();
    }

    public boolean nativeImage() {
        return this.toBooleanDefaultIfNull(this.nativeImage);
    }

    public String graalVMBuildOptions() {
        return Objects.requireNonNullElse(this.graalVMBuildOptions, "");
    }

    public boolean showDependencyDiagnostics() {
        return this.toBooleanDefaultIfNull(this.showDependencyDiagnostics);
    }

    public BuildOptions acceptTheirs(BuildOptions theirOptions) {
        BuildOptionsBuilder buildOptionsBuilder = new BuildOptionsBuilder();
        if (theirOptions.skipTests != null) {
            buildOptionsBuilder.setSkipTests(theirOptions.skipTests);
        } else {
            buildOptionsBuilder.setSkipTests(this.skipTests);
        }
        if (theirOptions.codeCoverage != null) {
            buildOptionsBuilder.setCodeCoverage(theirOptions.codeCoverage);
        } else {
            buildOptionsBuilder.setCodeCoverage(this.codeCoverage);
        }
        if (theirOptions.testReport != null) {
            buildOptionsBuilder.setTestReport(theirOptions.testReport);
        } else {
            buildOptionsBuilder.setTestReport(this.testReport);
        }
        if (theirOptions.dumpBuildTime != null) {
            buildOptionsBuilder.setDumpBuildTime(theirOptions.dumpBuildTime);
        } else {
            buildOptionsBuilder.setDumpBuildTime(this.dumpBuildTime);
        }
        if (theirOptions.targetDir != null) {
            buildOptionsBuilder.targetDir(theirOptions.targetDir);
        } else {
            buildOptionsBuilder.targetDir(this.targetDir);
        }
        if (theirOptions.nativeImage != null) {
            buildOptionsBuilder.setNativeImage(theirOptions.nativeImage);
        } else {
            buildOptionsBuilder.setNativeImage(this.nativeImage);
        }
        if (theirOptions.exportComponentModel != null) {
            buildOptionsBuilder.setExportComponentModel(theirOptions.exportComponentModel);
        } else {
            buildOptionsBuilder.setExportComponentModel(this.exportComponentModel);
        }
        if (theirOptions.graalVMBuildOptions != null) {
            buildOptionsBuilder.setGraalVMBuildOptions(theirOptions.graalVMBuildOptions);
        } else {
            buildOptionsBuilder.setGraalVMBuildOptions(this.graalVMBuildOptions);
        }
        if (theirOptions.showDependencyDiagnostics != null) {
            buildOptionsBuilder.setShowDependencyDiagnostics(theirOptions.showDependencyDiagnostics);
        } else {
            buildOptionsBuilder.setShowDependencyDiagnostics(this.showDependencyDiagnostics);
        }
        CompilationOptions compilationOptions = this.compilationOptions.acceptTheirs(theirOptions.compilationOptions());
        buildOptionsBuilder.setOffline(compilationOptions.offlineBuild);
        buildOptionsBuilder.setExperimental(compilationOptions.experimental);
        buildOptionsBuilder.setObservabilityIncluded(compilationOptions.observabilityIncluded);
        buildOptionsBuilder.setDumpBir(compilationOptions.dumpBir);
        buildOptionsBuilder.setDumpBirFile(compilationOptions.dumpBirFile);
        buildOptionsBuilder.setDumpGraph(compilationOptions.dumpGraph);
        buildOptionsBuilder.setDumpRawGraphs(compilationOptions.dumpRawGraphs);
        buildOptionsBuilder.setCloud(compilationOptions.cloud);
        buildOptionsBuilder.setListConflictedClasses(compilationOptions.listConflictedClasses);
        buildOptionsBuilder.setSticky(compilationOptions.sticky);
        buildOptionsBuilder.setConfigSchemaGen(compilationOptions.configSchemaGen);
        buildOptionsBuilder.setExportOpenAPI(compilationOptions.exportOpenAPI);
        buildOptionsBuilder.setExportComponentModel(compilationOptions.exportComponentModel);
        buildOptionsBuilder.setRemoteManagement(compilationOptions.remoteManagement);
        buildOptionsBuilder.setOptimizeDependencyCompilation(compilationOptions.optimizeDependencyCompilation);
        buildOptionsBuilder.setLockingMode(compilationOptions.lockingMode);
        return buildOptionsBuilder.build();
    }

    public static BuildOptionsBuilder builder() {
        return new BuildOptionsBuilder();
    }

    private boolean toBooleanDefaultIfNull(Boolean bool) {
        if (bool == null) {
            return false;
        }
        return bool;
    }

    private boolean toBooleanTrueIfNull(Boolean bool) {
        if (bool == null) {
            return true;
        }
        return bool;
    }

    public String getTargetPath() {
        return this.targetDir;
    }

    public static class BuildOptionsBuilder {
        private Boolean testReport;
        private Boolean codeCoverage;
        private Boolean dumpBuildTime;
        private Boolean skipTests;
        private String targetPath;
        private final CompilationOptions.CompilationOptionsBuilder compilationOptionsBuilder = CompilationOptions.builder();
        private Boolean nativeImage;
        private Boolean exportComponentModel;
        private String graalVMBuildOptions;
        private Boolean showDependencyDiagnostics;

        private BuildOptionsBuilder() {
        }

        public BuildOptionsBuilder disableSyntaxTreeCaching(Boolean value) {
            this.compilationOptionsBuilder.disableSyntaxTree(value);
            return this;
        }

        public BuildOptionsBuilder setTestReport(Boolean value) {
            this.testReport = value;
            return this;
        }

        public BuildOptionsBuilder setCodeCoverage(Boolean value) {
            this.codeCoverage = value;
            return this;
        }

        public BuildOptionsBuilder setDumpBuildTime(Boolean value) {
            this.dumpBuildTime = value;
            return this;
        }

        public BuildOptionsBuilder setSkipTests(Boolean value) {
            this.skipTests = value;
            return this;
        }

        @Deprecated(forRemoval=true, since="2201.13.0")
        public BuildOptionsBuilder setSticky(Boolean value) {
            this.compilationOptionsBuilder.setSticky(value);
            return this;
        }

        public BuildOptionsBuilder setListConflictedClasses(Boolean value) {
            this.compilationOptionsBuilder.setListConflictedClasses(value);
            return this;
        }

        public BuildOptionsBuilder setOffline(Boolean value) {
            this.compilationOptionsBuilder.setOffline(value);
            return this;
        }

        public BuildOptionsBuilder setGraalVMBuildOptions(String value) {
            this.graalVMBuildOptions = value;
            return this;
        }

        public BuildOptionsBuilder setExperimental(Boolean value) {
            this.compilationOptionsBuilder.setExperimental(value);
            return this;
        }

        public BuildOptionsBuilder setObservabilityIncluded(Boolean value) {
            this.compilationOptionsBuilder.setObservabilityIncluded(value);
            return this;
        }

        public BuildOptionsBuilder setCloud(String value) {
            this.compilationOptionsBuilder.setCloud(value);
            return this;
        }

        public BuildOptionsBuilder setDumpBir(Boolean value) {
            this.compilationOptionsBuilder.setDumpBir(value);
            return this;
        }

        public BuildOptionsBuilder setDumpBirFile(Boolean value) {
            this.compilationOptionsBuilder.setDumpBirFile(value);
            return this;
        }

        public BuildOptionsBuilder setDumpGraph(Boolean value) {
            this.compilationOptionsBuilder.setDumpGraph(value);
            return this;
        }

        public BuildOptionsBuilder setDumpRawGraphs(Boolean value) {
            this.compilationOptionsBuilder.setDumpRawGraphs(value);
            return this;
        }

        public BuildOptionsBuilder targetDir(String path) {
            this.targetPath = path;
            return this;
        }

        public BuildOptionsBuilder setConfigSchemaGen(Boolean value) {
            this.compilationOptionsBuilder.setConfigSchemaGen(value);
            return this;
        }

        public BuildOptionsBuilder setExportOpenAPI(Boolean value) {
            this.compilationOptionsBuilder.setExportOpenAPI(value);
            return this;
        }

        public BuildOptionsBuilder setExportComponentModel(Boolean value) {
            this.compilationOptionsBuilder.setExportComponentModel(value);
            this.exportComponentModel = value;
            return this;
        }

        public BuildOptionsBuilder setNativeImage(Boolean value) {
            this.nativeImage = value;
            return this;
        }

        public BuildOptionsBuilder setRemoteManagement(Boolean value) {
            this.compilationOptionsBuilder.setRemoteManagement(value);
            return this;
        }

        public BuildOptionsBuilder setShowDependencyDiagnostics(Boolean value) {
            this.showDependencyDiagnostics = value;
            return this;
        }

        public BuildOptionsBuilder setOptimizeDependencyCompilation(Boolean value) {
            this.compilationOptionsBuilder.setOptimizeDependencyCompilation(value);
            return this;
        }

        public BuildOptionsBuilder setLockingMode(PackageLockingMode value) {
            this.compilationOptionsBuilder.setLockingMode(value);
            return this;
        }

        public BuildOptions build() {
            CompilationOptions compilationOptions = this.compilationOptionsBuilder.build();
            return new BuildOptions(this.testReport, this.codeCoverage, this.dumpBuildTime, this.skipTests, compilationOptions, this.targetPath, this.nativeImage, this.exportComponentModel, this.graalVMBuildOptions, this.showDependencyDiagnostics);
        }
    }

    public static enum OptionName {
        OFFLINE("offline"),
        STICKY("sticky"),
        LOCKING_MODE("lockingMode"),
        OBSERVABILITY_INCLUDED("observabilityIncluded"),
        EXPERIMENTAL("experimental"),
        SKIP_TESTS("skipTests"),
        TEST_REPORT("testReport"),
        CODE_COVERAGE("codeCoverage"),
        LIST_CONFLICTED_CLASSES("listConflictedClasses"),
        DUMP_BUILD_TIME("dumpBuildTime"),
        TARGET_DIR("targetDir"),
        NATIVE_IMAGE("graalvm"),
        EXPORT_COMPONENT_MODEL("exportComponentModel"),
        GRAAL_VM_BUILD_OPTIONS("graalvmBuildOptions"),
        SHOW_DEPENDENCY_DIAGNOSTICS("showDependencyDiagnostics"),
        OPTIMIZE_DEPENDENCY_COMPILATION("optimizeDependencyCompilation"),
        REMOTE_MANAGEMENT("remoteManagement"),
        CLOUD("cloud");

        private final String name;

        private OptionName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

